/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.proizvodnja.gui.prijemnice;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.entity.Artikalkalkulacija;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.entity.Taksakalkulacija;
import rs.pezar.db.entity.Trosak;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.proizvodnja.gui.prijemnice.PzDialogPDV;
import rs.pezar.proizvodnja.gui.prijemnice.PzDialogTroskovi;
import rs.pezar.proizvodnja.gui.prijemnice.storno.Kolicina;
import rs.pezar.proizvodnja.util.PzProizvodnjaUtil;
import rs.pezar.reports.PzReportManager;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComponentGroup;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.event.PzTableCheckboxListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzFieldImpl;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextAreaPanel;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogStornoPrijemnice
extends PzDialogInsert {
    private static final long serialVersionUID = 1L;
    private PzPanelHeader header;
    private PzPanel mainPanel;
    private PzPanel pnlZaglavlje;
    private PzTextAreaPanel razlog;
    private PzToolBarIcon icnIzmena;
    private JPanel jPanel1;
    private PzToolBarIcon icnProbnoListanje;
    private PzDoubleField zaokruzenje;
    private JLabel jLabel5;
    private PzDoubleField pdvIznos;
    private JLabel jLabel4;
    private JTextField nazivDobavljaca;
    private PzDoubleField troskovi;
    private PzDoubleField planska;
    private PzDoubleField nabavna;
    private PzPanel pnlRight;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private PzTextField brDokumenta;
    private JComboBox tipDokumenta;
    private PzDoubleField trosakBezPdv;
    private JLabel jLabel7;
    private PzNumericOnlyTextField sfrKomitent;
    private JPanel pnlTable;
    private PzToolBarIcon icnArhiva;
    private PzToolBarIcon icnAzurPdv;
    private PzToolBarIcon icnAzurTroskova;
    private JPanel pnlIcons1;
    private JScrollPane scpIcons;
    private PzTable table;
    private JScrollPane scpArtikli;
    private JLabel labelTroskovi;
    private JLabel labelPlanska;
    private JLabel labelNabavna;
    private JPanel pnlSumarneVrednosti;
    private JSplitPane splitPane;
    private JLabel jLabel12;
    private JLabel jLabel11;
    private PzDateField datDokumenta;
    private PzDateField datIzrade;
    private JLabel jLabel1;
    private PzComponentGroup compGroupZaglavlje;
    private PzComponentGroup compGroupTable;
    private ButtonGroup pdv;
    private Kalkulacija kalkulacija;
    private PzComponentGroup compGroupPDV;
    private HashMap<String, Double> mapaKolicina = null;

    public PzDialogStornoPrijemnice(PzDialog parent) {
        super(parent);
        this.initGUI();
        this.paintPanel();
    }

    public boolean shouldBeShown() {
        try {
            this.kalkulacija = (Kalkulacija)PzEntityUtil.createStorno((PzDokument)((Kalkulacija)this.getSession().getParameter("kalkulacija")));
            this.getSession().putParameter("TRENUTNI_DOKUMENT", (Object)this.kalkulacija);
            if (this.kalkulacija.getTaksakalkulacijas() != null) {
                Iterator i = this.kalkulacija.getTaksakalkulacijas().iterator();
                while (i.hasNext()) {
                    Taksakalkulacija tk = (Taksakalkulacija)i.next();
                    if (!tk.getTip().equals(PzTaksaDokument.TIP_UKALKULISANI)) continue;
                    i.remove();
                }
            }
            this.calculatePDV();
            this.calculateTrosak((Vector)this.kalkulacija.getTrosaks());
            this.fillDokument((PzEntity)this.kalkulacija);
            this.mapaKolicina = this.setMapaKolicina(this.kalkulacija);
            this.instantiateTable();
            return true;
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            return false;
        }
    }

    private HashMap<String, Double> setMapaKolicina(Kalkulacija kalk) {
        HashMap<String, Double> rez = new HashMap<String, Double>();
        for (Artikalkalkulacija a : kalk.getArtikalkalkulacijas()) {
            rez.put(String.valueOf(a.getId().getSfrProizvod()) + "/" + a.getId().getrBroj(), a.getKolicina());
        }
        return rez;
    }

    public double getKolicinaFor(Artikalkalkulacija ak) {
        return this.mapaKolicina.get(String.valueOf(ak.getId().getSfrProizvod()) + "/" + ak.getId().getrBroj());
    }

    private void fillDokument(PzEntity entity) {
        Kalkulacija dokument = (Kalkulacija)entity;
        this.brDokumenta.setVal((Object)dokument.getOznDokumenta());
        PzSwingUtility.setSelectedValue((Object)dokument.getPodTip(), (JComboBox)this.tipDokumenta);
        this.trosakBezPdv.setVal((Object)dokument.getTrosakBezPdv());
        this.zaokruzenje.setVal((Object)dokument.getZaokruzenje());
        this.sfrKomitent.setVal((Object)dokument.getKomitent().getSfrKomitent());
        this.nazivDobavljaca.setText(dokument.getKomitent().getNaziv());
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void instantiateTable() {
        Collections.sort(this.kalkulacija.getArtikalkalkulacijas());
        this.table = new PzTable(this.kalkulacija.getArtikalkalkulacijas(), Artikalkalkulacija.class);
        this.table.getTableHeader().setFocusable(false);
        this.table.setCheckboxColumn(0, KeyStroke.getKeyStroke(113, 0), KeyStroke.getKeyStroke(113, 512), KeyStroke.getKeyStroke(113, 128), KeyStroke.getKeyStroke(113, 640));
        this.table.unCheckAll();
        this.scpArtikli.setViewportView((Component)this.table);
        this.table.addCheckboxListener(new PzTableCheckboxListener(){

            public void valueChanged(int rowIndex, PzEntity entity, boolean newValue) {
                PzDialogStornoPrijemnice.this.calculateSum((Vector)PzDialogStornoPrijemnice.this.table.getCheckedEntities());
            }
        });
        if (this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
        this.calculateSum((Vector)this.table.getCheckedEntities());
    }

    protected void initGUI() {
        try {
            this.mainPanel = new PzPanel();
            BorderLayout mainPanelLayout = new BorderLayout();
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.header = new PzPanelHeader();
            this.header.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/document_prijemnica.png")));
            this.header.setTitle("Izrada storno prijemnice repromaterijala");
            this.mainPanel.add((Component)this.header, (Object)"North");
            this.pnlRight = new PzPanel();
            GridBagLayout pnlTableLayout = new GridBagLayout();
            pnlTableLayout.columnWeights = new double[]{0.1};
            pnlTableLayout.columnWidths = new int[]{7};
            pnlTableLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            pnlTableLayout.rowHeights = new int[]{143, 58, 150, 100};
            this.pnlRight.setLayout((LayoutManager)pnlTableLayout);
            this.pnlZaglavlje = new PzPanel();
            this.pnlRight.add((Component)this.pnlZaglavlje, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlZaglavlje.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Zaglavlje", 4, 0));
            this.pnlZaglavlje.setLayout(null);
            this.pnlZaglavlje.setTransferFocusOnEnter(true);
            this.jLabel1 = new JLabel();
            this.pnlZaglavlje.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel1.setText("Datum izrade");
            this.jLabel1.setBounds(18, 33, 109, 14);
            this.jLabel2 = new JLabel();
            this.pnlZaglavlje.add((Component)this.jLabel2, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel2.setText("\u0160ifra dobavlja\u010da");
            this.jLabel2.setBounds(18, 60, 109, 14);
            this.jLabel3 = new JLabel();
            this.pnlZaglavlje.add((Component)this.jLabel3, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel3.setText("Datum dokumenta");
            this.jLabel3.setBounds(249, 33, 118, 14);
            this.datIzrade = new PzDateField();
            this.pnlZaglavlje.add((Component)this.datIzrade, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.datIzrade.setBounds(134, 27, 109, 25);
            this.datDokumenta = new PzDateField();
            this.pnlZaglavlje.add((Component)this.datDokumenta, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.datDokumenta.setBounds(367, 27, 109, 25);
            this.sfrKomitent = new PzNumericOnlyTextField();
            this.pnlZaglavlje.add((Component)this.sfrKomitent, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.sfrKomitent.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.sfrKomitent.setBounds(134, 54, 109, 25);
            this.sfrKomitent.setEditable(false);
            this.sfrKomitent.setFocusable(false);
            this.jLabel7 = new JLabel();
            this.pnlZaglavlje.add((Component)this.jLabel7, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel7.setText("Tro\u0161ak");
            this.jLabel7.setHorizontalAlignment(2);
            this.jLabel7.setBounds(18, 115, 83, 17);
            this.trosakBezPdv = new PzDoubleField();
            this.pnlZaglavlje.add((Component)this.trosakBezPdv, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.trosakBezPdv.setBounds(134, 110, 102, 24);
            this.trosakBezPdv.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    if (evt.getKeyCode() == 10) {
                        PzDialogStornoPrijemnice.this.calculateTrosak((Vector)PzDialogStornoPrijemnice.this.kalkulacija.getTrosaks());
                    }
                }
            });
            this.brDokumenta = new PzTextField();
            this.pnlZaglavlje.add((Component)this.brDokumenta, (Object)new GridBagConstraints(3, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.brDokumenta.setBounds(134, 82, 158, 25);
            this.brDokumenta.setPKField(Kalkulacija.class, null);
            this.brDokumenta.setEditable(false);
            this.brDokumenta.setFocusable(false);
            this.tipDokumenta = new JComboBox();
            this.pnlZaglavlje.add((Component)this.tipDokumenta, (Object)new GridBagConstraints(3, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.tipDokumenta.setBounds(568, 24, 121, 25);
            this.tipDokumenta.setEnabled(false);
            this.tipDokumenta.addItem(new PzChoice("Faktura", (Object)TipDokumentConfig.get().PODTIP_KALKULACIJA_FAKTURA));
            this.tipDokumenta.addItem(new PzChoice("Otpremnica", (Object)TipDokumentConfig.get().PODTIP_KALKULACIJA_OTPREMNICA));
            this.jLabel11 = new JLabel();
            this.pnlZaglavlje.add((Component)this.jLabel11, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel11.setText("Tip dokumenta");
            this.jLabel11.setBounds(481, 31, 116, 14);
            this.jLabel12 = new JLabel();
            this.pnlZaglavlje.add((Component)this.jLabel12, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel12.setText("Broj dokumenta");
            this.jLabel12.setBounds(18, 88, 109, 14);
            this.nazivDobavljaca = new JTextField();
            this.pnlZaglavlje.add((Component)this.nazivDobavljaca);
            this.nazivDobavljaca.setBounds(249, 54, 317, 25);
            this.nazivDobavljaca.setEditable(false);
            this.nazivDobavljaca.setFocusable(false);
            this.compGroupPDV = new PzComponentGroup();
            this.jLabel4 = new JLabel();
            this.compGroupPDV.add((Component)this.jLabel4);
            this.pnlZaglavlje.add((Component)this.jLabel4);
            this.jLabel4.setText("Iznos PDV-a:");
            this.jLabel4.setBounds(491, 108, 111, 26);
            this.jLabel4.setFont(new Font("Tahoma", 1, 16));
            this.jLabel4.setForeground(new Color(128, 0, 0));
            this.pdvIznos = new PzDoubleField();
            this.compGroupPDV.add((Component)this.pdvIznos);
            this.pnlZaglavlje.add((Component)this.pdvIznos);
            this.pdvIznos.setBounds(608, 108, 145, 26);
            this.pdvIznos.setEditable(false);
            this.pdvIznos.setFocusable(false);
            this.pdvIznos.setForeground(new Color(0, 0, 128));
            this.jLabel5 = new JLabel();
            this.pnlZaglavlje.add((Component)this.jLabel5);
            this.jLabel5.setText("Zaokru\u017eenje");
            this.jLabel5.setBounds(243, 116, 80, 14);
            this.zaokruzenje = new PzDoubleField();
            this.pnlZaglavlje.add((Component)this.zaokruzenje, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.zaokruzenje.setFont(new Font("Tahoma", 0, 14));
            this.zaokruzenje.setBounds(329, 110, 102, 24);
            this.zaokruzenje.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    if (evt.getKeyCode() == 10) {
                        PzDialogStornoPrijemnice.this.calculateTrosak((Vector)PzDialogStornoPrijemnice.this.kalkulacija.getTrosaks());
                    }
                }
            });
            this.pnlSumarneVrednosti = new JPanel();
            FlowLayout pnlSumarneVrednostiLayout = new FlowLayout();
            pnlSumarneVrednostiLayout.setHgap(5);
            this.pnlSumarneVrednosti.setLayout(pnlSumarneVrednostiLayout);
            this.pnlRight.add((Component)this.pnlSumarneVrednosti, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlSumarneVrednosti.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Sumarne vrednosti", 4, 0));
            this.labelNabavna = new JLabel();
            this.pnlSumarneVrednosti.add(this.labelNabavna);
            this.labelNabavna.setText("Nabavna:");
            this.labelNabavna.setFont(new Font("Tahoma", 1, 16));
            this.labelNabavna.setHorizontalAlignment(4);
            this.nabavna = new PzDoubleField();
            this.pnlSumarneVrednosti.add((Component)this.nabavna);
            this.nabavna.setEditable(false);
            this.nabavna.setPreferredSize(new Dimension(150, 25));
            this.nabavna.setFont(new Font("Tahoma", 1, 14));
            this.nabavna.setForeground(new Color(0, 0, 255));
            this.nabavna.setSize(150, 25);
            this.nabavna.setFocusable(false);
            this.labelPlanska = new JLabel();
            this.pnlSumarneVrednosti.add(this.labelPlanska);
            this.labelPlanska.setText("Planska:");
            this.labelPlanska.setFont(new Font("Tahoma", 1, 16));
            this.labelPlanska.setPreferredSize(new Dimension(90, 14));
            this.labelPlanska.setHorizontalAlignment(4);
            this.planska = new PzDoubleField();
            this.pnlSumarneVrednosti.add((Component)this.planska);
            this.planska.setEditable(false);
            this.planska.setEnabled(true);
            this.planska.setPreferredSize(new Dimension(150, 25));
            this.planska.setFont(new Font("Tahoma", 1, 14));
            this.planska.setForeground(new Color(0, 0, 255));
            this.planska.setSize(150, 25);
            this.planska.setFocusable(false);
            this.labelTroskovi = new JLabel();
            this.pnlSumarneVrednosti.add(this.labelTroskovi);
            this.labelTroskovi.setText("Tro\u0161kovi:");
            this.labelTroskovi.setFont(new Font("Tahoma", 1, 16));
            this.labelTroskovi.setPreferredSize(new Dimension(90, 14));
            this.labelTroskovi.setHorizontalAlignment(4);
            this.troskovi = new PzDoubleField();
            this.pnlSumarneVrednosti.add((Component)this.troskovi);
            this.troskovi.setEditable(false);
            this.troskovi.setEnabled(true);
            this.troskovi.setPreferredSize(new Dimension(150, 25));
            this.troskovi.setFont(new Font("Tahoma", 1, 14));
            this.troskovi.setForeground(new Color(0, 0, 255));
            this.troskovi.setSize(150, 25);
            this.troskovi.setFocusable(false);
            this.pnlTable = new JPanel();
            GridBagLayout pnlTableLayout1 = new GridBagLayout();
            this.pnlRight.add((Component)this.pnlTable, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlTableLayout1.rowWeights = new double[]{0.1, 0.0};
            pnlTableLayout1.rowHeights = new int[]{233, 82};
            pnlTableLayout1.columnWeights = new double[]{0.1};
            pnlTableLayout1.columnWidths = new int[]{7};
            this.pnlTable.setLayout(pnlTableLayout1);
            this.pnlTable.setBackground(new Color(192, 192, 192));
            this.pnlTable.setBorder(BorderFactory.createEtchedBorder(1));
            this.scpArtikli = new JScrollPane();
            this.pnlTable.add((Component)this.scpArtikli, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.jPanel1 = new JPanel();
            FlowLayout jPanel1Layout = new FlowLayout();
            jPanel1Layout.setAlignment(0);
            jPanel1Layout.setHgap(5);
            this.jPanel1.setLayout(jPanel1Layout);
            this.pnlTable.add((Component)this.jPanel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanel1.setOpaque(false);
            this.icnIzmena = new PzToolBarIcon();
            this.jPanel1.add((Component)this.icnIzmena);
            this.icnIzmena.setText("A\u017euriranje|koli\u010dine (F3)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/product_edit_small.png")));
            this.icnIzmena.setActionCommand("Kolicina");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("f3");
            this.icnIzmena.setPreferredSize(new Dimension(70, 70));
            this.razlog = new PzTextAreaPanel();
            this.razlog.setAreaFont(new Font("Tahoma", 0, 14));
            this.razlog.setBorder((Border)BorderFactory.createTitledBorder("Razlog storniranja"));
            this.razlog.setPreferredSize(new Dimension(900, 150));
            this.pnlRight.add((Component)this.razlog, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.scpIcons = new JScrollPane();
            this.splitPane = new JSplitPane();
            this.splitPane.getInputMap(1).put(KeyStroke.getKeyStroke(119, 0, false), "ENTER");
            this.splitPane.add((Component)this.pnlRight, "right");
            this.splitPane.add((Component)this.scpIcons, "left");
            this.scpIcons.getVerticalScrollBar().setFocusable(false);
            this.pnlIcons1 = new JPanel();
            this.scpIcons.setViewportView(this.pnlIcons1);
            this.pnlIcons1.setPreferredSize(new Dimension(40, 400));
            this.icnAzurPdv = new PzToolBarIcon();
            this.pnlIcons1.add((Component)this.icnAzurPdv);
            this.icnAzurPdv.setText("A\u017euriranje|PDV-a|(F8)");
            this.icnAzurPdv.setActionCommand("PzDialogPDV");
            this.icnAzurPdv.addActionListener((ActionListener)((Object)this));
            this.icnAzurPdv.setShortcut("f8");
            this.icnAzurPdv.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/pdv_edit.png")));
            this.icnAzurPdv.setPreferredSize(new Dimension(60, 100));
            this.icnAzurTroskova = new PzToolBarIcon();
            this.pnlIcons1.add((Component)this.icnAzurTroskova);
            this.icnAzurTroskova.setText("A\u017euriranje|tro\u0161kova|(F5)");
            this.icnAzurTroskova.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/money_envelope.png")));
            this.icnAzurTroskova.setActionCommand("PzDialogTroskovi");
            this.icnAzurTroskova.addActionListener((ActionListener)((Object)this));
            this.icnAzurTroskova.setShortcut("F5");
            this.icnAzurTroskova.setPreferredSize(new Dimension(60, 100));
            this.icnProbnoListanje = new PzToolBarIcon();
            this.pnlIcons1.add((Component)this.icnProbnoListanje);
            this.icnProbnoListanje.setText("Probno|listanje|(F7)");
            this.icnProbnoListanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/documents.png")));
            this.icnProbnoListanje.setActionCommand("listanje");
            this.icnProbnoListanje.addActionListener((ActionListener)((Object)this));
            this.icnProbnoListanje.setShortcut("f7");
            this.icnProbnoListanje.setPreferredSize(new Dimension(60, 100));
            this.icnArhiva = new PzToolBarIcon();
            this.pnlIcons1.add((Component)this.icnArhiva);
            this.icnArhiva.setText("Arhiva|i \u0161tampa|(CTRL+W)");
            this.icnArhiva.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/printer_preferences.png")));
            this.icnArhiva.addActionListener((ActionListener)((Object)this));
            this.icnArhiva.setActionCommand("arhiva");
            this.icnArhiva.setShortcut("ctrl+w");
            this.icnArhiva.setPreferredSize(new Dimension(60, 100));
            this.mainPanel.add((Component)this.splitPane, (Object)"Center");
            this.splitPane.setDividerLocation(70);
            this.splitPane.setEnabled(false);
            this.compGroupZaglavlje = new PzComponentGroup();
            this.compGroupZaglavlje.add(this.pnlZaglavlje.getComponents());
            this.compGroupTable = new PzComponentGroup();
            this.compGroupTable.add(this.pnlTable.getComponents());
            this.pnlIcons1.setOpaque(false);
            this.pnlRight.setOpaque(false);
            this.pnlSumarneVrednosti.setOpaque(false);
            this.pnlTable.setOpaque(false);
            this.pnlZaglavlje.setOpaque(false);
            this.header.setOpaque(false);
            this.jPanel1.setOpaque(false);
            this.splitPane.setOpaque(false);
            this.pack();
            this.setSize(1024, 768);
            this.setMinimumSize(new Dimension(1024, 768));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogStornoPrijemnice(Boolean.FALSE);
    }

    public PzDialogStornoPrijemnice(Boolean initGUI) {
    }

    public void actionPerformed(ActionEvent e) {
        try {
            String actionCommand = ((AbstractButton)e.getSource()).getActionCommand();
            if (actionCommand.equals("listanje")) {
                this.kalkulacija.setArtikalkalkulacijas(this.table.getCheckedEntities());
                this.listanje(this.nabavna.getBigDecimal());
                return;
            }
            if (actionCommand.equals("arhiva")) {
                this.arhiviraj();
                return;
            }
            if (actionCommand.equals("PzDialogPDV")) {
                this.getSession().putParameter("table", (Object)this.table);
                this.getSession().putParameter("kalkulacija", (Object)this.kalkulacija);
                this.getSession().putParameter("storno", (Object)true);
                this.showDialog(PzDialogPDV.class);
                if (this.table.getCheckedEntities() != null) {
                    this.calculateSum((Vector)this.table.getCheckedEntities());
                }
                return;
            }
            if (actionCommand.equalsIgnoreCase("PzDialogTroskovi")) {
                this.getSession().putParameter("kalkulacija", (Object)this.kalkulacija);
                this.showDialog(PzDialogTroskovi.class);
                this.calculateTrosak((Vector)this.kalkulacija.getTrosaks());
                return;
            }
            if (actionCommand.equalsIgnoreCase("Kolicina")) {
                this.getSession().putParameter("table", (Object)this.table);
                this.showDialog(Kolicina.class);
                return;
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    protected void onInsert() {
    }

    protected void onUpdate() {
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            ((PzFieldImpl)component).setVal((Object)((Komitent)entity).getSfrKomitent());
            this.nazivDobavljaca.setText(((Komitent)entity).getNaziv());
        }
    }

    protected void setHeaderOnInsert() {
    }

    protected void setHeaderOnUpdate() {
    }

    public void calculateSum(Vector<Artikalkalkulacija> art) {
        BigDecimal nabSum = this.trosakBezPdv.getBigDecimal().add(this.pdvIznos.getBigDecimal());
        BigDecimal prodSum = new BigDecimal(0);
        if (art != null) {
            for (Artikalkalkulacija a : art) {
                BigDecimal fakturnaCena = BDConverter.getFakturnaCena((double)a.getFakturnaCena());
                BigDecimal kolicina = BDConverter.getKolicina((double)a.getKolicina());
                BigDecimal fakturnaVrednost = fakturnaCena.multiply(kolicina);
                BigDecimal procRabata = BDConverter.getProcRabata100((double)a.getProcRabata());
                BigDecimal vredRabata = BDConverter.getIznos((BigDecimal)fakturnaVrednost.multiply(procRabata));
                BigDecimal nabVred = BDConverter.getIznos((BigDecimal)fakturnaVrednost.subtract(vredRabata));
                nabSum = nabSum.add(nabVred);
                prodSum = prodSum.add(BDConverter.getIznos((double)(a.getKolicina() * a.getProdCena().doubleValue())));
            }
        }
        this.nabavna.setVal((Object)nabSum);
        this.planska.setVal((Object)prodSum);
    }

    public void calculateTrosak(Vector<Trosak> vector) {
        BigDecimal trSum = this.trosakBezPdv.getBigDecimal();
        if (vector != null) {
            for (Trosak t : vector) {
                trSum = trSum.add(t.getOsnovica().add(t.getBezPrava().add(t.getOslobodjeno())));
            }
        }
        this.troskovi.setVal((Object)trSum);
    }

    public double getTrosak() {
        return this.troskovi.getVal();
    }

    public double getPDV() {
        return this.pdvIznos.getVal();
    }

    public void calculatePDV() {
        BigDecimal pdvSum = new BigDecimal(0.0);
        if (this.kalkulacija.getTaksakalkulacijas() != null) {
            for (Taksakalkulacija pdv : this.kalkulacija.getTaksakalkulacijas()) {
                if (!pdv.getVrsta().equals("PDV")) continue;
                pdvSum = pdvSum.add(pdv.getIznos());
            }
        }
        this.pdvIznos.setVal((Object)pdvSum);
        if (this.table != null && this.table.getCheckedEntities() != null) {
            this.calculateSum((Vector)this.table.getCheckedEntities());
        }
    }

    public PzComponentGroup getTableGroup() {
        return this.compGroupTable;
    }

    public String getPdvChoice() {
        return PzSwingUtility.getSelectedValue((ButtonGroup)this.pdv);
    }

    private void arhiviraj() {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            int izbor;
            if (this.kalkulacija.getIznos().subtract(this.kalkulacija.getStornoIznos()).subtract(this.kalkulacija.getUkupnoFakturisano()).compareTo(this.nabavna.getBigDecimal()) == -1) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Ne mo\u017eete stornirati iznos ve\u0107i od preostalog!");
                return;
            }
            List checkedList = this.table.getCheckedEntities();
            if (checkedList.size() == 0 && (izbor = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Niste obele\u017eili ni jedan artikal za storniranje.\nDa li ste sigurni da \u017eelite da stornirate dokument bez artikala?", (String)"Storniranje", null, (boolean)true)) != 0) {
                return;
            }
            this.kalkulacija.setArtikalkalkulacijas(checkedList);
            if (!this.ispitajKolicine()) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Operacija storniranja dokumenta je obustavljena.");
                return;
            }
            try {
                this.kalkulacija.getKalkulacijazapisniks1();
                this.kalkulacija.getKalkulacijazapisniks2();
                this.kalkulacija.setDatum(this.datDokumenta.getVal());
                this.kalkulacija.setDatFakture(this.datIzrade.getVal());
                this.kalkulacija.setTrosakBezPdv(this.trosakBezPdv.getBigDecimal());
                this.kalkulacija.setZaokruzenje(this.zaokruzenje.getBigDecimal());
                this.kalkulacija.setIznos(this.nabavna.getBigDecimal().add(this.zaokruzenje.getBigDecimal()));
                this.kalkulacija.setProdVrednost(this.planska.getBigDecimal());
                this.kalkulacija.setPoruka(this.razlog.getVal());
                this.sumirajTroskove(this.kalkulacija, em);
                this.preraspodeliTroskove(this.nabavna.getBigDecimal(), em);
                this.kalkulacija.setRazlUCeni(PzProizvodnjaUtil.getRazlikaUCeni(this.kalkulacija));
                this.kalkulacija.setNabavnaVrednost(PzProizvodnjaUtil.getNabavnaVrednost(this.kalkulacija));
                this.kalkulacija.setKalkulacijazapisniks1(new Vector());
                this.kalkulacija.adjust();
                List trosaks = this.kalkulacija.getTrosaks();
                this.kalkulacija.setTrosaks(new Vector());
                em.getTransaction().begin();
                PzDokumentManager.getInstance().arhivirajStorno((PzDokument)this.kalkulacija, PzEntityManager.KOLICINE_UMANJENJE, PzEntityManager.KOLICINA_UKUPNA, false, null, em);
                em.flush();
                for (Trosak t : trosaks) {
                    PzDokumentManager.getInstance().arhivirajStorno((PzDokument)t, PzEntityManager.KOLICINE_NEPROMENJENE, PzEntityManager.KOLICINA_UKUPNA, false, null, em);
                }
                em.getTransaction().commit();
                this.kalkulacija.setTrosaks(trosaks);
                PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)this.kalkulacija);
                this.dispose();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        }
        finally {
            em.close();
        }
    }

    private boolean ispitajKolicine() {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        Vector<String> nemaDovoljno = new Vector<String>();
        for (Artikalkalkulacija artikal : this.kalkulacija.getArtikalkalkulacijas()) {
            StanjePK spk = new StanjePK(artikal.getId().getSfrProizvod(), this.kalkulacija.getRadnajedinica().getId().getOznOgranak(), this.kalkulacija.getRadnajedinica().getId().getOznRj());
            Stanje s = (Stanje)em.find(Stanje.class, (Object)spk);
            if (!(s.getRaspolozivaKolicina() < artikal.getKolicina()) || !this.kalkulacija.getRadnajedinica().getMinusKolicine().equals("DOZVOLJEN")) continue;
            nemaDovoljno.add(" [ " + artikal.getId().getSfrProizvod() + " ] " + artikal.getNaziv());
        }
        if (nemaDovoljno.size() > 0) {
            String poruka = "Slede\u0107i artikli nemaju dovoljno raspolo\u017eive koli\u010dine:\n";
            for (String str : nemaDovoljno) {
                poruka = String.valueOf(poruka) + str + "\n";
            }
            int izbor = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)(poruka = String.valueOf(poruka) + "Ukoliko stornirate prijemnicu, navedeni artikli \u0107e oti\u0107i u minus sa koli\u010dinom.\nDa li ste sigurni da to \u017eelite?"), (String)"Nedovoljna koli\u010dina", null, (boolean)true);
            if (izbor != 0) {
                return false;
            }
        }
        em.close();
        return true;
    }

    private void preraspodeliTroskove(BigDecimal iznos2, EntityManager em) {
        for (Artikalkalkulacija ak : this.kalkulacija.getArtikalkalkulacijas()) {
            ak.setNabCena(ak.calculateNabCena().doubleValue());
            ak.setZavTroskovi(ak.calculateZavTrosak().doubleValue());
        }
    }

    private void sumirajTroskove(Kalkulacija kalkulacija, EntityManager em) {
        BigDecimal interni = new BigDecimal(0.0);
        BigDecimal eksterni = new BigDecimal(0.0);
        BigDecimal carina = new BigDecimal(0.0);
        for (Trosak t : kalkulacija.getTrosaks()) {
            if (t.getPodTip().equals(Trosak.TIP_INTERNI)) {
                interni = interni.add(t.getOsnovica().add(t.getBezPrava().add(t.getOslobodjeno())));
            } else if (t.getPodTip().equals(Trosak.TIP_EKSTERNI)) {
                eksterni = eksterni.add(t.getOsnovica().add(t.getBezPrava().add(t.getOslobodjeno())));
            } else if (t.getPodTip().equals(Trosak.TIP_CARINA)) {
                carina = carina.add(t.getOsnovica().add(t.getBezPrava().add(t.getOslobodjeno())));
            }
            t.setArhiviran((short)1);
            if (em == null) continue;
            em.merge((Object)t);
        }
        kalkulacija.setTroskoviCarina(carina);
        kalkulacija.setTroskoviInterni(interni);
        kalkulacija.setTroskoviEksterni(eksterni);
    }

    private void listanje(BigDecimal iznos) {
        if (this.kalkulacija.getArtikalkalkulacijas() == null || this.kalkulacija.getArtikalkalkulacijas().size() == 0) {
            PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Prijemnica ne sadr\u017ei stavke.");
            return;
        }
        this.kalkulacija.setProdVrednost(this.planska.getBigDecimal());
        this.kalkulacija.setRazlUCeni(PzProizvodnjaUtil.getRazlikaUCeni(this.kalkulacija));
        this.kalkulacija.setZaokruzenje(iznos.subtract(this.nabavna.getBigDecimal()));
        this.kalkulacija.setTrosakBezPdv(this.trosakBezPdv.getBigDecimal());
        this.sumirajTroskove(this.kalkulacija, null);
        PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)this.kalkulacija);
    }
}

