/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.proizvodnja.gui.prijemnice;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import rs.pezar.core.format.BDConverter;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalkalkulacija;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.proizvodnja.gui.prijemnice.PzDialogIzradaPrijemnice;
import rs.pezar.proizvodnja.gui.prijemnice.PzDialogPomocEvro;
import rs.pezar.sifarnici.gui.PzArtikliBrowser;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.event.PzEntityChecker;
import rs.pezar.swing.event.PzStanjeartikalChecker;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzField;
import rs.pezar.swing.fields.PzFieldImpl;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class Dodavanje
extends PzDialogInsert {
    private static final long serialVersionUID = 1L;
    private PzPanel mainPanel;
    private PzPanel pnlFields;
    private JLabel jLabel4;
    private PzDoubleField nabCena;
    private PzTextField nazivArt;
    private PzButton btnOK;
    private PzDoubleField procRabata;
    private PzDoubleField kolicina;
    private PzDoubleField planskaCena;
    private PzDoubleField poslNabavna;
    private PzTextField tarGrupa;
    private PzDoubleField zatKolicina;
    private JLabel jLabel11;
    private JLabel jLabel9;
    private PzPanel pnlArtikalStanje;
    private PzFieldImpl sfrArtDok;
    private JLabel jLabel7;
    private JLabel jLabel6;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzPanelHeader header;
    private Artikal artikal;
    private Kalkulacija kalkulacija = (Kalkulacija)this.getSession().getParameter("kalkulacija");
    private PzDialogIzradaPrijemnice dlgKalkulacija;
    private double udeoTrosak;
    private Artikalkalkulacija artdok;
    private JLabel jLabel13;
    private PzFieldIndikator indNabCena;
    private PzFieldIndikator indKolicina;
    private PzFieldIndikator indSifra;
    private double udeoTrosak1;
    private PzTable tableProvera = (PzTable)this.getSession().getParameter("table");
    private Short domaciKomitent;

    public Dodavanje(PzDialog dialog) {
        super(dialog);
        this.dlgKalkulacija = (PzDialogIzradaPrijemnice)dialog;
        if (!this.isUpdate()) {
            this.procRabata.setVal((Object)this.dlgKalkulacija.getRabat());
        }
        this.sfrArtDok.setParamToPass((Object)this.kalkulacija.getRadnajedinica());
        this.sfrArtDok.setEntityChecker((PzEntityChecker)new PzStanjeartikalChecker((PzField)this.sfrArtDok, this.kalkulacija.getRadnajedinica()));
        this.domaciKomitent = this.dlgKalkulacija.getDomaciKomitent();
        if (this.domaciKomitent != null && this.domaciKomitent == 0) {
            this.nabCena.setEnabled(false);
        }
        this.paintPanel();
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    protected void initGUI() {
        try {
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
            mainPanelLayout.rowHeights = new int[]{65, 180, 5};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0};
            mainPanelLayout.columnWidths = new int[]{426, 244, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.pnlArtikalStanje = new PzPanel();
            this.pnlArtikalStanje.setOpaque(false);
            this.mainPanel.add((Component)this.pnlArtikalStanje, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
            GridBagLayout pnlArtikalStanjeLayout = new GridBagLayout();
            this.pnlArtikalStanje.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Artikal", 4, 0));
            this.pnlArtikalStanje.setBackground(new Color(214, 214, 214));
            pnlArtikalStanjeLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            pnlArtikalStanjeLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            pnlArtikalStanjeLayout.columnWidths = new int[]{114, 109, 7};
            this.pnlArtikalStanje.setLayout((LayoutManager)pnlArtikalStanjeLayout);
            this.jLabel1 = new JLabel();
            this.pnlArtikalStanje.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
            this.jLabel1.setText("\u0160ifra artikla");
            this.jLabel2 = new JLabel();
            this.pnlArtikalStanje.add((Component)this.jLabel2, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel2.setText("Zate\u010dena koli\u010dina");
            this.jLabel3 = new JLabel();
            this.pnlArtikalStanje.add((Component)this.jLabel3, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel3.setText("Tarifna grupa");
            this.jLabel6 = new JLabel();
            this.pnlArtikalStanje.add((Component)this.jLabel6, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel6.setText("Poslednja nabavna");
            this.jLabel7 = new JLabel();
            this.pnlArtikalStanje.add((Component)this.jLabel7, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel7.setText("Planska cena");
            this.sfrArtDok = new PzTextField();
            this.pnlArtikalStanje.add((Component)this.sfrArtDok, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.sfrArtDok.setFKField(Stanjeartikal.class, PzArtikliBrowser.class, true, null);
            this.zatKolicina = new PzDoubleField();
            this.pnlArtikalStanje.add((Component)this.zatKolicina, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.zatKolicina.setEditable(false);
            this.zatKolicina.setFocusable(false);
            this.tarGrupa = new PzTextField();
            this.pnlArtikalStanje.add((Component)this.tarGrupa, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.tarGrupa.setEditable(false);
            this.tarGrupa.setFocusable(false);
            this.poslNabavna = new PzDoubleField();
            this.pnlArtikalStanje.add((Component)this.poslNabavna, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.poslNabavna.setEditable(false);
            this.poslNabavna.setFocusable(false);
            this.planskaCena = new PzDoubleField();
            this.pnlArtikalStanje.add((Component)this.planskaCena, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.planskaCena.setEditable(false);
            this.planskaCena.setFocusable(false);
            this.nazivArt = new PzTextField();
            this.pnlArtikalStanje.add((Component)this.nazivArt, (Object)new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.nazivArt.setEditable(false);
            this.nazivArt.setFocusable(false);
            this.indSifra = new PzFieldIndikator();
            this.pnlArtikalStanje.add((Component)this.indSifra, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.jLabel13 = new JLabel();
            this.pnlArtikalStanje.add((Component)this.jLabel13, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel13.setText("Naziv artikla");
            this.header = new PzPanelHeader();
            this.header.setOpaque(false);
            this.header.setIcon(this.getHeaderIcon());
            this.header.setTitle(this.getHeaderTitle());
            this.mainPanel.add((Component)this.header, (Object)new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.header.setPreferredSize(new Dimension(341, 70));
            this.pnlFields = new PzPanel();
            this.pnlFields.setTransferFocusOnEnter(true);
            this.pnlFields.setOpaque(false);
            GridBagLayout pnlFieldsLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlFields, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            pnlFieldsLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
            pnlFieldsLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            pnlFieldsLayout.columnWidths = new int[]{95, 119, 20};
            this.pnlFields.setLayout((LayoutManager)pnlFieldsLayout);
            this.jLabel4 = new JLabel();
            this.pnlFields.add((Component)this.jLabel4, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
            this.jLabel4.setText("Koli\u010dina");
            this.jLabel9 = new JLabel();
            this.pnlFields.add((Component)this.jLabel9, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel9.setText("Nabavna cena");
            this.jLabel11 = new JLabel();
            this.pnlFields.add((Component)this.jLabel11, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel11.setText("% rabata");
            this.kolicina = new PzDoubleField();
            this.kolicina.setDecimalFormat(PzFormatFactory.getKolicinaFormat());
            this.pnlFields.add((Component)this.kolicina, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 2, 0), 0, 0));
            this.kolicina.setFont(new Font("Tahoma", 0, 14));
            this.kolicina.setVerifyInput(true);
            this.kolicina.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (Dodavanje.this.domaciKomitent != null && Dodavanje.this.domaciKomitent == 0) {
                        Dodavanje.this.getSession().putParameter("dlgKalkulacija", (Object)Dodavanje.this.dlgKalkulacija);
                        Dodavanje.this.showDialog(PzDialogPomocEvro.class);
                        Double nabavnaCena = (Double)Dodavanje.this.getSession().getParameter("nabavnaCena");
                        if (nabavnaCena == null || nabavnaCena == 0.0) {
                            return false;
                        }
                        Dodavanje.this.nabCena.setVal(Dodavanje.this.getSession().getParameter("nabavnaCena"));
                    }
                    if (Dodavanje.this.kolicina.getVal() == 0.0) {
                        Dodavanje.this.kolicina.setState(PzFieldIndikator.STATE_INVALID);
                        return false;
                    }
                    Dodavanje.this.indKolicina.setState(PzFieldIndikator.STATE_VALID);
                    return true;
                }
            });
            this.nabCena = new PzDoubleField();
            this.nabCena.setDecimalFormat(PzFormatFactory.getFakturnaCenaFormat());
            this.pnlFields.add((Component)this.nabCena, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.nabCena.setFont(new Font("Tahoma", 0, 14));
            this.nabCena.setVerifyInput(true);
            this.nabCena.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (Dodavanje.this.nabCena.getVal() == 0.0) {
                        Dodavanje.this.indNabCena.setState(PzFieldIndikator.STATE_INVALID);
                        return false;
                    }
                    Dodavanje.this.indNabCena.setState(PzFieldIndikator.STATE_VALID);
                    return true;
                }
            });
            this.procRabata = new PzDoubleField();
            this.procRabata.setDecimalFormat(PzFormatFactory.getProcRabataFormat());
            this.pnlFields.add((Component)this.procRabata, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.procRabata.setFont(new Font("Tahoma", 0, 14));
            this.btnOK = new PzButton();
            this.pnlFields.add((Component)this.btnOK, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnOK.setText("OK");
            this.btnOK.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/check.png")));
            this.btnOK.setActionCommand("insert");
            this.btnOK.setFont(new Font("Tahoma", 1, 12));
            this.btnOK.setBounds(107, 7, 119, 30);
            this.btnOK.addActionListener((ActionListener)((Object)this));
            this.indKolicina = new PzFieldIndikator();
            this.pnlFields.add((Component)this.indKolicina, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.indNabCena = new PzFieldIndikator();
            this.pnlFields.add((Component)this.indNabCena, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.sfrArtDok.setStateIndikator(this.indSifra);
            this.nabCena.setStateIndikator(this.indNabCena);
            this.kolicina.setStateIndikator(this.indKolicina);
            this.pack();
            this.setResizable(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            String actionCommand = ((PzButton)e.getSource()).getActionCommand();
            if (actionCommand.equals("insert")) {
                this.artdok = new Artikalkalkulacija();
                this.artdok.init(this.artikal, (PzDokument)this.kalkulacija);
                this.artdok.setKolicina(this.kolicina.getVal().doubleValue());
                this.artdok.setFakturnaCena(this.nabCena.getVal().doubleValue());
                this.artdok.setNaziv(this.nazivArt.getText());
                this.artdok.setProcRabata(this.procRabata.getVal().doubleValue());
                this.artdok.setZavTroskovi(this.udeoTrosak + this.udeoTrosak1);
                this.artdok.setNabCena(this.artdok.getFakturnaCena() * (1.0 - this.artdok.getProcRabata() / 100.0) + this.artdok.getZavTroskovi());
                this.artdok.setProdCena(BDConverter.getPlanskaCena((double)this.artikal.getCenaPlanska()));
                int i = this.checkArtikal();
                if (i == 0) {
                    this.kolicina.setVal((Object)0);
                    this.nabCena.setVal((Object)0);
                    this.procRabata.setVal((Object)this.dlgKalkulacija.getRabat());
                    this.setFirstComponentInFocus((Component)this.sfrArtDok);
                    return;
                }
                if (i == 1) {
                    this.dispose();
                    return;
                }
                this.tableProvera.insert((PzEntity)this.artdok, true);
            } else if (actionCommand.equals("update")) {
                this.artdok.setKolicina(this.kolicina.getVal().doubleValue());
                this.artdok.setFakturnaCena(this.nabCena.getVal().doubleValue());
                this.artdok.setNaziv(this.nazivArt.getText());
                this.artdok.setProcRabata(this.procRabata.getVal().doubleValue());
                this.artdok.setZavTroskovi(this.udeoTrosak + this.udeoTrosak1);
                this.artdok.setNabCena(this.artdok.getFakturnaCena() * (1.0 - this.artdok.getProcRabata() / 100.0) + this.artdok.getZavTroskovi());
                this.artdok.setProdCena(BDConverter.getPlanskaCena((double)this.artikal.getCenaPlanska()));
                this.tableProvera.updateSelectedEntity((PzEntity)this.artdok, true);
            }
            this.dispose();
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    protected void onInsert() {
        this.btnOK.setActionCommand("insert");
    }

    protected void onUpdate() {
        this.kalkulacija = (Kalkulacija)this.getSession().getParameter("kalkulacija");
        this.tableProvera = (PzTable)this.getSession().getParameter("table");
        this.artdok = (Artikalkalkulacija)this.tableProvera.getSelectedEntity();
        this.setEntity((PzEntity)this.artdok.getArtikal(), (Component)this.sfrArtDok);
        this.btnOK.setActionCommand("update");
        this.sfrArtDok.setEnabled(false);
        this.kolicina.setVal((Object)this.artdok.getKolicina());
        this.nabCena.setVal((Object)this.artdok.getFakturnaCena());
        this.procRabata.setVal((Object)this.artdok.getProcRabata());
        this.pnlFields.updateAllFieldsState();
        this.pnlArtikalStanje.updateAllFieldsState();
    }

    public void setEntity(PzEntity entity, Component component) {
        try {
            if (entity == null) {
                return;
            }
            if (entity instanceof Stanjeartikal) {
                this.artikal = (Artikal)PzEntityManager.find(Artikal.class, (Object)((Stanjeartikal)entity).getId().getSfrProizvod());
            } else if (entity instanceof Artikal) {
                this.artikal = (Artikal)entity;
            }
            PzFieldImpl sfrField = (PzFieldImpl)component;
            sfrField.setVal((Object)this.artikal.getSfrProizvod());
            this.nazivArt.setText(this.artikal.getNaziv());
            this.tarGrupa.setText(String.valueOf(this.artikal.getTarifnaGrupa("PDV").getOznTarGr()) + "  (" + this.artikal.getTarifnaGrupa("PDV").getStopa() + "%)");
            Stanje s = (Stanje)PzEntityManager.find(Stanje.class, (Object)new StanjePK(this.artikal.getSfrProizvod(), this.kalkulacija.getRadnajedinica()));
            this.zatKolicina.setVal((Object)(s != null ? s.getKolicina() : 0.0));
            this.poslNabavna.setVal((Object)(s != null ? s.getZadNabCena() : 0.0));
            this.planskaCena.setVal((Object)(s != null ? this.artikal.getCenaPlanska() : 0.0));
            this.kolicina.requestFocusInWindow();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    protected void setHeaderOnInsert() {
        this.setHeaderTitle("Dodavanje artikla");
        this.setHeaderIcon("rs/pezar/proizvodnja/resource/img/product_new.png");
    }

    protected void setHeaderOnUpdate() {
        this.setHeaderTitle("Ispravka na artiklu");
        this.setHeaderIcon("rs/pezar/proizvodnja/resource/img/product_edit.png");
    }

    private int checkArtikal() {
        int control = 3;
        int check = 3;
        if (this.kalkulacija.getArtikalkalkulacijas() != null) {
            for (Artikalkalkulacija ak : this.kalkulacija.getArtikalkalkulacijas()) {
                if (!ak.getId().getSfrProizvod().toString().equals(this.sfrArtDok.getVal().toString())) continue;
                if (ak.getFakturnaCena() == this.artdok.getFakturnaCena()) {
                    control = 1;
                    int i = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Artikal ve\u0107 postoji na kalkulaciji. Da li ste sigurni da \u017eelite ponovo da ga dodate?", (String)"Postoje\u0107i artikal", null, (boolean)false);
                    if (i != 0) {
                        check = 0;
                        break;
                    }
                    ak.setKolicina(ak.getKolicina() + this.kolicina.getVal());
                    try {
                        PzEntityManager.update((Object)ak);
                        this.tableProvera.update(Integer.valueOf(this.tableProvera.convertRowIndexToView(this.kalkulacija.getArtikalkalkulacijas().indexOf(ak))), (PzEntity)ak, true);
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                    }
                    check = 1;
                    break;
                }
                if (control == 1) continue;
                control = 2;
            }
            if (control == 2) {
                int i = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Ovaj artikal ve\u0107 postoji na kalkulaciji sa razli\u010ditom nabavnom cenom. Da li ste sigurni da \u017eelite ponovo da ga dodate?", (String)"Postoje\u0107i artikal sa razli\u010ditom nabavnom cenom", null, (boolean)false);
                check = i != 0 ? 0 : 2;
            }
        }
        return check;
    }
}

