/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.liste.gui.narudzbenice;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Application;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Artikallista;
import rs.pezar.db.entity.Lista;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.liste.ListaUtil;
import rs.pezar.liste.gui.PzDialogNarudzbeniceUPripremi;
import rs.pezar.liste.gui.izrada.Arhiviranje;
import rs.pezar.liste.gui.narudzbenice.DodavanjeStavkeNarudzbenice;
import rs.pezar.liste.gui.narudzbenice.DopunaPoLageru;
import rs.pezar.liste.gui.narudzbenice.DopunaPoNabavci;
import rs.pezar.liste.gui.narudzbenice.DopunaPoProdaji;
import rs.pezar.liste.gui.narudzbenice.DopunaPoStoku;
import rs.pezar.liste.gui.narudzbenice.PovecanjeCena;
import rs.pezar.liste.gui.narudzbenice.PromenaVrednostiPoena;
import rs.pezar.liste.gui.narudzbenice.UzmiDrugu;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class IzradaNarudzbenice
extends PzDialog {
    private PzPanel pnlGlavni;
    private JToolBar toolbar;
    private PzButton btnPromenaVrednostiPoena;
    private PzDoubleField dfVrednostPoena;
    private JLabel jlVrednostPoena;
    private PzButton btnIzmenaRj;
    private PzDoubleField dfSelektovano;
    private JLabel lblSelektirano;
    private PzTextField tfNazivRj;
    private PzTextField tfRj;
    private JLabel lblRj;
    private PzTextField tfNazivKomitenta;
    private PzToolBarIcon icnDodavanjeArt;
    private PzToolBarIcon icnIzmena;
    private PzToolBarIcon icnBrisanje;
    private PzTextField tfSifraKomitenta;
    private JLabel lblSifraKomitenta;
    private PzTable tblArtikli;
    private JScrollPane scrollPane;
    private PzPanel pnlPolja;
    private Radnajedinica rj;
    private Lista lista;
    private PzToolBarIcon icnDodajBezSifre;
    private PzToolBarIcon icnBrisKolicinu;
    private PzToolBarIcon icnBrisiCenu;
    private PzToolBarIcon icnBrisNaziv;
    private PzToolBarIcon icnArhiva;
    private PzToolBarIcon icnUzmiDrugu;
    private PzToolBarIcon icnPrekoPoena;
    private PzToolBarIcon icnPoProdaji;
    private PzToolBarIcon icnDopunaStokovi;
    private PzToolBarIcon icnDopunaLager;
    private PzToolBarIcon icnIzmenaCena;
    private PzToolBarIcon icnDopunaPoNabavci;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brStavki = new JLabel();
    String tipDokumenta;
    private String tableID = "TABLE_NARUDZBENICA";

    public IzradaNarudzbenice(PzDialog dialog) {
        super(dialog);
        this.lista = (Lista)this.getSession().getParameter("lista");
        this.tipDokumenta = this.lista.getTip();
        this.setId("NARUDZBENICA");
        if (this.tipDokumenta.equals(ListaUtil.getTipListe("PONUDA"))) {
            this.tableID = "TABLE_PONUDA";
            this.setId("PONUDA");
        }
        this.initGUI();
        this.postInit();
        this.tblArtikli.checkAll();
        this.setSelektovano();
    }

    private void postInit() {
        try {
            this.lista = (Lista)PzEntityManager.find(Lista.class, (Object)this.lista.getIdLista());
            this.tfSifraKomitenta.setVal((Object)(this.lista.getKomitent() == null ? "" : this.lista.getKomitent().getSfrKomitent()));
            this.tfNazivKomitenta.setVal((Object)(this.lista.getKomitent() == null ? "" : this.lista.getKomitent().getNaziv()));
            List data = PzEntityManager.getList((String)("Select a From Artikallista a where a.id.idLista ='" + this.lista.getIdLista() + "'"));
            this.tblArtikli.setData(data, Artikallista.class);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            return;
        }
    }

    private void setSelektovano() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IzradaNarudzbenice.this.brStavki.setText(String.valueOf(IzradaNarudzbenice.this.tblArtikli.getDataSize()));
                IzradaNarudzbenice.this.setIznosSelektovanih();
            }
        });
    }

    private void setIznosSelektovanih() {
        double iznosSelektovanih = 0.0;
        for (Artikallista artL : this.lista.getArtikallistas()) {
            iznosSelektovanih += artL.getKolicina() * artL.getCena().doubleValue();
        }
        this.dfSelektovano.setVal((Object)iznosSelektovanih);
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Izrada narud\u017ebenice");
            if (this.tipDokumenta.equals(ListaUtil.getTipListe("PONUDA"))) {
                this.setTitle("Izrada ponude");
            }
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{85, 99, 7, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.toolbar = new JToolBar();
            this.pnlGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnDodavanjeArt = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodavanjeArt);
            this.icnDodavanjeArt.setText("Dodavanje|stavke|(Insert)");
            this.icnDodavanjeArt.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/product_add.png")));
            this.icnDodavanjeArt.addActionListener((ActionListener)((Object)this));
            this.icnDodavanjeArt.setActionCommand("dodavanje");
            this.icnDodavanjeArt.setShortcut("Insert");
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setText("Izmena|stavke|(F3)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/product_edit.png")));
            this.icnIzmena.setActionCommand("izmena");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("F3");
            this.icnBrisanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setText("Brisanje|stavke|(Delete)");
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/product_delete.png")));
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setActionCommand("brisanje");
            this.icnBrisanje.setShortcut("delete");
            this.icnDodajBezSifre = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodajBezSifre);
            this.icnDodajBezSifre.setText("Dodavanje|bez \u0161ifre|(F5)");
            this.icnDodajBezSifre.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/product_add.png")));
            this.icnDodajBezSifre.setActionCommand("dodajBezSifre");
            this.icnDodajBezSifre.addActionListener((ActionListener)((Object)this));
            this.icnDodajBezSifre.setShortcut("F5");
            this.icnBrisKolicinu = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisKolicinu);
            this.icnBrisKolicinu.setText("Brisanje|koli\u010dina|(Alt+F4)");
            this.icnBrisKolicinu.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/document_delete.png")));
            this.icnBrisKolicinu.addActionListener((ActionListener)((Object)this));
            this.icnBrisKolicinu.setActionCommand("brisi_Kolicinu");
            this.icnBrisKolicinu.setShortcut("Alt+F4");
            this.icnBrisiCenu = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisiCenu);
            this.icnBrisiCenu.setText("Brisanje|cena|(Alt+F5)");
            this.icnBrisiCenu.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/document_delete.png")));
            this.icnBrisiCenu.setActionCommand("brisi_Cenu");
            this.icnBrisiCenu.addActionListener((ActionListener)((Object)this));
            this.icnBrisiCenu.setShortcut("Alt+F5");
            this.icnBrisNaziv = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisNaziv);
            this.icnBrisNaziv.setText("Brisanje|naziva|(Alt+F6)");
            this.icnBrisNaziv.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/document_delete.png")));
            this.icnBrisNaziv.addActionListener((ActionListener)((Object)this));
            this.icnBrisNaziv.setActionCommand("brisi_Naziv");
            this.icnBrisNaziv.setShortcut("Alt+F6");
            this.icnIzmenaCena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmenaCena);
            this.icnIzmenaCena.setText("Pove\u0107anje|cena|(CTRL+F2)");
            this.icnIzmenaCena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/sort_ascending.png")));
            this.icnIzmenaCena.setActionCommand("izmenaCena");
            this.icnIzmenaCena.addActionListener((ActionListener)((Object)this));
            this.icnIzmenaCena.setShortcut("CTRL+F2");
            this.icnDopunaLager = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDopunaLager);
            this.icnDopunaLager.setText("Dopuna|po lageru|(CTRL+F3)");
            this.icnDopunaLager.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/document_add.png")));
            this.icnDopunaLager.addActionListener((ActionListener)((Object)this));
            this.icnDopunaLager.setActionCommand("dopunaLager");
            this.icnDopunaLager.setShortcut("CTRL+F3");
            this.icnDopunaStokovi = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDopunaStokovi);
            this.icnDopunaStokovi.setText("Dopuna|po stokovima|(CTRL+F6)");
            this.icnDopunaStokovi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/document_add.png")));
            this.icnDopunaStokovi.addActionListener((ActionListener)((Object)this));
            this.icnDopunaStokovi.setActionCommand("dopunaStokovi");
            this.icnDopunaStokovi.setShortcut("CTRL+F6");
            this.icnPoProdaji = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnPoProdaji);
            this.icnPoProdaji.setText("Dopuna|po prodaji|(CTRL+F7)");
            this.icnPoProdaji.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/document_add.png")));
            this.icnPoProdaji.setActionCommand("poProdaji");
            this.icnPoProdaji.addActionListener((ActionListener)((Object)this));
            this.icnPoProdaji.setShortcut("CTRL+F7");
            if (this.tipDokumenta.equals(ListaUtil.getTipListe("PONUDA"))) {
                this.icnDopunaPoNabavci = new PzToolBarIcon();
                this.toolbar.add((Component)this.icnDopunaPoNabavci);
                this.icnDopunaPoNabavci.setText("Dopuna|po nabavci|(CTRL+F8)");
                this.icnDopunaPoNabavci.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/document_add.png")));
                this.icnDopunaPoNabavci.addActionListener((ActionListener)((Object)this));
                this.icnDopunaPoNabavci.setActionCommand("dopunaNabavka");
                this.icnDopunaPoNabavci.setShortcut("CTRL+F8");
            }
            this.icnUzmiDrugu = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnUzmiDrugu);
            this.icnUzmiDrugu.setText("Preuzimanje|narud\u017ebenice|(F10)");
            if (this.tipDokumenta.equals(ListaUtil.getTipListe("PONUDA"))) {
                this.icnUzmiDrugu.setText("Preuzimanje|ponude|(F10)");
            }
            this.icnUzmiDrugu.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/index.png")));
            this.icnUzmiDrugu.setActionCommand("uzmiDrugu");
            this.icnUzmiDrugu.addActionListener((ActionListener)((Object)this));
            this.icnUzmiDrugu.setShortcut("F10");
            if (this.tipDokumenta.equals(ListaUtil.getTipListe("PONUDA"))) {
                this.icnPrekoPoena = new PzToolBarIcon();
                this.toolbar.add((Component)this.icnPrekoPoena);
                this.icnPrekoPoena.setText("Preko|poena|(F11)");
                this.icnPrekoPoena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/graphics_tablet.png")));
                this.icnPrekoPoena.addActionListener((ActionListener)((Object)this));
                this.icnPrekoPoena.setActionCommand("prekoPoena");
                this.icnPrekoPoena.setShortcut("F11");
            }
            this.icnArhiva = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnArhiva);
            this.icnArhiva.setText("Arhiva i|\u0161tampa|(CTRL+W)");
            this.icnArhiva.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/printer_preferences.png")));
            this.icnArhiva.addActionListener((ActionListener)((Object)this));
            this.icnArhiva.setActionCommand("arhiva");
            this.icnArhiva.setShortcut("CTRL+W");
            this.pnlPolja = new PzPanel();
            GridBagLayout pnlPoljaLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlPolja, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlPoljaLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlPoljaLayout.rowHeights = new int[]{10, 25, 25, 1, 7, 7};
            pnlPoljaLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlPoljaLayout.columnWidths = new int[]{25, 100, 135, 105, 280, 110, 7};
            this.pnlPolja.setLayout((LayoutManager)pnlPoljaLayout);
            this.pnlPolja.setOpaque(false);
            this.lblSifraKomitenta = new JLabel();
            this.pnlPolja.add((Component)this.lblSifraKomitenta, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblSifraKomitenta.setName("lblSifraKomitenta");
            this.tfSifraKomitenta = new PzTextField();
            this.pnlPolja.add((Component)this.tfSifraKomitenta, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfSifraKomitenta.setFocusable(false);
            this.tfNazivKomitenta = new PzTextField();
            this.pnlPolja.add((Component)this.tfNazivKomitenta, (Object)new GridBagConstraints(3, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.tfNazivKomitenta.setFocusable(false);
            this.lblRj = new JLabel();
            this.pnlPolja.add((Component)this.lblRj, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblRj.setName("lblRj");
            this.tfRj = new PzTextField();
            this.pnlPolja.add((Component)this.tfRj, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfRj.setFocusable(false);
            this.tfNazivRj = new PzTextField();
            this.pnlPolja.add((Component)this.tfNazivRj, (Object)new GridBagConstraints(3, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.tfNazivRj.setFocusable(false);
            this.lblSelektirano = new JLabel();
            this.pnlPolja.add((Component)this.lblSelektirano, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblSelektirano.setName("lblSelektirano");
            this.dfSelektovano = new PzDoubleField();
            this.pnlPolja.add((Component)this.dfSelektovano, (Object)new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfSelektovano.setFocusable(false);
            this.btnIzmenaRj = new PzButton();
            this.pnlPolja.add((Component)this.btnIzmenaRj, (Object)new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(1, 5, 1, 0), 0, 0));
            this.btnIzmenaRj.setName("btnIzmenaRj");
            this.btnIzmenaRj.setActionCommand("izmenaRj");
            this.btnIzmenaRj.addActionListener((ActionListener)((Object)this));
            this.btnIzmenaRj.setFocusable(false);
            if (this.tipDokumenta.equals(ListaUtil.getTipListe("PONUDA"))) {
                this.jlVrednostPoena = new JLabel();
                this.pnlPolja.add((Component)this.jlVrednostPoena, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.jlVrednostPoena.setText("Vrednost poena");
                this.dfVrednostPoena = new PzDoubleField();
                this.pnlPolja.add((Component)this.dfVrednostPoena, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.dfVrednostPoena.setName("dfVrednostPoena");
                this.dfVrednostPoena.setFocusable(false);
                this.btnPromenaVrednostiPoena = new PzButton();
                this.pnlPolja.add((Component)this.btnPromenaVrednostiPoena, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
                this.btnPromenaVrednostiPoena.setName("btnVrednostPoena");
                this.btnPromenaVrednostiPoena.setActionCommand("promenaVredPoena");
                this.btnPromenaVrednostiPoena.addActionListener((ActionListener)((Object)this));
                this.btnPromenaVrednostiPoena.setFocusable(false);
                this.btnPromenaVrednostiPoena.setEnabled(false);
            }
            this.scrollPane = new JScrollPane();
            this.pnlGlavni.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 2, 4, 2, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            this.tblArtikli = new PzTable();
            this.tblArtikli.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IzradaNarudzbenice.this.icnDodavanjeArt.doClick();
                }
            });
            if (!this.tipDokumenta.equals(ListaUtil.getTipListe("PONUDA"))) {
                this.tblArtikli.setFilter(new PzEntityFilter(){

                    public Object[] getValues(PzEntity entity) {
                        Artikallista art = (Artikallista)entity;
                        return new Object[]{art.getSfrProizvod(), art.getDobSifra(), art.getNaziv(), art.getKolicina(), art.getCena(), art.getPomKolicina(), art.getStandPak()};
                    }

                    public String[] getColumnNames() {
                        return new String[]{"Na\u0161a \u0161ifra", "Va\u0161a \u0161ifra", "Naziv", "Koli\u010dina", "Cena", "<html>Raspolo\u017eiva<br>koli\u010dina</html>", "<html>Standardno<br>pakovanje</html>"};
                    }
                });
            } else {
                this.tblArtikli.setFilter(new PzEntityFilter(){

                    public Object[] getValues(PzEntity entity) {
                        Artikallista art = (Artikallista)entity;
                        if (art != null) {
                            return new Object[]{art.getSfrProizvod(), art.getNaziv(), art.getDobSifra(), art.getKolicina(), art.getCena(), "1".equals(art.getTip()) ? "DA" : ""};
                        }
                        return null;
                    }

                    public String[] getColumnNames() {
                        return new String[]{"\u0160ifra", "Naziv", "Katalo\u0161ki broj", "Koli\u010dina", "Cena", "Rabat"};
                    }
                });
            }
            this.tblArtikli.setId(this.tableID);
            this.scrollPane.setViewportView((Component)this.tblArtikli);
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("Broj stavki");
            this.statusBar.add((Component)this.brStavki);
            this.brStavki.setFocusable(false);
            this.brStavki.setOpaque(false);
            this.setPreferredSize(new Dimension(925, 600));
            this.setMinimumSize(new Dimension(925, 600));
            this.setSelektovano();
            this.pack();
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void actionPerformed(ActionEvent arg0) {
        block42: {
            button = (PzButton)arg0.getSource();
            actionCommand = button.getActionCommand();
            em = PzEntityManager.getEm();
            this.getSession().putParameter("lista", (Object)this.lista);
            this.getSession().putParameter("tabela", (Object)this.tblArtikli);
            this.getSession().putParameter("rj", (Object)this.rj);
            try {
                if (actionCommand.equals("izmenaRj")) {
                    this.rj = PzDialogRJ.getRJ((PzDialog)this);
                    if (this.rj != null) {
                        this.tfRj.setVal((Object)this.rj.getId().getOznRj());
                        this.tfNazivRj.setVal((Object)this.rj.getNaziv());
                    }
                    break block42;
                }
                if (actionCommand.equals("dodavanje")) {
                    this.getSession().putParameter("update", (Object)false);
                    this.getSession().putParameter("saSifrom", (Object)true);
                    this.getSession().putParameter("prekoPoena", (Object)false);
                    if (this.btnPromenaVrednostiPoena != null && this.btnPromenaVrednostiPoena.isEnabled()) {
                        this.getSession().putParameter("prekoPoena", (Object)true);
                    }
                    this.showDialog(DodavanjeStavkeNarudzbenice.class);
                    this.setSelektovano();
                    break block42;
                }
                if (actionCommand.equals("izmena")) {
                    if (this.tblArtikli.getSelectedRow() != -1) {
                        this.getSession().putParameter("update", (Object)true);
                        aLista = (Artikallista)this.tblArtikli.getSelectedEntity();
                        if (aLista.getSfrProizvod() != null) {
                            this.getSession().putParameter("saSifrom", (Object)true);
                        } else {
                            this.getSession().putParameter("saSifrom", (Object)false);
                        }
                        this.showDialog(DodavanjeStavkeNarudzbenice.class);
                        this.setSelektovano();
                    }
                    break block42;
                }
                if (actionCommand.equalsIgnoreCase("brisanje")) {
                    em.getTransaction().begin();
                    if (this.tblArtikli.removeSelectedEntity(true, em)) {
                        em.getTransaction().commit();
                        this.lista = (Lista)em.find(Lista.class, (Object)this.lista.getIdLista());
                        this.tblArtikli.commitRemove();
                        this.setSelektovano();
                    }
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().commit();
                    }
                    break block42;
                }
                if (actionCommand.equals("dodajBezSifre")) {
                    this.getSession().putParameter("update", (Object)false);
                    this.getSession().putParameter("saSifrom", (Object)false);
                    this.showDialog(DodavanjeStavkeNarudzbenice.class);
                    this.setSelektovano();
                    break block42;
                }
                if (!actionCommand.startsWith("brisi_")) ** GOTO lbl67
                akcija = actionCommand.substring(actionCommand.indexOf("_") + 1);
                vrsta = akcija.equals("Kolicinu") != false ? " koli\u010dinama" : (akcija.equals("Cenu") != false ? " cenama" : " nazivima");
                rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)("Da li ste sigurni da \u017eelite da obri\u0161ete podatke o" + vrsta + "?"), (String)"Brisanje", null, (boolean)false);
                if (rez != 0) {
                    return;
                }
                try {
                    if (akcija.equals("Kolicinu")) {
                        this.brisiPodatkeOKolicinama();
                    } else if (akcija.equals("Cenu")) {
                        this.brisiPodatkeOCenama();
                    } else {
                        this.brisiPodatkeONazivima();
                    }
                    this.tblArtikli.refreshData();
                    this.setSelektovano();
                    break block42;
lbl67:
                    // 1 sources

                    if (actionCommand.equals("izmenaCena")) {
                        this.showDialog(PovecanjeCena.class);
                        this.setIznosSelektovanih();
                    } else if (actionCommand.equals("uzmiDrugu")) {
                        this.getSession().putParameter("tipDokumenta", (Object)this.lista.getTip());
                        this.showDialog(UzmiDrugu.class);
                        this.setSelektovano();
                    } else if (actionCommand.equals("dopunaLager")) {
                        this.getSession().putParameter("lista", (Object)this.lista);
                        this.getSession().putParameter("tabela", (Object)this.tblArtikli);
                        this.getSession().putParameter("rj", (Object)this.rj);
                        this.showDialog(DopunaPoLageru.class);
                        this.setSelektovano();
                    } else if (actionCommand.equals("dopunaStokovi")) {
                        this.getSession().putParameter("lista", (Object)this.lista);
                        this.getSession().putParameter("tabela", (Object)this.tblArtikli);
                        this.getSession().putParameter("rj", (Object)this.rj);
                        this.showDialog(DopunaPoStoku.class);
                        this.setSelektovano();
                    } else if (actionCommand.equals("dopunaNabavka")) {
                        this.getSession().putParameter("lista", (Object)this.lista);
                        this.getSession().putParameter("tabela", (Object)this.tblArtikli);
                        this.getSession().putParameter("rj", (Object)this.rj);
                        this.showDialog(DopunaPoNabavci.class);
                        this.setSelektovano();
                    } else if (actionCommand.equals("poProdaji")) {
                        this.getSession().putParameter("lista", (Object)this.lista);
                        this.getSession().putParameter("tabela", (Object)this.tblArtikli);
                        this.getSession().putParameter("rj", (Object)this.rj);
                        this.showDialog(DopunaPoProdaji.class);
                        this.setSelektovano();
                    } else if (actionCommand.equals("prekoPoena")) {
                        this.btnPromenaVrednostiPoena.setEnabled(this.btnPromenaVrednostiPoena.isEnabled() == false);
                        if (!this.btnPromenaVrednostiPoena.isEnabled()) {
                            this.dfVrednostPoena.setVal((Object)0);
                        }
                    } else if (actionCommand.equals("promenaVredPoena")) {
                        this.showDialog(PromenaVrednostiPoena.class);
                    } else if (actionCommand.equals("arhiva") && this.tblArtikli.getSelectedRow() != -1) {
                        this.getSession().putParameter("izrada", (Object)true);
                        this.getSession().putParameter("lista", em.find(Lista.class, (Object)this.lista.getIdLista()));
                        this.getSession().putParameter("poruka", (Object)this.getPoruka());
                        this.showDialog(Arhiviranje.class);
                    }
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)this, (Throwable)e1);
                }
            }
            finally {
                em.close();
            }
        }
    }

    private boolean getPoruka() {
        boolean rez = false;
        for (Artikallista a : this.lista.getArtikallistas()) {
            if (!"-1".equals(a.getTip())) continue;
            rez = true;
            break;
        }
        return rez;
    }

    private void brisiPodatkeOKolicinama() {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            em.getTransaction().begin();
            for (Artikallista aLista : this.lista.getArtikallistas()) {
                aLista.setKolicina(0.0);
                em.merge((Object)aLista);
            }
            em.getTransaction().commit();
        }
        catch (Exception e) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
    }

    private void brisiPodatkeOCenama() {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            em.getTransaction().begin();
            for (Artikallista aLista : this.lista.getArtikallistas()) {
                aLista.setCena(BDConverter.getFakturnaCena((double)0.0));
                em.merge((Object)aLista);
            }
            em.getTransaction().commit();
        }
        catch (Exception e) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
    }

    private void brisiPodatkeONazivima() {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            em.getTransaction().begin();
            for (Artikallista aLista : this.lista.getArtikallistas()) {
                aLista.setNaziv("");
                em.merge((Object)aLista);
            }
            em.getTransaction().commit();
        }
        catch (Exception e) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
    }

    public boolean shouldBeShown() {
        boolean result = true;
        this.rj = PzDialogRJ.getRJ((PzDialog)this);
        if (this.rj != null) {
            this.tfRj.setVal((Object)this.rj.getId().getOznRj());
            this.tfNazivRj.setVal((Object)this.rj.getNaziv());
        } else {
            result = false;
        }
        return result;
    }

    public void finish() {
        ((PzDialogNarudzbeniceUPripremi)this.getParentDialog()).ukloniListu();
        this.dispose();
    }

    public void setVrednostPoena(Double vrednostPoena) {
        this.dfVrednostPoena.setVal((Object)vrednostPoena);
    }

    public Double getVrednostPoena() {
        return this.dfVrednostPoena.getVal();
    }
}

