/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.liste.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.jdesktop.swingx.JXStatusBar;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Lista;
import rs.pezar.liste.gui.izrada.Arhiviranje;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBar;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzIntegerField;
import rs.pezar.util.PzDateUtility;

public class PzDialogListeArhiva
extends PzDialog {
    private static final long serialVersionUID = 1448469294084323367L;
    private final PzPanel contentPanel = new PzPanel();
    private PzToolBar toolbar;
    private PzPanel pnlPretraga;
    private PzPanel pnlTabela;
    private JXStatusBar statusBar;
    private PzButton icnStampanje;
    private JLabel lblTipListe;
    private JComboBox cbTip;
    private JLabel lblDatumOd;
    private PzDateField datOd;
    private JLabel lblDatumDo;
    private PzDateField datDo;
    private PzButton btnTrazi;
    private JScrollPane scrPane;
    private JLabel lbl1;
    private JLabel lblBrojPogodaka;
    private PzTable table;
    private JLabel lblBrojListe;
    private PzIntegerField intBrojListe;

    public static void main(String[] args) {
        try {
            PzDialogListeArhiva dialog = new PzDialogListeArhiva();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PzDialogListeArhiva() {
        this.initGUI();
    }

    public PzDialogListeArhiva(JFrame parent) {
        super(parent);
        this.initGUI();
        this.contentPanel.setPaintGradient(true);
        this.setTip();
    }

    private void initGUI() {
        this.setTitle("Liste iz arhive");
        this.setSize(1024, 768);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.contentPanel, "Center");
        GridBagLayout gbl_contentPanel = new GridBagLayout();
        gbl_contentPanel.columnWidths = new int[2];
        int[] nArray = new int[5];
        nArray[1] = 66;
        gbl_contentPanel.rowHeights = nArray;
        gbl_contentPanel.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_contentPanel.rowWeights = new double[]{0.0, 0.0, 1.0, 0.0, Double.MIN_VALUE};
        this.contentPanel.setLayout((LayoutManager)gbl_contentPanel);
        this.toolbar = new PzToolBar();
        GridBagConstraints gbc_toolbar = new GridBagConstraints();
        gbc_toolbar.insets = new Insets(0, 0, 5, 0);
        gbc_toolbar.fill = 2;
        gbc_toolbar.gridx = 0;
        gbc_toolbar.gridy = 0;
        this.contentPanel.add((Component)this.toolbar, (Object)gbc_toolbar);
        this.toolbar.setOpaque(false);
        this.icnStampanje = new PzButton();
        this.icnStampanje.setFocusable(false);
        this.icnStampanje.setText("\u0160tampanje|liste (F2)");
        this.icnStampanje.setIcon((Icon)new ImageIcon(PzDialogListeArhiva.class.getResource("/rs/pezar/liste/resource/img/printer_preferences.png")));
        this.icnStampanje.setOpaque(false);
        this.icnStampanje.addActionListener((ActionListener)new AbstractAction(){
            private static final long serialVersionUID = 1492632102210114132L;

            @Override
            public void actionPerformed(ActionEvent paramActionEvent) {
                PzDialogListeArhiva.this.showReport();
            }
        });
        this.icnStampanje.setShortcut("F2");
        this.toolbar.add((Component)this.icnStampanje);
        this.pnlPretraga = new PzPanel();
        this.pnlPretraga.setBorder((Border)new TitledBorder(null, "Pretraga", 4, 2, null, null));
        GridBagConstraints gbc_pnlPretraga = new GridBagConstraints();
        gbc_pnlPretraga.insets = new Insets(0, 0, 5, 0);
        gbc_pnlPretraga.fill = 1;
        gbc_pnlPretraga.gridx = 0;
        gbc_pnlPretraga.gridy = 1;
        this.contentPanel.add((Component)this.pnlPretraga, (Object)gbc_pnlPretraga);
        GridBagLayout gbl_pnlPretraga = new GridBagLayout();
        int[] nArray2 = new int[10];
        nArray2[1] = 200;
        nArray2[5] = 100;
        nArray2[7] = 100;
        nArray2[8] = 128;
        gbl_pnlPretraga.columnWidths = nArray2;
        int[] nArray3 = new int[2];
        nArray3[0] = 22;
        gbl_pnlPretraga.rowHeights = nArray3;
        gbl_pnlPretraga.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_pnlPretraga.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.pnlPretraga.setLayout((LayoutManager)gbl_pnlPretraga);
        this.pnlPretraga.setOpaque(false);
        this.lblTipListe = new JLabel("Tip liste:");
        GridBagConstraints gbc_lblTipListe = new GridBagConstraints();
        gbc_lblTipListe.fill = 3;
        gbc_lblTipListe.insets = new Insets(0, 0, 0, 5);
        gbc_lblTipListe.anchor = 13;
        gbc_lblTipListe.gridx = 0;
        gbc_lblTipListe.gridy = 0;
        this.pnlPretraga.add((Component)this.lblTipListe, (Object)gbc_lblTipListe);
        this.cbTip = new JComboBox();
        this.cbTip.setFont(new Font("SansSerif", 0, 14));
        GridBagConstraints gbc_cbTip = new GridBagConstraints();
        gbc_cbTip.insets = new Insets(0, 0, 0, 5);
        gbc_cbTip.fill = 2;
        gbc_cbTip.gridx = 1;
        gbc_cbTip.gridy = 0;
        this.pnlPretraga.add((Component)this.cbTip, (Object)gbc_cbTip);
        this.lblBrojListe = new JLabel("Broj liste:");
        GridBagConstraints gbc_lblBrojListe = new GridBagConstraints();
        gbc_lblBrojListe.anchor = 13;
        gbc_lblBrojListe.insets = new Insets(0, 0, 0, 5);
        gbc_lblBrojListe.gridx = 2;
        gbc_lblBrojListe.gridy = 0;
        this.pnlPretraga.add((Component)this.lblBrojListe, (Object)gbc_lblBrojListe);
        this.intBrojListe = new PzIntegerField();
        this.intBrojListe.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent paramKeyEvent) {
                PzDialogListeArhiva.this.intBrojListekeyReleased(paramKeyEvent);
            }
        });
        this.intBrojListe.setColumns(5);
        GridBagConstraints gbc_intBrojListe = new GridBagConstraints();
        gbc_intBrojListe.insets = new Insets(0, 0, 0, 5);
        gbc_intBrojListe.fill = 2;
        gbc_intBrojListe.gridx = 3;
        gbc_intBrojListe.gridy = 0;
        this.pnlPretraga.add((Component)this.intBrojListe, (Object)gbc_intBrojListe);
        this.lblDatumOd = new JLabel("Datum od:");
        GridBagConstraints gbc_lblDatumOd = new GridBagConstraints();
        gbc_lblDatumOd.insets = new Insets(0, 0, 0, 5);
        gbc_lblDatumOd.anchor = 13;
        gbc_lblDatumOd.gridx = 4;
        gbc_lblDatumOd.gridy = 0;
        this.pnlPretraga.add((Component)this.lblDatumOd, (Object)gbc_lblDatumOd);
        this.datOd = new PzDateField();
        this.datOd.setVal((Object)PzDateUtility.getFirstDayOfCurrentYear());
        GridBagConstraints gbc_datOd = new GridBagConstraints();
        gbc_datOd.insets = new Insets(0, 0, 0, 5);
        gbc_datOd.fill = 2;
        gbc_datOd.gridx = 5;
        gbc_datOd.gridy = 0;
        this.pnlPretraga.add((Component)this.datOd, (Object)gbc_datOd);
        this.lblDatumDo = new JLabel("Datum do:");
        GridBagConstraints gbc_lblDatumDo = new GridBagConstraints();
        gbc_lblDatumDo.insets = new Insets(0, 0, 0, 5);
        gbc_lblDatumDo.anchor = 13;
        gbc_lblDatumDo.gridx = 6;
        gbc_lblDatumDo.gridy = 0;
        this.pnlPretraga.add((Component)this.lblDatumDo, (Object)gbc_lblDatumDo);
        this.datDo = new PzDateField();
        GridBagConstraints gbc_datDo = new GridBagConstraints();
        gbc_datDo.insets = new Insets(0, 0, 0, 5);
        gbc_datDo.fill = 2;
        gbc_datDo.gridx = 7;
        gbc_datDo.gridy = 0;
        this.pnlPretraga.add((Component)this.datDo, (Object)gbc_datDo);
        this.btnTrazi = new PzButton();
        this.btnTrazi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PzDialogListeArhiva.this.btnTraziactionPerformed(arg0);
            }
        });
        this.btnTrazi.setIcon((Icon)new ImageIcon(PzDialogListeArhiva.class.getResource("/rs/pezar/liste/resource/img/find.png")));
        this.btnTrazi.setText("Tra\u017ei");
        GridBagConstraints gbc_btnTrazi = new GridBagConstraints();
        gbc_btnTrazi.gridx = 8;
        gbc_btnTrazi.gridy = 0;
        this.pnlPretraga.add((Component)this.btnTrazi, (Object)gbc_btnTrazi);
        this.pnlTabela = new PzPanel();
        this.pnlTabela.setOpaque(false);
        this.pnlTabela.setBorder((Border)new EmptyBorder(0, 7, 7, 7));
        GridBagConstraints gbc_pnlTabela = new GridBagConstraints();
        gbc_pnlTabela.insets = new Insets(0, 0, 5, 0);
        gbc_pnlTabela.fill = 1;
        gbc_pnlTabela.gridx = 0;
        gbc_pnlTabela.gridy = 2;
        this.contentPanel.add((Component)this.pnlTabela, (Object)gbc_pnlTabela);
        this.pnlTabela.setLayout((LayoutManager)new BorderLayout(0, 0));
        this.scrPane = new JScrollPane();
        this.pnlTabela.add((Component)this.scrPane, (Object)"Center");
        this.table = new PzTable();
        this.scrPane.setViewportView((Component)this.table);
        this.statusBar = new JXStatusBar();
        GridBagConstraints gbc_statusBar = new GridBagConstraints();
        gbc_statusBar.fill = 2;
        gbc_statusBar.gridx = 0;
        gbc_statusBar.gridy = 3;
        this.contentPanel.add((Component)this.statusBar, (Object)gbc_statusBar);
        this.lbl1 = new JLabel("Broj pogodaka");
        this.statusBar.add((Component)this.lbl1);
        this.lblBrojPogodaka = new JLabel();
        this.statusBar.add((Component)this.lblBrojPogodaka);
    }

    protected void showReport() {
        if (this.table.getSelectedRow() == -1) {
            return;
        }
        this.getSession().putParameter("lista", (Object)this.table.getSelectedEntity());
        this.getSession().putParameter("arhiva", (Object)Boolean.TRUE);
        this.showDialog(Arhiviranje.class);
        this.getSession().putParameter("arhiva", null);
    }

    private void setTip() {
        try {
            Properties props = new Properties();
            props.load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("rs/pezar/liste/resource/tip.properties"));
            Object[] tipovi = props.keySet().toArray();
            int i = 0;
            while (i < tipovi.length) {
                this.cbTip.addItem(new PzChoice((String)tipovi[i], props.get(tipovi[i])));
                if (tipovi[i].equals("STANDARDNA")) {
                    this.cbTip.setSelectedIndex(i);
                }
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setData() {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        Query q = em.createQuery("SELECT l FROM Lista l WHERE l.arhiviran=1 AND l.datum >=:datumOd AND l.datum<=:datumDo AND l.tip=:tip" + (this.intBrojListe.getText().equals("") ? "" : " AND l.rBroj=:rBroj"));
        if (this.datOd.isEnabled()) {
            q.setParameter("datumOd", (Object)this.datOd.getVal());
        } else {
            q.setParameter("datumOd", (Object)PzDateUtility.getFirstDayOfCurrentYear());
        }
        if (this.datDo.isEnabled()) {
            q.setParameter("datumDo", (Object)this.datDo.getVal());
        } else {
            q.setParameter("datumDo", (Object)PzDateUtility.getCurrentDate());
        }
        if (!this.intBrojListe.getText().equals("")) {
            q.setParameter("rBroj", (Object)this.intBrojListe.getVal());
        }
        q.setParameter("tip", ((PzChoice)this.cbTip.getSelectedItem()).getValue());
        List liste = q.getResultList();
        this.table.setData(liste, Lista.class);
        this.lblBrojPogodaka.setText(String.valueOf(liste.size()));
        this.table.requestFocus();
    }

    protected void btnTraziactionPerformed(ActionEvent arg0) {
        this.setData();
    }

    public void actionPerformed(ActionEvent e) {
    }

    protected void intBrojListekeyReleased(KeyEvent paramKeyEvent) {
        if (this.intBrojListe.getText().equals("")) {
            this.datOd.setEnabled(true);
            this.datDo.setEnabled(true);
        } else {
            this.datOd.setEnabled(false);
            this.datDo.setEnabled(false);
        }
    }
}

