/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval;

import net.sourceforge.jeval.EvaluationException;
import net.sourceforge.jeval.Evaluator;
import net.sourceforge.jeval.function.Function;
import net.sourceforge.jeval.function.FunctionException;
import net.sourceforge.jeval.function.FunctionHelper;
import net.sourceforge.jeval.function.FunctionResult;

public class MockStringReverseFunction
implements Function {
    @Override
    public String getName() {
        return "stringReverse";
    }

    @Override
    public FunctionResult execute(Evaluator evaluator, String arguments) throws FunctionException {
        String result = "";
        try {
            String stringValue = new Evaluator().evaluate(arguments, true, false);
            String argumentOne = FunctionHelper.trimAndRemoveQuoteChars(stringValue, evaluator.getQuoteCharacter());
            int size = argumentOne.length();
            int index = size - 1;
            while (index >= 0) {
                result = String.valueOf(result) + argumentOne.charAt(index);
                --index;
            }
        }
        catch (FunctionException fe) {
            throw new FunctionException(fe.getMessage(), fe);
        }
        catch (EvaluationException ee) {
            throw new FunctionException("Invalid expression in arguments.", ee);
        }
        catch (Exception e) {
            throw new FunctionException("One string argument is required.", e);
        }
        return new FunctionResult(result, 1);
    }
}

