/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.util;

import java.awt.Component;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import rs.pezar.core.PzApplication;
import rs.pezar.core.format.BDConverter;
import rs.pezar.core.transformation.DefaultDokumentTransformer;
import rs.pezar.core.transformation.TransformationException;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDefaultDokumentCustomizer;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzBrojacRj;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Artikalfakturaparameter;
import rs.pezar.db.entity.ArtikalfakturaparameterPK;
import rs.pezar.db.entity.Artikallista;
import rs.pezar.db.entity.Artikalopstidokument;
import rs.pezar.db.entity.Brojac;
import rs.pezar.db.entity.Dokumentpotvrda;
import rs.pezar.db.entity.DokumentpotvrdaPK;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fakturaservisa;
import rs.pezar.db.entity.Fakturausluga;
import rs.pezar.db.entity.FiskalniIzvestaj;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Komitentgrupa;
import rs.pezar.db.entity.Komitentparameter;
import rs.pezar.db.entity.Lista;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Rabat;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.RadnajedinicaPK;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.db.entity.StanjeartikalPK;
import rs.pezar.db.entity.Stavkafaktureusl;
import rs.pezar.db.entity.Taksafaktura;
import rs.pezar.db.entity.Uslugafaktura;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.msg.device.cashregister.CashRegisterHandler;
import rs.pezar.msg.device.cashregister.data.Article;
import rs.pezar.msg.device.cashregister.data.CashRegisterBill;
import rs.pezar.msg.device.cashregister.data.CashRegisterControl;
import rs.pezar.msg.msg.MsgProtocol;
import rs.pezar.prodaja.PzExtensionLoader;
import rs.pezar.prodaja.gui.PzDialogIzradaFaktureZaProdajuRobe;
import rs.pezar.prodaja.gui.faktureZaProdajuRobe.IzborModeratora;
import rs.pezar.prodaja.gui.util.PanelRabati;
import rs.pezar.service.msg.chat.textComponent.notification.NotificationText;
import rs.pezar.sifarnici.util.KomitentPrometUtility;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;
import rs.pezar.util.PzMathUtility;

public class PzProdajaUtil {
    public static final String PARAMETER_RJ = "RJ";
    public static final String PARAMETER_TIP = "TIP_DOKUMENTA";
    public static final String TRANSFORMER = "FAKTURA_TRANSFORMER";
    public static final String PARAMETER_KOMITENT = "KOMITENT";
    public static final String PARAMETER_DATUM_IZRADE = "DATUM_IZRADE";
    public static final String PARAMETER_DATUM_PROMETA = "DATUM_PROMETA";
    public static final String PARAMETER_DATUM_VALUTE = "DATUM_VALUTE";
    public static final String PARAMETER_KURS = "KURS";
    private static String KRITICNA_GRUPA_TIP = "KRITICNA";
    private static String CRNA_GRUPA_TIP = "CRNA";
    private static String RABAT_DISCRIMINATOR = "RBT";
    public static String ZATVARANJE_FAKTURE_AVANSOM_DISCRIMINATOR = "ZFA";

    public static Query getPretragaIzArhiveQuery(PzDokument dokument, String stornoExpression, Date datumOd, Date datumDo, Radnajedinica rj, int sfrKomitent, String oznDokument, String dodatniUslov) {
        EntityManager em = PzEntityManager.getEm();
        Query q = PzProdajaUtil.getPretragaIzArhiveQuery(em, dokument, stornoExpression, datumOd, datumDo, rj, sfrKomitent, oznDokument, dodatniUslov);
        em.close();
        return q;
    }

    public static Query getPretragaIzArhiveQuery(EntityManager em, PzDokument dokument, String stornoExpression, Date datumOd, Date datumDo, Radnajedinica rj, int sfrKomitent, String oznDokument, String dodatniUslov) {
        Query rez = null;
        try {
            String upit = "";
            if (dokument instanceof Fakturausluga) {
                upit = "SELECT f.oznDokumenta, k.sfrKomitent, k.naziv, f.datum, f.proknjizen, (SELECT CASE f.storno WHEN 1 THEN -fu.vrednostUsluga ELSE fu.vrednostUsluga END FROM Faktura fu WHERE fu.idDok = f.idDok AND f.saPorezom=1), CASE f.storno WHEN 1 THEN -SUM(taksa.iznos) ELSE SUM(taksa.iznos) END, (SELECT CASE f.storno WHEN 1 THEN -fu.vrednostUsluga ELSE fu.vrednostUsluga END FROM Faktura fu WHERE fu.idDok = f.idDok AND f.saPorezom=0 AND f.saPravomNaOdbitak=1), (SELECT CASE f.storno WHEN 1 THEN -fu.vrednostUsluga ELSE fu.vrednostUsluga END FROM Faktura fu WHERE fu.idDok = f.idDok AND f.saPorezom=0 AND f.saPravomNaOdbitak=0), CASE f.storno WHEN 1 THEN -f.iznos ELSE f.iznos END, f.usernamekraj, f.idDok FROM Komitent k , Faktura f LEFT JOIN Taksafaktura taksa ON f.idDok = taksa.idDok AND taksa.vrsta='PDV' WHERE f.storno" + stornoExpression + " AND f.arhiviran=1 AND f.datum>=':datumOD' AND f.datum<=':datumDO' " + "AND f.oznRj=':rj' AND f.oznOgranak=':ogranak' AND f.sfrKomitent=k.sfrKomitent AND f.tip='" + TipDokumentConfig.get().FAKTURA_USLUGA + "'";
            } else {
                Faktura f = (Faktura)dokument;
                boolean prodajna = false;
                if (rj != null) {
                    prodajna = rj.getNacinVodjenja().equals("PRODAJNA");
                }
                if (f.getTip().equals("FAKTURA")) {
                    if (f.izMaloprodaje()) {
                        upit = "SELECT f.oznDokumenta, k.sfrKomitent, k.naziv, f.datum, f.datValute, CASE f.storno WHEN 1 THEN -f.iznos ELSE f.iznos END, CASE f.storno WHEN 1 THEN -SUM(taksa.iznos) ELSE SUM(taksa.iznos) END, f.usernamekraj, f.idDok FROM Komitent k , Faktura f LEFT JOIN Taksafaktura taksa ON f.idDok = taksa.idDok AND taksa.vrsta='PDV' WHERE f.storno" + stornoExpression + " AND f.arhiviran=1 AND f.datum>=':datumOD' AND f.datum<=':datumDO' AND " + "f.tip in (':tip', '" + "FAKTURA_IZ_SERVISA" + "') " + "AND f.podTip not in ('" + "POCETNO" + "', '" + "TRENUTNA_SITUACIJA" + "','" + TipDokumentConfig.get().PODTIP_FAKTURA_SA_NALOGA + "') AND f.oznRj=':rj' AND f.oznOgranak=':ogranak' " + "AND f.sfrKomitent=k.sfrKomitent";
                    } else {
                        upit = "SELECT f.oznDokumenta, k.sfrKomitent, k.naziv, f.datum, f.datValute, f.proknjizen, CASE f.storno WHEN 1 THEN -f.iznos ELSE f.iznos END, CASE f.storno WHEN 1 THEN -f.rabatUkupno ELSE f.rabatUkupno END, CASE f.storno WHEN 1 THEN -SUM(taksa.iznos) ELSE SUM(taksa.iznos) END";
                        if (!prodajna) {
                            upit = String.valueOf(upit) + ", CASE f.storno WHEN 1 THEN -f.nabavnaUkupno ELSE f.nabavnaUkupno END, CASE f.storno WHEN 1 THEN -(f.iznos-SUM(taksa.iznos)) ELSE (f.iznos-SUM(taksa.iznos)) END";
                        }
                        upit = String.valueOf(upit) + ", f.usernamekraj, f.idDok";
                        upit = String.valueOf(upit) + " FROM Komitent k, Faktura f LEFT JOIN Taksafaktura taksa ON f.idDok = taksa.idDok AND taksa.vrsta='PDV' WHERE f.storno" + stornoExpression + " AND f.arhiviran=1 AND f.datum>=':datumOD' AND f.datum<=':datumDO' AND " + "(f.tip=':tip' OR f.tip='" + "FAKTURA_IZ_SERVISA" + "') " + "AND f.podTip not in ('" + "POCETNO" + "', '" + "TRENUTNA_SITUACIJA" + "','" + TipDokumentConfig.get().PODTIP_FAKTURA_SA_NALOGA + "') AND f.oznRj=':rj' AND f.oznOgranak=':ogranak' " + "AND f.sfrKomitent=k.sfrKomitent";
                    }
                } else if (f.getTip().equals("OTPREMNICA")) {
                    upit = "SELECT f.oznDokumenta, k.sfrKomitent, k.naziv, f.datum, CASE WHEN (f.podtip = 'SA' and f.storno = 0) THEN f.iznos ELSE 0 END + CASE WHEN (f.podtip = 'SA' and f.storno = 1) THEN -f.iznos ELSE 0 END, CASE WHEN (f.podtip = 'SA' and f.storno = 0) THEN f.iznos-f.stornoIznos ELSE 0 END + CASE WHEN (f.podtip = 'SA' and f.storno = 1) THEN -(f.iznos-f.stornoIznos) ELSE 0 END, (SELECT fak.oznDokumenta FROM Faktura fak where fak.idDok = f.faktura), SUM(CASE WHEN (f.podtip = 'SA' and f.storno = 0) THEN taksa.iznos ELSE 0 END) + SUM(CASE WHEN (f.podtip = 'SA' and f.storno = 1) THEN -taksa.iznos ELSE 0 END), f.zauzeto, f.usernamekraj, f.idDok FROM Komitent k, Faktura f LEFT JOIN Taksafaktura taksa ON f.idDok = taksa.idDok AND taksa.vrsta='PDV' WHERE f.storno" + stornoExpression + " AND f.arhiviran=1 AND f.datum>=':datumOD' AND f.datum<=':datumDO' AND f.tip=':tip' " + "AND f.oznRj=':rj' AND f.oznOgranak=':ogranak' AND f.sfrKomitent=k.sfrKomitent";
                } else if (f.getTip().equals("PRENOSNICA_SA_KONSIGNACIJE")) {
                    upit = "SELECT f.oznDokumenta, k.sfrKomitent, k.naziv, f.datum, CASE f.storno WHEN 1 THEN -f.iznos ELSE f.iznos END, CASE f.storno WHEN 1 THEN -(f.iznos-f.stornoIznos) ELSE f.iznos-f.stornoIznos END, CASE f.storno WHEN 1 THEN -SUM(taksa.iznos) ELSE SUM(taksa.iznos) END, f.usernamekraj, f.idDok FROM Komitent k, Faktura f LEFT JOIN Taksafaktura taksa ON f.idDok = taksa.idDok AND taksa.vrsta='PDV' WHERE f.storno" + stornoExpression + " AND f.arhiviran=1 AND f.datum>=':datumOD' AND f.datum<=':datumDO' AND f.tip=':tip' " + "AND f.oznRj=':rj' AND f.oznOgranak=':ogranak' AND f.sfrKomitent=k.sfrKomitent";
                } else if (f.getTip().equals("PROFAKTURA")) {
                    upit = "SELECT f.oznDokumenta, k.sfrKomitent, k.naziv, f.datum, CASE f.storno WHEN 1 THEN -f.iznos ELSE f.iznos END, CASE f.storno WHEN 1 THEN -SUM(taksa.iznos) ELSE SUM(taksa.iznos) END, f.usernamekraj, f.idDok FROM Komitent k, Faktura f LEFT JOIN Taksafaktura taksa ON f.idDok = taksa.idDok AND taksa.vrsta='PDV' WHERE f.storno" + stornoExpression + " AND f.arhiviran=1 AND f.datum>=':datumOD' AND f.datum<=':datumDO' AND f.tip=':tip' " + "AND f.oznRj=':rj' AND f.oznOgranak=':ogranak' AND f.sfrKomitent=k.sfrKomitent";
                } else if (f.getTip().equals("AVANSNI_RACUN")) {
                    upit = "SELECT f.oznDokumenta, k.sfrKomitent, k.naziv, f.datum, f.iznos, SUM(taksa.iznos), f.uplata, f.usernamekraj, f.idDok FROM Komitent k, Faktura f LEFT JOIN Taksafaktura taksa ON f.idDok = taksa.idDok AND taksa.vrsta='PDV' WHERE f.storno" + stornoExpression + " AND f.arhiviran=1 AND f.podTip in ('" + "AVANSNI_RACUN_KOLICINA" + "'" + ", '" + "AVANSNI_RACUN_IZNOS" + "') AND f.datum>=':datumOD' AND f.datum<=':datumDO' AND f.tip=':tip' " + "AND f.sfrKomitent=k.sfrKomitent";
                } else if (f.getTip().equals("FAKTURA_INTERNI_RACUN")) {
                    if (f.izMaloprodaje()) {
                        upit = "SELECT f.oznDokumenta, f.datum, CASE f.storno WHEN 1 THEN -(f.iznos-SUM(taksa.iznos)) ELSE (f.iznos-SUM(taksa.iznos)) END, CASE f.storno WHEN 1 THEN -SUM(taksa.iznos) ELSE SUM(taksa.iznos) END, CASE f.storno WHEN 1 THEN -f.iznos ELSE f.iznos END, f.usernamekraj, f.idDok";
                        upit = String.valueOf(upit) + " FROM Faktura f LEFT JOIN Taksafaktura taksa ON f.idDok = taksa.idDok AND taksa.vrsta='PDV' WHERE f.datum>=':datumOD' AND f.datum<=':datumDO' AND f.tip=':tip' AND f.oznRj=':rj' AND f.oznOgranak=':ogranak' AND f.storno" + stornoExpression + " AND f.arhiviran=1";
                    } else {
                        upit = "SELECT f.oznDokumenta, f.datum, f.proknjizen, CASE f.storno WHEN 1 THEN -(f.iznos-SUM(taksa.iznos)) ELSE (f.iznos-SUM(taksa.iznos)) END, CASE f.storno WHEN 1 THEN -SUM(taksa.iznos) ELSE SUM(taksa.iznos) END, CASE f.storno WHEN 1 THEN -f.iznos ELSE f.iznos END";
                        if (!f.izMaloprodaje() && !prodajna) {
                            upit = String.valueOf(upit) + ", CASE f.storno WHEN 1 THEN -f.nabavnaUkupno ELSE f.nabavnaUkupno END";
                        }
                        upit = String.valueOf(upit) + ", f.usernamekraj, f.idDok";
                        upit = String.valueOf(upit) + " FROM Faktura f LEFT JOIN Taksafaktura taksa ON f.idDok = taksa.idDok AND taksa.vrsta='PDV' WHERE f.datum>=':datumOD' AND f.datum<=':datumDO' AND f.tip=':tip' AND f.oznRj=':rj' AND f.oznOgranak=':ogranak' AND f.storno" + stornoExpression + " AND f.arhiviran=1";
                    }
                } else if (f.getTip().equals("FAKTURA_TRANZITA")) {
                    upit = "SELECT f.oznDokumenta, k.sfrKomitent, k.naziv, f.datum, f.datValute, f.proknjizen, f.iznos, f.rabatUkupno, SUM(taksa.iznos)";
                    if (!prodajna) {
                        upit = String.valueOf(upit) + ", f.nabavnaUkupno";
                    }
                    upit = String.valueOf(upit) + ", f.usernamekraj, f.idDok";
                    upit = String.valueOf(upit) + " FROM Komitent k, Faktura f LEFT JOIN Taksafaktura taksa ON f.idDok = taksa.idDok AND taksa.vrsta='PDV' WHERE f.storno" + stornoExpression + " AND f.arhiviran=1 AND f.datum>=':datumOD' AND f.datum<=':datumDO' AND f.tip=':tip' " + "AND f.oznRj=':rj' AND f.oznOgranak=':ogranak' AND f.sfrKomitent=k.sfrKomitent";
                }
            }
            if (dokument instanceof Faktura) {
                if (sfrKomitent != 0) {
                    upit = String.valueOf(upit) + " AND f.sfrKomitent=':komitent'";
                    upit = upit.replace(":komitent", String.valueOf(sfrKomitent));
                }
                if (!oznDokument.equals("")) {
                    upit = String.valueOf(upit) + " AND f.oznDokumenta=':oznaka'";
                    upit = upit.replace(":oznaka", oznDokument);
                }
                if (!dodatniUslov.equals("")) {
                    upit = dokument.getTip().equals("OTPREMNICA") ? (dodatniUslov.equals("IS NOT") ? String.valueOf(upit) + " AND f.faktura " + dodatniUslov + " null and f.zauzeto is null" : String.valueOf(upit) + " AND (f.faktura " + dodatniUslov + " null OR f.faktura is not null and f.zauzeto is not null) AND f.storno = 0 and f.iznos - f.stornoIznos != 0") : (dodatniUslov.equals("=") ? String.valueOf(upit) + " AND f.uplata = f.iznos" : String.valueOf(upit) + " AND f.uplata <> f.iznos");
                }
            }
            if (dokument.getTip().equals("FAKTURA")) {
                upit = String.valueOf(upit) + " GROUP BY f.oznDokumenta, k.sfrKomitent, k.naziv, f.datum, f.datValute, f.proknjizen, f.iznos, f.rabatUkupno, f.nabavnaUkupno, f.idDok, f.rbrDok, f.storno, f.usernamekraj";
            } else if (dokument.getTip().equals("OTPREMNICA")) {
                upit = String.valueOf(upit) + " GROUP BY f.oznDokumenta, k.sfrKomitent, k.naziv, f.datum, f.iznos, f.stornoIznos, f.faktura, f.zauzeto, f.idDok, f.rbrDok, f.podtip, f.storno, f.usernamekraj ";
            } else if (dokument.getTip().equals("PRENOSNICA_SA_KONSIGNACIJE")) {
                upit = String.valueOf(upit) + " GROUP BY f.oznDokumenta, k.sfrKomitent, k.naziv, f.datum, f.iznos, f.stornoIznos, f.idDok, f.rbrDok, f.storno, f.usernamekraj ";
            } else if (dokument.getTip().equals("PROFAKTURA")) {
                upit = String.valueOf(upit) + " GROUP BY f.oznDokumenta, k.sfrKomitent, k.naziv, f.datum, f.iznos, f.idDok, f.rbrDok, f.usernamekraj ";
            } else if (dokument.getTip().equals("AVANSNI_RACUN")) {
                upit = String.valueOf(upit) + " GROUP BY f.oznDokumenta, k.sfrKomitent, k.naziv, f.datum, f.iznos, f.uplata, f.idDok, f.rbrDok, f.usernamekraj";
            } else if (dokument.getTip().equals("FAKTURA_INTERNI_RACUN")) {
                upit = String.valueOf(upit) + " GROUP BY f.oznDokumenta, f.datum, f.proknjizen, f.iznos, f.nabavnaUkupno, f.idDok, f.rbrDok, f.storno, f.usernamekraj";
            } else if (dokument.getTip().equals("FAKTURA_TRANZITA")) {
                upit = String.valueOf(upit) + " GROUP BY f.oznDokumenta, k.sfrKomitent, k.naziv, f.datum, f.datValute, f.proknjizen, f.iznos, f.rabatUkupno, f.nabavnaUkupno, f.idDok, f.rbrDok, f.usernamekraj ";
            } else if (dokument.getTip().equals("FAKTURA_USLUGA")) {
                upit = String.valueOf(upit) + " GROUP BY f.oznDokumenta, k.sfrKomitent, k.naziv, f.datum, f.proknjizen, f.iznos, f.saporezom, f.sapravomnaodbitak, f.idDok, f.rbrDok, f.storno, f.usernamekraj";
            }
            upit = String.valueOf(upit) + " ORDER BY f.datum, f.rbrDok";
            upit = upit.replace(":datumOD", datumOd.toString()).replace(":datumDO", datumDo.toString());
            if (!dokument.getTip().equals("AVANSNI_RACUN")) {
                upit = upit.replace(":rj", rj.getId().getOznRj()).replace(":ogranak", rj.getId().getOznOgranak());
            }
            if (dokument instanceof Faktura) {
                upit = upit.replace(":tip", dokument.getTip());
            }
            rez = em.createNativeQuery(upit);
            rez.setHint("eclipselink.cursor.scrollable", (Object)"True");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rez;
    }

    public static Fakturausluga createStornoFakturaUsluga(Fakturausluga original) throws Exception {
        EntityManager em = PzEntityManager.getEm();
        Fakturausluga storno = PzProdajaUtil.createStornoFakturaUsluga(original, em);
        em.close();
        return storno;
    }

    public static Fakturausluga createStornoFakturaUsluga(Fakturausluga original, EntityManager em) throws Exception {
        if (original.jeFakturaSpedicije()) {
            return PzProdajaUtil.createStornoFakturaSpedicije(original, em);
        }
        return PzProdajaUtil.createStornoFaktUsluga(original, em);
    }

    private static Fakturausluga createStornoFaktUsluga(Fakturausluga original, EntityManager em) throws Exception {
        Query q = em.createQuery("select f from Fakturausluga f where f.original.idDok=" + original.getIdDok());
        for (Fakturausluga stornoFU : q.getResultList()) {
            if (stornoFU.getSaPorezom() == 1) {
                for (Taksafaktura taksa : stornoFU.getTaksafakturas()) {
                    PzProdajaUtil.umanjiIznosTakse(original, taksa);
                }
            }
            ((Stavkafaktureusl)original.getStavkafaktureusls().get(0)).setCena(((Stavkafaktureusl)original.getStavkafaktureusls().get(0)).getCena() - ((Stavkafaktureusl)stornoFU.getStavkafaktureusls().get(0)).getCena());
        }
        return original;
    }

    private static Fakturausluga createStornoFakturaSpedicije(Fakturausluga original, EntityManager em) throws Exception {
        Query q = em.createQuery("select f from Fakturausluga f where f.original.idDok=" + original.getIdDok());
        for (Fakturausluga stornoFU : q.getResultList()) {
            for (Stavkafaktureusl stavka : stornoFU.getStavkafaktureusls()) {
                PzProdajaUtil.umanjiIznosStavke(original, stavka);
            }
        }
        return original;
    }

    private static void umanjiIznosTakse(Fakturausluga original, Taksafaktura taksa) {
        for (Taksafaktura taksaOriginala : original.getTaksadokuments()) {
            if (!taksaOriginala.getId().getOznTarGr().equals(taksa.getId().getOznTarGr())) continue;
            if (taksaOriginala.getOsnovica().equals(taksa.getOsnovica())) {
                original.getTaksafakturas().remove(taksaOriginala);
                break;
            }
            taksaOriginala.setOsnovica(taksaOriginala.getOsnovica().subtract(taksa.getOsnovica()));
            taksaOriginala.setIznos(taksaOriginala.getIznos().subtract(taksa.getIznos()));
            break;
        }
    }

    private static void umanjiIznosStavke(Fakturausluga original, Stavkafaktureusl stavka) {
        for (Stavkafaktureusl stavkaOriginala : original.getStavkafaktureusls()) {
            BigDecimal stavkaCena;
            if (!stavkaOriginala.getUsluga().getSfrProizvod().equals(stavka.getUsluga().getSfrProizvod()) || stavkaOriginala.getId().getrBroj() != stavka.getId().getrBroj()) continue;
            BigDecimal originalCena = BDConverter.getIznos((double)stavkaOriginala.getCena());
            BigDecimal razlika = originalCena.subtract(stavkaCena = BDConverter.getIznos((double)stavka.getCena()));
            if (razlika.equals(new BigDecimal("0.00"))) {
                original.getStavkafaktureusls().remove(stavkaOriginala);
                break;
            }
            stavkaOriginala.setCena(razlika.doubleValue());
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean updateStanjeInsert(Faktura f, Artikalfaktura af, double kolicina, double kolSaKons, String konsignacija, boolean insert, boolean obavestavanjeKorisnika, boolean radSaKonsignacijama, EntityManager em, boolean dajStaDas) throws Exception {
        if (!(f.getZaOtpremnice() == 1 || f.getTip().equals("PROFAKTURA") || f.getTip().equals("AVANSNI_RACUN") || f.getTip().equals("FAKTURA_TRANZITA") || f.getTip().equals("FAKTURA_IZ_SERVISA") || f.getTip().equals("SLIKA_MALOPRODAJNOG_RACUNA") || f.getTip().equals("PROPUSTENA_PRODAJA"))) {
            Stanje sKons;
            Radnajedinica rj;
            RadnajedinicaPK id;
            Stanje s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(af.getSifra(), f.getRadnajedinica()));
            if (insert && s == null) {
                s = new Stanje();
                StanjePK sPK = new StanjePK(af.getId().getSfrProizvod(), f.getRadnajedinica());
                s.setId(sPK);
                s.setProdCena(af.getCena());
                em.persist((Object)s);
            }
            if (af.getTaksa("PDV").getOznTarGr().startsWith("U")) {
                s.setProdCena(af.getCena());
                return true;
            }
            if (!insert && !f.getTip().equals("FAKTURA_INTERNI_RACUN")) {
                s.setAlocKolicina(BDConverter.getKolicina((double)(s.getAlocKolicina() - af.getKolicina())).doubleValue());
                if (af.getKolSaKons() > 0.0) {
                    id = new RadnajedinicaPK(f.getRadnajedinica().getId().getOznOgranak(), af.getKonsignacija());
                    rj = (Radnajedinica)em.find(Radnajedinica.class, (Object)id);
                    sKons = (Stanje)em.find(Stanje.class, (Object)new StanjePK(af.getSifra(), rj));
                    sKons.setAlocKolicina(BDConverter.getKolicina((double)(sKons.getAlocKolicina() - af.getKolSaKons())).doubleValue());
                }
            }
            if (dajStaDas) {
                if (!(s.getRaspolozivaKolicina() > 0.0)) {
                    return false;
                }
                if (s.getRaspolozivaKolicina() >= kolicina) {
                    s.setAlocKolicina(s.getAlocKolicina() + kolicina);
                } else {
                    af.setKolicina(s.getRaspolozivaKolicina());
                    s.setAlocKolicina(s.getAlocKolicina() + s.getRaspolozivaKolicina());
                }
                PzEntityManager.update((Object)s, (EntityManager)em);
                return true;
            }
            if (f.getRadnajedinica().getMinusKolicine().equals("ZABRANJEN") && kolicina > s.getRaspolozivaKolicina()) {
                int rez;
                if (obavestavanjeKorisnika && (rez = PzSwingUtility.daNeDijalog(null, (Object)"Nema dovoljno raspolo\u017eive koli\u010dine. Nastavljate dalje?", (String)"", null, (boolean)false)) == 1) {
                    return false;
                }
            } else if (f.getRadnajedinica().getMinusKolicine().equals("KONSIGNACIJA")) {
                if (radSaKonsignacijama) {
                    if (!konsignacija.equals("")) {
                        id = new RadnajedinicaPK(f.getRadnajedinica().getId().getOznOgranak(), konsignacija);
                        rj = (Radnajedinica)em.find(Radnajedinica.class, (Object)id);
                        sKons = (Stanje)em.find(Stanje.class, (Object)new StanjePK(af.getSifra(), rj));
                        if (sKons.getRaspolozivaKolicina() >= kolSaKons) {
                            sKons.setAlocKolicina(sKons.getAlocKolicina() + kolSaKons);
                        } else {
                            if (obavestavanjeKorisnika) {
                                PzSwingUtility.showErrorMessage(null, (String)("Nema dovoljno raspolo\u017eive koli\u010dine artikla " + af.getSifra() + " u konsignaciji " + konsignacija + "!"));
                            }
                            return false;
                        }
                    }
                } else if (kolicina > s.getRaspolozivaKolicina()) {
                    if (obavestavanjeKorisnika) {
                        PzSwingUtility.showErrorMessage(null, (String)("Nema dovoljno raspolo\u017eive koli\u010dine artikla " + af.getSifra() + " u konsignaciji " + konsignacija + "!"));
                    }
                    return false;
                }
            }
            if (!f.getTip().equals("FAKTURA_INTERNI_RACUN")) {
                s.setAlocKolicina(s.getAlocKolicina() + kolicina);
            }
        }
        return true;
    }

    public static boolean updateStanjeInsertIzvestaj(FiskalniIzvestaj f, Artikalopstidokument af, double kolicina, double staraKolicina, boolean insert, EntityManager em) throws Exception {
        Stanje s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(af.getSifra(), f.getRadnajedinica()));
        if (insert && s == null) {
            PzSwingUtility.showErrorMessage(null, (String)("Artikal " + af.getSifra() + " do sada nije imao promet u izabranoj radnoj jedinici!"));
            return false;
        }
        if (f.getRadnajedinica().getMinusKolicine().equals("ZABRANJEN") && kolicina > s.getRaspolozivaKolicina()) {
            PzSwingUtility.showErrorMessage(null, (String)("Nema dovoljno raspolo\u017eive koli\u010dine artikla " + af.getSifra() + "!"));
            return false;
        }
        return true;
    }

    public static boolean updateStanjeArhiviranje(Faktura f, EntityManager em) throws Exception {
        if (f.getTip().equals("OTPREMNICA")) {
            Map<String, Stanje> stanja = PzProdajaUtil.checkStanjeArhiviranje(f, em);
            return stanja != null;
        }
        if (!(f.getTip().equals("OTPREMNICA") || f.getTip().equals("PROFAKTURA") || f.getTip().equals("AVANSNI_RACUN") || f.getTip().equals("SLIKA_MALOPRODAJNOG_RACUNA") || f.getTip().equals("FAKTURA_TRANZITA"))) {
            Map<String, Stanje> stanja = PzProdajaUtil.checkStanjeArhiviranje(f, em);
            if (stanja == null) {
                return false;
            }
            for (Artikalfaktura af : f.getArtikalfakturas()) {
                Stanje s = stanja.get(af.getId().getSfrProizvod());
                if (f.getTip().equals("FAKTURA") || f.getTip().equals("PRENOSNICA_SA_KONSIGNACIJE")) {
                    s.setAlocKolicina(s.getAlocKolicina() - af.getKolicina());
                } else if (af.getKolicina() > s.getRaspolozivaKolicina() && !f.getTip().equals("FAKTURA_INTERNI_RACUN") && !f.getTip().equals("FAKTURA_IZ_SERVISA")) {
                    PzSwingUtility.showErrorMessage(null, (String)("Nema dovoljno raspolo\u017eive koli\u010dine artikla " + af.getSifra() + "! Arhiviranje nije mogu\u0107e!"));
                    return false;
                }
                s.setKolicina(s.getKolicina() - af.getKolicina());
                s.setDatZadIzlaza(f.getDatum());
                s.setKumIzlaza(s.getKumIzlaza() + af.getKolicina());
            }
        }
        return true;
    }

    public static Map<String, Stanje> checkStanjeArhiviranje(Faktura f, EntityManager em) {
        HashMap<String, Stanje> stanja = new HashMap<String, Stanje>();
        for (Artikalfaktura af : f.getArtikalfakturas()) {
            StanjePK spk = new StanjePK(af.getId().getSfrProizvod(), f.getRadnajedinica().getId().getOznOgranak(), f.getRadnajedinica().getId().getOznRj());
            Stanje s = (Stanje)em.find(Stanje.class, (Object)spk);
            if (s == null) {
                PzSwingUtility.showErrorMessage(null, (String)("Artikal " + af.getSifra() + " do sada nije imao promet u izabranoj radnoj jedinici!"));
                return null;
            }
            if (f.getRadnajedinica().getMinusKolicine().equals("ZABRANJEN") && s.getKolicina() - af.getKolicina() < 0.0 && !af.getTaksa("PDV").getOznTarGr().startsWith("U")) {
                PzSwingUtility.showErrorMessage(null, (String)("Nema dovoljno raspolo\u017eive koli\u010dine artikla " + af.getSifra() + " !"));
                return null;
            }
            stanja.put(s.getId().getSfrProizvod(), s);
        }
        return stanja;
    }

    public static boolean updateStanjeArhiviranjeIzvestaj(FiskalniIzvestaj f, EntityManager em) throws Exception {
        for (Artikalopstidokument af : f.getArtikalopstidokuments()) {
            StanjePK spk = new StanjePK(af.getId().getSfrProizvod(), f.getRadnajedinica().getId().getOznOgranak(), f.getRadnajedinica().getId().getOznRj());
            Stanje s = (Stanje)em.find(Stanje.class, (Object)spk);
            s.setKolicina(s.getKolicina() - af.getKolicina());
            s.setDatZadIzlaza(f.getDatum());
            s.setKumIzlaza(s.getKumIzlaza() + af.getKolicina());
            PzEntityManager.update((Object)s, (EntityManager)em);
        }
        return true;
    }

    public static boolean updateStanjeStorniranje(Faktura f) {
        return !f.getTip().equals("PROFAKTURA") && !f.getTip().equals("AVANSNI_RACUN") && !f.getTip().equals("FAKTURA_TRANZITA");
    }

    public static void updateStanjeBrisanje(Faktura f, EntityManager em) throws Exception {
        for (Artikalfaktura af : f.getArtikalfakturas()) {
            PzProdajaUtil.updateStanjeBrisanje(f, af, em);
        }
    }

    public static void updateStanjeBrisanje(Faktura f, Artikalfaktura af, EntityManager em) throws Exception {
        if (!(f.getZaOtpremnice() == 1 || f.getTip().equals("PROFAKTURA") || f.getTip().equals("AVANSNI_RACUN") || f.getTip().equals("FAKTURA_TRANZITA") || f.getTip().equals("FAKTURA_INTERNI_RACUN") || f.getTip().equals("FAKTURA_IZ_SERVISA") || f.getTip().equals("SLIKA_MALOPRODAJNOG_RACUNA") || f.getTip().equals("PROPUSTENA_PRODAJA"))) {
            Stanje s = (Stanje)PzEntityManager.find(Stanje.class, (Object)new StanjePK(af.getId().getSfrProizvod(), f.getRadnajedinica()), (EntityManager)em);
            if (s != null) {
                s.setAlocKolicina(s.getAlocKolicina() - af.getKolicina());
            }
            if (af.getKolSaKons() > 0.0) {
                RadnajedinicaPK id = new RadnajedinicaPK(f.getRadnajedinica().getId().getOznOgranak(), af.getKonsignacija());
                Radnajedinica rj = (Radnajedinica)em.find(Radnajedinica.class, (Object)id);
                Stanje sKons = (Stanje)em.find(Stanje.class, (Object)new StanjePK(af.getSifra(), rj));
                sKons.setAlocKolicina(sKons.getAlocKolicina() - af.getKolSaKons());
            }
        }
    }

    public static void updateStanjeVracanjeUPripremu(Faktura f, EntityManager em) throws Exception {
        if (f.getTip().equals("FAKTURA")) {
            for (Artikalfaktura af : f.getArtikalfakturas()) {
                Stanje s = (Stanje)PzEntityManager.find(Stanje.class, (Object)new StanjePK(af.getId().getSfrProizvod(), f.getRadnajedinica()), (EntityManager)em);
                s.setAlocKolicina(s.getAlocKolicina() + af.getKolicina());
                s.setKolicina(s.getKolicina() + af.getKolicina());
            }
        }
    }

    public static boolean mozeFizickoLice(Radnajedinica rj, String tipF) {
        if (rj.getTip().equals("VS") || rj.getgTip().equals("E") && tipF.equals("FAKTURA")) {
            return true;
        }
        return tipF.equals(TipDokumentConfig.get().PROFAKTURA);
    }

    public static boolean postojiArtikalSaRabatom(Faktura f) {
        for (Artikalfaktura af : f.getArtikalfakturas()) {
            if (af.getProcRabata() == 0.0) continue;
            return true;
        }
        return false;
    }

    public static boolean stampajRacun(PzDokument dokument, Boolean predracun) {
        return PzProdajaUtil.bill(dokument, predracun);
    }

    public static boolean bill(PzDokument dokument, Boolean predracun) {
        HashMap results = null;
        try {
            results = CashRegisterHandler.sendToDefaultCashRegister((Object)PzProdajaUtil.createBill(dokument, predracun));
        }
        catch (Exception e) {
            PzProdajaUtil.showErrorMessage("Greska: " + e.getMessage());
            PzMysqlExceptionHandler.handle((Throwable)e);
            System.out.println("Greska: " + e.getMessage());
        }
        if (results != null && results.containsKey("CODE") && ((String)results.get("CODE")).equals("SUCCESS")) {
            PzProdajaUtil.showMessage(results);
            System.out.println("Rezultat operacije: " + (String)results.get("MESSAGE"));
            System.out.println("Info uredjaja: " + (String)results.get("INFOS"));
        }
        return results != null;
    }

    private static CashRegisterBill createBill(PzDokument dokument, Boolean predracun) {
        Article article;
        CashRegisterBill bill = new CashRegisterBill();
        bill.setOperaterCode("1");
        bill.setOperaterPassword("0000");
        bill.setCashRegisterCode("00000");
        bill.setPaidAmountCash(dokument.getIznos());
        bill.setPreBill(predracun.booleanValue());
        for (PzArtikalDokument af : dokument.getArtikalDocuments()) {
            article = new Article();
            article.setPLU(null);
            article.setSifra(af.getId().getSfrProizvod());
            article.setName(af.getNaziv());
            article.setUnit("");
            article.setQuantity(new BigDecimal(af.getKolicina()));
            article.setPrice(new BigDecimal(af.getCena()));
            article.setTaxRate('d');
            bill.addArticle(article);
        }
        if (dokument instanceof Fakturaservisa) {
            for (Uslugafaktura uf : ((Fakturaservisa)dokument).getUslugafakturas()) {
                article = new Article();
                article.setPLU(null);
                article.setSifra(uf.getUsluga().getSfrProizvod());
                article.setName(uf.getNaziv());
                article.setUnit("");
                article.setQuantity(new BigDecimal(uf.getKolicina()));
                article.setPrice(new BigDecimal(uf.getCena()));
                article.setTaxRate('d');
                bill.addArticle(article);
            }
        }
        return bill;
    }

    public static void control(String kontrola) {
        HashMap results = null;
        CashRegisterControl cntrl = new CashRegisterControl();
        cntrl.setControlCode(kontrola);
        try {
            results = CashRegisterHandler.sendToDefaultCashRegister((Object)cntrl);
        }
        catch (Exception e) {
            PzProdajaUtil.showErrorMessage("Greska: " + e.getMessage());
            System.out.println("Greska: " + e.getMessage());
        }
        if (results != null && results.containsKey("CODE") && ((String)results.get("CODE")).equals("SUCCESS")) {
            PzProdajaUtil.showMessage(results);
            System.out.println("Rezultat operacije: " + (String)results.get("MESSAGE"));
            System.out.println("Info uredjaja: " + (String)results.get("INFOS"));
        }
    }

    public static void showMessage(HashMap<String, String> results) {
        String infoUredjaja = results.get("INFOS");
        System.out.println("info uredjaja je " + infoUredjaja);
        String[] poruke = infoUredjaja.split(";");
        int i = 0;
        while (i < poruke.length) {
            System.out.println(poruke[i]);
            System.out.println(poruke[i].substring(0, 1));
            ++i;
        }
    }

    public static void showErrorMessage(String message) {
    }

    public static PzDokument toFaktura(Lista l, HashMap<String, Object> parameters, EntityManager em) throws Exception {
        Radnajedinica rj = (Radnajedinica)parameters.get(PARAMETER_RJ);
        DefaultDokumentTransformer ddt = new DefaultDokumentTransformer(Faktura.class, Artikalfaktura.class);
        Faktura f = (Faktura)ddt.toDokument(l, parameters, em);
        f.setTip((String)parameters.get(PARAMETER_TIP));
        f.setRadnajedinica(rj);
        if (parameters.get(PARAMETER_TIP).equals("AVANSNI_RACUN")) {
            f.setPodTip("AVANSNI_RACUN_KOLICINA");
        }
        if (parameters.get(PARAMETER_TIP).equals("FAKTURA_INTERNI_RACUN")) {
            f.setDatum(PzDateUtility.getCurrentDate());
            f.setDatValute(PzDateUtility.getCurrentDate());
            f.setDatPrometa(PzDateUtility.getCurrentDate());
        } else {
            f.setKomitent((Komitent)parameters.get(PARAMETER_KOMITENT));
            f.setDatum((Date)parameters.get(PARAMETER_DATUM_IZRADE));
            f.setDatValute((Date)parameters.get(PARAMETER_DATUM_VALUTE));
            f.setDatPrometa((Date)parameters.get(PARAMETER_DATUM_PROMETA));
            f.setKurs(parameters.get(PARAMETER_KURS) == null ? 0.0 : (Double)parameters.get(PARAMETER_KURS));
        }
        List<Object[]> stanja = PzProdajaUtil.getStanja(rj, l, em);
        for (Artikalfaktura af : f.getArtikalfakturas()) {
            if (!PzProdajaUtil.updateStanjeInsert(f, af, PzProdajaUtil.findValue(l, af.getId().getSfrProizvod()), em)) continue;
            af.setCena(((Double)PzProdajaUtil.findValue(stanja, af.getId().getSfrProizvod(), 2)).doubleValue());
            af.setNabCena(((Double)PzProdajaUtil.findValue(stanja, af.getId().getSfrProizvod(), 3)).doubleValue());
            af.setProsNabCena((BigDecimal)PzProdajaUtil.findValue(stanja, af.getId().getSfrProizvod(), 1));
            af.setKolicina(PzProdajaUtil.findValue(l, af.getId().getSfrProizvod()));
        }
        return f;
    }

    private static List<Object[]> getStanja(Radnajedinica rj, Lista l, EntityManager em) {
        Query q = em.createQuery("SELECT s.id.sfrProizvod, s.prosNabCena, s.prodCena, s.zadNabCena  FROM Stanje s WHERE s.radnajedinica=:rj AND s.id.sfrProizvod IN (SELECT al.sfrProizvod FROM Artikallista al WHERE al.id.idLista=:idLista)");
        q.setParameter("rj", (Object)rj);
        q.setParameter("idLista", (Object)l.getIdLista());
        return q.getResultList();
    }

    private static Object findValue(List<Object[]> stanja, String sfrProizvod, int i) {
        Object res = null;
        for (Object[] stanje : stanja) {
            if (!stanje[0].equals(sfrProizvod)) continue;
            res = stanje[i];
            break;
        }
        return res;
    }

    private static double findValue(Lista l, String sfrProizvod) {
        double res = 0.0;
        for (Artikallista al : l.getArtikallistas()) {
            if (!al.getSfrProizvod().equals(sfrProizvod)) continue;
            res = al.getKolicina();
            break;
        }
        return res;
    }

    public static boolean updateStanjeInsert(Faktura f, Artikalfaktura af, double kolicina, EntityManager em) throws Exception {
        if (!(f.getZaOtpremnice() == 1 || f.getTip().equals("PROFAKTURA") || f.getTip().equals("AVANSNI_RACUN") || f.getTip().equals("FAKTURA_TRANZITA") || f.getTip().equals("FAKTURA_IZ_SERVISA") || f.getTip().equals("SLIKA_MALOPRODAJNOG_RACUNA"))) {
            Stanje s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(af.getSifra(), f.getRadnajedinica()));
            if (s == null) {
                throw new TransformationException("Gre\u0161ka! Artikal " + af.getSifra() + " nema formiranu cenu u izabranoj radnoj jedinici!");
            }
            if (f.getRadnajedinica().getMinusKolicine().equals("ZABRANJEN") && kolicina > s.getRaspolozivaKolicina()) {
                throw new TransformationException("Gre\u0161ka! Nema dovoljno raspolo\u017eive koli\u010dine artikla " + af.getSifra() + "!");
            }
            if (!f.getTip().equals("FAKTURA_INTERNI_RACUN") && !f.getTip().equals("PRENOSNICA_SA_KONSIGNACIJE")) {
                s.setAlocKolicina(s.getAlocKolicina() + kolicina);
                PzEntityManager.update((Object)s, (EntityManager)em);
            }
        }
        return true;
    }

    public static Faktura postojiFaktura(String tipF, Radnajedinica rj, Komitent k, EntityManager em) throws Exception {
        Faktura fak = null;
        try {
            fak = (Faktura)em.createQuery("select f from Faktura f where f.radnajedinica=:rj and f.komitent=:k and f.tip=:tipF and f.userKraj=:user").setParameter("rj", (Object)rj).setParameter("k", (Object)k).setParameter("tipF", (Object)tipF).setParameter("user", (Object)PzExtensionLoader.getLoggedUser()).getSingleResult();
        }
        catch (NoResultException noResultException) {
            return null;
        }
        return fak;
    }

    public static Faktura postojiFaktura(String tipF, Radnajedinica rj, Komitent k) throws Exception {
        EntityManager em = PzEntityManager.getEm();
        Faktura f = PzProdajaUtil.postojiFaktura(tipF, rj, k, em);
        em.close();
        return f;
    }

    public static boolean dodajUPropustenuProdaju(double kolicina, String sfrProizvod, String sfrKomitent, String oznRj, String oznOgranak, EntityManager em) throws Exception {
        Stanjeartikal stanjeArt = (Stanjeartikal)em.find(Stanjeartikal.class, (Object)new StanjeartikalPK(sfrProizvod, oznOgranak, oznRj));
        Komitent kom = (Komitent)em.find(Komitent.class, (Object)sfrKomitent);
        Radnajedinica rj = stanjeArt.getRadnajedinica();
        Artikal art = (Artikal)em.find(Artikal.class, (Object)stanjeArt.getId().getSfrProizvod());
        Faktura f = PzProdajaUtil.postojiFaktura("PROPUSTENA_PRODAJA", rj, kom, em);
        if (f == null) {
            f = new Faktura();
            f.setTip("PROPUSTENA_PRODAJA");
            f.setDatum(PzDateUtility.getCurrentDate());
            f.setDatPrometa(PzDateUtility.getCurrentDate());
            f.setDatValute(PzDateUtility.getCurrentDate());
            f.setKomitent(kom);
            f.setRadnajedinica(stanjeArt.getRadnajedinica());
            PzDokumentManager.getInstance().snimiDokument((PzDokument)f, true, null, em);
        }
        Artikalfaktura af = f.getArtikal(art.getSfrProizvod());
        boolean izmenaPostojecegArtikla = false;
        if (af != null) {
            af.setKolicina(kolicina + af.getKolicina());
            izmenaPostojecegArtikla = true;
        } else {
            af = new Artikalfaktura();
            af.init(stanjeArt, (PzDokument)f);
            af.setKolicina(kolicina);
        }
        af.setCena(stanjeArt.getProdCena());
        af.setProsNabCena(stanjeArt.getProsNabCena());
        af.setProdCena(PzMathUtility.roundToBigDecimal((double)stanjeArt.getProdCena(), (int)PzMathUtility.getBrojDecimala()));
        af.setTezina(stanjeArt.getTezina() != 0.0 ? stanjeArt.getTezina() : 0.0);
        af.setDobSifra(stanjeArt.getDobSifra());
        af.setNabCena(stanjeArt.getZadNabCena());
        if (!PzProdajaUtil.updateStanjeInsert(f, af, kolicina, 0.0, "", true, false, false, em, false)) {
            return false;
        }
        if (izmenaPostojecegArtikla) {
            f.getArtikalfakturas().set(f.getArtikalfakturas().indexOf(af), af);
        } else {
            em.persist((Object)af);
        }
        return true;
    }

    public static boolean dodajUPropustenuProdaju(double kolicina, String sfrProizvod, String sfrKomitent, String oznRj, String oznOgranak) throws Exception {
        EntityManager em = PzEntityManager.getEm();
        try {
            em.getTransaction().begin();
            boolean rez = PzProdajaUtil.dodajUPropustenuProdaju(kolicina, sfrProizvod, sfrKomitent, oznRj, oznOgranak, em);
            em.getTransaction().commit();
            boolean bl = rez;
            return bl;
        }
        catch (Exception e1) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            PzMysqlExceptionHandler.handle(null, (Throwable)e1);
            return false;
        }
        finally {
            em.close();
        }
    }

    public static boolean grupeKomitenata(PzDialog dialog, Pzuser korisnik, Komitent k) {
        boolean dalje = true;
        if (PzProdajaUtil.pripadaGrupi(k, CRNA_GRUPA_TIP)) {
            if (korisnik.isModerator()) {
                PzSwingUtility.showInformationMessage((Component)dialog, (String)("Komitent [" + k.getSfrKomitent() + "] " + k.getNaziv() + " se nalazi u crnoj grupi."));
                dalje = true;
            } else if (korisnik.isKorisnik()) {
                PzSwingUtility.showInformationMessage((Component)dialog, (String)"Ne mo\u017eete otvoriti novu fakturu za izabranog komitenta, jer se isti nalazi na crnoj listi!");
                dalje = false;
            }
        } else if (PzProdajaUtil.pripadaGrupi(k, KRITICNA_GRUPA_TIP)) {
            if (korisnik.isModerator()) {
                PzSwingUtility.showInformationMessage((Component)dialog, (String)("Komitent [" + k.getSfrKomitent() + "] " + k.getNaziv() + " se nalazi u kriti\u010dnoj grupi."));
                dalje = true;
            } else if (korisnik.isKorisnik()) {
                int rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)"<html>Izabrani komitent pripada kriti\u010dnoj grupi.<br>Za arhiviranje ove fakture \u0107e vam biti potrebno posebno odobrenje moderatora.<br>Da li \u017eelite da nastavite dalje</html>", (String)"Informacija", null, (boolean)true);
                dalje = rez == 0;
            }
        }
        return dalje;
    }

    private static boolean pripadaGrupi(Komitent k, String tipGrupe) {
        boolean pripada = false;
        Komitentgrupa grupa = null;
        Query q = PzEntityManager.getEm().createQuery("SELECT g FROM Komitentgrupa g Where g.tip=:tip");
        q.setParameter("tip", (Object)tipGrupe);
        try {
            grupa = (Komitentgrupa)q.getSingleResult();
        }
        catch (Exception exception) {
            grupa = null;
        }
        pripada = grupa == null ? false : grupa.getKomitent(k.getSfrKomitent()) != null;
        return pripada;
    }

    public static boolean grupeKomitenataArhiva(PzDialog dialog, Faktura f) {
        boolean dalje;
        block17: {
            EntityManager em = PzEntityManager.getEm();
            dalje = true;
            Pzuser user = PzApplication.getApplication().getSession().getLoggedUser();
            try {
                try {
                    Dokumentpotvrda potvrda = (Dokumentpotvrda)em.find(Dokumentpotvrda.class, (Object)new DokumentpotvrdaPK(f.getIdDok(), "FAKTURISANJE"));
                    if (potvrda != null && potvrda.getStatus() == 1) {
                        dalje = true;
                        break block17;
                    }
                    if (PzProdajaUtil.pripadaGrupi(f.getKomitent(), KRITICNA_GRUPA_TIP)) {
                        if (potvrda != null && potvrda.getStatus() == 2) {
                            dalje = false;
                            if (dialog.getClass().equals(PzDialogIzradaFaktureZaProdajuRobe.class)) {
                                PzSwingUtility.showInformationMessage((Component)dialog, (String)"Zabranjeno je slanje naloga magacinu!");
                            } else {
                                PzSwingUtility.showInformationMessage((Component)dialog, (String)"Arhiviranje fakture je zabranjeno!");
                            }
                        } else {
                            Pzuser moderator = IzborModeratora.getModerator(dialog);
                            if (moderator == null) {
                                dalje = false;
                            } else {
                                em.getTransaction().begin();
                                Dokumentpotvrda dokPotvrda = new Dokumentpotvrda();
                                dokPotvrda.setId(new DokumentpotvrdaPK(f.getIdDok(), "FAKTURISANJE"));
                                dokPotvrda.setPzusername(moderator.getPzusername());
                                dokPotvrda.setStatus(Integer.valueOf(0));
                                em.persist((Object)dokPotvrda);
                                f.setArhiviran((short)2);
                                em.merge((Object)f);
                                em.getTransaction().commit();
                                PzSwingUtility.showInformationMessage((Component)dialog, (String)"Zahtev za izdavanjem fakture je prosle\u0111en moderatoru.");
                                PzProdajaUtil.sendMessage(moderator, "Poslat vam je zahtev za izdavanjem robe kupcu [" + f.getKomitent().getSfrKomitent() + "] " + f.getKomitent().getNaziv() + " iz kriti\u010dne liste od strane korisnika " + user.getFullName());
                                dalje = false;
                            }
                        }
                        break block17;
                    }
                    if (PzProdajaUtil.pripadaGrupi(f.getKomitent(), CRNA_GRUPA_TIP)) {
                        if (dialog.getClass().equals(PzDialogIzradaFaktureZaProdajuRobe.class)) {
                            PzSwingUtility.showInformationMessage((Component)dialog, (String)"Ne mo\u017eete poslati nalog magacinu jer se komitent nalazi u crnoj listi!");
                        } else {
                            PzSwingUtility.showInformationMessage((Component)dialog, (String)"Ne mo\u017eete arhivirati fakturu jer se komitent nalazi u crnoj listi!");
                        }
                        dalje = false;
                        break block17;
                    }
                    dalje = true;
                }
                catch (Exception e) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Throwable)e);
                    dalje = false;
                    em.close();
                }
            }
            finally {
                em.close();
            }
        }
        return dalje;
    }

    public static void sendMessage(Pzuser user, String poruka) {
        try {
            String text = NotificationText.codeNotification((String)poruka);
            String queueName = MsgProtocol.getQueueNameFromUserName((String)user.getPzusername(), (String)user.getIme(), (String)user.getPrezime());
            if (MsgProtocol.getInstance() != null) {
                MsgProtocol.getInstance().sendChatTextMessageToQueue(queueName, text);
            }
        }
        catch (JMSException e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
    }

    public static void sendNotification(Pzuser user, String poruka) {
        try {
            String queueName = MsgProtocol.getQueueNameFromUserName((String)user.getPzusername(), (String)user.getIme(), (String)user.getPrezime());
            if (MsgProtocol.getInstance() != null) {
                MsgProtocol.getInstance().sendActionMessageToDestination((Destination)MsgProtocol.getInstance().createDestinationFromQueueName(queueName), "ID:3;CORNER:DD;MESSAGE:" + poruka);
            }
        }
        catch (JMSException e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
    }

    public static void convertPanelRabatiToAFParameters(PanelRabati panel, Artikalfaktura af, EntityManager em) throws Exception {
        af.setArtikalFakturaParameters(new Vector());
        for (Rabat r : panel.getRabati()) {
            Artikalfakturaparameter afParameter = (Artikalfakturaparameter)em.find(Artikalfakturaparameter.class, (Object)new ArtikalfakturaparameterPK(af, String.valueOf(RABAT_DISCRIMINATOR) + r.getId()));
            if (afParameter == null) {
                afParameter = new Artikalfakturaparameter(af, String.valueOf(RABAT_DISCRIMINATOR) + r.getId(), panel.getValueForRabat(r).toString(), r.getNaziv());
                em.persist((Object)afParameter);
            } else {
                afParameter.setValue(panel.getValueForRabat(r).toString());
                afParameter.setDescription(r.getNaziv());
            }
            af.getArtikalFakturaParameters().add(afParameter);
        }
    }

    public static void convertAFParametersToPanelRabati(Artikalfaktura af, PanelRabati panel) throws Exception {
        for (Rabat r : panel.getRabati()) {
            Artikalfakturaparameter afParameter = (Artikalfakturaparameter)PzEntityManager.find(Artikalfakturaparameter.class, (Object)new ArtikalfakturaparameterPK(af, String.valueOf(RABAT_DISCRIMINATOR) + r.getId()));
            if (afParameter == null) continue;
            panel.setValueForRabat(r, afParameter.getValue());
        }
    }

    public static PzDefaultDokumentCustomizer getAvansniRacunCustomizer() {
        return new PzDefaultDokumentCustomizer(){

            public int getRBroj(PzDokument dokument, EntityManager em) throws Exception {
                Brojac brojac = PzBrojacRj.getBrojac((PzDokument)dokument, (EntityManager)em);
                brojac.setrBroj(brojac.getrBroj() + 1);
                return brojac.getrBroj();
            }
        };
    }

    public static boolean komitentVanTolerancije(Komitent k) {
        boolean res = false;
        try {
            Komitentparameter kp = k.getKomitentparameter("TOLERANCIJA_PLACANJA");
            if (kp != null && !kp.getValue().equals("")) {
                int tolerancija = Integer.parseInt(kp.getValue());
                Date datum = PzDateUtility.add((Date)PzDateUtility.getCurrentDate(), (int)(-tolerancija));
                List list = PzEntityManager.getList((String)("Select f.idDok From Faktura f where f.iznos-f.stornoIznos-f.uplata > 50 and f.datValute < '" + datum + "' and " + "f.arhiviran=1 and f.storno=0 and f.komitent.sfrKomitent=" + k.getSfrKomitent() + " and " + "f.tip IN ('" + TipDokumentConfig.get().FAKTURA + "','" + TipDokumentConfig.get().FAKTURA_SERVISA + "','" + TipDokumentConfig.get().FAKTURA_USLUGA + "')"));
                if (list.size() != 0) {
                    res = true;
                }
            }
            return res;
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
            return res;
        }
    }

    public static boolean komitentPrekoLimita(boolean provera, Komitent kom, Faktura f, PzDialog parent, BigDecimal vrednostStavke) {
        if (kom == null || kom.getNovcaniLimit() == null || kom.getNovcaniLimit().doubleValue() == 0.0) {
            return false;
        }
        BigDecimal limit = kom.getNovcaniLimit();
        if (limit != null && limit.doubleValue() > 0.0) {
            BigDecimal dosadasnjiDug;
            BigDecimal iznos = BigDecimal.ZERO;
            for (Artikalfaktura af : f.getArtikalfakturas()) {
                iznos = iznos.add(af.getProdCena().multiply(new BigDecimal(af.getKolicina())));
            }
            BigDecimal ukupanDug = dosadasnjiDug = KomitentPrometUtility.getBigDecimalValue((String)KomitentPrometUtility.getUkupanDug((Komitent)kom, (Boolean)true));
            ukupanDug = iznos.add(dosadasnjiDug).add(vrednostStavke);
            if (ukupanDug.compareTo(limit) == 1) {
                JOptionPane.showMessageDialog((Component)parent, "Dodavanjem ove stavke bio bi prema\u0161en definisani limit za komitenta!\nNastavak nije mogu\u0107e!", "Informacija", 1);
                return true;
            }
        }
        return false;
    }

    public static void convertToOtherDokument(Faktura f, String toTip, EntityManager em) {
        f.setTip(toTip);
        f.updateDokument(true);
        em.merge((Object)f);
    }
}

