/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui.faktureZaProdajuRobe;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.eclipse.persistence.queries.FetchGroup;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.FiskalniIzvestaj;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzGradient;

public class UzmiDokument
extends PzDialog {
    private static final long serialVersionUID = 5284942039737355206L;
    private JToolBar toolbar;
    private PzToolBarIcon btnSlikaProfakture;
    private PzToolBarIcon btnNeplacene;
    private PzPanel plGlavni;
    private Faktura f;
    private PzTable tblTabela;
    private JScrollPane scTabela;
    private PzPanel plTabela;
    private JPanel jPanel1;
    private String tipDokumenta;
    private Radnajedinica radnaJedinica;
    private Faktura selektovanaFaktura;
    private FiskalniIzvestaj selektovaniIzvestaj;
    private String tableID = "";
    private Komitent komitent;
    private boolean vracanjeFakture = false;
    private boolean vracanjeOtpremnice = false;
    private boolean izmenaDatuma = false;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();

    public UzmiDokument(PzDialog dialog) {
        super(dialog);
        this.preInit();
        this.initGUI();
    }

    private void preInit() {
        this.f = (Faktura)this.getSession().getParameter("faktura");
        this.komitent = (Komitent)this.getSession().getParameter("komitent");
        this.radnaJedinica = (Radnajedinica)this.getSession().getParameter("radnaJedinica");
        if (this.getSession().getParameter("vracanjeFaktureUPripremu") == null && this.getSession().getParameter("vracanjeOtpremniceUPripremu") == null && this.getSession().getParameter("izmenaDatumaValute") == null) {
            this.tipDokumenta = this.getSession().getParameter("tipDokumenta").toString();
            if (this.tipDokumenta.equals("PROFAKTURA")) {
                this.setTitle("Izaberite profakturu");
                this.tableID = "TABLE_PROFAKTURA";
                this.setId("PROFAKTURA");
            } else if (this.tipDokumenta.equals("OTPREMNICA")) {
                this.setTitle("Izaberite otpremnicu");
                this.tableID = "TABLE_OTPREMNICA";
                this.setId("OTPREMNICA");
            } else if (this.tipDokumenta.equals("FAKTURA")) {
                this.setTitle("Izbor dokumenata za komitenta");
                this.tableID = "TABLE_FAKTURA";
                this.setId("FAKTURA");
            } else if (this.tipDokumenta.equals("FAKTURA_TRANZITA")) {
                this.setTitle("Izbor fakture");
                this.tableID = "TABLE_FAKTURA_TRANZITA";
                this.setId("FAKTURA_TRANZITA");
            } else if (this.tipDokumenta.equals("AVANSNI_RACUN")) {
                this.setTitle("Izbor avansnog ra\u010duna za brisanje");
                this.tableID = "TABLE_AVANSNI_RACUN";
                this.setId("AVANSNI_RACUN");
            } else if (this.tipDokumenta.equals("FISKALNI_IZVESTAJ")) {
                this.setTitle("IZBOR DOKUMENTA");
                this.tableID = "TABLE_FISKALNI_IZVESTAJ";
                this.setId("FISKALNI_IZVESTAJ");
            }
        } else if (this.getSession().getParameter("vracanjeFaktureUPripremu") != null) {
            this.vracanjeFakture = true;
            this.setTitle("Izaberite fakturu za vra\u0107anje u pripremu");
            this.tableID = "TABLE_VRACANJE_FAKTURE";
            this.setId("VRACANJE_FAKTURE");
        } else if (this.getSession().getParameter("izmenaDatumaValute") != null) {
            this.izmenaDatuma = true;
            this.setTitle("Izaberite fakturu za izmenu datuma valute");
            this.tableID = "TABLE_IZMENA_DATUMA_VALUTE";
            this.setId("IZMENA_DATUMA_VALUTE");
        } else {
            this.vracanjeOtpremnice = true;
            this.setTitle("Izaberite otpremnicu za vra\u0107anje u pripremu");
            this.tableID = "TABLE_VRACANJE_OTPREMNICE";
            this.setId("VRACANJE_OTPREMNICE");
        }
    }

    private void paintPanel() {
        this.plGlavni.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.plGlavni.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.plGlavni.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            this.plGlavni = new PzPanel();
            this.paintPanel();
            GridBagLayout plGlavniLayout = new GridBagLayout();
            plGlavniLayout.rowWeights = new double[]{0.0, 0.1};
            plGlavniLayout.rowHeights = new int[]{84, 7};
            plGlavniLayout.columnWeights = new double[]{0.1};
            plGlavniLayout.columnWidths = new int[]{7};
            this.plGlavni.setLayout((LayoutManager)plGlavniLayout);
            this.getContentPane().add((Component)this.plGlavni, "Center");
            this.toolbar = new JToolBar();
            this.plGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.btnSlikaProfakture = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnSlikaProfakture);
            this.btnSlikaProfakture.setText("Slika|dokumenta|(F2)");
            this.btnSlikaProfakture.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/presentation_chart.png")));
            this.btnSlikaProfakture.setActionCommand("slika");
            this.btnSlikaProfakture.addActionListener((ActionListener)((Object)this));
            this.btnSlikaProfakture.setShortcut("F2");
            this.btnNeplacene = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnNeplacene);
            this.btnNeplacene.setText("Samo|neplacene|(F4)");
            this.btnNeplacene.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/presentation.png")));
            this.btnNeplacene.setActionCommand("neplacene");
            this.btnNeplacene.addActionListener((ActionListener)((Object)this));
            this.btnNeplacene.setShortcut("F4");
            this.btnNeplacene.setVisible(false);
            this.jPanel1 = new JPanel();
            this.plGlavni.add((Component)this.jPanel1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            BorderLayout jPanel1Layout1 = new BorderLayout();
            this.jPanel1.setLayout(jPanel1Layout1);
            this.jPanel1.setOpaque(false);
            this.plTabela = new PzPanel();
            BorderLayout jPanel1Layout = new BorderLayout();
            this.jPanel1.add((Component)this.plTabela, "Center");
            this.plTabela.setLayout((LayoutManager)jPanel1Layout);
            this.plTabela.setOpaque(false);
            this.scTabela = new JScrollPane();
            this.plTabela.add((Component)this.scTabela, (Object)"Center");
            this.scTabela.setBackground(new Color(211, 242, 210));
            this.tblTabela = new PzTable();
            if (this.vracanjeFakture || this.izmenaDatuma || "FAKTURA".equals(this.tipDokumenta)) {
                this.tblTabela.setFilter(new PzEntityFilter(){

                    public Object[] getValues(PzEntity entity) {
                        Faktura dok = (Faktura)entity;
                        return new Object[]{dok.getOznDokumenta(), dok.getIznos(), dok.getIznos().subtract(dok.getUplata().subtract(dok.getStornoIznos())), dok.getDatum(), dok.getDatValute()};
                    }

                    public String[] getColumnNames() {
                        return new String[]{"Oznaka", "Iznos", "Dug", "Datum dokumenta", "Datum valute"};
                    }
                });
            } else if ("FISKALNI_IZVESTAJ".equals(this.tipDokumenta)) {
                this.tblTabela.setFilter(new PzEntityFilter(){

                    public Object[] getValues(PzEntity entity) {
                        FiskalniIzvestaj dok = (FiskalniIzvestaj)entity;
                        return new Object[]{dok.getOznDokumenta(), dok.getUkupno(), dok.getDatum()};
                    }

                    public String[] getColumnNames() {
                        return new String[]{"Broj izvestaja", "Iznos", "Datum"};
                    }
                });
            } else if (this.vracanjeOtpremnice || "OTPREMNICA".equals(this.tipDokumenta)) {
                this.tblTabela.setFilter(new PzEntityFilter(){

                    public Object[] getValues(PzEntity entity) {
                        Faktura dok = (Faktura)entity;
                        return new Object[]{dok.getOznDokumenta(), dok.getDatum(), dok.getIznos()};
                    }

                    public String[] getColumnNames() {
                        return new String[]{"Oznaka", "Datum", "Iznos"};
                    }
                });
            } else if (this.tipDokumenta.equals("AVANSNI_RACUN")) {
                this.tblTabela.setFilter(new PzEntityFilter(){

                    public Object[] getValues(PzEntity entity) {
                        Faktura dok = (Faktura)entity;
                        return new Object[]{dok.getOznDokumenta(), dok.getDatum(), dok.getIznos(), dok.getIznos().subtract(dok.getUplata())};
                    }

                    public String[] getColumnNames() {
                        return new String[]{"Oznaka", "Datum dokumenta", "Iznos", "Dug"};
                    }
                });
            } else {
                this.tblTabela.setFilter(new PzEntityFilter(){

                    public Object[] getValues(PzEntity entity) {
                        Faktura dok = (Faktura)entity;
                        return new Object[]{dok.getOznDokumenta(), dok.getKomitent().getSfrKomitent(), dok.getKomitent().getNaziv(), dok.getDatum(), dok.getIznos()};
                    }

                    public String[] getColumnNames() {
                        return new String[]{"Oznaka", "\u0160ifra kupca", "Kupac", "Datum", "Iznos"};
                    }
                });
            }
            EntityManager em = PzEntityManager.getEm();
            Query q = null;
            if (!(this.vracanjeFakture || this.vracanjeOtpremnice || this.izmenaDatuma)) {
                if (this.tipDokumenta.equals("PROFAKTURA")) {
                    FetchGroup grp = new FetchGroup();
                    grp.addAttribute("komitent.sfrKomitent");
                    grp.addAttribute("komitent.naziv");
                    grp.addAttribute("oznDokumenta");
                    grp.addAttribute("datum");
                    grp.addAttribute("iznos");
                    q = em.createQuery("SELECT f FROM Faktura f join fetch f.komitent where f.tip=:tip AND f.komitent=:komitent and f.arhiviran = 1 and f.radnajedinica=:rj ORDER BY f.datum, f.rbrDok");
                    q.setParameter("tip", (Object)this.tipDokumenta);
                    q.setParameter("rj", (Object)this.f.getRadnajedinica());
                    q.setParameter("komitent", (Object)this.f.getKomitent());
                    q.setHint("eclipselink.fetch-group", (Object)grp);
                    Vector data = (Vector)q.getResultList();
                    this.brDok.setText(String.valueOf(data.size()));
                    this.tblTabela.setData(data, Faktura.class);
                } else if (this.tipDokumenta.equals("OTPREMNICA")) {
                    q = em.createQuery("SELECT f FROM Faktura f where f.tip=:tip and f.arhiviran = 1 and f.iznos - f.stornoIznos <> 0 and f.storno = 0 and f.radnajedinica=:rj and f.komitent=:komitent and f.fakturaBean is null ORDER BY f.datum, f.rbrDok");
                    q.setParameter("tip", (Object)this.tipDokumenta);
                    q.setParameter("rj", (Object)this.f.getRadnajedinica());
                    q.setParameter("komitent", (Object)this.f.getKomitent());
                    Vector data = (Vector)q.getResultList();
                    this.brDok.setText(String.valueOf(data.size()));
                    this.tblTabela.setData(data, Faktura.class);
                } else if (this.tipDokumenta.equals("FAKTURA")) {
                    q = em.createQuery("SELECT f FROM Faktura f where f.zaOtpremnice=1 and f.arhiviran = 1 and f.storno = 0 and f.komitent=:komitent ORDER BY f.datum, f.rbrDok");
                    q.setParameter("komitent", (Object)this.komitent);
                    Vector data = (Vector)q.getResultList();
                    this.brDok.setText(String.valueOf(data.size()));
                    this.tblTabela.setData(data, Faktura.class);
                } else if (this.tipDokumenta.equals("FAKTURA_TRANZITA")) {
                    FetchGroup grp = new FetchGroup();
                    grp.addAttribute("komitent.sfrKomitent");
                    grp.addAttribute("komitent.naziv");
                    grp.addAttribute("oznDokumenta");
                    grp.addAttribute("datum");
                    grp.addAttribute("iznos");
                    q = em.createQuery("SELECT f FROM Faktura f join fetch f.komitent where f.tip=:tip AND f.podTip <> 'POCETNO' and f.radnajedinica=:rj ORDER BY f.datum, f.rbrDok");
                    q.setParameter("tip", (Object)"FAKTURA");
                    q.setParameter("rj", (Object)this.f.getRadnajedinica());
                    q.setHint("eclipselink.fetch-group", (Object)grp);
                    Vector data = (Vector)q.getResultList();
                    this.brDok.setText(String.valueOf(data.size()));
                    this.tblTabela.setData(data, Faktura.class);
                } else if (this.tipDokumenta.equals("AVANSNI_RACUN")) {
                    q = em.createQuery("SELECT f FROM Faktura f where f.tip=:tip and f.arhiviran = 1 and f.proknjizen = 0 and f.komitent=:komitent ORDER BY f.datum, f.rbrDok");
                    q.setParameter("tip", (Object)this.tipDokumenta);
                    q.setParameter("komitent", (Object)this.komitent);
                    Vector data = (Vector)q.getResultList();
                    this.brDok.setText(String.valueOf(data.size()));
                    this.tblTabela.setData(data, Faktura.class);
                } else if (this.tipDokumenta.equals("FISKALNI_IZVESTAJ")) {
                    q = em.createQuery("SELECT f FROM FiskalniIzvestaj f where  f.arhiviran = 1and f.radnajedinica=:rj ORDER BY f.datum, f.rbrDok");
                    q.setParameter("rj", (Object)this.radnaJedinica);
                    Vector data = (Vector)q.getResultList();
                    this.brDok.setText(String.valueOf(data.size()));
                    this.tblTabela.setData(data, FiskalniIzvestaj.class);
                }
            } else {
                q = this.vracanjeFakture ? em.createQuery("SELECT f FROM Faktura f where f.dokument.proknjizen=0 and f.arhiviran = 1 and f.storno=0 and f.original is null and ((f.tip ='FAKTURA' and f.podTip != 'POCETNO') or f.tip ='FAKTURA_USLUGA') and f.podTip != 'TRENUTNA_SITUACIJA' and f.komitent=:komitent") : (this.izmenaDatuma ? em.createQuery("SELECT f FROM Faktura f where f.arhiviran = 1 and f.storno=0 and f.original is null and f.tip ='FAKTURA' and f.podTip != 'POCETNO' and f.podTip != 'TRENUTNA_SITUACIJA' and f.komitent=:komitent") : em.createQuery("SELECT f FROM Faktura f where f.dokument.proknjizen=0 and f.arhiviran = 1 and f.storno=0 and f.original is null and f.tip ='OTPREMNICA' and f.komitent=:komitent"));
                q.setParameter("komitent", (Object)this.komitent);
                Vector data = (Vector)q.getResultList();
                this.brDok.setText(String.valueOf(data.size()));
                this.tblTabela.setData(data, Faktura.class);
            }
            em.close();
            this.tblTabela.setId(this.tableID);
            this.scTabela.setViewportView((Component)this.tblTabela);
            this.tblTabela.getTableHeader().setFocusable(false);
            this.tblTabela.requestFocusInWindow();
            if (this.tblTabela.getDataSize() > 0) {
                this.tblTabela.setRowSelectionInterval(0, 0);
            }
            this.tblTabela.setEnterAction(new AbstractAction(){

                /*
                 * Exception decompiling
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 2[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("Broj stavki");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.setSize(800, 450);
            this.setMinimumSize(new Dimension(800, 450));
            this.pack();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(null, (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("slika")) {
            this.showReport();
        }
    }

    public void showReport() {
        try {
            if (this.tblTabela.getSelectedEntity() != null) {
                if (!this.vracanjeFakture && "FISKALNI_IZVESTAJ".equals(this.tipDokumenta)) {
                    FiskalniIzvestaj izvestaj = (FiskalniIzvestaj)this.tblTabela.getSelectedEntity();
                    PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)izvestaj);
                } else {
                    Faktura faktura = (Faktura)this.tblTabela.getSelectedEntity();
                    PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)faktura);
                }
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new UzmiDokument(Boolean.FALSE);
    }

    public UzmiDokument(Boolean initGUI) {
    }

    static /* synthetic */ PzTable access$0(UzmiDokument uzmiDokument) {
        return uzmiDokument.tblTabela;
    }

    static /* synthetic */ boolean access$1(UzmiDokument uzmiDokument) {
        return uzmiDokument.vracanjeFakture;
    }

    static /* synthetic */ String access$2(UzmiDokument uzmiDokument) {
        return uzmiDokument.tipDokumenta;
    }

    static /* synthetic */ void access$3(UzmiDokument uzmiDokument, FiskalniIzvestaj fiskalniIzvestaj) {
        uzmiDokument.selektovaniIzvestaj = fiskalniIzvestaj;
    }

    static /* synthetic */ void access$4(UzmiDokument uzmiDokument, Faktura faktura) {
        uzmiDokument.selektovanaFaktura = faktura;
    }

    static /* synthetic */ boolean access$5(UzmiDokument uzmiDokument) {
        return uzmiDokument.vracanjeOtpremnice;
    }

    static /* synthetic */ boolean access$6(UzmiDokument uzmiDokument) {
        return uzmiDokument.izmenaDatuma;
    }

    static /* synthetic */ Faktura access$7(UzmiDokument uzmiDokument) {
        return uzmiDokument.selektovanaFaktura;
    }

    static /* synthetic */ FiskalniIzvestaj access$8(UzmiDokument uzmiDokument) {
        return uzmiDokument.selektovaniIzvestaj;
    }

    static /* synthetic */ Faktura access$9(UzmiDokument uzmiDokument) {
        return uzmiDokument.f;
    }
}

