/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui.faktureZaProdajuRobe;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzEntity;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Faktura;
import rs.pezar.prodaja.gui.faktureZaProdajuRobe.UnosPodataka;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.util.PzGradient;

public class PomocPrekoEvra
extends PzDialog {
    private PzDoubleField dfKurs;
    private JLabel lblOznakaUsera;
    private PzPanel plGlavni;
    private PzDoubleField dfCena;
    private JLabel jLabel1;
    private Faktura faktura;
    private String valuta;
    private Double cenaE;

    public PomocPrekoEvra(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PomocPrekoEvra(PzDialog dialog) {
        super(dialog);
        this.cenaE = (Double)this.getSession().getParameter("cenaE");
        this.faktura = (Faktura)this.getSession().getParameter("faktura");
        this.initGUI();
        this.dfKurs.setVal((Object)this.faktura.getKurs());
        this.postInit();
    }

    private void postInit() {
        this.valuta = PzParameter.getParameterValue((String)"DEF_VALUTA", (String)"EUR");
        this.lblOznakaUsera.setText("Kurs valute-" + this.valuta);
        this.jLabel1.setText("Cena u valuti-" + this.valuta);
        this.dfCena.setVal((Object)this.cenaE);
    }

    private void paintPanel() {
        this.plGlavni.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.plGlavni.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.plGlavni.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            this.setTitle("Pomo\u0107 pri unosu prodajne cene");
            this.plGlavni = new PzPanel();
            GridBagLayout plGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.plGlavni, "Center");
            plGlavniLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.0};
            plGlavniLayout.rowHeights = new int[]{10, 25, 25, 10};
            plGlavniLayout.columnWeights = new double[]{0.0, 0.0};
            plGlavniLayout.columnWidths = new int[]{66, 120};
            this.plGlavni.setLayout((LayoutManager)plGlavniLayout);
            this.lblOznakaUsera = new JLabel();
            this.plGlavni.add((Component)this.lblOznakaUsera, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblOznakaUsera.setText("Kurs evra");
            this.dfKurs = new PzDoubleField();
            this.plGlavni.add((Component)this.dfKurs, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 1, 0), 0, 0));
            this.dfKurs.setFont(new Font("Tahoma", 0, 14));
            this.dfKurs.setPreferredSize(new Dimension(70, 24));
            this.dfKurs.setEditable(false);
            this.dfKurs.setFocusable(false);
            this.dfKurs.setDecimalFormat(PzFormatFactory.getKursFormat());
            this.jLabel1 = new JLabel();
            this.plGlavni.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel1.setText("Cena u evrima");
            this.dfCena = new PzDoubleField();
            this.plGlavni.add((Component)this.dfCena, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 1, 0), 0, 0));
            this.dfCena.setFont(new Font("Tahoma", 0, 14));
            this.dfCena.setPreferredSize(new Dimension(70, 24));
            this.dfCena.setDecimalFormat(PzFormatFactory.getFakturnaCenaFormat());
            this.dfCena.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    PomocPrekoEvra.this.keyRel(evt);
                }
            });
            this.setPreferredSize(new Dimension(300, 100));
            this.setResizable(false);
            this.paintPanel();
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void keyRel(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            if (this.dfCena.getVal() <= 0.0) {
                JOptionPane.showMessageDialog(null, "Nekorektna cena u evrima!", "Informacija", 1);
                return;
            }
            ((UnosPodataka)((Object)this.getParent())).setCena(this.dfCena.getVal() * this.dfKurs.getVal());
            ((UnosPodataka)((Object)this.getParent())).setCenaUValuti(this.dfCena.getVal());
            this.dispose();
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void setEntity(PzEntity entity, Component component) {
    }

    public static Object getGUIBuilderInstance() {
        return new PomocPrekoEvra(Boolean.FALSE);
    }

    public PomocPrekoEvra(Boolean initGUI) {
    }
}

