/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui.faktureZaProdajuRobe;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Faktura;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.util.PzGradient;

public class GeneralnoPovecanjeCena
extends PzDialog {
    private JLabel lblGenPovCena;
    private PzDoubleField dfProcenatGPC;
    private PzButton btnPotvrdi;
    private PzPanel plGlavni;
    private Faktura f;

    public GeneralnoPovecanjeCena(PzDialog dialog) {
        super(dialog);
        this.f = (Faktura)this.getSession().getParameter("faktura");
        this.initGUI();
        this.paintPanel();
    }

    private void paintPanel() {
        this.plGlavni.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.plGlavni.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.plGlavni.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            this.setTitle("Dodela generalnog pove\u0107anja cena");
            this.plGlavni = new PzPanel();
            GridBagLayout plGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.plGlavni, "Center");
            plGlavniLayout.rowWeights = new double[]{0.0, 0.0};
            plGlavniLayout.rowHeights = new int[]{40, 40};
            plGlavniLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            plGlavniLayout.columnWidths = new int[]{64, 128, 100, 20};
            this.plGlavni.setLayout((LayoutManager)plGlavniLayout);
            this.plGlavni.setOpaque(false);
            this.lblGenPovCena = new JLabel();
            this.plGlavni.add((Component)this.lblGenPovCena, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 5), 0, 0));
            this.lblGenPovCena.setText("% generalnog pove\u0107anja");
            this.btnPotvrdi = new PzButton();
            this.plGlavni.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(80, 30));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.dfProcenatGPC = new PzDoubleField();
            this.plGlavni.add((Component)this.dfProcenatGPC, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.dfProcenatGPC.setPreferredSize(new Dimension(60, 24));
            this.dfProcenatGPC.setFont(new Font("Tahoma", 0, 14));
            this.dfProcenatGPC.setDecimalFormat(PzFormatFactory.getDefaultDecimalFormat());
            this.pack();
            this.setSize(400, 135);
            this.setResizable(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                em.getTransaction().begin();
                int i = 0;
                while (i < this.f.getArtikalfakturas().size()) {
                    Artikalfaktura af = (Artikalfaktura)this.f.getArtikalfakturas().get(i);
                    Double cena = af.getCena() + af.getCena() / 100.0 * this.dfProcenatGPC.getVal();
                    af.setCena(cena.doubleValue());
                    PzEntityManager.update((Object)af, (EntityManager)em);
                    ++i;
                }
                em.getTransaction().commit();
                this.dispose();
            }
            catch (Exception e1) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    public static Object getGUIBuilderInstance() {
        return new GeneralnoPovecanjeCena(Boolean.FALSE);
    }

    public GeneralnoPovecanjeCena(Boolean initGUI) {
    }
}

