/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui.faktureZaProdajuRobe;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.db.entity.StanjeartikalPK;
import rs.pezar.prodaja.gui.util.PanelRabati;
import rs.pezar.prodaja.util.PzProdajaUtil;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class GeneralniRabat
extends PzDialog {
    private static final long serialVersionUID = -7684929256173125929L;
    private PanelRabati pnlRabati;
    private PzButton btnPotvrdi;
    private PzPanel plGlavni;
    private Faktura f;

    public GeneralniRabat(PzDialog dialog) {
        super(dialog);
        this.f = (Faktura)this.getSession().getParameter("faktura");
        this.initGUI();
        this.paintPanel();
    }

    private void paintPanel() {
        this.plGlavni.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.plGlavni.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.plGlavni.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            this.setTitle("Dodela generalnog rabata");
            this.plGlavni = new PzPanel();
            GridBagLayout plGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.plGlavni, "Center");
            plGlavniLayout.rowWeights = new double[]{0.1, 0.0};
            plGlavniLayout.rowHeights = new int[]{40, 40};
            plGlavniLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            plGlavniLayout.columnWidths = new int[]{85, 60, 60, 85};
            this.plGlavni.setLayout((LayoutManager)plGlavniLayout);
            this.plGlavni.setOpaque(false);
            this.btnPotvrdi = new PzButton();
            this.plGlavni.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(100, 30));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pnlRabati = new PanelRabati();
            this.plGlavni.add((Component)((Object)this.pnlRabati), (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pack();
            this.setResizable(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        EntityManager em = PzEntityManager.getEm();
        try {
            double maxRabat = new Double(PzParameter.getParameterValue((String)"MAKSIMALNI_RABAT", (String)"100", (EntityManager)em));
            if (this.pnlRabati.getSumaRabata().doubleValue() > maxRabat) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Rabat je ve\u0107i od maksimalnog dozvoljenog rabata. Dalji rad nije mogu\u0107.");
                return;
            }
            try {
                boolean mergeArt = false;
                boolean mergeFakturu = false;
                em.getTransaction().begin();
                int i = 0;
                while (i < this.f.getArtikalfakturas().size()) {
                    Artikalfaktura af = (Artikalfaktura)this.f.getArtikalfakturas().get(i);
                    if (this.f.getRadnajedinica().getgTip().equals("V") && !this.f.getRadnajedinica().getNacinVodjenja().equals("PRODAJNA")) {
                        Stanjeartikal st = (Stanjeartikal)em.find(Stanjeartikal.class, (Object)new StanjeartikalPK(af.getId().getSfrProizvod(), this.f.getRadnajedinica()));
                        if (af.cekPRNCena(this.pnlRabati.getSumaRabata().doubleValue(), st)) {
                            mergeArt = true;
                            mergeFakturu = true;
                        } else {
                            Object[] options = new Object[]{"Da", "Ne"};
                            int rez = JOptionPane.showOptionDialog((Component)((Object)this), "Magacin iz velikoprodaje se vodi po prose\u010dnoj nabavnoj ceni.\nSa unetim procentom rabata cena postaje manja od prose\u010dne nabavne cene!\nDa li \u017eelite da izmenite procenat rabata ovoj stavci?", "ARTIKAL: " + af.getId().getSfrProizvod() + ", BROJ STAVKE:" + af.getId().getrBroj(), 0, 3, null, options, options[1]);
                            if (rez != 0) {
                                mergeArt = false;
                            } else {
                                mergeArt = true;
                                mergeFakturu = true;
                            }
                        }
                        if (mergeArt) {
                            af.setProcRabata(this.pnlRabati.getSumaRabata().doubleValue());
                            PzProdajaUtil.convertPanelRabatiToAFParameters(this.pnlRabati, af, em);
                            PzEntityManager.update((Object)af, (EntityManager)em);
                        }
                    } else {
                        af.setProcRabata(this.pnlRabati.getSumaRabata().doubleValue());
                        PzProdajaUtil.convertPanelRabatiToAFParameters(this.pnlRabati, af, em);
                        PzEntityManager.update((Object)af, (EntityManager)em);
                        mergeFakturu = true;
                    }
                    ++i;
                }
                if (mergeFakturu) {
                    this.f.setProcRabata(this.pnlRabati.getSumaRabata().doubleValue());
                    PzEntityManager.update((Object)this.f, (EntityManager)em);
                }
                em.getTransaction().commit();
                this.dispose();
            }
            catch (Exception e1) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
            }
        }
        finally {
            em.close();
        }
    }

    public static Object getGUIBuilderInstance() {
        return new GeneralniRabat(Boolean.FALSE);
    }

    public GeneralniRabat(Boolean initGUI) {
    }
}

