/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui.dnevniFiskalniIzvestaj;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.FiskalniIzvestaj;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Taksaopstidokument;
import rs.pezar.db.entity.TaksaopstidokumentPK;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzCalculatedField;
import rs.pezar.swing.fields.PzDateField;

public class AutomatskoRegistrovanjeIzvestaja
extends PzDialog {
    private PzPanel pnlGlavni;
    private PzPanel pnlDatum;
    private PzCalculatedField dfPdvF;
    private JLabel lblPdvF;
    private PzCalculatedField dfOsnovicaF;
    private JLabel lblOsnovicaF;
    private JScrollPane scrollPaneFizickoLice;
    private PzTable tabelaFizickoLice;
    private PzDateField dfDatumIzvestaja;
    private JLabel lblDatum;
    private JPanel pnlButton;
    private PzPanel pnlPravnaLica;
    private PzCalculatedField dfPdvP;
    private JLabel lbPdv;
    private PzCalculatedField dfOsnovicaP;
    private JLabel lblOsnovicaP;
    private PzTable tabelaPravnoLice;
    private JScrollPane scrollPanePravnoLice;
    private PzPanel pnlFizickaLica;
    private PzButton btnPotvrdi;
    private Vector<Faktura> tableDataF = null;
    private Vector<Faktura> tableDataP = null;
    private FiskalniIzvestaj izvestaj = null;
    private Radnajedinica rj;
    private String brIzvestaja;
    private Date datum;
    private Integer fizickoLice;

    public AutomatskoRegistrovanjeIzvestaja(PzDialog dialog) {
        super(dialog);
        this.initGUI();
        this.rj = (Radnajedinica)this.getSession().getParameter("radnajedinica");
        this.brIzvestaja = (String)this.getSession().getParameter("brIzvestaja");
        this.datum = (Date)this.getSession().getParameter("datumIzvestaja");
        this.fizickoLice = (Integer)this.getSession().getParameter("fLice");
        this.postInit();
        this.tabelaFizickoLice.calculateFields();
        this.tabelaPravnoLice.calculateFields();
    }

    public void postInit() {
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                em.getTransaction().begin();
                this.dfDatumIzvestaja.setVal((Object)this.datum);
                if (this.fizickoLice == 1) {
                    Query qF = em.createQuery("Select f from Faktura f where f.radnajedinica=:rj and f.datPrometa=:datum and f.arhiviran=1 and f.komitent.tip='2'");
                    qF.setParameter("rj", (Object)this.rj);
                    qF.setParameter("datum", (Object)this.datum);
                    this.tableDataF = (Vector)qF.getResultList();
                    this.tabelaFizickoLice.setData(this.tableDataF, Faktura.class);
                } else {
                    Query qP = em.createQuery("Select f from Faktura f where f.radnajedinica=:rj and f.datPrometa=:datum and f.arhiviran=1 and f.komitent.tip != '2'");
                    qP.setParameter("rj", (Object)this.rj);
                    qP.setParameter("datum", (Object)this.datum);
                    this.tableDataP = (Vector)qP.getResultList();
                    this.tabelaPravnoLice.setData(this.tableDataP, Faktura.class);
                }
                em.getTransaction().commit();
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Automatsko registrovanje dnevnog fiskalnog izve\u0161taja");
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            this.pnlGlavni.setGradient(Color.WHITE, Color.YELLOW, PzPanel.GRADIENT_WEST_EAST);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            this.pnlGlavni.setPreferredSize(new Dimension(345, 331));
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.0};
            pnlGlavniLayout.rowHeights = new int[]{50, 177, 195, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlDatum = new PzPanel();
            GridBagLayout pnlDatumLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlDatum, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlDatumLayout.rowWeights = new double[]{0.1, 0.0, 0.1};
            pnlDatumLayout.rowHeights = new int[]{7, 25, 7};
            pnlDatumLayout.columnWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            pnlDatumLayout.columnWidths = new int[]{93, 100, 7, 7};
            this.pnlDatum.setLayout((LayoutManager)pnlDatumLayout);
            this.pnlDatum.setOpaque(false);
            this.lblDatum = new JLabel();
            this.pnlDatum.add((Component)this.lblDatum, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 3), 0, 0));
            this.lblDatum.setName("lblDatum");
            this.dfDatumIzvestaja = new PzDateField();
            this.pnlDatum.add((Component)this.dfDatumIzvestaja, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlFizickaLica = new PzPanel();
            GridBagLayout pnlFizickaLicaLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlFizickaLica, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlFizickaLica.setBorder((Border)BorderFactory.createTitledBorder(null, "Izdate fakture: fizi\u010dka lica", 4, 0, new Font("Segoe UI", 1, 12), new Color(0, 0, 160)));
            pnlFizickaLicaLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.0, 0.0, 0.0};
            pnlFizickaLicaLayout.rowHeights = new int[]{40, 40, 40, 6, 25, 7};
            pnlFizickaLicaLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFizickaLicaLayout.columnWidths = new int[]{85, 115, 92, 115, 20};
            this.pnlFizickaLica.setLayout((LayoutManager)pnlFizickaLicaLayout);
            this.pnlFizickaLica.setOpaque(false);
            this.scrollPaneFizickoLice = new JScrollPane();
            this.pnlFizickaLica.add((Component)this.scrollPaneFizickoLice, (Object)new GridBagConstraints(0, 0, 5, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tabelaFizickoLice = new PzTable();
            this.tabelaFizickoLice.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Faktura f = (Faktura)entity;
                    return new Object[]{f.getDatum(), f.getOznDokumenta(), f.getIznos().subtract(f.getUkupanPDV()), f.getUkupanPDV()};
                }

                public String[] getColumnNames() {
                    return new String[]{"Datum", "Broj fakture", "Osnovica", "Pdv"};
                }
            });
            this.tabelaFizickoLice.setId("TABLE_F");
            this.scrollPaneFizickoLice.setViewportView((Component)this.tabelaFizickoLice);
            this.lblOsnovicaF = new JLabel();
            this.pnlFizickaLica.add((Component)this.lblOsnovicaF, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 3), 0, 0));
            this.lblOsnovicaF.setName("lblOsnovica");
            this.dfOsnovicaF = this.tabelaFizickoLice.createExpresionField("$2$");
            this.pnlFizickaLica.add((Component)this.dfOsnovicaF, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfOsnovicaF.setForeground(new Color(0, 0, 255));
            this.dfOsnovicaF.setFocusable(false);
            this.lblPdvF = new JLabel();
            this.pnlFizickaLica.add((Component)this.lblPdvF, (Object)new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 3), 0, 0));
            this.lblPdvF.setName("lblPdvF");
            this.dfPdvF = this.tabelaFizickoLice.createExpresionField("$3$");
            this.pnlFizickaLica.add((Component)this.dfPdvF, (Object)new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfPdvF.setForeground(new Color(0, 0, 255));
            this.dfPdvF.setFocusable(false);
            this.pnlPravnaLica = new PzPanel();
            GridBagLayout pnlPravnaLicaLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlPravnaLica, (Object)new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlPravnaLica.setBorder((Border)BorderFactory.createTitledBorder(null, "Izdate fakture: pravna lica", 4, 0, new Font("Segoe UI", 1, 12), new Color(0, 0, 160)));
            pnlPravnaLicaLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.0, 0.0, 0.0};
            pnlPravnaLicaLayout.rowHeights = new int[]{40, 40, 40, 6, 25, 7};
            pnlPravnaLicaLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            pnlPravnaLicaLayout.columnWidths = new int[]{85, 115, 92, 115, 20};
            this.pnlPravnaLica.setLayout((LayoutManager)pnlPravnaLicaLayout);
            this.pnlPravnaLica.setOpaque(false);
            this.scrollPanePravnoLice = new JScrollPane();
            this.pnlPravnaLica.add((Component)this.scrollPanePravnoLice, (Object)new GridBagConstraints(0, 0, 5, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tabelaPravnoLice = new PzTable();
            this.tabelaPravnoLice.setId("TABLE_P");
            this.scrollPanePravnoLice.setViewportView((Component)this.tabelaPravnoLice);
            this.tabelaPravnoLice.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Faktura f = (Faktura)entity;
                    return new Object[]{f.getDatum(), f.getOznDokumenta(), f.getIznos().subtract(f.getUkupanPDV()), f.getUkupanPDV()};
                }

                public String[] getColumnNames() {
                    return new String[]{"Datum", "Broj fakture", "Osnovica", "Pdv"};
                }
            });
            this.lblOsnovicaP = new JLabel();
            this.pnlPravnaLica.add((Component)this.lblOsnovicaP, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 3), 0, 0));
            this.lblOsnovicaP.setName("lblOsnovicaP");
            this.dfOsnovicaP = this.tabelaPravnoLice.createExpresionField("$2$");
            this.pnlPravnaLica.add((Component)this.dfOsnovicaP, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfOsnovicaP.setForeground(new Color(0, 0, 255));
            this.dfOsnovicaP.setFocusable(false);
            this.lbPdv = new JLabel();
            this.pnlPravnaLica.add((Component)this.lbPdv, (Object)new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 3), 0, 0));
            this.lbPdv.setName("lbPdv");
            this.dfPdvP = this.tabelaPravnoLice.createExpresionField("$3$");
            this.pnlPravnaLica.add((Component)this.dfPdvP, (Object)new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfPdvP.setForeground(new Color(0, 0, 255));
            this.dfPdvP.setFocusable(false);
            this.pnlButton = new JPanel();
            this.pnlGlavni.add((Component)this.pnlButton, (Object)new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlButton.setOpaque(false);
            this.btnPotvrdi = new PzButton();
            this.pnlButton.add((Component)this.btnPotvrdi, new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 25, 0, 25), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(115, 33));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pack();
            this.setSize(490, 515);
            this.setMinimumSize(new Dimension(490, 515));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                if (actionCommand.equals("potvrdi")) {
                    if (this.fizickoLice == 1) {
                        Faktura cfr_ignored_0 = (Faktura)this.tabelaFizickoLice.getSelectedEntity();
                    } else {
                        Faktura cfr_ignored_1 = (Faktura)this.tabelaPravnoLice.getSelectedEntity();
                    }
                    em.getTransaction().begin();
                    this.izvestaj = new FiskalniIzvestaj();
                    this.izvestaj.setOznDokumenta(this.brIzvestaja);
                    this.izvestaj.setArhiviran((short)0);
                    this.izvestaj.setTip("FISKALNI_IZVESTAJ");
                    this.izvestaj.setRadnajedinica(this.rj);
                    this.izvestaj.setRjUlaz(this.rj.getPunNaziv());
                    this.izvestaj.setDatum(this.dfDatumIzvestaja.getVal());
                    this.izvestaj.setDatValute(this.datum);
                    this.izvestaj.setArtikalopstidokuments(new Vector());
                    this.izvestaj.setTaksadokuments((List)new IndirectList());
                    this.izvestaj.setFizickoLice(this.fizickoLice);
                    PzDokumentManager.getInstance().snimiDokument((PzDokument)this.izvestaj, false, null);
                    String upit = "Select taksa.oznTarGr, SUM(taksa.osnovica), SUM(taksa.iznos) FROM Taksafaktura taksa, Faktura f, Komitent k Where taksa.idDok = f.idDok  and f.oznRj=':rj' and f.oznOgranak=':ogranak' and f.datPrometa=':datum' and f.arhiviran=1 and f.sfrKomitent=k.sfrKomitent";
                    upit = this.izvestaj.getFizickoLice() == 1 ? String.valueOf(upit) + " and k.tip='2' GROUP BY taksa.oznTarGr" : String.valueOf(upit) + " and k.tip != '2' GROUP BY taksa.oznTarGr";
                    upit = upit.replace(":datum", this.izvestaj.getDatum().toString());
                    upit = upit.replace(":rj", this.izvestaj.getRadnajedinica().getId().getOznRj());
                    upit = upit.replace(":ogranak", this.izvestaj.getRadnajedinica().getId().getOznOgranak());
                    Query q = em.createNativeQuery(upit);
                    q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                    ScrollableCursor cursor = (ScrollableCursor)q.getSingleResult();
                    Object[] stanje = null;
                    while (cursor.hasNext()) {
                        stanje = (Object[])cursor.next();
                        Taksaopstidokument taksa = new Taksaopstidokument();
                        TaksaopstidokumentPK tpk = new TaksaopstidokumentPK();
                        tpk.setIdDok(this.izvestaj.getIdDok());
                        tpk.setOznTarGr((String)stanje[0]);
                        taksa.setId(tpk);
                        taksa.setVrsta("PDV");
                        taksa.setIznos((BigDecimal)stanje[2]);
                        taksa.setOsnovica((BigDecimal)stanje[1]);
                        taksa.setOpstidokument((Opstidokument)this.izvestaj);
                        taksa.setTarifnagrupa((Tarifnagrupa)em.find(Tarifnagrupa.class, (Object)((String)stanje[0])));
                        em.persist((Object)taksa);
                        this.izvestaj.getTaksaopstidokuments().add(taksa);
                    }
                    if (this.izvestaj.getFizickoLice() == 1) {
                        this.izvestaj.setUkupno(this.dfOsnovicaF.getVal() + this.dfPdvF.getVal());
                    } else {
                        this.izvestaj.setUkupno(this.dfOsnovicaP.getVal() + this.dfPdvP.getVal());
                    }
                    em.merge((Object)this.izvestaj);
                    this.getSession().putParameter("izvestaj", (Object)this.izvestaj);
                    em.getTransaction().commit();
                }
                this.dispose();
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    public static Object getGUIBuilderInstance() {
        return new AutomatskoRegistrovanjeIzvestaja(Boolean.FALSE);
    }

    public AutomatskoRegistrovanjeIzvestaja(Boolean initGUI) {
    }
}

