/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.eclipse.persistence.indirection.IndirectList;
import org.jdesktop.application.Application;
import rs.pezar.core.PzApplication;
import rs.pezar.core.format.BDConverter;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fakturausluga;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Kurs;
import rs.pezar.db.entity.KursPK;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Sfutaksa;
import rs.pezar.db.entity.SfutaksaPK;
import rs.pezar.db.entity.Stavkafaktureusl;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.db.entity.Valuta;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.prodaja.PzExtensionLoader;
import rs.pezar.prodaja.gui.faktureUsluga.ArhivaFaktureZaUsluge;
import rs.pezar.prodaja.gui.faktureUsluga.FakturaUI;
import rs.pezar.prodaja.util.ProdajaGradientUtil;
import rs.pezar.prodaja.util.PzProdajaUtil;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.sifarnici.gui.PzDialogStopePoreza;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextAreaPanel;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PzDialogIzradaFaktureUsluga
extends PzDialog {
    private static String CRNA_GRUPA_TIP = "CRNA";
    private static final long serialVersionUID = 8835902771032086792L;
    private PzPanel plGlavniPanel;
    private PzDoubleField dfIznosBezPoreza;
    private PzDoubleField dfIznosSaPorezom;
    private PzTextField tfSifraKomitenta;
    private PzTextField tfNazivKomitenta;
    private PzDateField dfDatumIzrade;
    private PzTextField tgTarifnaGrupa;
    private PzComboBox cbSaBezPoreza;
    private PzDoubleField dfIznosValuta;
    private JLabel lblIznosValuta;
    private PzDoubleField tfKurs;
    private PzComboBox cbValuta;
    private JLabel lblValuta;
    private PzFieldIndikator indTarifnaGrupa;
    private PzFieldIndikator indKupac;
    private PzComboBox cbSaBezPravaNaOdbitak;
    private PzDoubleField dfStopaPDV;
    private PzTextAreaPanel taOpis;
    private JScrollPane scPane1;
    private PzPanel plGornji;
    private PzDateField dfDatumPrometa;
    private JLabel lblDatumPrometa;
    private JLabel lblIznosSaPorezom;
    private JLabel lblTarifnaGrupa;
    private JLabel lblIznosBezPoreza;
    private JLabel lblSifraKupca;
    private JLabel lblDatumIzrade;
    private Radnajedinica rjRadnaJedinica;
    private Tarifnagrupa tarifnaGrupa;
    private Komitent komitent;
    private JToolBar toolbar;
    private PzToolBarIcon icnArhiviraj;
    private JSeparator sep;
    private PzToolBarIcon icnFUI;
    private boolean enableFakturaUI = false;
    FakturaUI fuiDialog = null;
    private PzToolBarIcon icnSnimiOpis;
    private PropertiesConfiguration props;
    private File confFile;
    private String OPIS = "OPIS";
    private String valuta;
    private Firma firma;

    public PzDialogIzradaFaktureUsluga(JFrame frame) {
        super(frame);
        try {
            this.enableFakturaUI = PzParameter.getBoolean((String)"ENABLE_FAKTURA_UI", (boolean)false);
            this.firma = PzFirma.getFirma();
        }
        catch (Exception exception) {}
        this.OPIS = String.valueOf(this.OPIS) + "_" + this.firma.getMatBroj();
        this.initGUI();
        this.loadProperties();
        if (this.enableFakturaUI) {
            this.fuiDialog = new FakturaUI(this);
            this.setChildDialog(this.fuiDialog);
            this.fuiDialog.setModal(true);
            this.fuiDialog.restoreSize();
        }
        this.taOpis.getArea().setText(this.props.getProperty(this.OPIS) == null ? "" : this.props.getProperty(this.OPIS).toString());
        try {
            if (PzFirma.getFirma().getPdvObveznik() == 0) {
                this.cbSaBezPoreza.setSelectedIndex(1);
                this.cbSaBezPoreza.setEnabled(false);
                this.lblTarifnaGrupa.setEnabled(false);
                this.lblIznosSaPorezom.setEnabled(false);
                this.tgTarifnaGrupa.setEnabled(false);
                this.tgTarifnaGrupa.setVal((Object)"");
                this.dfIznosSaPorezom.setEnabled(false);
                this.dfIznosSaPorezom.setVal((Object)0);
                this.dfStopaPDV.setVal((Object)0);
                this.dfStopaPDV.setEnabled(false);
                this.indTarifnaGrupa.setEnabled(false);
                this.cbSaBezPravaNaOdbitak.setEnabled(true);
                this.cbSaBezPravaNaOdbitak.setSelectedIndex(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadProperties() {
        this.props = new PropertiesConfiguration();
        this.confFile = new File(String.valueOf(PzApplication.getApplication().getDataFolder().getAbsolutePath()) + File.separator + "PzDialogIzradaFaktureUsluga.properties");
        try {
            if (!this.confFile.exists()) {
                this.props.load(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/gui/resources/PzDialogIzradaFaktureUsluga.properties"));
            } else {
                this.props.load(this.confFile);
            }
        }
        catch (ConfigurationException e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void postInit() {
        if (!this.rjRadnaJedinica.getgTip().equals("E")) {
            Query q = PzEntityManager.getEm().createQuery("Select v from Valuta v");
            Iterator i = q.getResultList().iterator();
            this.cbValuta.addItem((Object)new PzChoice("Dinar", (Object)"RSD"));
            while (i.hasNext()) {
                Valuta v = (Valuta)i.next();
                this.cbValuta.addItem((Object)new PzChoice(v.getNaziv(), (Object)v.getOznValuta()));
            }
        } else {
            this.cbValuta.addItem((Object)new PzChoice("Dinar", (Object)"RSD"));
        }
        this.setFirstComponentInFocus((Component)this.cbValuta);
        this.lblIznosValuta.setText("Iznos u valuti: " + PzParameter.getParameterValue((String)"DEF_VALUTA", (String)"EUR"));
        this.enableIznosValuta(false);
        this.valuta = this.cbValuta.getSelectedChoice().getValue().toString();
        this.getSession().putParameter("tgr", (Object)"U");
    }

    private void initGUI() {
        try {
            this.plGlavniPanel = new PzPanel();
            GridBagLayout plDugmiciLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.plGlavniPanel, "Center");
            plDugmiciLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            plDugmiciLayout.rowHeights = new int[]{100, 20, 25, 25, 20, 25, 25, 25, 20};
            plDugmiciLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.1};
            plDugmiciLayout.columnWidths = new int[]{115, 84, 60, 140, 120, 20, 7};
            this.plGlavniPanel.setLayout((LayoutManager)plDugmiciLayout);
            this.toolbar = new JToolBar();
            this.toolbar.setFloatable(false);
            this.plGlavniPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 6, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnArhiviraj = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnArhiviraj);
            this.icnArhiviraj.setText("Arhiva i|\u0161tampa|(Ctrl+W)");
            this.icnArhiviraj.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/printer_preferences.png")));
            this.icnArhiviraj.setActionCommand("arhiviranje");
            this.icnArhiviraj.addActionListener((ActionListener)((Object)this));
            this.icnArhiviraj.setShortcut("ctrl+w");
            this.icnSnimiOpis = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnSnimiOpis);
            this.icnSnimiOpis.setText("Sa\u010duvaj|opis|(Ctrl+S)");
            this.icnSnimiOpis.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/save48.png")));
            this.icnSnimiOpis.setActionCommand("sacuvaj");
            this.icnSnimiOpis.addActionListener((ActionListener)((Object)this));
            this.icnSnimiOpis.setShortcut("ctrl+s");
            if (this.enableFakturaUI) {
                this.sep = new JSeparator();
                this.toolbar.add(this.sep);
                this.sep.setOrientation(1);
                this.sep.setPreferredSize(new Dimension(2, 75));
                this.icnFUI = new PzToolBarIcon();
                this.toolbar.add((Component)this.icnFUI);
                this.icnFUI.setText("Faktura|izvoza/uvoza|(Ctrl+F)");
                this.icnFUI.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/fakturaUI.png")));
                this.icnFUI.setActionCommand("fui");
                this.icnFUI.addActionListener((ActionListener)((Object)this));
                this.icnFUI.setShortcut("ctrl+f");
            }
            this.lblValuta = new JLabel();
            this.plGlavniPanel.add((Component)this.lblValuta, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 12, 0, 0), 0, 0));
            this.lblValuta.setName("lblValuta");
            this.cbValuta = new PzComboBox();
            this.plGlavniPanel.add((Component)this.cbValuta, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 1, 0), 0, 0));
            this.cbValuta.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    PzDialogIzradaFaktureUsluga.this.valuta = PzDialogIzradaFaktureUsluga.this.cbValuta.getSelectedChoice().getValue().toString();
                    if (!PzDialogIzradaFaktureUsluga.this.valuta.equals("RSD")) {
                        PzDialogIzradaFaktureUsluga.this.enableKurs(true);
                        PzDialogIzradaFaktureUsluga.this.lblIznosValuta.setText("Iznos u valuti: " + PzDialogIzradaFaktureUsluga.this.valuta);
                        PzDialogIzradaFaktureUsluga.this.enableIznosValuta(true);
                        PzDialogIzradaFaktureUsluga.this.dfIznosBezPoreza.setDecimalFormat(PzFormatFactory.getIznosValutaFormat());
                        PzDialogIzradaFaktureUsluga.this.dfIznosSaPorezom.setDecimalFormat(PzFormatFactory.getIznosValutaFormat());
                        PzDialogIzradaFaktureUsluga.this.dfIznosValuta.setDecimalFormat(PzFormatFactory.getIznosValutaFormat());
                    } else {
                        PzDialogIzradaFaktureUsluga.this.lblIznosValuta.setText("Iznos u valuti: " + PzParameter.getParameterValue((String)"DEF_VALUTA", (String)"EUR"));
                        PzDialogIzradaFaktureUsluga.this.enableKurs(false);
                        PzDialogIzradaFaktureUsluga.this.enableIznosValuta(false);
                        PzDialogIzradaFaktureUsluga.this.dfIznosBezPoreza.setDecimalFormat(PzFormatFactory.getIznosFormat());
                        PzDialogIzradaFaktureUsluga.this.dfIznosSaPorezom.setDecimalFormat(PzFormatFactory.getIznosFormat());
                        PzDialogIzradaFaktureUsluga.this.dfIznosValuta.setDecimalFormat(PzFormatFactory.getIznosFormat());
                    }
                    return true;
                }
            });
            this.tfKurs = new PzDoubleField();
            this.plGlavniPanel.add((Component)this.tfKurs, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 1, 0), 0, 0));
            this.lblDatumIzrade = new JLabel();
            this.plGlavniPanel.add((Component)this.lblDatumIzrade, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
            this.lblDatumIzrade.setText("Datum izrade");
            this.lblSifraKupca = new JLabel();
            this.plGlavniPanel.add((Component)this.lblSifraKupca, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
            this.lblSifraKupca.setText("\u0160ifra kupca");
            this.lblIznosBezPoreza = new JLabel();
            this.plGlavniPanel.add((Component)this.lblIznosBezPoreza, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
            this.lblIznosBezPoreza.setText("Iznos bez poreza");
            this.lblTarifnaGrupa = new JLabel();
            this.plGlavniPanel.add((Component)this.lblTarifnaGrupa, (Object)new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
            this.lblTarifnaGrupa.setText("Tarifna grupa");
            this.lblIznosSaPorezom = new JLabel();
            this.plGlavniPanel.add((Component)this.lblIznosSaPorezom, (Object)new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
            this.lblIznosSaPorezom.setText("Iznos sa porezom");
            this.lblDatumPrometa = new JLabel();
            this.plGlavniPanel.add((Component)this.lblDatumPrometa, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.lblDatumPrometa.setText("Datum prometa");
            this.dfDatumIzrade = new PzDateField();
            this.plGlavniPanel.add((Component)this.dfDatumIzrade, (Object)new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.dfDatumIzrade.setFont(new Font("Tahoma", 0, 14));
            this.dfDatumIzrade.setDefaultDate(PzDateUtility.getCurrentDate());
            this.tfSifraKomitenta = new PzTextField();
            this.plGlavniPanel.add((Component)this.tfSifraKomitenta, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 20), 0, 0));
            this.tfSifraKomitenta.setFont(new Font("Tahoma", 0, 14));
            this.tfSifraKomitenta.setFKField(Komitent.class, PzDialogKomintenti.class, true, "\u0160ifra komitenta nije na\u0111ena!");
            this.tfSifraKomitenta.setCustomInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PzDialogIzradaFaktureUsluga.this.komitent == null) {
                        return false;
                    }
                    return PzProdajaUtil.grupeKomitenata(PzDialogIzradaFaktureUsluga.this, PzApplication.getApplication().getSession().getLoggedUser(), PzDialogIzradaFaktureUsluga.this.komitent);
                }
            });
            this.tfNazivKomitenta = new PzTextField();
            this.plGlavniPanel.add((Component)this.tfNazivKomitenta, (Object)new GridBagConstraints(2, 3, 3, 1, 0.0, 0.0, 17, 1, new Insets(0, 3, 1, 0), 0, 0));
            this.tfNazivKomitenta.setForeground(new Color(255, 0, 0));
            this.tfNazivKomitenta.setFocusable(false);
            this.dfIznosBezPoreza = new PzDoubleField();
            this.plGlavniPanel.add((Component)this.dfIznosBezPoreza, (Object)new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.dfIznosBezPoreza.setFont(new Font("Tahoma", 0, 14));
            this.dfIznosBezPoreza.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PzDialogIzradaFaktureUsluga.this.dfIznosBezPoreza.getVal() <= 0.0) {
                        JOptionPane.showMessageDialog(null, "Iznos bez poreza mora biti ve\u0107i 0!", "Informacija", 1);
                        return false;
                    }
                    return true;
                }
            });
            this.tgTarifnaGrupa = new PzTextField();
            this.plGlavniPanel.add((Component)this.tgTarifnaGrupa, (Object)new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 20), 0, 0));
            this.tgTarifnaGrupa.setFont(new Font("Tahoma", 0, 14));
            this.tgTarifnaGrupa.setFKField(Tarifnagrupa.class, PzDialogStopePoreza.class, true, null);
            this.tgTarifnaGrupa.setToUpperCase(true);
            this.tgTarifnaGrupa.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    PzDialogIzradaFaktureUsluga.this.tfTarifnaGrupaKeyPressed(evt);
                }
            });
            this.dfStopaPDV = new PzDoubleField();
            this.plGlavniPanel.add((Component)this.dfStopaPDV, (Object)new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 3, 1, 0), 0, 0));
            this.dfStopaPDV.setLimit(7, 2);
            this.dfStopaPDV.setForeground(new Color(255, 0, 0));
            this.dfStopaPDV.setFocusable(false);
            this.dfIznosSaPorezom = new PzDoubleField();
            this.plGlavniPanel.add((Component)this.dfIznosSaPorezom, (Object)new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.dfIznosSaPorezom.setFont(new Font("Tahoma", 0, 14));
            this.dfIznosSaPorezom.setActionCommand("saPorezom");
            this.dfIznosSaPorezom.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    PzDialogIzradaFaktureUsluga.this.dfIznosSaPorezomKeyPressed(evt);
                }
            });
            this.dfIznosSaPorezom.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PzDialogIzradaFaktureUsluga.this.dfIznosSaPorezom.getVal() <= 0.0) {
                        PzDialogIzradaFaktureUsluga.this.dfIznosSaPorezom.setVal((Object)0);
                        PzDialogIzradaFaktureUsluga.this.dfIznosBezPoreza.setVal((Object)0);
                        JOptionPane.showMessageDialog(null, "Iznos sa porezom mora biti ve\u0107i 0!", "Informacija", 1);
                        return false;
                    }
                    return true;
                }
            });
            this.dfDatumPrometa = new PzDateField();
            this.plGlavniPanel.add((Component)this.dfDatumPrometa, (Object)new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.dfDatumPrometa.setFont(new Font("Tahoma", 0, 14));
            this.dfDatumPrometa.setDefaultDate(PzDateUtility.getCurrentDate());
            this.dfDatumPrometa.setCustomInputVerifier(this.getInputVerifier());
            this.indKupac = new PzFieldIndikator();
            this.plGlavniPanel.add((Component)this.indKupac, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.indTarifnaGrupa = new PzFieldIndikator();
            this.plGlavniPanel.add((Component)this.indTarifnaGrupa, (Object)new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.cbSaBezPravaNaOdbitak = new PzComboBox();
            this.plGlavniPanel.add((Component)this.cbSaBezPravaNaOdbitak, (Object)new GridBagConstraints(4, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.cbSaBezPravaNaOdbitak.addItem((Object)"Sa pravom na odbitak");
            this.cbSaBezPravaNaOdbitak.addItem((Object)"Bez prava na odbitak");
            this.cbSaBezPravaNaOdbitak.setActionCommand("sa_bez_prava_na_odbitak");
            this.cbSaBezPravaNaOdbitak.setSelectedIndex(0);
            this.cbSaBezPravaNaOdbitak.addActionListener((ActionListener)((Object)this));
            this.cbSaBezPravaNaOdbitak.setEnabled(false);
            this.cbSaBezPoreza = new PzComboBox();
            this.plGlavniPanel.add((Component)this.cbSaBezPoreza, (Object)new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
            this.cbSaBezPoreza.addItem((Object)"Sa porezom");
            this.cbSaBezPoreza.addItem((Object)"Bez poreza");
            this.cbSaBezPoreza.setActionCommand("sa_bez_poreza");
            this.cbSaBezPoreza.setSelectedIndex(0);
            this.cbSaBezPoreza.addActionListener((ActionListener)((Object)this));
            this.plGornji = new PzPanel();
            this.plGlavniPanel.add((Component)this.plGornji, (Object)new GridBagConstraints(0, 8, 7, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
            GridBagLayout plGornjiLayout = new GridBagLayout();
            plGornjiLayout.rowWeights = new double[]{0.1};
            plGornjiLayout.rowHeights = new int[]{100};
            plGornjiLayout.columnWeights = new double[]{0.1};
            plGornjiLayout.columnWidths = new int[]{7};
            this.plGornji.setLayout((LayoutManager)plGornjiLayout);
            this.plGornji.setOpaque(false);
            this.scPane1 = new JScrollPane();
            this.plGornji.add((Component)this.scPane1, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            this.scPane1.setBorder(BorderFactory.createTitledBorder("Opis"));
            this.taOpis = new PzTextAreaPanel();
            this.scPane1.setViewportView((Component)this.taOpis);
            this.lblIznosValuta = new JLabel();
            this.plGlavniPanel.add((Component)this.lblIznosValuta, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 12, 0, 0), 0, 0));
            this.lblIznosValuta.setName("lblIznosValuta");
            this.dfIznosValuta = new PzDoubleField();
            this.plGlavniPanel.add((Component)this.dfIznosValuta, (Object)new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.dfIznosValuta.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    if (PzDialogIzradaFaktureUsluga.this.dfIznosValuta.getVal() != 0.0) {
                        BigDecimal kurs = BDConverter.getKurs((double)PzDialogIzradaFaktureUsluga.this.tfKurs.getVal());
                        BigDecimal iznos = PzDialogIzradaFaktureUsluga.this.valuta.equals("RSD") ? BDConverter.getIznos((double)PzDialogIzradaFaktureUsluga.this.dfIznosValuta.getVal()) : BDConverter.getIznosValuta((double)PzDialogIzradaFaktureUsluga.this.dfIznosValuta.getVal());
                        BigDecimal iznosUDin = PzDialogIzradaFaktureUsluga.this.valuta.equals("RSD") ? BDConverter.getIznos((BigDecimal)iznos.multiply(kurs)) : BDConverter.getIznosValuta((BigDecimal)iznos.multiply(kurs));
                        PzDialogIzradaFaktureUsluga.this.dfIznosBezPoreza.setVal((Object)iznosUDin.doubleValue());
                    }
                    return true;
                }
            });
            this.tfSifraKomitenta.setStateIndikator(this.indKupac);
            this.tgTarifnaGrupa.setStateIndikator(this.indTarifnaGrupa);
            this.pack();
            this.setSize(725, 600);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void enableKurs(boolean enable) {
        this.tfKurs.setEnabled(false);
        this.tfKurs.setFocusable(false);
        if (!enable) {
            this.tfKurs.setVal((Object)0);
        }
    }

    private void enableIznosValuta(boolean enable) {
        this.lblIznosValuta.setEnabled(enable);
        this.dfIznosValuta.setEnabled(enable);
        this.dfIznosValuta.setFocusable(enable);
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (e.getSource() == this.icnFUI) {
            if (this.dfIznosBezPoreza.getVal() == 0.0) {
                JOptionPane.showMessageDialog((Component)this.cbSaBezPoreza, "Nije unet iznos bez poreza!", "Informacija", 1);
                return;
            }
            this.fuiDialog.setIznosBezPoreza(this.dfIznosBezPoreza.getVal());
            this.fuiDialog.setKurs(this.dfDatumPrometa.getVal());
            this.fuiDialog.setVisible(true);
            Object o = this.getSession().getParameter("poruka");
            if (o != null) {
                this.taOpis.getArea().setText(o.toString());
                Object izn = this.getSession().getParameter("iznos");
                if (izn != null) {
                    this.dfIznosBezPoreza.setVal(izn);
                }
                this.dfIznosBezPoreza.requestFocus();
            }
            return;
        }
        if (e.getSource() == this.icnSnimiOpis) {
            this.props.setProperty(this.OPIS, (Object)this.taOpis.getArea().getText());
            try {
                this.props.save(this.confFile);
            }
            catch (ConfigurationException e1) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
        } else if (actionCommand.equalsIgnoreCase("sa_bez_poreza")) {
            if (this.cbSaBezPoreza.getSelectedItem().equals("Sa porezom")) {
                this.lblTarifnaGrupa.setEnabled(true);
                this.lblIznosSaPorezom.setEnabled(true);
                this.tgTarifnaGrupa.setEnabled(true);
                this.dfIznosSaPorezom.setEnabled(true);
                this.dfStopaPDV.setEnabled(true);
                this.indTarifnaGrupa.setEnabled(true);
                this.cbSaBezPravaNaOdbitak.setEnabled(false);
                this.tgTarifnaGrupa.setFKField(Tarifnagrupa.class, PzDialogStopePoreza.class, true, "Uneta tarifna grupa nije na\u0111ena!");
            } else if (this.cbSaBezPoreza.getSelectedItem().equals("Bez poreza")) {
                this.lblTarifnaGrupa.setEnabled(false);
                this.lblIznosSaPorezom.setEnabled(false);
                this.tgTarifnaGrupa.setEnabled(false);
                this.tgTarifnaGrupa.setVal((Object)"");
                this.dfIznosSaPorezom.setEnabled(false);
                this.dfIznosSaPorezom.setVal((Object)0);
                this.dfStopaPDV.setVal((Object)0);
                this.dfStopaPDV.setEnabled(false);
                this.indTarifnaGrupa.setEnabled(false);
                this.cbSaBezPravaNaOdbitak.setEnabled(true);
            }
        } else if (actionCommand.equalsIgnoreCase("arhiviranje") || e.getSource() == this.icnArhiviraj) {
            if (!this.plGlavniPanel.validateForm(true)) {
                return;
            }
            if (this.cbSaBezPoreza.getSelectedItem().equals("Sa porezom") && this.komitent.getDomaciKomitent() == 0) {
                int rez = JOptionPane.showConfirmDialog(SwingUtilities.getRoot((Component)((Object)this)), "Inostrani komitent! Obra\u010dun PDV-a?", "", 0);
                if (rez != 0) {
                    return;
                }
            } else if (this.dfIznosBezPoreza.getVal() <= 0.0) {
                JOptionPane.showMessageDialog(this.getParent(), "Iznos bez poreza mora biti ve\u0107i od 0!", "Informacija", 1);
                return;
            }
            Fakturausluga fUsluga = new Fakturausluga();
            fUsluga.setKomitent(this.komitent);
            fUsluga.setRadnajedinica(this.rjRadnaJedinica);
            fUsluga.setTip(TipDokumentConfig.get().FAKTURA_USLUGA);
            fUsluga.setPodTip(TipDokumentConfig.get().PODTIP_FAKTURA_USLUGA);
            fUsluga.setDatum(this.dfDatumIzrade.getVal());
            fUsluga.setDatPrometa(this.dfDatumPrometa.getVal());
            if (fUsluga.getRadnajedinica().getgTip().equals("E")) {
                fUsluga.setVrednostUsluga(BDConverter.getIznos((double)this.dfIznosSaPorezom.getVal()));
            } else {
                fUsluga.setVrednostUsluga(BDConverter.getIznos((double)this.dfIznosBezPoreza.getVal()));
            }
            fUsluga.setKurs(this.tfKurs.getVal().doubleValue());
            if (this.cbSaBezPoreza.getSelectedIndex() == 0) {
                fUsluga.setSaPorezom(1);
            } else {
                fUsluga.setSaPorezom(0);
                if (this.cbSaBezPravaNaOdbitak.getSelectedIndex() == 0) {
                    fUsluga.setSaPravomNaOdbitak(1);
                } else {
                    fUsluga.setSaPravomNaOdbitak(0);
                }
            }
            fUsluga.setUserKraj(PzExtensionLoader.getLoggedUser());
            Stavkafaktureusl stavka = new Stavkafaktureusl();
            if (fUsluga.getRadnajedinica().getgTip().equals("E")) {
                if (this.cbSaBezPoreza.getSelectedIndex() == 0) {
                    stavka.setCena(this.dfIznosSaPorezom.getVal().doubleValue());
                } else {
                    stavka.setCena(this.dfIznosBezPoreza.getVal().doubleValue());
                }
            } else {
                stavka.setCena(this.dfIznosBezPoreza.getVal().doubleValue());
            }
            stavka.setNaziv(this.taOpis.getVal().toString());
            stavka.setKolicina(1.0);
            if (this.cbSaBezPoreza.getSelectedItem().equals("Sa porezom")) {
                if (stavka.getSfutaksas() == null) {
                    stavka.setSfutaksas((List)new IndirectList());
                }
                Sfutaksa stavkaTaksa = new Sfutaksa();
                SfutaksaPK sfutaksaPK = new SfutaksaPK();
                sfutaksaPK.setrBroj(1);
                sfutaksaPK.setOznTarGr(this.tarifnaGrupa.getOznTarGr());
                stavkaTaksa.setOznVrstaTG("PDV");
                stavkaTaksa.setStopa(this.tarifnaGrupa.getStopa());
                stavkaTaksa.setOpis(this.tarifnaGrupa.getVrstatg().getOpis());
                stavkaTaksa.setId(sfutaksaPK);
                stavka.getSfutaksas().add(stavkaTaksa);
                stavkaTaksa.setStavkafaktureusl(stavka);
            }
            if (fUsluga.getStavkafaktureusls() == null) {
                fUsluga.setStavkafaktureusls((List)new IndirectList());
            }
            fUsluga.setIznos(this.dfIznosSaPorezom.getBigDecimal().compareTo(BigDecimal.ZERO) != 0 ? this.dfIznosSaPorezom.getBigDecimal() : this.dfIznosBezPoreza.getBigDecimal());
            this.getSession().putParameter("fakturaU", (Object)fUsluga);
            this.getSession().putParameter("stavkaFU", (Object)stavka);
            this.getSession().putParameter("VALUTA", (Object)this.cbValuta.getSelectedValue().toString());
            if (!PzProdajaUtil.grupeKomitenataArhiva(this, (Faktura)fUsluga)) {
                return;
            }
            this.showDialog(ArhivaFaktureZaUsluge.class);
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Tarifnagrupa) {
            this.tarifnaGrupa = (Tarifnagrupa)entity;
            ((PzTextField)component).setVal((Object)this.tarifnaGrupa.getOznTarGr());
            this.dfStopaPDV.setVal((Object)this.tarifnaGrupa.getStopa());
            this.dfIznosSaPorezom.setVal((Object)(this.dfIznosBezPoreza.getVal() * (1.0 + this.dfStopaPDV.getVal() / 100.0)));
            this.dfIznosSaPorezom.requestFocus();
        } else if (entity instanceof Komitent) {
            this.komitent = (Komitent)entity;
            ((PzTextField)component).setVal((Object)this.komitent.getSfrKomitent());
            this.tfNazivKomitenta.setVal((Object)this.komitent.getNaziv());
            if (this.valuta.equals("RSD")) {
                this.dfIznosBezPoreza.requestFocus();
            } else {
                this.dfIznosValuta.requestFocus();
            }
        }
    }

    private void dfIznosSaPorezomKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.dfIznosBezPoreza.setVal((Object)(this.dfIznosSaPorezom.getVal() / (1.0 + this.dfStopaPDV.getVal() / 100.0)));
        }
    }

    private void tfTarifnaGrupaKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.dfIznosSaPorezom.setVal((Object)(this.dfIznosBezPoreza.getVal() * (1.0 + this.dfStopaPDV.getVal() / 100.0)));
        }
    }

    private InputVerifier getInputVerifier() {
        return new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                PzDialogIzradaFaktureUsluga.this.dfDatumPrometa.getVal();
                if (input == PzDialogIzradaFaktureUsluga.this.dfDatumPrometa) {
                    PzDialogIzradaFaktureUsluga.this.dfDatumIzrade.getVal();
                    if (!PzDialogIzradaFaktureUsluga.this.valuta.equals("RSD")) {
                        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
                        Kurs kurs = (Kurs)em.find(Kurs.class, (Object)new KursPK(PzDialogIzradaFaktureUsluga.this.valuta, PzDialogIzradaFaktureUsluga.this.dfDatumIzrade.getVal()));
                        em.close();
                        if (kurs == null) {
                            PzSwingUtility.showInformationMessage((Component)((Object)PzDialogIzradaFaktureUsluga.this), (String)("Na datum prometa ne postoji kurs valute! Preuzmite kurs za valutu - " + PzDialogIzradaFaktureUsluga.this.valuta + " na datum prometa kroz opciju: \u0160ifarnici->Kursna lista"));
                            return false;
                        }
                        PzDialogIzradaFaktureUsluga.this.tfKurs.setVal((Object)(kurs.getSrednji().doubleValue() / (double)kurs.getJedinica()));
                    }
                }
                return true;
            }
        };
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogIzradaFaktureUsluga(Boolean.FALSE);
    }

    public PzDialogIzradaFaktureUsluga(Boolean initGUI) {
    }

    public boolean shouldBeShown() {
        this.plGlavniPanel.setPaintGradient(true);
        this.plGlavniPanel.setGradient(ProdajaGradientUtil.FAKTURA_USLUGA_GRADIENT);
        this.getSession().putParameter("gradient", (Object)ProdajaGradientUtil.FAKTURA_USLUGA_GRADIENT);
        this.rjRadnaJedinica = PzDialogRJ.getRJ((PzDialog)this, (Character[])new Character[]{Character.valueOf("V".charAt(0)), Character.valueOf("E".charAt(0))});
        if (this.rjRadnaJedinica != null && this.rjRadnaJedinica.getTip().equals("ET")) {
            JOptionPane.showMessageDialog(this.getParent(), "Fakture usluga se ne izdaju u konsignacijama!", "Informacija", 1);
            this.rjRadnaJedinica = null;
        }
        if (this.rjRadnaJedinica != null) {
            this.setVisible(false);
            this.setTitle("Izrada fakture usluga iz rj: " + this.rjRadnaJedinica.getPunNaziv());
            this.postInit();
            return true;
        }
        return false;
    }

    private DecimalFormat getFormatCena() {
        if (this.komitent != null && this.komitent.getDomacaValuta() == 0) {
            return PzFormatFactory.getProdCenaValutaFormat();
        }
        return PzFormatFactory.getProdCenaFormat();
    }
}

