/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Application;
import rs.pezar.core.format.BDConverter;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.RadnajedinicaPK;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.db.entity.StanjeartikalPK;
import rs.pezar.prodaja.gui.faktureZaProdajuRobe.ArhivaStampa;
import rs.pezar.prodaja.util.ProdajaGradientUtil;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.event.PzEntityChecker;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogAutomatskaIzradaPrenosnice
extends PzDialog {
    private static final long serialVersionUID = -7614101062481072689L;
    private JToolBar toolbar;
    private PzPanel pnlTable;
    private JScrollPane scrpTable;
    private PzPanel mainPanel;
    private PzTextField konsOpis;
    private PzTextField nazKomitenta;
    private PzNumericOnlyTextField sfrKomitenta;
    private PzDoubleField dfProcRabata;
    private PzNumericOnlyTextField nfKonsignacija;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzPanel panelArhiva;
    private PzTable table;
    private PzToolBarIcon btnArhivaIStampa;
    private PzToolBarIcon btnBrisanjeDokumenta;
    private PzToolBarIcon btnBrisanjeReda;
    private Radnajedinica rj;
    private Komitent k;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brStavki = new JLabel();
    private PzPanel panelContent;

    public PzDialogAutomatskaIzradaPrenosnice() {
    }

    public PzDialogAutomatskaIzradaPrenosnice(JFrame frame) {
        super(frame);
        this.initGUI();
        this.setEnabledArhiva(false);
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Automatska izrada prenosnice");
            this.mainPanel = new PzPanel();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            GridBagLayout mainPanelLayout1 = new GridBagLayout();
            mainPanelLayout1.columnWeights = new double[]{0.1};
            mainPanelLayout1.columnWidths = new int[]{7};
            mainPanelLayout1.rowWeights = new double[]{0.0, 0.1, 0.0};
            mainPanelLayout1.rowHeights = new int[]{7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout1);
            this.toolbar = new JToolBar();
            this.toolbar.setOpaque(false);
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setFloatable(false);
            this.btnBrisanjeReda = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnBrisanjeReda);
            this.btnBrisanjeReda.setText("Brisanje|stavke|(Delete)");
            this.btnBrisanjeReda.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/row_delete.png")));
            this.btnBrisanjeReda.setActionCommand("brisanje");
            this.btnBrisanjeReda.addActionListener((ActionListener)((Object)this));
            this.btnBrisanjeReda.setShortcut("delete");
            this.btnBrisanjeDokumenta = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnBrisanjeDokumenta);
            this.btnBrisanjeDokumenta.setText("Brisanje|svega|(Ctrl+Q)");
            this.btnBrisanjeDokumenta.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/note_delete.png")));
            this.btnBrisanjeDokumenta.setActionCommand("brisanjeSvega");
            this.btnBrisanjeDokumenta.addActionListener((ActionListener)((Object)this));
            this.btnBrisanjeDokumenta.setShortcut("CTRL+Q");
            this.btnArhivaIStampa = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnArhivaIStampa);
            this.btnArhivaIStampa.setText("Arhiva i|\u0161tampa|(Ctrl+W)");
            this.btnArhivaIStampa.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/printer_preferences.png")));
            this.btnArhivaIStampa.setActionCommand("ArhivaStampa");
            this.btnArhivaIStampa.addActionListener((ActionListener)((Object)this));
            this.btnArhivaIStampa.setShortcut("ctrl+w");
            this.panelContent = new PzPanel();
            this.panelContent.setOpaque(false);
            this.mainPanel.add((Component)this.panelContent, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.panelContent.setLayout((LayoutManager)mainPanelLayout);
            mainPanelLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.0};
            mainPanelLayout.rowHeights = new int[]{75, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlTable = new PzPanel();
            this.panelContent.add((Component)this.pnlTable, (Object)new GridBagConstraints(0, 0, 4, 3, 0.0, 0.0, 10, 1, new Insets(5, 10, 5, 10), 0, 0));
            GridBagLayout pnlTableLayout = new GridBagLayout();
            pnlTableLayout.columnWidths = new int[]{7};
            pnlTableLayout.rowHeights = new int[]{7};
            pnlTableLayout.columnWeights = new double[]{0.1};
            pnlTableLayout.rowWeights = new double[]{0.1};
            this.pnlTable.setLayout((LayoutManager)pnlTableLayout);
            this.scrpTable = new JScrollPane();
            this.pnlTable.add((Component)this.scrpTable, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.initializeTable();
            this.panelArhiva = new PzPanel();
            this.panelArhiva.setOpaque(false);
            GridBagLayout panelArhivaLayout1 = new GridBagLayout();
            GridBagLayout panelArhivaLayout = new GridBagLayout();
            panelArhivaLayout.columnWidths = new int[]{7, 7, 7, 7};
            panelArhivaLayout.rowHeights = new int[]{7, 7, 7, 7};
            panelArhivaLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            panelArhivaLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            this.panelContent.add((Component)this.panelArhiva, (Object)new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            panelArhivaLayout1.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            panelArhivaLayout1.rowHeights = new int[]{30, 25, 25, 7};
            panelArhivaLayout1.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            panelArhivaLayout1.columnWidths = new int[]{83, 139, 100, 352, 20};
            this.panelArhiva.setLayout((LayoutManager)panelArhivaLayout1);
            this.jLabel1 = new JLabel();
            this.panelArhiva.add((Component)this.jLabel1, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 3), 0, 0));
            this.jLabel1.setName("jLabel1");
            this.jLabel2 = new JLabel();
            this.panelArhiva.add((Component)this.jLabel2, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 3), 0, 0));
            this.jLabel2.setName("jLabel2");
            this.jLabel3 = new JLabel();
            this.panelArhiva.add((Component)this.jLabel3, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 3), 0, 0));
            this.jLabel3.setName("jLabel3");
            this.nfKonsignacija = new PzNumericOnlyTextField();
            this.panelArhiva.add((Component)this.nfKonsignacija, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 1, 0), 0, 0));
            this.nfKonsignacija.setMaxLength(3);
            this.nfKonsignacija.setEnabled(false);
            this.nfKonsignacija.setFKField(Radnajedinica.class, PzDialogRJ.class, true, null);
            this.nfKonsignacija.setParamToPass((Object)this.rj);
            this.nfKonsignacija.setEntityChecker(new PzEntityChecker(){

                public PzEntity getEntity() {
                    try {
                        return PzEntityManager.find(Radnajedinica.class, (Object)new RadnajedinicaPK("1", PzDialogAutomatskaIzradaPrenosnice.this.nfKonsignacija.getVal()));
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)PzDialogAutomatskaIzradaPrenosnice.this.nfKonsignacija, (Throwable)e);
                        return null;
                    }
                }
            });
            this.dfProcRabata = new PzDoubleField();
            this.panelArhiva.add((Component)this.dfProcRabata, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.dfProcRabata.setDecimalFormat(PzFormatFactory.getProcRabataFormat());
            this.dfProcRabata.setEnabled(false);
            this.dfProcRabata.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent arg0) {
                    if (arg0.getKeyCode() == 10) {
                        PzDialogAutomatskaIzradaPrenosnice.this.btnArhivaIStampa.doClick();
                    }
                }
            });
            this.sfrKomitenta = new PzNumericOnlyTextField();
            this.panelArhiva.add((Component)this.sfrKomitenta, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.sfrKomitenta.setName("sfrKomitenta");
            this.sfrKomitenta.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.sfrKomitenta.setEnabled(false);
            this.nazKomitenta = new PzTextField();
            this.panelArhiva.add((Component)this.nazKomitenta, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 2, 1, 10), 0, 0));
            this.nazKomitenta.setName("nazKomitenta");
            this.nazKomitenta.setFocusable(false);
            this.nazKomitenta.setEditable(false);
            this.konsOpis = new PzTextField();
            this.panelArhiva.add((Component)this.konsOpis, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 2, 1, 10), 0, 0));
            this.konsOpis.setName("konsOpis");
            this.konsOpis.setFocusable(false);
            this.konsOpis.setEditable(false);
            this.statusBar = new PzStatusBar();
            this.mainPanel.add((Component)this.statusBar, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("Broj stavki");
            this.statusBar.add((Component)this.brStavki);
            this.brStavki.setFocusable(false);
            this.brStavki.setOpaque(false);
            this.pack();
            this.setSize(800, 600);
            this.setMinimumSize(new Dimension(800, 600));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void setEnabledArhiva(boolean enabled) {
        this.sfrKomitenta.setEnabled(enabled);
        this.nfKonsignacija.setEnabled(enabled);
        this.dfProcRabata.setEnabled(enabled);
        this.jLabel1.setEnabled(enabled);
        this.jLabel2.setEnabled(enabled);
        this.jLabel3.setEnabled(enabled);
    }

    public void initializeTable() {
        this.table = new PzTable();
        this.table.setFilter(new PzEntityFilter(){

            public Object[] getValues(PzEntity entity) {
                Artikalfaktura af = (Artikalfaktura)entity;
                return new Object[]{af.getKonsignacija(), af.getSifra(), String.valueOf(af.getNaziv()) + ", " + af.getBliziOpis(), af.getKolSaKons(), af.getProcRabata()};
            }

            public String[] getColumnNames() {
                return new String[]{"RJ", "\u0160ifra", "Naziv", "Koli\u010dina", "% rabata"};
            }
        });
        Query q = null;
        q = PzEntityManager.getEm().createQuery("SELECT af FROM Artikalfaktura af where af.kolSaKons > 0 and af.indp=0 and af.faktura.arhiviran = 1 and af.faktura.storno = 0");
        Vector data = (Vector)q.getResultList();
        this.table.setData(data, Artikalfaktura.class);
        this.table.setSortOrder(0, SortOrder.ASCENDING);
        this.scrpTable.setViewportView((Component)this.table);
        this.table.getTableHeader().setFocusable(false);
        this.brStavki.setText(String.valueOf(this.table.getDataSize()));
        if (this.table.getDataSize() == 0) {
            this.dispose();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void actionPerformed(ActionEvent e) {
        block15: {
            button = (AbstractButton)e.getSource();
            actionCommand = button.getActionCommand();
            em = PzEntityManager.getEm();
            try {
                if (actionCommand.equals("brisanje") && this.table.getSelectedRow() != -1) {
                    em.getTransaction().begin();
                    rez = PzSwingUtility.daNeDijalog((Component)this.panelContent, (Object)"Da li ste sigurni?", (String)"Brisanje stavke", null, (boolean)false);
                    if (rez != 0) {
                        return;
                    }
                    this.deleteRow(this.table.getSelectedRow(), em);
                    em.getTransaction().commit();
                    this.initializeTable();
                    break block15;
                }
                if (!actionCommand.equals("brisanjeSvega")) ** GOTO lbl28
                em.getTransaction().begin();
                rez = PzSwingUtility.daNeDijalog((Component)this.panelContent, (Object)"Da li ste sigurni?", (String)"Brisanje svih podataka", null, (boolean)false);
                if (rez != 0) {
                    return;
                }
                try {
                    i = 0;
                    while (i < this.table.getDataSize()) {
                        this.deleteRow(i, em);
                        ++i;
                    }
                    em.getTransaction().commit();
                    this.dispose();
                    break block15;
lbl28:
                    // 1 sources

                    if (!actionCommand.equals("ArhivaStampa")) break block15;
                    if (!this.nfKonsignacija.isEnabled()) {
                        this.setEnabledArhiva(true);
                        this.nfKonsignacija.requestFocus();
                        break block15;
                    }
                    f = this.createFaktura();
                    if (f == null) {
                        JOptionPane.showMessageDialog((Component)this, "Nema podataka za izradu prenosnice odabrane konsignacije!", "Informacija", 1);
                    } else {
                        this.getSession().putParameter("faktura", (Object)f);
                        this.showDialog(ArhivaStampa.class);
                        this.initializeTable();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PzDialogAutomatskaIzradaPrenosnice.this.nfKonsignacija.requestFocus();
                        }
                    });
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)this, (Throwable)e1);
                }
            }
            finally {
                em.close();
            }
        }
    }

    private Faktura createFaktura() {
        Faktura rez = new Faktura();
        rez.setKomitent(this.k);
        rez.setRadnajedinica(this.rj);
        rez.setArtikalfakturas(new Vector());
        EntityManager em = PzEntityManager.getEm();
        for (PzEntity entity : this.table.getAllEntities()) {
            Artikalfaktura af = (Artikalfaktura)entity;
            if (!af.getKonsignacija().equals(rez.getRadnajedinica().getId().getOznRj())) continue;
            af.setProcRabata(this.dfProcRabata.getVal().doubleValue());
            af.setKolicina(af.getKolSaKons());
            af.setKolSaKons(0.0);
            af.setKonsignacija(null);
            af.setFaktura(rez);
            af.setArtikalFakturaParameters(null);
            Stanjeartikal sa = (Stanjeartikal)em.find(Stanjeartikal.class, (Object)new StanjeartikalPK(af.getId().getSfrProizvod(), this.rj));
            af.setCena(sa.getProdCena());
            af.setProdCena(BDConverter.getProdCena((double)sa.getProdCena()));
            af.setProsNabCena(sa.getProsNabCena());
            rez.getArtikalfakturas().add(af);
        }
        if (rez.getArtikalfakturas().size() == 0) {
            return null;
        }
        rez.setTip("PRENOSNICA_SA_KONSIGNACIJE");
        rez.setPodTip("AUTOMATSKA");
        rez.setId(0);
        return rez;
    }

    private void deleteRow(int index, EntityManager em) {
        Artikalfaktura af = (Artikalfaktura)this.table.getEntity(index);
        af.setIndp((short)1);
        Radnajedinica kons = (Radnajedinica)em.find(Radnajedinica.class, (Object)new RadnajedinicaPK("1", af.getKonsignacija()));
        Stanje s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(af.getSifra(), kons));
        s.setAlocKolicina(s.getAlocKolicina() - af.getKolicina());
        em.merge((Object)s);
        em.merge((Object)af);
    }

    public boolean shouldBeShown() {
        this.mainPanel.setPaintGradient(true);
        this.mainPanel.setGradient(ProdajaGradientUtil.PRENOSNICA_GRADIENT);
        this.getSession().putParameter("gradient", (Object)ProdajaGradientUtil.PRENOSNICA_GRADIENT);
        if (this.table.getDataSize() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Nema podataka za izradu prenosnice!", "Informacija", 1);
            this.dispose();
            return false;
        }
        return true;
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.k = (Komitent)entity;
            this.sfrKomitenta.setVal((Object)this.k.getSfrKomitent());
            this.nazKomitenta.setVal((Object)this.k.getNaziv());
        } else if (entity instanceof Radnajedinica) {
            this.rj = (Radnajedinica)entity;
            if (!this.rj.getTip().equals("T") && !this.rj.getTip().equals("ET")) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Radna jedinica nije konsignacija!", "Informacija", 1);
                this.nfKonsignacija.setVal((Object)"");
                this.konsOpis.setVal((Object)"");
                return;
            }
            this.nfKonsignacija.setVal((Object)((Radnajedinica)entity).getId().getOznRj());
            this.konsOpis.setVal((Object)this.rj.getNaziv());
        }
        if (entity == null) {
            if (component.getName() != null) {
                this.nazKomitenta.setVal((Object)"");
            } else {
                this.konsOpis.setVal((Object)"");
            }
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogAutomatskaIzradaPrenosnice(Boolean.FALSE);
    }

    public PzDialogAutomatskaIzradaPrenosnice(Boolean initGUI) {
    }
}

