/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.interniprenos.gui.Trebovanje;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.Border;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Artikalnivelacija;
import rs.pezar.db.entity.Artikalopstidokument;
import rs.pezar.db.entity.Nivelacija;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.interniprenos.gui.PzDialogIzradaTrebovanja;
import rs.pezar.interniprenos.gui.PzDialogTrebovanje;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzTextAreaPanel;

public class Arhiviranje
extends PzDialog {
    private static final String SA_NIVELACIJOM = "Sa nivelacijom";
    private static final String BEZ_NIVELACIJE = "Bez nivelacije";
    private static final String NA_UKUPNU_KOLICINU = "Na ukupnu koli\u010dinu";
    private static final String NA_IZLAZNU_KOLICINU = "Na izlaznu koli\u010dinu";
    private PzPanel mainPanel;
    private PzDateField dfDatum;
    private PzRadioGroup<String> panelRbs1;
    private PzButton btnPotvrdi;
    private PzTextAreaPanel areaRazlogIzrade;
    private PzRadioGroup<String> panelRbs2;
    private JLabel lblDatum;
    private final Opstidokument trebovanje;
    private Nivelacija nivelacija = null;
    private final PzDialog parent;

    public Arhiviranje(PzDialog dialog) {
        super(dialog);
        this.initGUI();
        this.parent = (PzDialogIzradaTrebovanja)((Object)this.getParent());
        this.trebovanje = (Opstidokument)this.getSession().getParameter("trebovanje");
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Arhiviranje dokumenta");
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1, 0.0};
            mainPanelLayout.rowHeights = new int[]{20, 7, 45, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            mainPanelLayout.columnWidths = new int[]{120, 120, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.lblDatum = new JLabel();
            this.mainPanel.add((Component)this.lblDatum, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.lblDatum.setText("Datum izrade");
            this.dfDatum = new PzDateField();
            this.mainPanel.add((Component)this.dfDatum, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.panelRbs1 = new PzRadioGroup((Object[])new String[]{SA_NIVELACIJOM, BEZ_NIVELACIJE});
            BoxLayout panelRBsLayout = new BoxLayout((Container)this.panelRbs1, 1);
            this.panelRbs1.setLayout((LayoutManager)panelRBsLayout);
            this.mainPanel.add(this.panelRbs1, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 5), 0, 0));
            this.panelRbs1.setBorder((Border)BorderFactory.createTitledBorder(""));
            this.panelRbs1.setSelectedValue((Object)BEZ_NIVELACIJE);
            this.panelRbs1.setOpaque(false);
            this.panelRbs1.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getStateChange() == 1) {
                        if (evt.getValue().equals(Arhiviranje.SA_NIVELACIJOM)) {
                            Arhiviranje.this.panelRbs2.setFocusable(true);
                            Arhiviranje.this.panelRbs2.setEnabled(true);
                        } else {
                            Arhiviranje.this.panelRbs2.setFocusable(false);
                            Arhiviranje.this.panelRbs2.setEnabled(false);
                        }
                    }
                }
            });
            this.panelRbs2 = new PzRadioGroup((Object[])new String[]{NA_UKUPNU_KOLICINU, NA_IZLAZNU_KOLICINU});
            panelRBsLayout = new BoxLayout((Container)this.panelRbs2, 1);
            this.panelRbs2.setLayout((LayoutManager)panelRBsLayout);
            this.mainPanel.add(this.panelRbs2, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRbs2.setSelectedValue((Object)NA_IZLAZNU_KOLICINU);
            this.panelRbs2.setBorder((Border)BorderFactory.createTitledBorder(""));
            this.panelRbs2.setOpaque(false);
            this.panelRbs2.setFocusable(false);
            this.panelRbs2.setEnabled(false);
            this.areaRazlogIzrade = new PzTextAreaPanel();
            this.mainPanel.add((Component)this.areaRazlogIzrade, (Object)new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
            this.areaRazlogIzrade.setName("areaRazlogIzrade");
            this.areaRazlogIzrade.getArea().setBorder((Border)BorderFactory.createTitledBorder("Razlog izrade"));
            this.areaRazlogIzrade.setOpaque(false);
            this.btnPotvrdi = new PzButton();
            this.mainPanel.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 10, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(125, 36));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.btnPotvrdi.setShortcut("Ctrl+W");
            this.pack();
            this.setSize(419, 405);
            this.setResizable(false);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equalsIgnoreCase("potvrdi")) {
            EntityManager em = PzEntityManager.getEm();
            try {
                try {
                    em.getTransaction().begin();
                    this.trebovanje.setDatArh(this.dfDatum.getVal());
                    this.trebovanje.setDatum(this.dfDatum.getVal());
                    this.trebovanje.setPoruka(this.areaRazlogIzrade.getVal());
                    this.trebovanje.setIznosBezPoreza(this.trebovanje.getIznosBezPoreza(this.trebovanje.getArtikalopstidokuments()));
                    this.trebovanje.setIznosSaPorezom(this.trebovanje.getIznosSaPorezom(this.trebovanje.getArtikalopstidokuments()));
                    this.azurirajStanje(em);
                    if (((String)this.panelRbs1.getSelectedValue()).equals(SA_NIVELACIJOM)) {
                        this.nivelacija = ((String)this.panelRbs2.getSelectedValue()).equals(NA_UKUPNU_KOLICINU) ? PzEntityUtil.createNivelacija((PzDokument)this.trebovanje, (boolean)true, (boolean)true, (EntityManager)em) : PzEntityUtil.createNivelacija((PzDokument)this.trebovanje, (boolean)false, (boolean)true, (EntityManager)em);
                    }
                    PzDokumentManager.getInstance().arhivirajDokument((PzDokument)this.trebovanje, true, null, em);
                    this.arhiviraj(this.nivelacija, em);
                    em.getTransaction().commit();
                    PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)this.trebovanje);
                    if (this.nivelacija != null) {
                        PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)this.nivelacija);
                    }
                    this.parent.dispose();
                    ((PzDialogTrebovanje)((Object)this.parent.getParent())).createTable();
                    this.dispose();
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                    em.close();
                }
            }
            finally {
                em.close();
            }
        }
    }

    private void arhiviraj(Nivelacija nivel, EntityManager em) throws Exception {
        if (nivel == null) {
            return;
        }
        if (((String)this.panelRbs1.getSelectedValue()).equals(SA_NIVELACIJOM) && ((String)this.panelRbs2.getSelectedValue()).equals(NA_UKUPNU_KOLICINU)) {
            for (Artikalnivelacija arniv : nivel.getArtikalnivelacijas()) {
                StanjePK stanjePk = new StanjePK(arniv.getId().getSfrProizvod(), nivel.getRadnajedinica());
                Stanje s = (Stanje)em.find(Stanje.class, (Object)stanjePk);
                s.setProdCena(arniv.getCenaNova());
                em.merge((Object)s);
            }
        }
        PzDokumentManager.getInstance().arhivirajDokument((PzDokument)nivel, true, null, em);
    }

    private void azurirajStanje(EntityManager em) {
        for (Artikalopstidokument art : this.trebovanje.getArtikalopstidokuments()) {
            Stanje stanje = (Stanje)em.find(Stanje.class, (Object)new StanjePK(art.getSifra(), this.trebovanje.getRadnajedinica()));
            if (stanje == null) {
                stanje = new Stanje();
                stanje.setId(new StanjePK(art.getSifra(), this.trebovanje.getRadnajedinica()));
                stanje.setAlocKolicina(0.0);
                stanje.setKolicina(-art.getKolicina());
                stanje.setDatZadIzlaza(this.trebovanje.getDatum());
                stanje.setKumIzlaza(art.getKolicina());
                em.persist((Object)stanje);
                continue;
            }
            stanje.setKolicina(stanje.getKolicina() - art.getKolicina());
            stanje.setDatZadIzlaza(this.trebovanje.getDatum());
            stanje.setKumIzlaza(stanje.getKumIzlaza() + art.getKolicina());
        }
    }
}

