/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.interniprenos.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.core.PzApplication;
import rs.pezar.core.PzGenericService;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.PzTableDataSource;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzComponentGroup;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzScrollableTable;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.util.PzDateUtility;

public class PzDialogKonsignacijaPovratnicaPregled
extends PzDialog {
    private PzPanel pzPanelN;
    private JScrollPane jScrollPane;
    private JLabel jLabel3;
    private PzDoubleField vrednostIzMagacina;
    private JLabel jLabel8;
    private PzPanel pnlSouth;
    private PzPanel mainPanel;
    private PzToolBarIcon icnStampa;
    private PzToolBarIcon icnArhiva;
    private PzToolBarIcon icnUpit;
    private PzToolBarIcon icnTraziDokument;
    private PzToolBarIcon icnTraziDatum;
    private PzToolBarIcon pzPrikaziSve;
    private PzDateField krajnjiDatum;
    private PzDateField pocetniDatum;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzScrollableTable table;
    private PzPanel pzPanelC;
    private JToolBar jToolBar;
    private PzTextField brDokumenta;
    private Radnajedinica rj;
    private PzComponentGroup fieldGroup;
    private String pretraga;
    private String izvestaj;
    private PzButton bntTrazi;
    ScrollableCursor cursor = null;
    Interniracun ir = null;
    boolean pretragaPoIzlaznojRJ;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogKonsignacijaPovratnicaPregled inst = new PzDialogKonsignacijaPovratnicaPregled(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogKonsignacijaPovratnicaPregled(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogKonsignacijaPovratnicaPregled(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle("PREGLED URA\u0110ENIH POVRATNICA SA NA\u0160E KONSIGNACIJE");
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            mainPanelLayout.columnWidths = new int[]{7, 7};
            mainPanelLayout.rowHeights = new int[]{7, 7, 526, 7};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.1};
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.0};
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.pzPanelN = new PzPanel();
            this.mainPanel.add((Component)this.pzPanelN, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout pzPanelNLayout = new GridBagLayout();
            pzPanelNLayout.rowWeights = new double[]{14.0, 0.0, 14.0};
            pzPanelNLayout.rowHeights = new int[]{7, 23, 7};
            pzPanelNLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pzPanelNLayout.columnWidths = new int[]{78, 110, 20, 80, 120, 20, 80, 120, 20, 110, 20};
            this.pzPanelN.setLayout((LayoutManager)pzPanelNLayout);
            this.pzPanelN.setOpaque(false);
            this.jLabel1 = new JLabel();
            this.pzPanelN.add((Component)this.jLabel1, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel1.setText("Po\u010detni datum:");
            this.jLabel2 = new JLabel();
            this.pzPanelN.add((Component)this.jLabel2, (Object)new GridBagConstraints(6, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel2.setText("Krajnji datum:");
            this.jLabel8 = new JLabel();
            this.pzPanelN.add((Component)this.jLabel8, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.jLabel8.setText("Dokument:");
            this.fieldGroup = new PzComponentGroup();
            this.brDokumenta = new PzTextField();
            this.fieldGroup.add((Component)this.brDokumenta);
            this.pzPanelN.add((Component)this.brDokumenta, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.brDokumenta.setMaxLength(15);
            this.brDokumenta.setPreferredSize(new Dimension(47, 21));
            this.pocetniDatum = new PzDateField();
            this.fieldGroup.add((Component)this.pocetniDatum);
            this.pzPanelN.add((Component)this.pocetniDatum, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pocetniDatum.setVal((Object)PzDateUtility.getFirstDayOfCurrentYear());
            this.krajnjiDatum = new PzDateField();
            this.fieldGroup.add((Component)this.krajnjiDatum);
            this.pzPanelN.add((Component)this.krajnjiDatum, (Object)new GridBagConstraints(7, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.krajnjiDatum.setDefaultDate(new Date(new java.util.Date().getTime()));
            this.bntTrazi = new PzButton();
            this.pzPanelN.add((Component)this.bntTrazi, (Object)new GridBagConstraints(9, 0, 1, 2, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.bntTrazi.setText("Tra\u017ei");
            this.bntTrazi.setBounds(90, 6, 126, 33);
            this.bntTrazi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/find.png")));
            this.bntTrazi.addActionListener((ActionListener)((Object)this));
            this.bntTrazi.setActionCommand("trazi");
            this.jToolBar = new JToolBar();
            this.mainPanel.add((Component)this.jToolBar, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.jToolBar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            this.jToolBar.setOpaque(false);
            this.pzPrikaziSve = new PzToolBarIcon();
            this.jToolBar.add((Component)this.pzPrikaziSve);
            this.pzPrikaziSve.setText("Prika\u017ei sve|(F5)");
            this.pzPrikaziSve.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/document_refresh.png")));
            this.pzPrikaziSve.setActionCommand("prikazi_sve");
            this.pzPrikaziSve.addActionListener((ActionListener)((Object)this));
            this.pzPrikaziSve.setShortcut("f5");
            this.jSeparator1 = new JSeparator();
            this.jToolBar.add(this.jSeparator1);
            this.jSeparator1.setOrientation(1);
            this.jSeparator1.setPreferredSize(new Dimension(8, 75));
            this.icnTraziDokument = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnTraziDokument);
            this.icnTraziDokument.setText("Tra\u017ei po|dokumentu (F8)");
            this.icnTraziDokument.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/documentsearch.png")));
            this.icnTraziDokument.setActionCommand("trazidokument");
            this.icnTraziDokument.addActionListener((ActionListener)((Object)this));
            this.icnTraziDokument.setShortcut("f8");
            this.icnTraziDatum = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnTraziDatum);
            this.icnTraziDatum.setText("Tra\u017ei po|datumu (F9)");
            this.icnTraziDatum.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/date_search.png")));
            this.icnTraziDatum.setActionCommand("trazidatum");
            this.icnTraziDatum.addActionListener((ActionListener)((Object)this));
            this.icnTraziDatum.setShortcut("f9");
            this.jSeparator2 = new JSeparator();
            this.jToolBar.add(this.jSeparator2);
            this.jSeparator2.setOrientation(1);
            this.jSeparator2.setPreferredSize(new Dimension(8, 75));
            this.icnArhiva = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnArhiva);
            this.icnArhiva.setText("Slika iz|arhive (F2)");
            this.icnArhiva.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/presentation_chart.png")));
            this.icnArhiva.setActionCommand("slika");
            this.icnArhiva.addActionListener((ActionListener)((Object)this));
            this.icnArhiva.setShortcut("F2");
            this.icnUpit = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnUpit);
            this.icnUpit.setText("Upit u NZK|(F5)");
            this.icnUpit.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/nzk.png")));
            this.icnUpit.setActionCommand("nzk");
            this.icnUpit.addActionListener((ActionListener)((Object)this));
            this.icnUpit.setShortcut("F5");
            this.icnStampa = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnStampa);
            this.icnStampa.setText("Priprema za|\u0161tampu (Alt+S)");
            this.icnStampa.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/printer_view.png")));
            this.icnStampa.setActionCommand("stampa");
            this.icnStampa.addActionListener((ActionListener)((Object)this));
            this.icnStampa.setShortcut("alt+s");
            this.pzPanelC = new PzPanel();
            GridBagLayout pzPanelCLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pzPanelC, (Object)new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pzPanelC.setLayout((LayoutManager)pzPanelCLayout);
            this.pzPanelC.setBounds(1030, 0, 8, 604);
            pzPanelCLayout.rowWeights = new double[]{0.1};
            pzPanelCLayout.rowHeights = new int[]{7};
            pzPanelCLayout.columnWeights = new double[]{0.1};
            pzPanelCLayout.columnWidths = new int[]{7};
            this.pzPanelC.setOpaque(false);
            this.jScrollPane = new JScrollPane();
            this.pzPanelC.add((Component)this.jScrollPane, (Object)new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.jScrollPane.setViewportView((Component)this.table);
            this.pnlSouth = new PzPanel();
            GridBagLayout pnlSouthLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlSouth, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlSouth.setLayout((LayoutManager)pnlSouthLayout);
            this.pnlSouth.setOpaque(false);
            pnlSouthLayout.rowWeights = new double[]{0.1, 0.0, 0.1};
            pnlSouthLayout.rowHeights = new int[]{7, 25, 7};
            pnlSouthLayout.columnWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            pnlSouthLayout.columnWidths = new int[]{71, 150, 7, 7};
            this.jLabel3 = new JLabel();
            this.pnlSouth.add((Component)this.jLabel3, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.jLabel3.setText("Vrednost");
            this.jLabel3.setFont(new Font("SansSerif", 1, 12));
            this.vrednostIzMagacina = new PzDoubleField();
            this.pnlSouth.add((Component)this.vrednostIzMagacina, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.vrednostIzMagacina.setFocusable(false);
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj stavki ");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.setMinimumSize(new Dimension(1000, 700));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = ((PzButton)e.getSource()).getActionCommand();
        if (actionCommand.equals("trazi")) {
            if (this.cursor != null) {
                this.cursor.close();
            }
            EntityManager em = PzEntityManager.getEm();
            Query q = null;
            String query = "SELECT k.oznDokumenta, k.datum, k.vredNaUlazu, k.vredNaIzlazu, k.vredNaUlazu-k.vredNaIzlazu, k.vredNaUlazu, k.idDok, k.rjUlaz, k.rjIzlaz, k.usernamekraj FROM Interniracun k where k.datum>=':datumOD' AND k.datum<=':datumDO' AND k.arhiviran=:arh AND k.tip=':tipdok'";
            query = query.replace(":arh", "1").replace(":tipdok", "POVRATNICA_SA_NASE_KONS").replace(":datumOD", this.pocetniDatum.getVal().toString()).replace(":datumDO", this.krajnjiDatum.getVal().toString());
            if (this.pretragaPoIzlaznojRJ) {
                query = String.valueOf(query) + " AND k.izlaznaRj=':oznRJ' AND k.izlazniOgranak=':oznOgranak'";
                query = query.replace(":oznRJ", this.rj.getId().getOznRj()).replace(":oznOgranak", this.rj.getId().getOznOgranak());
            } else {
                query = String.valueOf(query) + " AND k.ulaznaRj=':oznRJ' AND k.ulazniOgranak=':oznOgranak'";
                query = query.replace(":oznRJ", this.rj.getId().getOznRj()).replace(":oznOgranak", this.rj.getId().getOznOgranak());
            }
            if (!this.brDokumenta.getVal().equals("")) {
                query = String.valueOf(query) + " AND k.oznDokumenta like ':oznDokumenta'";
                query = query.replace(":oznDokumenta", String.valueOf(this.brDokumenta.getVal()) + "%");
            }
            query = String.valueOf(query) + " ORDER BY k.oznDokumenta ASC";
            q = em.createNativeQuery(query);
            q.setHint("eclipselink.cursor.scrollable", (Object)"True");
            this.cursor = (ScrollableCursor)q.getSingleResult();
            this.table = new PzScrollableTable(this.cursor, this.ir.getDokColumnNames());
            this.jScrollPane.setViewportView((Component)this.table);
            em.close();
            this.table.getTableHeader().setFocusable(false);
            if (this.cursor.size() > 0) {
                this.popuniPodatke();
                this.table.setRowSelectionInterval(0, 0);
                this.table.requestFocusInWindow();
                this.table.hideColumnByName("idDok");
                this.table.hideColumnByName("rjUlaz");
                this.table.hideColumnByName("rjIzlaz");
            }
            return;
        }
        if (actionCommand.equals("slika")) {
            if (this.table.getSelectedRow() == -1) {
                return;
            }
            this.izvestaj = "slika";
            this.showReport();
            return;
        }
        if (actionCommand.equals("nzk")) {
            try {
                PzGenericService gs = PzApplication.getApplication().getGenericServiceRegistry().getService("NZK_SERVICE");
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("NZK_DOKUMENT", this.getSelectedEntity());
                params.put("NZK_PARENT_DIALOG", (Object)this);
                gs.run(params);
                return;
            }
            catch (Exception e1) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                return;
            }
        }
        if (actionCommand.equals("stampa")) {
            if (this.cursor == null || this.cursor.size() == 0) {
                return;
            }
            this.izvestaj = "stampa";
            this.showReport();
            return;
        }
    }

    public boolean shouldBeShown() {
        this.mainPanel.setPaintGradient(true);
        this.pretragaPoIzlaznojRJ = PzParameter.getParameterValue((String)"POVRATNICA_KONS_IZ_ARHIVE", (String)"ulazna").equals("izlazna");
        boolean result = false;
        this.rj = this.pretragaPoIzlaznojRJ ? PzDialogRJ.getRJ((PzDialog)this, (String[])new String[]{"K", "N"}) : PzDialogRJ.getRJ((PzDialog)this, (String[])new String[]{"V", "VR", "VS", "G"});
        if (this.rj != null) {
            result = true;
            this.setTitle("PREGLED URA\u0110ENIH POVRATNICA SA NA\u0160E KONSIGNACIJE IZ  " + this.rj.getId().getOznRj() + "(" + this.rj.getgTip() + ") " + this.rj.getNaziv());
            try {
                this.ir = new Interniracun();
                this.ir.setTip("POVRATNICA_SA_NASE_KONS");
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        }
        return result;
    }

    public void showReport() {
        try {
            if (this.izvestaj.equalsIgnoreCase("slika")) {
                Interniracun povratnica = (Interniracun)this.getSelectedEntity();
                if (povratnica == null) {
                    return;
                }
                PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)povratnica);
            } else if (this.izvestaj.equalsIgnoreCase("stampa")) {
                Vector<Object> data = new Vector<Object>();
                data.addElement(this.rj);
                data.addElement(PzFirma.getFirma());
                PzTableDataSource ds = new PzTableDataSource((PzAbstractTable)this.table, data);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("datumOd", this.pocetniDatum.getVal());
                params.put("datumDo", this.krajnjiDatum.getVal());
                params.put("datum", new Date(new java.util.Date().getTime()));
                params.put("title", "Pregled ura\u0111enih povratnica sa na\u0161e konsignacije");
                params.put("rjIzlaz", this.rj.getId().getOznRj());
                PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (String)"rs/pezar/reports/compiled/kons.nasaroba.povratnica.stampa.jasper", params, (String)"Pregled ura\u0111enih povratnica sa na\u0161e konsignacije");
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void popuniPodatke() {
        BigDecimal vredUlaza = new BigDecimal(0.0);
        int i = 0;
        while (i < this.cursor.size()) {
            BigDecimal vredMag = this.table.getValueAt(i, 2) != null ? BDConverter.getIznos((double)Double.valueOf(this.table.getValueAt(i, 2).toString())) : new BigDecimal(0.0);
            vredUlaza = vredUlaza.add(vredMag);
            ++i;
        }
        this.vrednostIzMagacina.setVal((Object)vredUlaza);
        this.brDok.setText(" " + this.cursor.size());
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogKonsignacijaPovratnicaPregled(Boolean.FALSE);
    }

    public PzDialogKonsignacijaPovratnicaPregled(Boolean initGUI) {
    }

    protected void thisWindowClosing(WindowEvent evt) {
        super.thisWindowClosing(evt);
        if (this.cursor != null) {
            this.cursor.close();
        }
    }

    private PzEntity getSelectedEntity() {
        int selectedRow = this.table.getRealSelectedRowIndex();
        if (selectedRow == -1) {
            return null;
        }
        EntityManager em = PzEntityManager.getEm();
        String ozn = this.table.getModel().getValueAt(selectedRow, 6).toString();
        System.out.println(ozn);
        Interniracun intrac = (Interniracun)em.createQuery("select k from Interniracun k where k.idDok='" + ozn + "'").getSingleResult();
        return intrac;
    }
}

