/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.interniprenos.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.eclipse.persistence.indirection.IndirectList;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikalinterniracun;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.interniprenos.gui.PzDialogDokumenti;
import rs.pezar.interniprenos.gui.interniNalog.Arhiviranje;
import rs.pezar.interniprenos.gui.interniNalog.Dodavanje;
import rs.pezar.interniprenos.gui.interniNalog.Dopuna;
import rs.pezar.reports.PzReportManager;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogInterniNalog
extends PzDialogInsert {
    private PzPanel pzPanelN;
    private JScrollPane jScrollPane;
    private PzToolBarIcon icnDopuna;
    private PzToolBarIcon icnProbnoListanje;
    private PzToolBarIcon icnArhiva;
    private PzToolBarIcon icnDodavanje;
    private PzToolBarIcon icnIzmena;
    private PzDoubleField vrednostUlaz;
    private JLabel jLabel2;
    private PzDoubleField vrednostIzlaz;
    private JLabel jLabel1;
    private PzPanel pzPanelC;
    private JToolBar jToolBar;
    private PzTable tableInterni;
    private Interniracun interninalog;
    private boolean izmena;
    private Radnajedinica izlaznaRJ;
    private PzToolBarIcon icnBrisanje;
    private Radnajedinica ulaznaRJ;
    private PzTable table;
    private Stanje stanjeIzlaz;
    private List<Artikalinterniracun> artintiracuns;
    private PzDialogDokumenti parent;
    private PzPanel mainPanel;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();

    public PzDialogInterniNalog(JFrame frame) {
        super(frame);
        this.interninalog = new Interniracun();
    }

    public PzDialogInterniNalog(PzDialog parent, boolean izmena, Object data1, Object data2) {
        super(parent);
        this.parent = (PzDialogDokumenti)parent;
        this.tableInterni = (PzTable)data1;
        this.interninalog = izmena ? (Interniracun)this.tableInterni.getSelectedEntity() : new Interniracun();
        this.izmena = izmena;
        this.initGUI();
        this.refresh();
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogInterniNalog.this.brDok.setText(String.valueOf(PzDialogInterniNalog.this.table.getRowCount()));
            }
        });
    }

    protected void initGUI() {
        try {
            if (this.izmena) {
                this.setTitle("INTERNI NALOG     Izlazna RJ: " + this.interninalog.getIzlaznaRJ().getId().getOznRj() + "(" + this.interninalog.getIzlaznaRJ().getgTip() + ") " + this.interninalog.getIzlaznaRJ().getNaziv() + "        Ulazna RJ: " + this.interninalog.getUlaznaRJ().getId().getOznRj() + "(" + this.interninalog.getUlaznaRJ().getgTip() + ") " + this.interninalog.getUlaznaRJ().getNaziv());
            }
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            mainPanelLayout.columnWidths = new int[]{7};
            mainPanelLayout.rowHeights = new int[]{97, 45, 7};
            mainPanelLayout.columnWeights = new double[]{0.1};
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 20.0};
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.pzPanelN = new PzPanel();
            this.mainPanel.add((Component)this.pzPanelN, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout pzPanelNLayout = new GridBagLayout();
            pzPanelNLayout.rowWeights = new double[]{0.0, 0.0, 0.1};
            pzPanelNLayout.rowHeights = new int[]{14, 25, 7};
            pzPanelNLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pzPanelNLayout.columnWidths = new int[]{113, 99, 20, 98, 123, 99, 324};
            this.pzPanelN.setLayout((LayoutManager)pzPanelNLayout);
            this.pzPanelN.setBounds(0, 777, 1008, 22);
            this.pzPanelN.setOpaque(false);
            this.jLabel1 = new JLabel();
            this.pzPanelN.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.jLabel1.setText("Vrednost na izlazu");
            this.vrednostIzlaz = new PzDoubleField();
            this.pzPanelN.add((Component)this.vrednostIzlaz, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.vrednostIzlaz.setEditable(false);
            this.vrednostIzlaz.setVal((Object)this.interninalog.getVredNaIzlazu());
            this.vrednostIzlaz.setFocusable(false);
            this.jLabel2 = new JLabel();
            this.pzPanelN.add((Component)this.jLabel2, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel2.setText("Vrednost na ulazu");
            this.vrednostUlaz = new PzDoubleField();
            this.pzPanelN.add((Component)this.vrednostUlaz, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.vrednostUlaz.setEditable(false);
            this.vrednostUlaz.setVal((Object)this.interninalog.getVredNaUlazu());
            this.vrednostUlaz.setFocusable(false);
            this.pzPanelC = new PzPanel();
            GridBagLayout pzPanelCLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pzPanelC, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pzPanelC.setLayout((LayoutManager)pzPanelCLayout);
            this.pzPanelC.setBounds(1030, 0, 8, 604);
            pzPanelCLayout.rowWeights = new double[]{0.1};
            pzPanelCLayout.rowHeights = new int[]{7};
            pzPanelCLayout.columnWeights = new double[]{0.1};
            pzPanelCLayout.columnWidths = new int[]{7};
            this.pzPanelC.setOpaque(false);
            this.jScrollPane = new JScrollPane();
            this.pzPanelC.add((Component)this.jScrollPane, (Object)new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            if (this.interninalog.getArtikalinterniracuns() == null) {
                this.interninalog.setArtikalinterniracuns((List)new IndirectList());
            }
            this.table = new PzTable(this.interninalog.getArtikalinterniracuns(), Artikalinterniracun.class);
            this.table.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PzDialogInterniNalog.this.icnDodavanje.doClick();
                }
            });
            this.jScrollPane.setViewportView((Component)this.table);
            this.jToolBar = new JToolBar();
            this.mainPanel.add((Component)this.jToolBar, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.jToolBar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.jToolBar.setOpaque(false);
            this.icnDodavanje = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setText("Dodavanje|stavke|(Insert)");
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/product_add.png")));
            this.icnDodavanje.setActionCommand("Dodavanje");
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setShortcut("insert");
            this.icnIzmena = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnIzmena);
            this.icnIzmena.setText("Izmena|stavke|(F3)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/product_edit.png")));
            this.icnIzmena.setActionCommand("Izmena");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("f3");
            this.icnBrisanje = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setText("Brisanje|stavke|(Delete)");
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/product_delete.png")));
            this.icnBrisanje.setActionCommand("Brisanje");
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setShortcut("delete");
            this.icnProbnoListanje = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnProbnoListanje);
            this.icnProbnoListanje.setText("Probno|listanje|(F7)");
            this.icnProbnoListanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/presentation_chart.png")));
            this.icnProbnoListanje.setActionCommand("listanje");
            this.icnProbnoListanje.addActionListener((ActionListener)((Object)this));
            this.icnProbnoListanje.setShortcut("F7");
            this.icnDopuna = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnDopuna);
            this.icnDopuna.setText("Dopuna po|prodaji|(F10)");
            this.icnDopuna.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/product_text.png")));
            this.icnDopuna.setActionCommand("Dopuna");
            this.icnDopuna.addActionListener((ActionListener)((Object)this));
            this.icnDopuna.setShortcut("F10");
            this.icnArhiva = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnArhiva);
            this.icnArhiva.setText("Arhiva|i \u0161tampa|(Ctrl+W)");
            this.icnArhiva.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/printer_preferences.png")));
            this.icnArhiva.setActionCommand("Arhiviranje");
            this.icnArhiva.addActionListener((ActionListener)((Object)this));
            this.icnArhiva.setShortcut("ctrl+w");
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj stavki");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.setSize(900, 550);
            this.setMinimumSize(new Dimension(900, 550));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent e) {
        EntityManager em = PzEntityManager.getEm();
        try {
            void var6_11;
            boolean izmena1 = false;
            PzTable data1 = null;
            Interniracun data2 = null;
            Class<Dodavanje> clazz = Dodavanje.class;
            String actionCommand = ((PzButton)e.getSource()).getActionCommand();
            if (actionCommand.equals("Brisanje")) {
                if (this.table.getSelectedEntity() == null) {
                    return;
                }
                int rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)"Da li ste sigurni?", (String)"Brisanje", null, (boolean)false);
                if (rez != 0) {
                    return;
                }
                em.getTransaction().begin();
                Artikalinterniracun artintrac = (Artikalinterniracun)this.table.getSelectedEntity();
                this.interninalog.setVredNaIzlazu(this.interninalog.getVredNaIzlazu().subtract(BDConverter.getIznos((double)(artintrac.getIzlCena() * artintrac.getKolicina()))));
                this.interninalog.setVredNaUlazu(this.interninalog.getVredNaUlazu().subtract(BDConverter.getIznos((double)(artintrac.getUlCena() * artintrac.getKolicina()))));
                Interniracun intrac = (Interniracun)em.find(Interniracun.class, (Object)this.interninalog.getIdDok());
                intrac.setVredNaIzlazu(this.interninalog.getVredNaIzlazu());
                intrac.setVredNaUlazu(this.interninalog.getVredNaUlazu());
                this.stanjeIzlaz = (Stanje)em.find(Stanje.class, (Object)new StanjePK(artintrac.getId().getSfrProizvod(), this.interninalog.getIzlaznaRJ()));
                if (PzParameter.getParameterValue((String)"INT_NAL_FORM_ALOC").equals("true")) {
                    this.stanjeIzlaz.setAlocKolicina(this.stanjeIzlaz.getAlocKolicina() - artintrac.getKolicina());
                }
                this.vrednostIzlaz.setVal((Object)this.interninalog.getVredNaIzlazu());
                this.vrednostUlaz.setVal((Object)this.interninalog.getVredNaUlazu());
                this.table.removeSelectedEntity(false, em);
                em.getTransaction().commit();
                this.table.commitRemove();
                this.refresh();
                return;
            }
            if (actionCommand.equals("Izmena")) {
                if (this.table.getSelectedRow() == -1) {
                    return;
                }
                izmena1 = true;
                actionCommand = "Dodavanje";
                Class<Dodavanje> clazz2 = Dodavanje.class;
            } else {
                if (actionCommand.equals("listanje")) {
                    if (this.table.getDataSize() == 0) {
                        return;
                    }
                    PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)this.interninalog);
                    return;
                }
                if (actionCommand.equals("Arhiviranje")) {
                    if (this.table.getRowCount() == 0) {
                        JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Nije uneta nijedna stavka na internom nalogu!", "Obave\u0161tenje", 1);
                        return;
                    }
                    Class<Arhiviranje> clazz3 = Arhiviranje.class;
                } else if (actionCommand.equals("Dopuna")) {
                    if (!this.interninalog.getIzlaznaRJ().getgTip().equals("V")) {
                        JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Izlazna RJ nije velikoprodaja. Dopuna nije mogu\u0107a!", "Obave\u0161tenje", 1);
                        return;
                    }
                    Class<Dopuna> clazz4 = Dopuna.class;
                }
            }
            data1 = this.table;
            data2 = this.interninalog;
            this.showDialog((Class)var6_11, izmena1, data1, data2);
            this.refresh();
            this.vrednostIzlaz.setVal((Object)this.interninalog.getVredNaIzlazu());
            this.vrednostUlaz.setVal((Object)this.interninalog.getVredNaUlazu());
            return;
        }
        catch (Exception e1) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            return;
        }
        finally {
            em.close();
        }
    }

    protected void onInsert() {
    }

    protected void onUpdate() {
    }

    public boolean shouldBeShown() {
        if (this.izmena) {
            return true;
        }
        boolean result = false;
        this.izlaznaRJ = PzDialogRJ.getRJ((PzDialog)this, (String[])new String[]{"V", "VR", "VS", "T", "G"}, (String)"Izbor izlazne radne jedinice");
        if (this.izlaznaRJ == null) {
            return false;
        }
        this.ulaznaRJ = PzDialogRJ.getRJ((PzDialog)this, (String[])new String[]{"EL", "EV", "ET", "ELK", "EP", "EW", "ELR"}, (String)"Izbor ulazne radne jedinice");
        if (this.ulaznaRJ != null) {
            if (this.izlaznaRJ.getgTip().equals("V") && (this.ulaznaRJ.getpTip().equals("P") || this.ulaznaRJ.getpTip().equals("W") || this.ulaznaRJ.getpTip().equals("T"))) {
                JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Prodavnica ulaza nije prodavnica TRGOVA\u010cKE ROBE!", "Obave\u0161tenje", 1);
                return false;
            }
            if (this.izlaznaRJ.getgTip().equals("T") && !this.ulaznaRJ.getpTip().equals("T")) {
                JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Prodavnica ulaza nije KONSIGNACIONA prodavnica!", "Obave\u0161tenje", 1);
                return false;
            }
            result = true;
            this.setTitle("INTERNI NALOG     Izlazna RJ: " + this.izlaznaRJ.getId().getOznRj() + "(" + this.izlaznaRJ.getgTip() + ") " + this.izlaznaRJ.getNaziv() + "        Ulazna RJ: " + this.ulaznaRJ.getId().getOznRj() + "(" + this.ulaznaRJ.getgTip() + ") " + this.ulaznaRJ.getNaziv());
            EntityManager em = PzEntityManager.getEm();
            try {
                try {
                    if (this.interninalog == null) {
                        this.interninalog = new Interniracun();
                    }
                    this.interninalog.setStorno(0);
                    this.interninalog.setArhiviran((short)0);
                    this.interninalog.setTip("INTERNI_NALOG");
                    em.getTransaction().begin();
                    this.interninalog.setIzlaznaRJ(this.izlaznaRJ);
                    this.interninalog.setUlaznaRJ(this.ulaznaRJ);
                    this.interninalog.setDatum(new Date(new java.util.Date().getTime()));
                    this.interninalog.setProknjizen((short)0);
                    this.interninalog.setProcRabata(0.0);
                    this.interninalog.setVredNaIzlazu(new BigDecimal("0.00"));
                    this.interninalog.setVredNaUlazu(new BigDecimal("0.00"));
                    this.interninalog.setPdvIznos(new BigDecimal("0.00"));
                    this.interninalog.setRjIzlaz(this.izlaznaRJ.getPunNaziv());
                    this.interninalog.setRjUlaz(this.ulaznaRJ.getPunNaziv());
                    PzDokumentManager.getInstance().snimiDokument((PzDokument)this.interninalog, true, null, em);
                    em.getTransaction().commit();
                    this.tableInterni.insert((PzEntity)this.interninalog, false);
                }
                catch (Exception e) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                    em.close();
                }
            }
            finally {
                em.close();
            }
        }
        return result;
    }

    public void setEntity(PzEntity entity, Component component) {
    }

    protected void setHeaderOnInsert() {
    }

    protected void setHeaderOnUpdate() {
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogInterniNalog(Boolean.FALSE);
    }

    public PzDialogInterniNalog(Boolean initGUI) {
    }

    public void finish() {
        this.parent.finish();
        this.dispose();
    }
}

