/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.kontniPlan;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Aop;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.event.PzEntityChecker;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;

public class DodavanjeAOP
extends PzDialogInsert {
    private static final long serialVersionUID = -3362895422040638148L;
    private PzPanel panel;
    private PzFieldIndikator indNaziv;
    private PzFieldIndikator indOznaka;
    private ButtonGroup buttonGroupAnalitika;
    private PzNumericOnlyTextField oznaka;
    private PzTextField naziv;
    private PzButton btnOK;
    private JPanel pnlButtons;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private boolean izmena;
    private Pattern patern = Pattern.compile("([-]?[0-9]{1,6})([,][-]?[0-9]{1,6})*");

    public DodavanjeAOP(PzDialog dialog) {
        super(dialog);
        this.izmena = (Boolean)this.getSession().getParameter("izmena");
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        if (this.izmena) {
            this.setHeaderTitle("Izmena AOP-a");
            this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/row_edit.png")));
            this.btnOK.setActionCommand("update");
            this.oznaka.setEnabled(false);
            Aop aop = (Aop)((PzTable)this.getSession().getParameter("tabela")).getSelectedEntity();
            this.oznaka.setVal((Object)aop.getOznaka());
            this.naziv.setVal((Object)aop.getIzraz());
            this.panel.updateAllFieldsState();
            this.setTitle("Izmena AOP-a");
        } else {
            this.setTitle("Dodavanje AOP-a");
            this.setHeaderTitle("Dodavanje AOP-a");
            this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/row_new.png")));
            this.btnOK.setActionCommand("insert");
        }
    }

    protected void initGUI() {
        try {
            this.setResizable(false);
            this.panel = new PzPanel();
            this.panel.setTransferFocusOnEnter(true);
            GridBagLayout panelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.panel, "Center");
            this.panel.setPreferredSize(new Dimension(498, 184));
            panelLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
            panelLayout.rowHeights = new int[]{25, 9, 9};
            panelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0};
            panelLayout.columnWidths = new int[]{100, 72, 44, 49, 20, 90, 33, 21};
            this.panel.setLayout((LayoutManager)panelLayout);
            this.jLabel1 = new JLabel();
            this.panel.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel1.setText("Oznaka AOP-a");
            this.jLabel2 = new JLabel();
            this.panel.add((Component)this.jLabel2, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel2.setText("Grupa ra\u010duna");
            this.oznaka = new PzNumericOnlyTextField();
            this.panel.add((Component)this.oznaka, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.oznaka.setFont(new Font("Tahoma", 0, 14));
            this.oznaka.setMaxLength(3);
            this.oznaka.setSize(80, 24);
            this.oznaka.setPKField(Aop.class, null);
            this.oznaka.setEntityChecker(new PzEntityChecker(){

                public PzEntity getEntity() {
                    try {
                        return PzEntityManager.find(Aop.class, (Object)PzEntityUtil.strZero((String)DodavanjeAOP.this.oznaka.getVal(), (int)3));
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)DodavanjeAOP.this.oznaka, (Throwable)e);
                        return null;
                    }
                }
            });
            this.oznaka.setParseInput(false);
            this.naziv = new PzTextField();
            this.panel.add((Component)this.naziv, (Object)new GridBagConstraints(1, 2, 5, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.naziv.setFont(new Font("Tahoma", 0, 14));
            this.naziv.setSize(80, 24);
            this.naziv.setCustomInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    Matcher matcher = DodavanjeAOP.this.patern.matcher(DodavanjeAOP.this.naziv.getVal());
                    return matcher.matches();
                }
            });
            this.naziv.setVerifyInput(true);
            this.indOznaka = new PzFieldIndikator();
            this.panel.add((Component)this.indOznaka, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.indNaziv = new PzFieldIndikator();
            this.panel.add((Component)this.indNaziv, (Object)new GridBagConstraints(6, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.pnlButtons = new JPanel();
            this.getContentPane().add((Component)this.pnlButtons, "South");
            this.pnlButtons.setPreferredSize(new Dimension(494, 55));
            this.btnOK = new PzButton();
            this.pnlButtons.add((Component)this.btnOK);
            this.btnOK.setText("Potvrdi");
            this.btnOK.setBounds(91, 12, 133, 30);
            this.btnOK.setFont(new Font("Tahoma", 1, 12));
            this.btnOK.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/check.png")));
            this.btnOK.setPreferredSize(new Dimension(140, 31));
            this.btnOK.addActionListener((ActionListener)((Object)this));
            this.oznaka.setStateIndikator(this.indOznaka);
            this.naziv.setStateIndikator(this.indNaziv);
            this.setSize(612, 185);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.panel.validateForm(true)) {
            return;
        }
        String actionCommand = e.getActionCommand();
        if (actionCommand.equalsIgnoreCase("odustajanje")) {
            this.dispose();
        } else if (actionCommand.equals("insert")) {
            Aop aop = new Aop(PzEntityUtil.strZero((String)this.oznaka.getVal(), (int)3), this.naziv.getVal());
            ((PzTable)this.getSession().getParameter("tabela")).insert((PzEntity)aop, true);
        } else if (actionCommand.equals("update")) {
            Aop aop = (Aop)((PzTable)this.getSession().getParameter("tabela")).getSelectedEntity();
            aop.setIzraz(this.naziv.getVal());
            ((PzTable)this.getSession().getParameter("tabela")).updateSelectedEntity((PzEntity)aop, true);
        }
        this.dispose();
    }

    public static Object getGUIBuilderInstance() {
        return new DodavanjeAOP(Boolean.FALSE);
    }

    public DodavanjeAOP(Boolean initGUI) {
    }

    protected void onInsert() {
    }

    protected void onUpdate() {
    }

    public void setEntity(PzEntity entity, Component component) {
    }

    protected void setHeaderOnInsert() {
        this.setHeaderTitle("Dodavanje AOP-a");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/row_new.png")));
    }

    protected void setHeaderOnUpdate() {
        this.setHeaderTitle("Izmena AOP-a");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/row_edit.png")));
    }
}

