/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.artikli.browser.component;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.sifarnici.gui.PzArtikliBrowser;
import rs.pezar.sifarnici.gui.artikli.browser.component.BrowserComponent;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.RabatnaPolitikaManager;

public class BrowserInfoPanel
extends BrowserComponent {
    private static final long serialVersionUID = -5578554735143826807L;
    public static final String ID = "INFO_PANEL";
    private JScrollPane scp;
    private JTable table;
    private DefaultTableModel tableModel;
    private DecimalFormat pf;
    private DecimalFormat nf;
    private DecimalFormat mf;
    private DecimalFormat rf;
    private DecimalFormat pdvf;
    private DecimalFormat def;
    private SimpleDateFormat df;
    private DecimalFormat kf;
    private DecimalFormat prncf;

    public BrowserInfoPanel() {
        this.initGUI();
        this.setComponentLocation(new BrowserComponent.Location(1, 2, 1, 1));
        this.pf = PzFormatFactory.getProdCenaFormat();
        this.nf = PzFormatFactory.getNabCenaFormat();
        this.mf = PzFormatFactory.getProcMarzeFormat();
        this.rf = PzFormatFactory.getProcRabataFormat();
        this.pdvf = PzFormatFactory.getStopaPDVFormat();
        this.def = PzFormatFactory.getDefaultDecimalFormat();
        this.df = PzFormatFactory.getDateFormat();
        this.kf = PzFormatFactory.getKolicinaFormat();
        this.prncf = PzFormatFactory.getPrncFormat();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout(0, 0));
        this.scp = new JScrollPane();
        this.add(this.scp, "Center");
        this.table = new JTable();
        this.tableModel = new DefaultTableModel();
        this.table.setModel(this.tableModel);
        this.scp.setViewportView(this.table);
        this.table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = -1826950648219026579L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value != null && value.toString().startsWith("~")) {
                    DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
                    renderer.setText(value.toString().replace("~", ""));
                    renderer.setFont(new Font("SansSerif", 1, 12));
                    renderer.setBackground(Color.BLUE);
                    renderer.setForeground(Color.YELLOW);
                    return renderer;
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
    }

    @Override
    public void updateData(Stanjeartikal sa, Object parentComponent) {
        try {
            if (sa == null) {
                return;
            }
            double marza = sa.getZadNabCena() != 0.0 && sa.getProdCena() != 0.0 ? 100.0 * (sa.getProdCena() - sa.getZadNabCena()) / sa.getZadNabCena() : 0.0;
            Tarifnagrupa tg = (Tarifnagrupa)PzEntityManager.getList((String)("SELECT t FROM Artikal a join a.tarifnagrupas t WHERE t.vrstatg.oznVrstaTG='PDV' AND a.sfrProizvod='" + sa.getId().getSfrProizvod() + "'")).get(0);
            Object[][] info = new Object[][]{{"~ INFO ~", "~"}, {"Robna grupa", "[" + sa.getOznRobGr() + "] " + sa.getNazivRobGr()}, {"Stopa PDV-a", String.valueOf(this.pdvf.format(tg.getStopa())) + " % [" + tg.getOznTarGr() + "]"}, {"Dobavlja\u010d", sa.getSfrDobavljac() != null ? "[" + sa.getSfrDobavljac() + "] " + sa.getNazivDobavljac() : ""}, {"Proizvodja\u010d", sa.getSfrProizvodjac() != null ? "[" + sa.getSfrProizvodjac() + "] " + sa.getNazivProizvodjac() : ""}, {"~ CENE ~", "~"}, {"Cena sa rabatom", this.pf.format(sa.getProdCena() * (1.0 - sa.getRabat().doubleValue()))}, {"Prodajna", this.pf.format(sa.getProdCena())}, {"Prodajna sa PDV-om", !sa.getTipRj().startsWith("E") ? this.pf.format((100.0 + tg.getStopa()) * sa.getProdCena() / 100.0) : this.pf.format(sa.getProdCena())}, {"Prose\u010dna nabavna", sa.getProsNabCena() != null ? this.prncf.format(sa.getProsNabCena()) : ""}, {"Poslednja nabavna", this.nf.format(sa.getZadNabCena())}, {"Cena u poenima", this.pf.format(sa.getCenaPoeni())}, {"Mar\u017ea (posl. nabavka)", this.mf.format(marza)}, {"~ KUMULATIVI ~", "~"}, {"Kumulativ ulaza", this.kf.format(sa.getKumUlaza())}, {"Dat. posl. ulaza", sa.getDatZadUlaza() != null ? this.df.format(sa.getDatZadUlaza()) : ""}, {"Kumulativ izlaza", this.kf.format(sa.getKumIzlaza())}, {"Dat. posl. izlaza", sa.getDatZadIzlaza() != null ? this.df.format(sa.getDatZadIzlaza()) : ""}, {"~ LOKACIJE ~", "~"}, {"Stala\u017ea", sa.getStalaza()}, {"Nivo", sa.getNivo()}, {"Paleta", sa.getPaleta()}, {"~ DIMENZIJE ~", "~"}, {"Te\u017eina", this.def.format(sa.getTezina())}, {"Du\u017eina", this.def.format(sa.getDuzina())}, {"\u0160irina", this.def.format(sa.getSirina())}, {"Visina", this.def.format(sa.getVisina())}, {"Fi", this.def.format(sa.getFi())}, {"~ STOKOVI ~", "~"}, {"Stok minimuma", this.kf.format(sa.getStokMin())}, {"Stok maksimuma", this.kf.format(sa.getStokMax())}};
            Object[] kolone = new String[]{"Obele\u017eje", "Vrednost"};
            this.tableModel.setDataVector(info, kolone);
        }
        catch (Exception e) {
            if (e instanceof RabatnaPolitikaManager.RabatnaPolitikaException) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)e.getMessage());
            }
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    @Override
    public void updateData(Artikal sa, Object parentComponent) {
        if (sa == null) {
            return;
        }
        Object[][] objectArray = new Object[12][];
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "DIMENZIJE";
        objectArray[0] = objectArray2;
        objectArray[1] = new Object[]{"Te\u017eina", sa.getTezina()};
        objectArray[2] = new Object[]{"Du\u017eina", sa.getDuzina()};
        objectArray[3] = new Object[]{"\u0160irina", sa.getSirina()};
        objectArray[4] = new Object[]{"Visina", sa.getVisina()};
        objectArray[5] = new Object[]{"Fi", sa.getFi()};
        Object[] objectArray3 = new Object[2];
        objectArray3[0] = "OP\u0160TE";
        objectArray[6] = objectArray3;
        objectArray[7] = new Object[]{"Robna grupa", "[" + sa.getRobnagrupa().getOznRobGr() + "] " + sa.getRobnagrupa().getNaziv()};
        objectArray[8] = new Object[]{"Dobavlja\u010d", "[" + sa.getDobavljac().getSfrKomitent() + "] " + sa.getDobavljac().getNaziv()};
        objectArray[9] = new Object[]{"Proizvodja\u010d", "[" + sa.getProizvodjac().getSfrKomitent() + "] " + sa.getProizvodjac().getNaziv()};
        Object[] objectArray4 = new Object[2];
        objectArray4[0] = "Tarifna grupa";
        objectArray[10] = objectArray4;
        objectArray[11] = new Object[]{"PDV", String.valueOf(sa.getTarifnaGrupa("PDV").getOznTarGr()) + " (" + sa.getTarifnaGrupa("PDV").getStopa() + "%)"};
        Object[][] info = objectArray;
        Object[] kolone = new String[]{"Obele\u017eje", "Vrednost"};
        this.tableModel.setDataVector(info, kolone);
    }

    @Override
    public void focusGained() {
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getTitle() {
        return "Informacije";
    }

    @Override
    public boolean isCloseable() {
        return true;
    }

    @Override
    public PzToolBarIcon getSwitchIcon() {
        PzToolBarIcon icnInfo = new PzToolBarIcon();
        icnInfo.addActionListener(this.createSwitchActionListener());
        icnInfo.setActionCommand("info");
        icnInfo.setShortcut("alt+f7");
        icnInfo.setText("Dodatne|informacije|(ALT+F7)");
        icnInfo.setIcon((Icon)new ImageIcon(PzArtikliBrowser.class.getResource("/rs/pezar/sifarnici/resource/img/product_info.png")));
        return icnInfo;
    }
}

