/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.artikli;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.eclipse.persistence.queries.FetchGroup;
import org.jdesktop.swingx.JXStatusBar;
import org.jdesktop.swingx.JXTitledPanel;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikaldokument;
import rs.pezar.db.entity.Artikalkalkulacija;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Lokacija;
import rs.pezar.db.entity.LokacijaPK;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.reports.PzReportManager;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.sifarnici.gui.artikli.upit.PzTableDokumentCellRenderer;
import rs.pezar.sifarnici.gui.artikli.upit.SettingsTipDokumenata;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzGradient;

public class Upit
extends PzDialog {
    private static final long serialVersionUID = -6535630147293965878L;
    private JPanel pnlContent;
    private PzPanel panelMain;
    private JXStatusBar statusBar;
    private JXTitledPanel pnlStanje;
    private PzPanel pnlIzvod;
    private PzTable tableIzvodIzNabavke;
    private PzTable tblStanjeInfo;
    private JScrollPane scrStanje;
    private JScrollPane scrIzvodIzNabavke;
    private PzTable tabelaIzvodIzProdaje;
    private JScrollPane scrIzvodIzProdaje;
    private JXTitledPanel panelIzvodIzProdaje;
    private JXTitledPanel panelIzvodIzNabavke;
    private PzPanelHeader header;
    private PzTable tblStanje;
    private JScrollPane jScrollPane1;
    private Artikal artikal;
    private EntityManager em;
    private JLabel lblStatus;
    private JLabel lblStatText;
    private boolean prviPut;

    public Upit(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public Upit(PzDialog dialog, boolean izmena, Object data1, Object data2) {
        super(dialog);
        this.artikal = data2 instanceof Artikal ? (Artikal)data2 : (Artikal)((PzTable)data1).getSelectedEntity();
        this.initGUI();
        this.paintPanel();
        this.prviPut = true;
        try {
            this.tblStanje.setData(this.getStanja(this.artikal), Stanje.class);
            this.jScrollPane1.setViewportView((Component)this.tblStanje);
            if (this.artikal != null) {
                this.header.setText("Artikal: [ " + this.artikal.getSfrProizvod() + " ]  " + this.artikal.getNaziv());
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private List<Stanje> getStanja(Artikal artikal2) {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        Query q = em.createQuery("SELECT s FROM Stanje s JOIN FETCH s.radnajedinica WHERE s.artikal.sfrProizvod='" + this.artikal.getSfrProizvod() + "' ORDER BY s.radnajedinica.grupaMagacina");
        List stanja = q.getResultList();
        em.close();
        return stanja;
    }

    public static void upit(PzDialog parent, Artikal artikal) {
        Upit dialog = new Upit(parent, false, null, artikal);
        if (dialog.isRestorable()) {
            dialog.restoreSize();
        }
        dialog.setLocationRelativeTo((Component)parent);
        dialog.setModal(true);
        dialog.setVisible(true);
    }

    public static void upit(PzDialog parent, Stanjeartikal stanjeArtikal) throws Exception {
        Artikal a = (Artikal)PzEntityManager.find(Artikal.class, (Object)stanjeArtikal.getId().getSfrProizvod());
        if (a == null) {
            return;
        }
        Upit dialog = new Upit(parent, false, null, a);
        if (dialog.isRestorable()) {
            dialog.restoreSize();
        }
        dialog.setLocationRelativeTo((Component)parent);
        dialog.setModal(true);
        dialog.setVisible(true);
    }

    private void paintPanel() {
        this.panelMain.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.panelMain.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.panelMain.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
        this.panelMain.setGradient(PzGradient.DEFAULT_GRADIENT);
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Upit u stanje artikla");
            this.panelMain = new PzPanel();
            BorderLayout jPanel1Layout = new BorderLayout();
            jPanel1Layout.setHgap(5);
            jPanel1Layout.setVgap(5);
            this.panelMain.setLayout((LayoutManager)jPanel1Layout);
            this.getContentPane().add((Component)this.panelMain, "Center");
            this.statusBar = new JXStatusBar();
            this.statusBar.setOpaque(false);
            this.panelMain.add((Component)this.statusBar, (Object)"South");
            this.lblStatus = new JLabel("Ukupno radnih jedinica: ");
            this.statusBar.add((Component)this.lblStatus);
            this.lblStatText = new JLabel();
            this.statusBar.add((Component)this.lblStatText);
            this.pnlContent = new JPanel();
            GridBagLayout panelLayout = new GridBagLayout();
            this.panelMain.add((Component)this.pnlContent, (Object)"Center");
            this.pnlContent.setOpaque(false);
            panelLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.0};
            panelLayout.columnWeights = new double[]{0.1};
            int[] nArray = new int[2];
            nArray[1] = 233;
            panelLayout.rowHeights = nArray;
            this.pnlContent.setLayout(panelLayout);
            this.pnlContent.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
            this.pnlStanje = new JXTitledPanel("Stanje artikla po radnoj jedinici");
            GridBagLayout pnlStanjeLayout = new GridBagLayout();
            this.pnlContent.add((Component)this.pnlStanje, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlStanjeLayout.rowWeights = new double[]{0.1};
            pnlStanjeLayout.rowHeights = new int[]{7};
            pnlStanjeLayout.columnWeights = new double[]{0.0, 0.1};
            pnlStanjeLayout.columnWidths = new int[]{714, 7};
            this.pnlStanje.getContentContainer().setLayout(pnlStanjeLayout);
            this.jScrollPane1 = new JScrollPane();
            this.pnlStanje.getContentContainer().add((Component)this.jScrollPane1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tblStanje = new PzTable();
            this.tblStanje.setId("TABLE_STANJE");
            this.tblStanje.getSelectionModel().addListSelectionListener(this.createSelectionListener());
            this.scrStanje = new JScrollPane();
            this.pnlStanje.getContentContainer().add((Component)this.scrStanje, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tblStanjeInfo = new PzTable();
            this.tblStanjeInfo.setId("TABLE_STANJE_INFO");
            this.scrStanje.setViewportView((Component)this.tblStanjeInfo);
            this.pnlIzvod = new PzPanel();
            this.pnlIzvod.setOpaque(false);
            GridBagLayout pnlIzvodLayout = new GridBagLayout();
            this.pnlContent.add((Component)this.pnlIzvod, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlIzvodLayout.rowWeights = new double[]{0.1};
            pnlIzvodLayout.rowHeights = new int[]{7};
            pnlIzvodLayout.columnWeights = new double[]{0.1, 0.1};
            pnlIzvodLayout.columnWidths = new int[]{7, 7};
            this.pnlIzvod.setLayout((LayoutManager)pnlIzvodLayout);
            this.panelIzvodIzProdaje = new JXTitledPanel("Izvod iz prodaje");
            this.pnlIzvod.add((Component)this.panelIzvodIzProdaje, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            BorderLayout panelIzvodIzProdajeLayout = new BorderLayout();
            this.panelIzvodIzProdaje.getContentContainer().setLayout(panelIzvodIzProdajeLayout);
            this.scrIzvodIzProdaje = new JScrollPane();
            this.panelIzvodIzProdaje.getContentContainer().add((Component)this.scrIzvodIzProdaje, "Center");
            this.tabelaIzvodIzProdaje = new PzTable();
            this.tabelaIzvodIzProdaje.setDefaultRenderer(Object.class, (TableCellRenderer)((Object)new PzTableDokumentCellRenderer()));
            this.tabelaIzvodIzProdaje.setId("TABLE_PRODAJA");
            this.tabelaIzvodIzProdaje.getInputMap(1).put(KeyStroke.getKeyStroke(113, 0, false), "F2");
            this.tabelaIzvodIzProdaje.getActionMap().put("F2", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Upit.this.showReportAction(Upit.this.tabelaIzvodIzProdaje);
                }
            });
            this.panelIzvodIzNabavke = new JXTitledPanel("Izvod iz nabavke");
            this.pnlIzvod.add((Component)this.panelIzvodIzNabavke, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            BorderLayout panelIzvodIzNabavkeLayout = new BorderLayout();
            this.panelIzvodIzNabavke.getContentContainer().setLayout(panelIzvodIzNabavkeLayout);
            this.scrIzvodIzNabavke = new JScrollPane();
            this.panelIzvodIzNabavke.getContentContainer().add((Component)this.scrIzvodIzNabavke, "Center");
            this.tableIzvodIzNabavke = new PzTable();
            this.tableIzvodIzNabavke.setDefaultRenderer(Object.class, (TableCellRenderer)((Object)new PzTableDokumentCellRenderer()));
            this.tableIzvodIzNabavke.setId("TABLE_NABAVKA");
            this.tableIzvodIzNabavke.getInputMap(1).put(KeyStroke.getKeyStroke(113, 0, false), "F2");
            this.tableIzvodIzNabavke.getActionMap().put("F2", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Upit.this.showReportAction(Upit.this.tableIzvodIzNabavke);
                }
            });
            this.header = new PzPanelHeader();
            this.header.setOpaque(false);
            this.panelMain.add((Component)this.header, (Object)"North");
            this.header.setTitle("Upit u stanje artikla");
            this.header.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/product_view.png")));
            this.setSize(1000, 700);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ListSelectionListener createSelectionListener() {
        return new ListSelectionListener(){
            private DefaultTableModel model;

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                Stanje s = (Stanje)Upit.this.tblStanje.getSelectedEntity();
                if (s == null) {
                    return;
                }
                boolean found = false;
                Iterator<Radnajedinica> iterator = PzDialogRJ.getAvaliableRj().iterator();
                while (iterator.hasNext() && !found) {
                    Radnajedinica rj1 = iterator.next();
                    if (!rj1.getId().equals((Object)s.getRadnajedinica().getId())) continue;
                    found = true;
                }
                if (!found) {
                    return;
                }
                Lokacija l = (Lokacija)PzEntityManager.findEntity(Lokacija.class, (Object)new LokacijaPK(s.getArtikal(), s.getRadnajedinica()));
                Object[][] info = new Object[][]{{"Radna jedinica:", s.getRadnajedinica().getPunNaziv()}, {"Zad. nabavna", s.getZadNabCena()}, {"Pros. nabavna", s.getProsNabCena()}, {"Po\u010d. stanje", s.getKolPop()}, {"Cena na P.S.", s.getCenaNaPS()}, {"Dat. posl. ul.", s.getDatZadUlaza()}, {"Dat. posl. izl.", s.getDatZadIzlaza()}, {"Stala\u017ea", l != null ? l.getStalaza() : "00"}, {"Nivo", l != null ? l.getNivo() : "00"}, {"Paleta", l != null ? l.getPaleta() : "00"}};
                this.model = new DefaultTableModel();
                this.model.setDataVector(info, new String[]{"Obele\u017eje", "Vrednost"});
                Upit.this.tblStanjeInfo.setModel((TableModel)this.model);
                try {
                    Upit.this.setIzvodTableParameter(s.getRadnajedinica());
                }
                catch (Exception e) {
                    PzMysqlExceptionHandler.handle((Component)((Object)Upit.this), (Throwable)e);
                }
                Upit.this.lblStatText.setText(String.valueOf(Upit.this.tblStanje.getRowCount()));
            }
        };
    }

    protected void showReportAction(PzTable table) {
        PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)((PzArtikalDokument)table.getSelectedEntity()).getDokument());
    }

    public PzTable getTable() {
        return this.tblStanje;
    }

    public void actionPerformed(ActionEvent e) {
        Object data1 = null;
        Object data2 = null;
        boolean prodaja = false;
        PzButton icon = (PzButton)e.getSource();
        String actionCommand = icon.getActionCommand();
        if (actionCommand.equalsIgnoreCase("odustajanje")) {
            this.dispose();
            return;
        }
        if (actionCommand.equalsIgnoreCase("IzvodProdaja")) {
            actionCommand = "Izvod";
            prodaja = true;
        } else if (actionCommand.equalsIgnoreCase("IzvodNabavka")) {
            actionCommand = "Izvod";
            prodaja = false;
        }
        this.showDialog("upit." + actionCommand, prodaja, data1, data2);
    }

    private void setIzvodTableParameter(Radnajedinica rj) throws Exception {
        Boolean prometPoRj = PzParameter.getBoolean((String)"UPIT_PROMET_PO_RJ", (boolean)true);
        String rjQuery = "";
        if (prometPoRj.booleanValue()) {
            boolean found = false;
            Iterator<Radnajedinica> iterator = PzDialogRJ.getAvaliableRj().iterator();
            while (iterator.hasNext() && !found) {
                Radnajedinica rj1 = iterator.next();
                if (!rj1.getId().equals((Object)rj.getId())) continue;
                found = true;
            }
            if (!found) {
                return;
            }
            rjQuery = " %dok%.radnajedinica = :rj";
        } else {
            if (!this.prviPut) {
                return;
            }
            rjQuery = " %dok%.radnajedinica.id.oznRj in (" + PzDialogRJ.getAvaliableRjString() + ")";
        }
        ArrayList<String> listaUlaznih = new ArrayList<String>(Arrays.asList(SettingsTipDokumenata.ulazniTipDokumenta));
        ArrayList<String> listaIzlaznih = new ArrayList<String>(Arrays.asList(SettingsTipDokumenata.izlazniTipDokumenata));
        String query = "SELECT ad FROM Artikaldokument ad JOIN FETCH ad.dokument WHERE ad.id.sfrProizvod=:sifra AND ad.dokument.tip IN :listaParameter AND ad.dokument.arhiviran=1 AND " + rjQuery.replace("%dok%", "ad.dokument");
        String queriUlazni = "SELECT ad FROM Artikalkalkulacija ad JOIN FETCH ad.kalkulacija  WHERE ad.id.sfrProizvod=:sifra AND ad.kalkulacija.tip IN :listaParameter AND ad.kalkulacija.arhiviran=1 and " + rjQuery.replace("%dok%", "ad.kalkulacija");
        this.em = PzEntityManager.getEm();
        Query qIzvodIzNabavke = this.em.createQuery(queriUlazni).setParameter("sifra", (Object)this.artikal.getSfrProizvod());
        Query qIzvodIzPodaje = this.em.createQuery(query).setParameter("sifra", (Object)this.artikal.getSfrProizvod());
        qIzvodIzNabavke.setParameter("listaParameter", listaUlaznih);
        if (prometPoRj.booleanValue()) {
            qIzvodIzNabavke.setParameter("rj", (Object)rj);
        }
        qIzvodIzPodaje.setParameter("listaParameter", listaIzlaznih);
        if (prometPoRj.booleanValue()) {
            qIzvodIzPodaje.setParameter("rj", (Object)rj);
        }
        qIzvodIzPodaje.setHint("eclipselink.fetch-group", (Object)this.getGrpIzlaz());
        if (this.prviPut) {
            this.tableIzvodIzNabavke.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    return ((Artikalkalkulacija)entity).getIzvodValues();
                }

                public String[] getColumnNames() {
                    return new String[]{"Datum", "RJ", "Dokument", "Koli\u010dina", "<html>Fakturna <br/> cena</html>", "% rabata", "<html>Nabavna <br/> cena</html>", "Dobavlja\u010d", "Naziv"};
                }
            });
        }
        List adlist = qIzvodIzNabavke.getResultList();
        this.tableIzvodIzNabavke.setData(adlist, Artikalkalkulacija.class);
        if (this.prviPut) {
            this.tabelaIzvodIzProdaje.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Artikaldokument ad = (Artikaldokument)entity;
                    Dokument d = ad.getDokument();
                    String sfrKomitent = d.getKomitent() != null ? d.getKomitent().getSfrKomitent() : "";
                    String nazivKomitent = d.getKomitent() != null ? d.getKomitent().getNaziv() : "";
                    String oznRj = d.getRadnajedinica().getNaziv();
                    String oznDokumenta = d.getOznDokumenta();
                    Date datum = d.getDatum();
                    return new Object[]{datum, oznRj, oznDokumenta, ad.getKolicina(), ad.getCena(), ad.getProcRabata(), ad.getCena() * (1.0 - ad.getProcRabata() / 100.0), sfrKomitent, nazivKomitent};
                }

                public String[] getColumnNames() {
                    return new String[]{"Datum", "RJ", "Dokument", "Koli\u010dina", "<html>Fakturna <br/> cena</html>", "% rabata", "<html>Neto prod. <br/> cena</html>", "Komitent", "Naziv"};
                }
            });
        }
        adlist = qIzvodIzPodaje.getResultList();
        this.tabelaIzvodIzProdaje.setData(adlist, Artikaldokument.class);
        this.em.clear();
        this.em.close();
        this.scrIzvodIzNabavke.setViewportView((Component)this.tableIzvodIzNabavke);
        this.scrIzvodIzProdaje.setViewportView((Component)this.tabelaIzvodIzProdaje);
        this.prviPut = false;
    }

    public static Object getGUIBuilderInstance() {
        return new Upit(Boolean.FALSE);
    }

    public Upit(Boolean initGUI) {
    }

    private FetchGroup getGrpIzlaz() {
        FetchGroup grp = new FetchGroup();
        grp.addAttribute("dokument.datum");
        grp.addAttribute("dokument.radnajedinica");
        grp.addAttribute("dokument.oznDokumenta");
        grp.addAttribute("dokument.komitent.sfrKomitent");
        grp.addAttribute("dokument.komitent.naziv");
        grp.addAttribute("dokument.radnajedinica.naziv");
        grp.addAttribute("kolicina");
        grp.addAttribute("cena");
        grp.addAttribute("procRabata");
        return grp;
    }
}

