/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.artikli;

import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;
import org.eclipse.persistence.indirection.IndirectList;
import org.jdesktop.application.Application;
import org.jdesktop.swingx.JXImagePanel;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Slika;
import rs.pezar.sifarnici.gui.artikli.ImagePreviewSettings;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzButtonPanel;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzFileExtensionFilter;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBar;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;

public class SlikePreview
extends PzDialog {
    private PzButtonPanel pnlButton;
    private JScrollPane jScrollPane1;
    private PzPanel pnlImagePreview;
    private PzToolBarIcon icnDodaj;
    private JXImagePanel imagePreview;
    private static PzTable table;
    private PzButton btnNazad;
    private PzToolBarIcon icnObrisi;
    private PzPanel pnlMain;
    private PzToolBar pzToolBar;
    private Artikal artikal;
    private Slika s;
    private File novaSlika;
    private String parameterDirSlike;
    private JLabel lblMessage;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                SlikePreview inst = new SlikePreview(frame);
                inst.setVisible(true);
            }
        });
    }

    public SlikePreview(JFrame frame) {
        super(frame);
        this.artikal = (Artikal)this.getSession().getParameter("artikal");
        this.initGUI();
    }

    public SlikePreview(PzDialog dialog) {
        super(dialog);
        this.artikal = (Artikal)this.getSession().getParameter("artikal");
        this.parameterDirSlike = PzParameter.getParameterValue((String)"DIR_SLIKE") == null ? "" : PzParameter.getParameterValue((String)"DIR_SLIKE");
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setSize(566, 484);
            this.setTitle("Slike artikla");
            AnchorLayout thisLayout = new AnchorLayout();
            this.getContentPane().setLayout((LayoutManager)thisLayout);
            this.pzToolBar = new PzToolBar();
            this.getContentPane().add((Component)this.pzToolBar, new AnchorConstraint(0, 1000, 169, 0, 2, 1, 0, 2));
            this.pzToolBar.setPreferredSize(new Dimension(550, 88));
            this.icnDodaj = new PzToolBarIcon();
            this.pzToolBar.add((Component)this.icnDodaj);
            this.icnDodaj.setName("icnDodaj");
            this.icnDodaj.setText("Dodaj|(INS)");
            this.icnDodaj.addActionListener((ActionListener)((Object)this));
            this.icnDodaj.setActionCommand("dodaj");
            this.icnDodaj.setShortcut("INSERT");
            this.icnDodaj.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/img_add.png")));
            this.icnObrisi = new PzToolBarIcon();
            this.pzToolBar.add((Component)this.icnObrisi);
            this.icnObrisi.setName("icnObrisi");
            this.icnObrisi.setText("Obri\u0161i|(DEL)");
            this.icnObrisi.addActionListener((ActionListener)((Object)this));
            this.icnObrisi.setActionCommand("obrisi");
            this.icnObrisi.setShortcut("DELETE");
            this.icnObrisi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/img_delete.png")));
            this.pnlMain = new PzPanel();
            AnchorLayout pnlMainLayout = new AnchorLayout();
            this.getContentPane().add((Component)this.pnlMain, new AnchorConstraint(75, 990, 877, 6, 2, 1, 1, 2));
            this.pnlMain.setLayout((LayoutManager)pnlMainLayout);
            this.pnlImagePreview = new PzPanel();
            this.pnlMain.add((Component)this.pnlImagePreview, (Object)new AnchorConstraint(39, 1000, 1001, 536, 1, 1, 1, 1));
            this.pnlImagePreview.setPreferredSize(new Dimension(250, 304));
            this.imagePreview = new JXImagePanel();
            this.pnlImagePreview.add((Component)this.imagePreview);
            this.imagePreview.setStyle(JXImagePanel.Style.SCALED_KEEP_ASPECT_RATIO);
            this.imagePreview.setPreferredSize(new Dimension(155, 180));
            this.lblMessage = new JLabel("");
            this.imagePreview.add((Component)this.lblMessage);
            this.jScrollPane1 = new JScrollPane();
            this.pnlMain.add((Component)this.jScrollPane1, (Object)new AnchorConstraint(61, 536, 1001, 0, 1, 1, 1, 1));
            this.jScrollPane1.setPreferredSize(new Dimension(288, 297));
            if (this.artikal != null) {
                table = new PzTable(this.artikal.getSlikas(), Slika.class);
            }
            this.jScrollPane1.setViewportView((Component)table);
            table.setName("slikePreviewTable");
            table.setHorizontalScrollEnabled(true);
            table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    SlikePreview.this.tableValueChanged(e);
                }
            });
            table.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent arg0) {
                    SlikePreview.this.tableValueChanged(arg0);
                }
            });
            this.tableImageInit();
            this.pnlButton = new PzButtonPanel();
            this.getContentPane().add((Component)this.pnlButton, new AnchorConstraint(891, 990, 994, 0, 0, 1, 1, 2));
            FlowLayout pnlButtonLayout = new FlowLayout();
            this.pnlButton.setLayout((LayoutManager)pnlButtonLayout);
            this.btnNazad = new PzButton();
            this.pnlButton.add((Component)this.btnNazad);
            this.btnNazad.setName("btnNazad");
            this.btnNazad.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/x.png")));
            this.btnNazad.addActionListener((ActionListener)((Object)this));
            this.btnNazad.setActionCommand("Nazad");
            this.btnNazad.setPreferredSize(new Dimension(103, 36));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        try {
            if (actionCommand.equalsIgnoreCase("nazad")) {
                this.dispose();
                return;
            }
            if (actionCommand.equalsIgnoreCase("obrisi")) {
                if (table.getSelectedEntity() == null) {
                    return;
                }
                Slika picture = (Slika)table.getSelectedEntity();
                String slikaName = picture.getFileName();
                File delSlika = null;
                if (picture.getPath() != null) {
                    delSlika = new File(picture.getPath());
                } else if (!this.parameterDirSlike.equals("")) {
                    delSlika = new File(String.valueOf(this.parameterDirSlike) + File.separator + picture.getFileName());
                }
                if (table.removeSelectedEntity(true, false)) {
                    PzEntityManager.update((Object)this.artikal);
                    Slika s = (Slika)PzEntityManager.find(Slika.class, (Object)slikaName);
                    if (delSlika.exists() && (s.getArtikals() == null || s.getArtikals().size() == 0)) {
                        delSlika.delete();
                    }
                    if (s.getArtikals() == null || s.getArtikals().size() == 0) {
                        PzEntityManager.delete(Slika.class, (Object)s.getFileName());
                    }
                }
                return;
            }
            if (actionCommand.equalsIgnoreCase("dodaj")) {
                if (this.parameterDirSlike.equals("")) {
                    PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Nije pode\u0161en direktorijum sa slikama. Molimo podesite ovaj parametar, pa onda unesite sliku.");
                    return;
                }
                File[] slike = this.fileChooser();
                if (slike == null) {
                    return;
                }
                if (this.artikal.getSlikas() != null) {
                    int n;
                    int i = 0;
                    while (i < this.artikal.getSlikas().size()) {
                        File[] fileArray = slike;
                        int n2 = slike.length;
                        n = 0;
                        while (n < n2) {
                            File slika = fileArray[n];
                            if (((Slika)this.artikal.getSlikas().get(i)).getFileName().equalsIgnoreCase(slika.getName())) {
                                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)("Slika " + slika.getName() + " ve\u0107 postoji."));
                                return;
                            }
                            ++n;
                        }
                        ++i;
                    }
                    File[] fileArray = slike;
                    n = slike.length;
                    int n3 = 0;
                    while (n3 < n) {
                        File slika = fileArray[n3];
                        this.novaSlika = new File(String.valueOf(this.parameterDirSlike) + File.separator + slika.getName());
                        this.s = (Slika)PzEntityManager.find(Slika.class, (Object)slika.getName().toLowerCase());
                        if (this.s == null) {
                            this.s = new Slika();
                            this.s.setFileName(this.novaSlika.getName().toLowerCase());
                            this.s.setArtikals((List)new IndirectList());
                            this.s.setPath(this.novaSlika.getPath());
                        }
                        this.artikal.getSlikas().add(this.s);
                        ++n3;
                    }
                    PzEntityManager.update((Object)this.artikal);
                    fileArray = slike;
                    n = slike.length;
                    n3 = 0;
                    while (n3 < n) {
                        File slika = fileArray[n3];
                        if (!slika.getParent().equals(this.parameterDirSlike)) {
                            FileUtils.copyFileToDirectory((File)slika, (File)new File(this.parameterDirSlike));
                        }
                        ++n3;
                    }
                    table.refreshData();
                }
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new SlikePreview(Boolean.FALSE);
    }

    public SlikePreview(Boolean initGUI) {
    }

    public static PzTable getTable() {
        return table;
    }

    private void tableValueChanged(ListSelectionEvent arg0) {
        Slika slika = null;
        BufferedImage image = null;
        try {
            if (table.getSelectedEntity() != null) {
                slika = (Slika)table.getSelectedEntity();
                if (!slika.getPath().equals("")) {
                    image = ImageIO.read(new FileInputStream(slika.getPath()));
                } else if (!this.parameterDirSlike.equals("")) {
                    image = ImageIO.read(new FileInputStream(String.valueOf(this.parameterDirSlike) + File.separator + slika.getFileName()));
                }
                this.lblMessage.setVisible(false);
                this.imagePreview.setStyle(JXImagePanel.Style.SCALED_KEEP_ASPECT_RATIO);
                this.imagePreview.setImage((Image)image);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.lblMessage.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/no_image.png")));
            this.lblMessage.setVisible(true);
            this.imagePreview.setImage((Image)image);
        }
        catch (IOException iOException) {
            this.imagePreview.setImage(null);
            this.lblMessage.setVisible(true);
            this.lblMessage.setText("Neuspelo u\u010ditavanje slike iz fajla: " + slika.getPath());
        }
    }

    private void tableImageInit() {
        BufferedImage image = null;
        Slika initSlika = null;
        try {
            if (table.getRowCount() != 0 && table.getSelectedEntity() != null) {
                initSlika = (Slika)table.getSelectedEntity();
                if (initSlika.getPath() != null && !initSlika.getPath().equals("")) {
                    image = ImageIO.read(new FileInputStream(initSlika.getPath()));
                } else if (!this.parameterDirSlike.equals("")) {
                    image = ImageIO.read(new FileInputStream(String.valueOf(this.parameterDirSlike) + File.separator + initSlika.getFileName()));
                }
                this.lblMessage.setVisible(false);
                this.imagePreview.setImage((Image)image);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.lblMessage.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/no_image.png")));
            this.lblMessage.setVisible(true);
            this.imagePreview.setImage(image);
        }
        catch (IOException iOException) {
            this.imagePreview.setImage(null);
            this.lblMessage.setVisible(true);
            this.lblMessage.setText("Neuspelo u\u010ditavanje slike iz fajla: " + initSlika.getPath());
        }
    }

    private File[] fileChooser() {
        String direktorijum = PzParameter.getParameterValue((String)"DIR_SLIKE");
        File file = new File(direktorijum);
        boolean exist = file.exists();
        if (!exist) {
            file.mkdirs();
            if (file.exists()) {
                System.out.println("Direktorijum je kreiran");
            }
        }
        JFileChooser fc = new JFileChooser();
        fc.setMultiSelectionEnabled(true);
        ImagePreviewSettings preview = new ImagePreviewSettings();
        fc.setAccessory((JComponent)((Object)preview));
        fc.addPropertyChangeListener(preview);
        fc.setDialogTitle("Izaberite sliku");
        PzFileExtensionFilter filter = new PzFileExtensionFilter();
        filter.setExtension(".jpg");
        fc.addChoosableFileFilter((FileFilter)filter);
        fc.setDialogType(0);
        int rez = fc.showOpenDialog((Component)((Object)this));
        if (rez == 0) {
            File[] selectedFiles = fc.getSelectedFiles();
            return selectedFiles;
        }
        return null;
    }

    private void copy(String stari, String novi) throws IOException {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            int data;
            in = new FileInputStream(stari);
            out = new FileOutputStream(novi);
            ((InputStream)in).available();
            while ((data = ((InputStream)in).read()) != -1) {
                out.write(data);
            }
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

