/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import net.sf.jasperreports.engine.JRDataSource;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.PzTableDataSource;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.util.PzDateUtility;

public class PzDialogZapisnikPromeneStopePregled
extends PzDialog {
    private PzPanel mainPanel;
    private JToolBar toolbar;
    private JScrollPane scrollPane;
    private PzTable tabela;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();
    private PzToolBarIcon icnSlika;
    private PzToolBarIcon icnPriprema;
    private PzPanel pnlPretraga;
    private JLabel lblPocetni;
    private JButton btnPotvrdi;
    private PzDateField dfKrajnjiDatum;
    private JLabel lblKrajnjiDatum;
    private PzDateField tfPocetniDatum;
    private final int idDokColumnIndex = -1;

    public PzDialogZapisnikPromeneStopePregled(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout bLayout = new BorderLayout();
            this.setLayout(bLayout);
            this.setTitle("Pregled zapisnika o promeni tarifne stope");
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.mainPanel.setPreferredSize(new Dimension(653, 386));
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.1};
            mainPanelLayout.rowHeights = new int[]{7, 55, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.toolbar = new JToolBar();
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnSlika = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnSlika);
            this.icnSlika.setText("Slika|dokumenta|(F2)");
            this.icnSlika.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/presentation_chart.png")));
            this.icnSlika.setActionCommand("slika");
            this.icnSlika.addActionListener((ActionListener)((Object)this));
            this.icnSlika.setShortcut("F2");
            this.icnPriprema = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnPriprema);
            this.icnPriprema.setText("Priprema|za \u0161tampu|(ALT+S)");
            this.icnPriprema.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/printer_view.png")));
            this.icnPriprema.setActionCommand("priprema");
            this.icnPriprema.addActionListener((ActionListener)((Object)this));
            this.icnPriprema.setShortcut("ALT+S");
            this.scrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.tabela = new PzTable();
            this.scrollPane.setViewportView((Component)this.tabela);
            this.tabela.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Opstidokument dok = (Opstidokument)entity;
                    return new Object[]{dok.getOznDokumenta(), dok.getDatum(), dok.getRadnajedinica().getId().getOznRj(), dok.getIznosBezPoreza(), dok.getIznosSaPorezom()};
                }

                public String[] getColumnNames() {
                    return new String[]{"Dokument", "Datum", "Radna jedinica", "Stara vrednost", "Nova vrednost"};
                }
            });
            this.pnlPretraga = new PzPanel();
            GridBagLayout pnlPretragaLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlPretraga, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlPretragaLayout.rowWeights = new double[]{0.0, 0.0};
            pnlPretragaLayout.rowHeights = new int[]{7, 7};
            pnlPretragaLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlPretragaLayout.columnWidths = new int[]{95, 130, 95, 130, 7, 20};
            this.pnlPretraga.setLayout((LayoutManager)pnlPretragaLayout);
            this.lblPocetni = new JLabel();
            this.pnlPretraga.add((Component)this.lblPocetni, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblPocetni.setText("Po\u010detni datum");
            this.tfPocetniDatum = new PzDateField();
            this.pnlPretraga.add((Component)this.tfPocetniDatum, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblKrajnjiDatum = new JLabel();
            this.pnlPretraga.add((Component)this.lblKrajnjiDatum, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblKrajnjiDatum.setText("Krajnji datum");
            this.dfKrajnjiDatum = new PzDateField();
            this.pnlPretraga.add((Component)this.dfKrajnjiDatum, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi = new PzButton();
            this.pnlPretraga.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(4, 0, 1, 2, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(75, 9, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(110, 31));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj stavki");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setSize(666, 516);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("potvrdi")) {
            final EntityManager em = PzEntityManager.getEm();
            PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    em.getTransaction().begin();
                    String upit = "";
                    Query q = null;
                    upit = "Select p From Opstidokument p Where p.arhiviran = 1 and p.tip ='" + TipDokumentConfig.get().PROMENA_STOPE + "' and p.datum>=:datumOd and p.datum<=:datumDo ";
                    q = em.createQuery(upit);
                    q.setParameter("datumOd", (Object)PzDialogZapisnikPromeneStopePregled.this.tfPocetniDatum.getVal());
                    q.setParameter("datumDo", (Object)PzDialogZapisnikPromeneStopePregled.this.dfKrajnjiDatum.getVal());
                    List data = q.getResultList();
                    System.out.println("Kursor je nasao faktura" + data.size());
                    em.getTransaction().commit();
                    return data;
                }

                @Override
                protected void done() {
                    try {
                        List data = (List)this.get();
                        if (data.size() == 0) {
                            JOptionPane.showMessageDialog(PzDialogZapisnikPromeneStopePregled.this.getParent(), "Nema podataka za prikazivanje", "Informacija", 1);
                            return;
                        }
                        try {
                            PzDialogZapisnikPromeneStopePregled.this.tabela.setData(data, Opstidokument.class);
                            PzDialogZapisnikPromeneStopePregled.this.tabela.setRowSelectionInterval(0, 0);
                            PzDialogZapisnikPromeneStopePregled.this.tabela.requestFocusInWindow();
                            PzDialogZapisnikPromeneStopePregled.this.brDok.setText(String.valueOf(data.size()));
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)((Object)PzDialogZapisnikPromeneStopePregled.this), (Throwable)e);
                        }
                    }
                    finally {
                        em.close();
                        PzWorkerDialog.hideStatus();
                    }
                }
            };
            worker.execute();
        } else if (actionCommand.equals("slika")) {
            if (this.tabela.getRowCount() != 0) {
                Opstidokument dok = (Opstidokument)this.tabela.getSelectedEntity();
                PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)dok);
            }
        } else if (actionCommand.equals("priprema") && this.tabela.getRowCount() != 0) {
            this.showReports();
        }
    }

    public void showReports() {
        try {
            Vector<Firma> data = new Vector<Firma>();
            data.add(PzFirma.getFirma());
            PzTableDataSource ds = new PzTableDataSource((PzAbstractTable)this.tabela, data);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("datumOd", this.tfPocetniDatum.getVal());
            params.put("datumDo", this.dfKrajnjiDatum.getVal());
            params.put("datum", PzDateUtility.formatDate((Date)PzDateUtility.getCurrentDate()));
            params.put("reklama", "");
            params.put("title", "PREGLED ZAPISNIKA O PROMENI TARIFNE STOPE");
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (String)"rs/pezar/reports/compiled/zapisnik.promena.stope.stampa.jasper", params, (String)"PREGLED ZAPISNIKA O PROMENI TARIFNE STOPE");
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }
}

