/*
 * Decompiled with CFR 0.152.
 */
package org.cheffo.jeplite.function;

import java.util.HashMap;
import org.cheffo.jeplite.ParseException;
import org.cheffo.jeplite.util.DoubleStack;

public abstract class PostfixMathCommand {
    public static final PostfixMathCommand ADD = new Add();
    public static final PostfixMathCommand DIVIDE = new Divide();
    public static final PostfixMathCommand MULTIPLY = new Multiply();
    public static final PostfixMathCommand UMINUS = new UMinus();
    public static final PostfixMathCommand AND = new Logical(0);
    public static final PostfixMathCommand OR = new Logical(1);
    protected int numberOfParameters;

    public final int getNumberOfParameters() {
        return this.numberOfParameters;
    }

    public double operation(double[] params) throws ParseException {
        throw new ParseException("Not implemented");
    }

    public void run(DoubleStack inStack, int numOfParams) throws ParseException {
        double[] params = new double[this.numberOfParameters];
        int i = this.numberOfParameters - 1;
        while (i > -1) {
            params[i] = inStack.pop();
            --i;
        }
        inStack.push(this.operation(params));
    }

    public static void fillFunctionTable(HashMap funTab) {
        funTab.put("sin", new Sine());
        funTab.put("cos", new Cosine());
        funTab.put("tan", new Tangent());
        funTab.put("asin", new ArcSine());
        funTab.put("acos", new ArcCosine());
        funTab.put("atan", new ArcTangent());
        funTab.put("sqrt", new Sqrt());
        funTab.put("log", new Logarithm());
        funTab.put("ln", new NaturalLogarithm());
        funTab.put("angle", new Angle());
        funTab.put("abs", new Abs());
        funTab.put("mod", new Modulus());
        funTab.put("sum", new Sum());
        funTab.put("rand", new Random());
        funTab.put("umin", new UMinus());
        funTab.put("add", new Add());
    }

    static class Abs
    extends PostfixMathCommand {
        public Abs() {
            this.numberOfParameters = 1;
        }

        @Override
        public void run(DoubleStack inStack, int numOfParams) throws ParseException {
            inStack.push(Math.abs(inStack.pop()));
        }
    }

    static class Add
    extends PostfixMathCommand {
        public Add() {
            this.numberOfParameters = 2;
        }

        @Override
        public void run(DoubleStack inStack, int numOfParams) throws ParseException {
            inStack.push(inStack.pop() + inStack.pop());
        }
    }

    static class Angle
    extends PostfixMathCommand {
        public Angle() {
            this.numberOfParameters = 2;
        }

        @Override
        public void run(DoubleStack inStack, int numOfParams) throws ParseException {
            double param2 = inStack.pop();
            double param1 = inStack.pop();
            inStack.push(Math.atan2(param1, param2));
        }
    }

    static class ArcCosine
    extends PostfixMathCommand {
        public ArcCosine() {
            this.numberOfParameters = 1;
        }

        @Override
        public void run(DoubleStack inStack, int numOfParams) throws ParseException {
            inStack.push(Math.acos(inStack.pop()));
        }
    }

    static class ArcSine
    extends PostfixMathCommand {
        public ArcSine() {
            this.numberOfParameters = 1;
        }

        @Override
        public final double operation(double[] params) throws ParseException {
            return Math.asin(params[0]);
        }
    }

    static class ArcTangent
    extends PostfixMathCommand {
        public ArcTangent() {
            this.numberOfParameters = 1;
        }

        @Override
        public final double operation(double[] params) throws ParseException {
            return Math.atan(params[0]);
        }
    }

    public static class Comparative
    extends PostfixMathCommand {
        int id;
        double tolerance;

        @Override
        public double operation(double[] params) {
            return 0.0;
        }

        public Comparative(int id_in) {
            this.id = id_in;
            this.numberOfParameters = 2;
            this.tolerance = 1.0E-6;
        }

        @Override
        public void run(DoubleStack inStack, int numOfParams) throws ParseException {
            boolean r;
            double y = inStack.pop();
            double x = inStack.pop();
            switch (this.id) {
                case 0: {
                    r = x < y;
                    break;
                }
                case 1: {
                    r = x > y;
                    break;
                }
                case 2: {
                    r = x <= y;
                    break;
                }
                case 3: {
                    r = x >= y;
                    break;
                }
                case 4: {
                    r = x != y;
                    break;
                }
                case 5: {
                    r = x == y;
                    break;
                }
                default: {
                    throw new ParseException("Unknown relational operator");
                }
            }
            inStack.push((double)r);
        }
    }

    static class Cosine
    extends PostfixMathCommand {
        public Cosine() {
            this.numberOfParameters = 1;
        }

        @Override
        public final double operation(double[] params) throws ParseException {
            return Math.cos(params[0]);
        }
    }

    public static class Divide
    extends PostfixMathCommand {
        public Divide() {
            this.numberOfParameters = 2;
        }

        @Override
        public void run(DoubleStack inStack, int numOfParams) throws ParseException {
            double p2 = inStack.pop();
            inStack.push(inStack.pop() / p2);
        }

        @Override
        public final double operation(double[] params) throws ParseException {
            return params[0] / params[1];
        }
    }

    static class Logarithm
    extends PostfixMathCommand {
        private static final double LOG_10 = Math.log(10.0);

        public Logarithm() {
            this.numberOfParameters = 1;
        }

        @Override
        public final double operation(double[] params) throws ParseException {
            return Math.log(params[0]) / LOG_10;
        }
    }

    public static class Logical
    extends PostfixMathCommand {
        int id;

        public Logical(int id_in) {
            this.id = id_in;
            this.numberOfParameters = 2;
        }

        @Override
        public final double operation(double[] params) {
            return 0.0;
        }

        @Override
        public void run(DoubleStack inStack, int numOfParams) throws ParseException {
            boolean r;
            double y = inStack.pop();
            double x = inStack.pop();
            switch (this.id) {
                case 0: {
                    r = x != 0.0 && y != 0.0;
                    break;
                }
                case 1: {
                    r = x != 0.0 || y != 0.0;
                    break;
                }
                default: {
                    r = false;
                }
            }
            inStack.push((double)r);
        }
    }

    public static class Modulus
    extends PostfixMathCommand {
        public Modulus() {
            this.numberOfParameters = 2;
        }

        @Override
        public double operation(double[] params) {
            return 0.0;
        }

        @Override
        public void run(DoubleStack inStack, int numOfParams) throws ParseException {
            double param2 = inStack.pop();
            double param1 = inStack.pop();
            double result = param1 % param2;
            inStack.push(result);
        }
    }

    public static class Multiply
    extends PostfixMathCommand {
        public Multiply() {
            this.numberOfParameters = 2;
        }

        @Override
        public final double operation(double[] params) {
            return 0.0;
        }

        @Override
        public void run(DoubleStack inStack, int numOfParams) throws ParseException {
            inStack.push(inStack.pop() * inStack.pop());
        }
    }

    static class NaturalLogarithm
    extends PostfixMathCommand {
        public NaturalLogarithm() {
            this.numberOfParameters = 1;
        }

        @Override
        public final double operation(double[] params) throws ParseException {
            return Math.log(params[0]);
        }
    }

    public static class Not
    extends PostfixMathCommand {
        public Not() {
            this.numberOfParameters = 1;
        }

        @Override
        public double operation(double[] params) {
            return 0.0;
        }

        @Override
        public void run(DoubleStack inStack, int numOfParams) throws ParseException {
            double param = inStack.pop();
            boolean r = param == 0.0;
            inStack.push((double)r);
        }
    }

    public static class Power
    extends PostfixMathCommand {
        public Power() {
            this.numberOfParameters = 2;
        }

        @Override
        public final double operation(double[] params) {
            return 0.0;
        }

        @Override
        public void run(DoubleStack inStack, int numOfParams) throws ParseException {
            double param2 = inStack.pop();
            double param1 = inStack.pop();
            inStack.push(Math.pow(param1, param2));
        }
    }

    static class Random
    extends PostfixMathCommand {
        public Random() {
            this.numberOfParameters = 0;
        }

        @Override
        public double operation(double[] params) {
            return 0.0;
        }

        @Override
        public void run(DoubleStack inStack, int numOfParams) throws ParseException {
            inStack.push(Math.random());
        }
    }

    static class Sine
    extends PostfixMathCommand {
        public Sine() {
            this.numberOfParameters = 1;
        }

        @Override
        public final double operation(double[] params) throws ParseException {
            return Math.sin(params[0]);
        }
    }

    static class Sqrt
    extends PostfixMathCommand {
        public Sqrt() {
            this.numberOfParameters = 1;
        }

        @Override
        public void run(DoubleStack inStack, int numOfParams) throws ParseException {
            inStack.push(Math.sqrt(inStack.pop()));
        }
    }

    public static class Subtract
    extends PostfixMathCommand {
        public Subtract() {
            this.numberOfParameters = 2;
        }

        @Override
        public final double operation(double[] params) {
            return params[0] - params[1];
        }
    }

    static class Sum
    extends PostfixMathCommand {
        public Sum() {
            this.numberOfParameters = -1;
        }

        @Override
        public final double operation(double[] params) {
            return 0.0;
        }

        @Override
        public void run(DoubleStack inStack, int numOfParams) throws ParseException {
            if (inStack == null) {
                throw new ParseException("Stack argument null");
            }
            double r = 0.0;
            int i = 0;
            while (i < numOfParams) {
                r += inStack.pop();
                ++i;
            }
            inStack.push(r);
        }
    }

    static class Tangent
    extends PostfixMathCommand {
        public Tangent() {
            this.numberOfParameters = 1;
        }

        @Override
        public final double operation(double[] params) throws ParseException {
            return Math.tan(params[0]);
        }
    }

    static class UMinus
    extends PostfixMathCommand {
        public UMinus() {
            this.numberOfParameters = 1;
        }

        @Override
        public void run(DoubleStack inStack, int numOfParams) throws ParseException {
            inStack.push(-inStack.pop());
        }
    }
}

