/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prostoKnjigovodstvo.gui.izvod.uplate;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import rs.pezar.db.PzRacun;
import rs.pezar.db.entity.Uplata;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.prostoKnjigovodstvo.gui.izvod.uplate.UplataComponent;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzTextField;

public class PnlUplataPoRacunu
extends UplataComponent {
    private static final long serialVersionUID = 1667879464920970057L;
    private PzTextField txtOznDokument;
    private PzTextField txtOpis;
    private PzDoubleField dblDug;
    private PzDoubleField dblIznos;
    private Uplata uplata;
    private PzRacun racun;
    private BigDecimal dugBezUplate = new BigDecimal("0.00");

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new PnlUplataPoRacunu());
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public PnlUplataPoRacunu() {
        this.initGUI();
    }

    public PnlUplataPoRacunu(Uplata u) {
        this.initGUI();
        this.setUplata(u);
    }

    private void initGUI() {
        try {
            FlowLayout thisLayout = new FlowLayout();
            thisLayout.setVgap(0);
            thisLayout.setAlignment(0);
            this.setLayout(thisLayout);
            this.txtOpis = new PzTextField();
            this.txtOpis.setFont(new Font("SansSerif", 0, 10));
            this.txtOpis.setColumns(10);
            this.txtOpis.setEditable(false);
            this.txtOpis.setFocusable(false);
            this.add((Component)this.txtOpis);
            this.txtOpis.setName("txtOpis");
            this.txtOznDokument = new PzTextField();
            this.txtOznDokument.setFont(new Font("SansSerif", 0, 10));
            this.txtOznDokument.setColumns(10);
            this.txtOznDokument.setFocusable(false);
            this.txtOznDokument.setEditable(false);
            this.add((Component)this.txtOznDokument);
            this.txtOznDokument.setName("txtOznDokument");
            this.dblDug = new PzDoubleField();
            this.dblDug.setFocusable(false);
            this.dblDug.setEditable(false);
            this.dblDug.setFont(new Font("SansSerif", 0, 10));
            this.add((Component)this.dblDug);
            this.dblDug.setColumns(8);
            this.dblIznos = new PzDoubleField();
            this.dblIznos.setFont(new Font("SansSerif", 0, 10));
            this.dblIznos.setColumns(8);
            this.add((Component)this.dblIznos);
            this.dblIznos.setName("dblIznos");
            this.dblIznos.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    PnlUplataPoRacunu.this.dblDug.setVal((Object)PnlUplataPoRacunu.this.dugBezUplate.subtract(PnlUplataPoRacunu.this.dblIznos.getBigDecimal()));
                }
            });
            this.dblIznos.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    boolean ok = PnlUplataPoRacunu.this.validateUplata();
                    if (ok) {
                        PnlUplataPoRacunu.this.getPanelTransakcija().getIzvodManager().validateTransakcije();
                    }
                    return ok;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Uplata getUplata() {
        if (this.racun != null) {
            this.racun.setUplata(this.racun.getUplata().subtract(this.uplata.getIznos()));
        }
        this.uplata.setIznos(this.dblIznos.getBigDecimal());
        if (this.racun != null) {
            this.racun.setUplata(this.racun.getUplata().add(this.uplata.getIznos()));
        }
        return this.uplata;
    }

    @Override
    public void setUplata(Uplata u) {
        this.uplata = u;
        this.txtOznDokument.setVal((Object)u.getOznDokumenta());
        if (u.getTipDokumentaUpl() != null) {
            this.txtOpis.setVal((Object)TipDokumentConfig.getNameByValue((String)u.getTipDokumentaUpl(), null));
        } else {
            this.txtOpis.setVal((Object)TipDokumentConfig.getNameByValue((String)u.getTip(), null));
        }
        this.dblIznos.setVal((Object)u.getIznos().doubleValue());
        this.racun = (PzRacun)u.getDokumentUpl();
        if (this.racun != null) {
            this.dblDug.setVal((Object)this.racun.getDug());
            this.dugBezUplate = this.racun.getDug().add(this.uplata.getIznos());
        }
    }

    public void setOpis(String opis) {
        this.txtOpis.setVal((Object)opis);
    }

    public void setOznDokumenta(String oznDokumenta) {
        this.txtOznDokument.setVal((Object)oznDokumenta);
    }

    public void setDug(BigDecimal dug) {
        this.dblDug.setVal((Object)dug);
    }

    public void setIznos(BigDecimal iznos) {
        this.dblDug.setVal((Object)iznos);
    }

    public void setColor(Color c) {
        this.txtOznDokument.setForeground(c);
        this.txtOpis.setForeground(c);
        this.dblDug.setForeground(c);
        this.dblIznos.setForeground(c);
    }

    @Override
    public boolean validateUplata() {
        BigDecimal izn = this.dblIznos.getBigDecimal();
        if (this.dugBezUplate.compareTo(izn) < 0) {
            this.getPanelTransakcija().setError(true);
            this.getPanelTransakcija().setErrorMessage("Uplata je ve\u0107a od duga na dokumentu na koji se odnosi.");
            this.paintBorder(Color.RED);
            return false;
        }
        this.getPanelTransakcija().setError(false);
        this.removeBorder();
        return true;
    }

    private void paintBorder(Color c) {
        LineBorder border = new LineBorder(c);
        this.setBorder(border);
    }

    private void removeBorder() {
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.dblIznos.setEnabled(enabled);
    }
}

