/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prostoKnjigovodstvo.engine.izvod.loaderImpl;

import java.io.File;
import java.math.BigInteger;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import rs.pezar.prostoKnjigovodstvo.engine.izvod.IzvodBanke;
import rs.pezar.prostoKnjigovodstvo.engine.izvod.IzvodLoader;
import rs.pezar.prostoKnjigovodstvo.engine.izvod.IzvodLoaderException;
import rs.pezar.prostoKnjigovodstvo.engine.izvod.TransakcijaIzvodaBanke;
import rs.pezar.prostoKnjigovodstvo.engine.izvod.loaderImpl.reiffeisen.TransakcioniRacunPrivredaIzvod;

public class ReiffeisenLoader
implements IzvodLoader {
    @Override
    public List<IzvodBanke> loadIzvodList(File f) throws IzvodLoaderException {
        try {
            ArrayList<IzvodBanke> list = new ArrayList<IzvodBanke>();
            IzvodBanke izv = new IzvodBanke();
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{TransakcioniRacunPrivredaIzvod.class});
            Unmarshaller u = jc.createUnmarshaller();
            Document d = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(f);
            System.out.println(d.getDocumentElement().getNodeName());
            if (d.getDocumentElement().getElementsByTagName("Stavke").getLength() == 0) {
                throw new IzvodLoaderException("Fajl ne sadr\u017ei ni jedan izvod banke. Uvoz nemogu\u0107!");
            }
            TransakcioniRacunPrivredaIzvod tr = (TransakcioniRacunPrivredaIzvod)u.unmarshal((Node)d.getDocumentElement());
            TransakcioniRacunPrivredaIzvod.Zaglavlje z = tr.getZaglavlje();
            izv.setBrojRacuna(ReiffeisenLoader.formatBrojRacuna(z.getPartija()));
            izv.setDatum(ReiffeisenLoader.parseDate(z.getDatumIzvoda()));
            izv.setPrethodnoStanje(z.getPrethodnoStanje());
            izv.setrBroj(new BigInteger("" + z.getBrojIzvoda()));
            izv.setStanje(z.getNovoStanje());
            izv.setValuta("RSD");
            izv.setTransakcije(new Vector<TransakcijaIzvodaBanke>());
            for (TransakcioniRacunPrivredaIzvod.Stavke s : tr.getStavke()) {
                TransakcijaIzvodaBanke t = new TransakcijaIzvodaBanke();
                t.setBrojRacuna(ReiffeisenLoader.formatBrojRacuna(s.getBrojRacunaPrimaocaPosiljaoca()));
                t.setDatumPlacanja(ReiffeisenLoader.parseDate(s.getDatumValute()));
                t.setIdTransakcije(s.getBrojZaReklamaciju());
                t.setIznos(s.getDuguje().add(s.getPotrazuje()));
                t.setModel(s.getModelKorisnika());
                t.setNazivBanke("Nepoznat");
                t.setNazivKomitenta(s.getNalogKorisnik());
                t.setPozivNaBroj(s.getPozivNaBrojKorisnika());
                t.setSedisteKomitenta("Nepoznato");
                t.setSifraPlacanja(s.getSifraPlacanja());
                t.setStrana(s.getDuguje().doubleValue() != 0.0 ? "ZADUZENJE" : "ODOBRENJE");
                t.setSvrhaPlacanja(s.getOpis());
                t.setValuta("RSD");
                t.setIzvod(izv);
                izv.getTransakcije().add(t);
            }
            list.add(izv);
            return list;
        }
        catch (Exception e) {
            IzvodLoaderException ex = new IzvodLoaderException("Gre\u0161ka prilikom u\u010ditavanja izvoda iz fajla", e);
            throw ex;
        }
    }

    public String toString() {
        return "Reiffeisen Email Format";
    }

    private static Date parseDate(String date) throws ParseException {
        return new Date(new SimpleDateFormat("dd.MM.yyyy").parse(date).getTime());
    }

    private static String formatBrojRacuna(String br) {
        if (br.equals("")) {
            return br;
        }
        String s1 = br.substring(0, 3);
        String s2 = br.substring(3, br.length() - 2).replaceAll("^0+", "");
        String s3 = br.substring(br.length() - 2).replaceAll("^0+", "");
        return String.valueOf(s1) + "-" + s2 + "-" + s3;
    }

    public static void main(String[] args) {
        System.out.println(ReiffeisenLoader.formatBrojRacuna("12300000000456789"));
    }
}

