/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prostoKnjigovodstvo.engine.internal;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Konto;
import rs.pezar.db.entity.KontoPK;
import rs.pezar.db.entity.Nzk;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Shema;
import rs.pezar.db.entity.Stavkanzk;
import rs.pezar.db.entity.StavkanzkPK;
import rs.pezar.db.entity.Stavkasheme;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.prostoKnjigovodstvo.engine.DokumentCompilerException;
import rs.pezar.prostoKnjigovodstvo.engine.ShemaProvider;
import rs.pezar.prostoKnjigovodstvo.engine.SingleDokumentCompiler;
import rs.pezar.prostoKnjigovodstvo.engine.internal.CompilerUtility;
import rs.pezar.prostoKnjigovodstvo.engine.internal.ExpressionParser;

public class PzSingleDokumentCompiler
implements SingleDokumentCompiler {
    private ShemaProvider sProvider;

    public PzSingleDokumentCompiler(ShemaProvider sProvider) {
        this.sProvider = sProvider;
    }

    @Override
    public Nzk compileDokument(PzDokument dokument) throws DokumentCompilerException {
        if (dokument == null) {
            return null;
        }
        Shema s = this.sProvider.getShema(dokument);
        if (s == null) {
            throw new DokumentCompilerException("Za tip dokumenta " + TipDokumentConfig.getNameByValue((String)dokument.getTip(), null) + " nije definisana odgovaraju\u0107a \u0161ema knji\u017eenja.");
        }
        if (s.getStavkashemes().size() == 0) {
            throw new DokumentCompilerException("Ne postoji sadr\u017eaj sheme za tip dokumenta " + TipDokumentConfig.getNameByValue((String)dokument.getTip(), null));
        }
        return this.primeniShemuNaDokument(s, dokument);
    }

    private Nzk primeniShemuNaDokument(Shema s, PzDokument dokument) throws DokumentCompilerException {
        Nzk nalog = new Nzk();
        Vector stavke = new Vector();
        nalog.setStavkanzks(stavke);
        dokument.getDokument().setStavkanzks(stavke);
        this.addStavke(s, nalog, dokument);
        nalog.setBrSheme(s.getrBroj());
        nalog.setRadnajedinica(dokument.getRadnajedinica());
        nalog.setArhiviran(s.getZatvori());
        nalog.setBrojac(Integer.valueOf(nalog.getStavkanzks().size()));
        dokument.setProknjizen((short)1);
        return nalog;
    }

    private void addStavke(Shema s, Nzk nalog, PzDokument dokument) throws DokumentCompilerException {
        Iterator i = s.getStavkashemes().iterator();
        BigDecimal duguje = new BigDecimal("0");
        BigDecimal potrazuje = new BigDecimal("0");
        while (i.hasNext()) {
            List<Stavkanzk> stavke = this.compileStavka((Stavkasheme)i.next(), dokument);
            for (Stavkanzk snzk : stavke) {
                if (snzk == null || snzk.getDuguje().doubleValue() == 0.0 && snzk.getPotrazuje().doubleValue() == 0.0) continue;
                snzk.getId().setrBroj(Integer.valueOf(nalog.getStavkanzks().size()));
                nalog.getStavkanzks().add(snzk);
                duguje = duguje.add(snzk.getDuguje());
                potrazuje = potrazuje.add(snzk.getPotrazuje());
            }
            nalog.setDuguje(duguje);
            nalog.setPotrazuje(potrazuje);
        }
        if (s.getNadSheme() != null && s.getNadSheme().size() > 0) {
            for (Shema ss : s.getNadSheme()) {
                if (ss.getStavkashemes() == null || ss.getStavkashemes().size() <= 0) continue;
                this.addStavke(ss, nalog, dokument);
            }
        }
    }

    private List<Stavkanzk> compileStavka(Stavkasheme stavka, PzDokument dokument) throws DokumentCompilerException {
        Vector<Stavkanzk> list = new Vector<Stavkanzk>();
        if (stavka.getIzraz().matches("SUBDOK\\{.+?:.+?\\}")) {
            String s = StringUtils.substringBeforeLast((String)StringUtils.substringAfter((String)stavka.getIzraz(), (String)"SUBDOK{"), (String)"}");
            String[] arr = s.split(":");
            try {
                List subdoks = (List)PropertyUtils.getProperty((Object)dokument, (String)arr[0].trim());
                for (PzDokument pzdok : subdoks) {
                    list.add(this.compileStavka(stavka, arr[1].trim(), pzdok));
                }
            }
            catch (Exception e) {
                throw new DokumentCompilerException("Greska prilikom pristupa podlisti dokumenata", e);
            }
        } else {
            list.add(this.compileStavka(stavka, stavka.getIzraz(), dokument));
        }
        return list;
    }

    private Stavkanzk compileStavka(Stavkasheme stavka, String izraz, PzDokument dokument) throws DokumentCompilerException {
        if (!CompilerUtility.condition(stavka, dokument)) {
            return null;
        }
        CompilerUtility.validate(izraz);
        Stavkanzk stavkaNzk = new Stavkanzk();
        stavkaNzk.setId(this.getID(stavka, dokument));
        stavkaNzk.setNazivAnalitike(this.getNazivAnalitike(stavka, dokument));
        stavkaNzk.setBrdokumenta(dokument.getOznDokumenta() != null ? dokument.getOznDokumenta() : "");
        stavkaNzk.setDatdokumenta(dokument.getDatum());
        stavkaNzk.setDokument(dokument.getDokument());
        stavkaNzk.setDatKnjizenja(dokument.getDatum());
        stavkaNzk.setKomitent(dokument.getKomitent());
        stavkaNzk.setNazivKonta(stavka.getNazivKonta());
        stavkaNzk.setRadnajedinica(dokument.getRadnajedinica());
        stavkaNzk.setOpis(String.valueOf(dokument.getStorno() == 1 ? "(Storno)" : "") + CompilerUtility.formatirajOpis(stavka.getShema().getOpisKnjizenja(), dokument));
        try {
            if (stavka.getStrana() == 0) {
                stavkaNzk.setDuguje((BigDecimal)ExpressionParser.parseDoubleExpression(izraz, dokument));
                if (dokument.getStorno() == 1) {
                    stavkaNzk.setDuguje(stavkaNzk.getDuguje().negate());
                }
                stavkaNzk.setPotrazuje(new BigDecimal("0"));
            } else {
                stavkaNzk.setPotrazuje((BigDecimal)ExpressionParser.parseDoubleExpression(izraz, dokument));
                if (dokument.getStorno() == 1) {
                    stavkaNzk.setPotrazuje(stavkaNzk.getPotrazuje().negate());
                }
                stavkaNzk.setDuguje(new BigDecimal("0"));
            }
            boolean cfr_ignored_0 = dokument instanceof Interniracun;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DokumentCompilerException(e.getMessage());
        }
        return stavkaNzk;
    }

    private StavkanzkPK getID(Stavkasheme stavka, PzDokument dokument) {
        String oznKonto = stavka.getOznKonto();
        String analitika = "";
        try {
            if ("K".equals(stavka.getTipAnalitike()) && dokument.getKomitent() != null) {
                analitika = dokument.getKomitent().getSfrKomitent();
            } else if ("R".equals(stavka.getTipAnalitike())) {
                if (dokument instanceof Interniracun) {
                    if ("W".equals(stavka.getIndikator())) {
                        analitika = this.formatAnalitika(((Interniracun)dokument).getIzlaznaRJ());
                    } else if ("Q".equals(stavka.getIndikator())) {
                        analitika = this.formatAnalitika(((Interniracun)dokument).getUlaznaRJ());
                    }
                } else if (dokument.getRadnajedinica() != null) {
                    analitika = this.formatAnalitika(dokument.getRadnajedinica());
                }
            }
            KontoPK id = new KontoPK(oznKonto, analitika);
            Konto k = (Konto)PzEntityManager.find(Konto.class, (Object)id);
            if (k == null) {
                Konto temp = (Konto)PzEntityManager.find(Konto.class, (Object)new KontoPK(oznKonto, ""));
                k = new Konto(oznKonto, analitika, "", temp != null ? temp.getNaziv() : "");
                PzEntityManager.insert((Object)k);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new StavkanzkPK(oznKonto, analitika);
    }

    private String getNazivAnalitike(Stavkasheme stavka, PzDokument dokument) {
        String nazivAnalitike = null;
        if ("K".equals(stavka.getTipAnalitike()) && dokument.getKomitent() != null) {
            nazivAnalitike = dokument.getKomitent().getNaziv();
        }
        if ("R".equals(stavka.getTipAnalitike())) {
            if (dokument instanceof Interniracun) {
                if ("W".equals(stavka.getIndikator())) {
                    nazivAnalitike = ((Interniracun)dokument).getIzlaznaRJ().getNaziv();
                } else if ("Q".equals(stavka.getIndikator())) {
                    nazivAnalitike = ((Interniracun)dokument).getUlaznaRJ().getNaziv();
                }
            } else if (dokument.getRadnajedinica() != null) {
                nazivAnalitike = dokument.getRadnajedinica().getNaziv();
            }
        }
        return nazivAnalitike;
    }

    private String formatAnalitika(Radnajedinica rj) {
        return String.valueOf(PzEntityUtil.strZero((String)rj.getId().getOznRj(), (int)3)) + rj.getgTip();
    }

    @Override
    public ShemaProvider getShemaProvider() {
        return this.sProvider;
    }
}

