/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.util;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import rs.pezar.core.PzApplication;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Pzuser;

public class UserLockUtility {
    private static FileLock usrLock;
    private static HashMap<String, List<Object>> map;

    static {
        map = new HashMap();
    }

    public static void lockObject(String username, String objectName) throws Exception {
        RandomAccessFile raf;
        FileChannel channel;
        FileLock lock;
        String lockDir = UserLockUtility.getLockDir();
        if (lockDir == null) {
            return;
        }
        PzApplication.getApplication().getSession().getLoggedUser();
        File lockFile = new File(String.valueOf(lockDir) + File.separator + username + "-" + objectName + ".lock");
        if (!lockFile.exists()) {
            lockFile.createNewFile();
        }
        if ((lock = (channel = (raf = new RandomAccessFile(lockFile, "rw")).getChannel()).tryLock()) == null) {
            throw new UserLockException("Gre\u0161ka! Objekatu " + objectName + " je nemoguce pristupiti.");
        }
        ArrayList<AutoCloseable> l = new ArrayList<AutoCloseable>();
        l.add(lock);
        l.add(channel);
        l.add(raf);
        map.put(String.valueOf(username) + "-" + objectName, l);
    }

    public static void unLockObject(String username, String objectName) throws Exception {
        List<Object> l = map.get(String.valueOf(username) + "-" + objectName);
        if (l == null) {
            return;
        }
        FileLock lock = (FileLock)l.get(0);
        if (lock != null) {
            lock.release();
            ((FileChannel)l.get(1)).close();
            ((RandomAccessFile)l.get(2)).close();
        }
    }

    public static boolean isObjectLocked(String username, String objectName) throws Exception {
        try {
            UserLockUtility.lockObject(username, objectName);
            UserLockUtility.unLockObject(username, objectName);
            return false;
        }
        catch (UserLockException userLockException) {
            return true;
        }
    }

    public static void lockCurrentUser() throws Exception {
        FileChannel channel;
        FileLock lock;
        String lockDir = UserLockUtility.getLockDir();
        if (lockDir == null) {
            return;
        }
        Pzuser user = PzApplication.getApplication().getSession().getLoggedUser();
        File lockFile = new File(String.valueOf(lockDir) + File.separator + user.getPzusername() + ".lock");
        if (!lockFile.exists()) {
            lockFile.createNewFile();
        }
        if ((lock = (channel = new RandomAccessFile(lockFile, "rw").getChannel()).tryLock()) == null) {
            throw new UserLockException("Gre\u0161ka! Korisnik sa imenom [" + user.getPzusername() + "] je vec prijavljen na sistem.");
        }
        usrLock = lock;
    }

    public static boolean isUserLocked() throws Exception {
        try {
            UserLockUtility.lockCurrentUser();
            UserLockUtility.unLockCurrentUser();
            return true;
        }
        catch (UserLockException userLockException) {
            return false;
        }
    }

    public static void unLockCurrentUser() throws Exception {
        if (usrLock != null) {
            usrLock.release();
            Pzuser user = PzApplication.getApplication().getSession().getLoggedUser();
            new File(String.valueOf(UserLockUtility.getLockDir()) + File.separator + user.getPzusername() + ".lock").delete();
        }
    }

    private static String getLockDir() throws Exception {
        Firma fir = PzFirma.getFirma();
        if (fir == null) {
            fir = new Firma();
            fir.setNaziv("firma");
        }
        fir.setNaziv(String.valueOf(fir.getNaziv()) + PzParameter.getParameterValue("TEKUCA_GODINA"));
        String deljeniDir = PzApplication.getApplication().getLocalMachineUserSettings().getString("DELJENI_DIR");
        if (deljeniDir == null) {
            deljeniDir = PzParameter.getParameterValue("DELJENI_DIR");
        }
        if (deljeniDir != null && !deljeniDir.equals("")) {
            File usrDir;
            File firDir = new File(String.valueOf(deljeniDir) + File.separator + fir.getNaziv().replaceAll("\\W", ""));
            if (!firDir.exists()) {
                firDir.mkdir();
            }
            if (!(usrDir = new File(String.valueOf(firDir.getPath()) + File.separator + "usr-lock")).exists()) {
                usrDir.mkdir();
            }
            return usrDir.getPath();
        }
        return null;
    }

    public static class UserLockException
    extends Exception {
        private static final long serialVersionUID = 4822594207928354337L;

        public UserLockException(String message) {
            super(message);
        }
    }
}

