/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.util;

import javax.swing.border.TitledBorder;
import rs.pezar.swing.PzRadioGroup;

public class PzUlazniRacunKategorijaUtil {
    public static final UlazniRacunKategorija SEF = new UlazniRacunKategorija("sef", "SEF");
    public static final UlazniRacunKategorija FISKAL = new UlazniRacunKategorija("fiskal", "Fiskalni ra\u010dun");
    public static final UlazniRacunKategorija OSTALO = new UlazniRacunKategorija("ostalo", "Ostalo");
    public static final UlazniRacunKategorija NEKATEGORISANO = new UlazniRacunKategorija("nekategorisano", "Nekategorisano");
    public static final UlazniRacunKategorija[] SVE_KATEGORIJE = new UlazniRacunKategorija[]{SEF, FISKAL, OSTALO, NEKATEGORISANO};

    public static UlazniRacunKategorija getKategorija(String id) {
        UlazniRacunKategorija kategorija = null;
        int i = 0;
        while (i < SVE_KATEGORIJE.length && kategorija == null) {
            if (SVE_KATEGORIJE[i].getId().equals(id)) {
                kategorija = SVE_KATEGORIJE[i];
            }
            ++i;
        }
        return kategorija;
    }

    private static PzRadioGroup<UlazniRacunKategorija> createGroup(UlazniRacunKategorija[] kategorije) {
        PzRadioGroup<UlazniRacunKategorija> grp = new PzRadioGroup<UlazniRacunKategorija>(kategorije);
        grp.setLayoutAxis(1);
        grp.setBorder(new TitledBorder("Ulazna kategorija"));
        grp.setOpaque(false);
        return grp;
    }

    public static PzRadioGroup<UlazniRacunKategorija> getKategorijeKalkulacija() {
        PzRadioGroup<UlazniRacunKategorija> grp = PzUlazniRacunKategorijaUtil.createGroup(new UlazniRacunKategorija[]{SEF, FISKAL, OSTALO, NEKATEGORISANO});
        grp.setSelectedIndex(0);
        return grp;
    }

    public static PzRadioGroup<UlazniRacunKategorija> getKategorijeTrosak() {
        PzRadioGroup<UlazniRacunKategorija> grp = PzUlazniRacunKategorijaUtil.createGroup(new UlazniRacunKategorija[]{FISKAL, SEF, OSTALO, NEKATEGORISANO});
        return grp;
    }

    public static class UlazniRacunKategorija {
        private String id;
        private String label;

        public UlazniRacunKategorija(String id, String label) {
            this.id = id;
            this.label = label;
        }

        public String getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public String toString() {
            return this.label;
        }
    }
}

