/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;
import net.sourceforge.jtimepiece.JTimepiece;
import rs.pezar.core.format.BDConverter;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Firma;

public class PzDateUtility {
    public static long DAY;
    private static java.sql.Date currentDate;

    static {
        java.sql.Date sd;
        java.sql.Date ldy;
        DAY = 86400000L;
        try {
            ldy = PzDateUtility.getLastDayOfCurrentYear();
            sd = PzDateUtility.getServerDate();
        }
        catch (Exception exception) {
            ldy = new java.sql.Date(new Date().getTime());
            sd = new java.sql.Date(new Date().getTime());
        }
        if (sd.compareTo(ldy) > 0) {
            currentDate = ldy;
        }
    }

    public static java.sql.Date add(java.sql.Date date1, int numDays) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date1.getTime());
        calendar.add(6, numDays);
        return new java.sql.Date(calendar.getTimeInMillis());
    }

    public static int subtract(java.sql.Date date1, java.sql.Date date2) {
        return BDConverter.getRoundedInt(new JTimepiece().getDaysAfter((Date)date2, (Date)date1));
    }

    public static java.sql.Date getCurrentDate() {
        return currentDate != null ? currentDate : new java.sql.Date(new Date().getTime());
    }

    public static void setCurrentDate(java.sql.Date date) {
        currentDate = date;
    }

    public static int getCurrentYear() {
        String year = new SimpleDateFormat("yyyy").format(new Date());
        try {
            year = PzParameter.getParameterValue("TEKUCA_GODINA", year);
        }
        catch (Exception exception) {
            year = new SimpleDateFormat("yyyy").format(new Date());
        }
        return Integer.parseInt(year);
    }

    public static java.sql.Date getFirstDayOfCurrentYear() {
        return java.sql.Date.valueOf(String.valueOf(PzDateUtility.getCurrentYear()) + "-01-01");
    }

    public static java.sql.Date getLastDayOfCurrentYear() {
        return java.sql.Date.valueOf(String.valueOf(PzDateUtility.getCurrentYear()) + "-12-31");
    }

    public static String formatDate(java.sql.Date date) {
        if (date == null) {
            return null;
        }
        return PzFormatFactory.getDateFormat().format(new Date(date.getTime()));
    }

    public static int getNumberDayOfMonth(int month) {
        JTimepiece tp = new JTimepiece();
        Date date = tp.createDate(PzDateUtility.getCurrentYear(), month, 1);
        System.out.println("Broj dana:" + tp.getDayOfMonth(tp.getLastDateOfMonth(date)));
        return tp.getDayOfMonth(tp.getLastDateOfMonth(date));
    }

    public static boolean isDateAlowed(Date date) {
        Date datelimit;
        JTimepiece tp;
        Integer limit = PzDateUtility.getDateLimit();
        return limit <= -1 || !(tp = new JTimepiece()).isAfter(date, datelimit = tp.addDay(new Date(), limit.intValue()));
    }

    public static int getDayOfWeek(java.sql.Date date) {
        JTimepiece tp = new JTimepiece();
        return tp.getDayOfWeek((Date)date);
    }

    public static Integer getDateLimit() {
        return PzParameter.getInteger("DATUM_LIMIT", new Integer(-1));
    }

    public static java.sql.Date getServerDate() {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        java.sql.Date serverDate = PzDateUtility.getServerDate(em);
        em.close();
        return serverDate;
    }

    public static java.sql.Date getServerDate(EntityManager em) {
        CriteriaBuilder cb = em.getCriteriaBuilder();
        Expression date = cb.currentDate();
        CriteriaQuery cq = cb.createQuery();
        cq.select((Selection)date).from(Firma.class);
        java.sql.Date serverDate = (java.sql.Date)em.createQuery(cq).getSingleResult();
        return serverDate;
    }

    public static Timestamp getServerTime() {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        Timestamp serverDate = PzDateUtility.getServerTime(em);
        em.close();
        return serverDate;
    }

    public static Timestamp getServerTime(EntityManager em) {
        CriteriaBuilder cb = em.getCriteriaBuilder();
        Expression date = cb.currentTimestamp();
        CriteriaQuery cq = cb.createQuery();
        cq.select((Selection)date).from(Firma.class);
        Timestamp serverDate = (Timestamp)em.createQuery(cq).getSingleResult();
        return serverDate;
    }

    public static void main(String[] args) throws ParseException {
        java.sql.Date date1 = new java.sql.Date(new SimpleDateFormat("yyyy-MM-dd").parse("2010-12-31").getTime());
        java.sql.Date date2 = new java.sql.Date(new SimpleDateFormat("yyyy-MM-dd").parse("2011-01-04").getTime());
        System.out.println(PzDateUtility.subtract(date2, date1));
    }
}

