/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.fields;

import java.util.List;
import java.util.Vector;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import rs.pezar.swing.fields.PzDocument;
import rs.pezar.swing.fields.PzFieldImpl;
import rs.pezar.swing.fields.PzFieldIndikator;

public class PzTextField
extends PzFieldImpl {
    private PzDocument document;
    private List<?> autocompletions;
    private AutoCompletion ac;
    private boolean completionActive = true;
    private static final long serialVersionUID = 2450268153031750260L;

    public PzTextField() {
        this.setHorizontalAlignment(2);
    }

    public PzTextField(String text) {
        super(text);
        this.setHorizontalAlignment(2);
    }

    public void setMaxLength(int length) {
        this.getDoc().setLimit(length);
    }

    public void setToUpperCase(boolean arg) {
        if (arg) {
            this.getDoc().setToUppercase(true);
        } else {
            this.getDoc().setToUppercase(false);
        }
    }

    private PzDocument getDoc() {
        if (this.document == null) {
            this.document = new PzDocument();
            this.setDocument(this.document);
        }
        return this.document;
    }

    @Override
    public String getVal() {
        return this.getText();
    }

    @Override
    public void setVal(Object value) {
        if (value == null) {
            return;
        }
        if (value.equals("") && this.isFKNotNullField()) {
            this.setState(PzFieldIndikator.STATE_INVALID);
        }
        this.setText(value.toString());
    }

    @Override
    public boolean isValueValid() {
        return !this.getVal().equals("");
    }

    public void setAutoCompletionList(List<?> autocompletions) {
        this.autocompletions = autocompletions;
        this.installAutoCompletion();
        this.setAutocompletionActivated(this.completionActive);
    }

    public void setAutocompletionActivated(boolean activated) {
        this.completionActive = activated;
        if (this.ac != null) {
            this.ac.setAutoCompleteEnabled(activated);
            this.ac.setAutoActivationEnabled(activated);
            this.ac.setAutoActivationDelay(1000);
        }
    }

    private void installAutoCompletion() {
        if (this.autocompletions != null && this.completionActive) {
            if (this.ac != null) {
                this.ac.uninstall();
            }
            this.ac = new AutoCompletion(this.createAutoCompleteProvider());
            this.ac.install((JTextComponent)this);
        }
    }

    private CompletionProvider createAutoCompleteProvider() {
        DefaultCompletionProvider provider = new DefaultCompletionProvider();
        Vector<BasicCompletion> completions = new Vector<BasicCompletion>();
        for (Object o : this.autocompletions) {
            completions.add(new BasicCompletion((CompletionProvider)provider, o.toString()));
        }
        provider.addCompletions(completions);
        provider.setAutoActivationRules(true, null);
        return provider;
    }
}

