/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.event;

import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzField;
import rs.pezar.swing.fields.PzFieldImpl;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzIntegerField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PzInputVerifier
extends InputVerifier {
    private static PzInputVerifier instance;

    public static PzInputVerifier getInstance() {
        if (instance == null) {
            instance = new PzInputVerifier();
        }
        return instance;
    }

    @Override
    public boolean verify(JComponent input) {
        boolean result = true;
        if (input instanceof PzDoubleField) {
            if (((PzDoubleField)input).getVal() == 0.0) {
                result = false;
            }
        } else if (input instanceof PzNumericOnlyTextField) {
            if (((PzNumericOnlyTextField)input).getValue() == null || ((PzNumericOnlyTextField)input).getVal().equals("")) {
                result = false;
            }
        } else if (input instanceof JTextArea) {
            if (((JTextArea)input).getText().equals("")) {
                result = false;
            }
        } else if (input instanceof PzTextField) {
            if (((PzTextField)input).getText().equals("")) {
                result = false;
            }
        } else if (input instanceof PzIntegerField) {
            if (((PzIntegerField)input).getVal().equals(new Integer(0))) {
                result = false;
            }
        } else if (input instanceof PzDateField) {
            if (!((PzDateField)input).isValueValid()) {
                result = false;
            } else {
                if (((PzDateField)input).getText().equals("  .  .    ")) {
                    ((PzDateField)input).setVal(((PzDateField)input).getDefaultDate());
                    return true;
                }
                result = ((PzDateField)input).getYear() != PzDateUtility.getCurrentYear() ? PzSwingUtility.daNeDijalog(input, "Datum nije iz teku\u0107e godine! Da li ste sigurni da \u017eelite da nastavite?", "Mogu\u0107a gre\u0161ka", null, false) == 0 : true;
            }
        }
        if (((PzFieldImpl)input).getCustomInputVerifier() != null && !((PzFieldImpl)input).getCustomInputVerifier().verify(input)) {
            result = false;
        }
        if (result) {
            ((PzField)((Object)input)).setState(PzFieldIndikator.STATE_VALID);
        } else {
            ((PzField)((Object)input)).setState(PzFieldIndikator.STATE_INVALID);
        }
        return result;
    }

    @Override
    public boolean shouldYieldFocus(JComponent input) {
        return this.verify(input);
    }
}

