/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.data.models;

import java.util.Vector;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.db.PzEntity;
import rs.pezar.swing.data.models.PzManageableTableModel;

public class PzScrollableTableModelEntity
extends PzManageableTableModel {
    private static final long serialVersionUID = 1L;
    private ScrollableCursor cursor;
    ScrollableMap map;

    public PzScrollableTableModelEntity() {
    }

    public PzScrollableTableModelEntity(ScrollableCursor cursor) {
        this.cursor = cursor;
        this.map = new ScrollableMap(cursor);
    }

    public void setScrollableCursor(ScrollableCursor cursor) {
        this.cursor = cursor;
        this.map = new ScrollableMap(cursor);
        super.refresh();
    }

    public ScrollableCursor getCursor() {
        return this.cursor;
    }

    @Override
    public synchronized void insert(PzEntity entity) {
        this.insertCheckBoxRowAt(this.map.size());
        this.map.insert(entity);
        super.refresh();
    }

    @Override
    public synchronized void update(int index, PzEntity entity) {
        this.map.update(index, entity);
    }

    @Override
    public synchronized void remove(int index) {
        this.map.delete(index);
        this.removeCheckBoxRow(index);
    }

    @Override
    public synchronized int getRowCount() {
        return this.map.size();
    }

    @Override
    public synchronized PzEntity getEntity(int index) {
        return this.map.get(index);
    }

    private static class ScrollableMap {
        public static boolean CURSOR = false;
        public static boolean STORAGE = true;
        Vector<MapElement> map;
        private ScrollableCursor cursor;
        private Vector<PzEntity> storage;

        public ScrollableMap(ScrollableCursor cursor) {
            this.cursor = cursor;
            this.storage = new Vector();
            this.map = new Vector();
            if (cursor != null) {
                int i = 0;
                while (i < cursor.size()) {
                    this.map.addElement(new MapElement(i, CURSOR));
                    ++i;
                }
            }
        }

        public PzEntity get(int i) {
            if (this.map.size() == 0) {
                return null;
            }
            if (this.map.elementAt(i).getReadFrom() == CURSOR && this.cursor != null) {
                if (this.cursor.absolute(this.map.elementAt(i).getId())) {
                    return (PzEntity)this.cursor.next();
                }
                return null;
            }
            return this.storage.elementAt(this.map.elementAt(i).getId());
        }

        public void insert(PzEntity entity) {
            int id = this.storage.size();
            this.storage.addElement(entity);
            this.map.addElement(new MapElement(id, STORAGE));
        }

        public void update(int i, PzEntity entity) {
            if (this.map.elementAt(i).getReadFrom() == STORAGE) {
                this.storage.setElementAt(entity, this.map.elementAt(i).getId());
            } else {
                int id = this.storage.size();
                this.storage.addElement(entity);
                this.map.elementAt(i).setId(id);
                this.map.elementAt(i).setReadFrom(STORAGE);
            }
        }

        public void delete(int i) {
            this.map.remove(i);
        }

        public int size() {
            return this.map.size();
        }

        private static class MapElement {
            private int id;
            private boolean readFrom;

            public MapElement(int id, boolean readFrom) {
                this.id = id;
                this.readFrom = readFrom;
            }

            public int getId() {
                return this.id;
            }

            public void setId(int id) {
                this.id = id;
            }

            public boolean getReadFrom() {
                return this.readFrom;
            }

            public void setReadFrom(boolean readFrom) {
                this.readFrom = readFrom;
            }
        }
    }
}

