/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.data.models;

import java.util.Arrays;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cheffo.jeplite.ParseException;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.swing.data.models.PzAbstractTableModel;

public class PzScrollableTableModel
extends PzAbstractTableModel {
    private volatile ScrollableCursor cursor;
    private Vector<String> columns;
    ColumnLookup columnLookup;

    public PzScrollableTableModel() {
    }

    public PzScrollableTableModel(ScrollableCursor cursor, String[] columns) {
        this.cursor = cursor;
        this.columns = new Vector<String>(Arrays.asList(columns));
        this.columnLookup = new ColumnLookup(cursor, this);
    }

    public synchronized void setScrollableCursor(ScrollableCursor cursor) {
        this.cursor = cursor;
        this.columnLookup = new ColumnLookup(cursor, this);
    }

    public synchronized ScrollableCursor getCursor() {
        return this.cursor;
    }

    @Override
    public synchronized int getColumnCount() {
        if (this.columns == null || this.cursor == null || this.cursor.isClosed()) {
            return 0;
        }
        return this.columns.size();
    }

    @Override
    public synchronized String getColumnName(int columnIndex) {
        if (this.columns == null || this.cursor.isClosed()) {
            return null;
        }
        return this.columns.elementAt(columnIndex);
    }

    @Override
    public synchronized int getRowCount() {
        if (this.cursor == null || this.cursor.isClosed()) {
            return 0;
        }
        return this.cursor.size();
    }

    @Override
    public synchronized Object getValueAt(int rowIndex, int columnIndex) {
        try {
            return this.columnLookup.getValueAtLookup(rowIndex, columnIndex);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public synchronized boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public synchronized void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        throw new IllegalArgumentException("Cannot set value on scrollable table!");
    }

    public void insertColumn(int column, String expression, String columnName) {
        String pattern = null;
        Matcher m = null;
        Pattern p = null;
        String replace = "";
        int i = 0;
        while (i < expression.length() - 1) {
            if (!expression.substring(i, i + 1).equalsIgnoreCase("$")) {
                replace = String.valueOf(replace) + expression.substring(i, i + 1);
            } else {
                String pomocni = expression.substring(i, i + 2);
                while (!pomocni.endsWith("$")) {
                    pomocni = String.valueOf(pomocni) + expression.substring(i + 2, i + 3);
                    ++i;
                }
                int j = 0;
                while (j < this.getColumnCount()) {
                    pattern = "\\$" + j + "\\$";
                    p = Pattern.compile(pattern);
                    m = p.matcher(pomocni);
                    if (m.find() && j >= column) {
                        replace = String.valueOf(replace) + pomocni.replaceAll("\\$" + j + "\\$", "\\$" + (j + 1) + "\\$");
                        ++i;
                        break;
                    }
                    m = p.matcher(pomocni);
                    if (m.find() && j < column) {
                        replace = String.valueOf(replace) + pomocni;
                        ++i;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.columns.insertElementAt(columnName, column);
        this.columnLookup.insert(replace, column);
        this.fireTableStructureChanged();
    }

    private static class ColumnLookup {
        public static boolean CURSOR = false;
        public static boolean STORAGE = true;
        PzAbstractTableModel model;
        Vector<MapElement> lookup;
        private ScrollableCursor cursor;
        private Vector<String> storage;

        public ColumnLookup(ScrollableCursor cursor, PzScrollableTableModel model) {
            this.model = model;
            this.cursor = cursor;
            this.storage = new Vector();
            this.lookup = new Vector();
            if (cursor != null && cursor.size() != 0) {
                cursor.absolute(0);
                Object[] nizObjekata = (Object[])cursor.next();
                int i = 0;
                while (i < nizObjekata.length) {
                    this.lookup.addElement(new MapElement(i, CURSOR));
                    ++i;
                }
            }
        }

        public Object getValueAtLookup(int row, int column) throws ParseException {
            this.cursor.absolute(row);
            if (this.lookup.elementAt(column).getReadFrom() == CURSOR) {
                return ((Object[])this.cursor.next())[this.lookup.elementAt(column).getId()];
            }
            return this.model.calculateExpression(this.storage.get(this.lookup.elementAt(column).getId()), row);
        }

        public void insert(String value, int column) {
            this.storage.addElement(value);
            this.lookup.insertElementAt(new MapElement(this.storage.size() - 1, STORAGE), column);
        }
    }

    private static class MapElement {
        private int id;
        private boolean readFrom;

        public MapElement(int id, boolean readFrom) {
            this.id = id;
            this.readFrom = readFrom;
        }

        public int getId() {
            return this.id;
        }

        public boolean getReadFrom() {
            return this.readFrom;
        }
    }
}

