/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.data.models;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.table.AbstractTableModel;
import org.cheffo.jeplite.JEP;
import org.cheffo.jeplite.ParseException;
import rs.pezar.core.format.BDConverter;

public abstract class PzAbstractTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -8847742730600265113L;
    protected JEP jep;

    public double calculateExpression(String expression, int row) throws ParseException {
        String expression1 = new String(expression);
        String pattern = null;
        Matcher m = null;
        Pattern p = null;
        int i = 0;
        while (i < this.getColumnCount()) {
            pattern = "\\$" + i + "\\$";
            p = Pattern.compile(pattern);
            m = p.matcher(expression1);
            if (m.find()) {
                if (this.isNumeric(this.getValueAt(row, i)) || this.getValueAt(row, i) == null) {
                    String regex = "\\$" + i + "\\$";
                    expression1 = expression1.replaceAll(regex, this.getValueAt(row, i) == null ? "0" : this.getValueAt(row, i).toString());
                } else {
                    throw new NumberFormatException("Vrednost izraza $" + i + " nije numerickog tipa");
                }
            }
            ++i;
        }
        this.jep = new JEP();
        this.jep.parseExpression(expression1);
        double value = this.jep.getValue();
        return value;
    }

    private boolean isNumeric(Object val) {
        if (val == null) {
            return false;
        }
        try {
            Double.parseDouble(val.toString());
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public double sumAll(String expression) throws ParseException {
        return this.sum(0, this.getRowCount() - 1, expression);
    }

    public BigDecimal[] sumAll(String[] expressions) throws ParseException {
        return this.sum(0, this.getRowCount() - 1, expressions);
    }

    public double sum(int startRow, int endRow, String expression) throws ParseException {
        BigDecimal suma = new BigDecimal(0);
        String expression1 = "";
        int i = startRow;
        while (i < endRow + 1) {
            expression1 = new String(expression);
            int j = 0;
            while (j < this.getColumnCount()) {
                expression1 = expression1.replaceAll("\\$" + j + "\\$", this.getValueAt(i, j) != null ? this.getValueAt(i, j).toString() : "0");
                ++j;
            }
            this.jep = new JEP();
            this.jep.parseExpression(expression1);
            suma = suma.add(BDConverter.getIznos(this.jep.getValue()));
            ++i;
        }
        return suma.doubleValue();
    }

    public BigDecimal[] sum(int startRow, int endRow, String[] expressions) throws ParseException {
        BigDecimal[] suma = new BigDecimal[expressions.length];
        if (endRow < startRow) {
            int i = 0;
            while (i < suma.length) {
                suma[i] = BigDecimal.ZERO;
                ++i;
            }
        }
        String[] expressions1 = null;
        this.jep = new JEP();
        int i = startRow;
        while (i < endRow + 1) {
            expressions1 = new String[expressions.length];
            int j = 0;
            while (j < this.getColumnCount()) {
                int k = 0;
                while (k < expressions1.length) {
                    if (expressions1[k] == null) {
                        expressions1[k] = expressions[k];
                    }
                    expressions1[k] = expressions1[k].replaceAll("\\$" + j + "\\$", this.getValueAt(i, j) != null ? this.getValueAt(i, j).toString() : "0");
                    ++k;
                }
                ++j;
            }
            int k = 0;
            while (k < expressions1.length) {
                this.jep.parseExpression(expressions1[k]);
                if (suma[k] == null) {
                    suma[k] = new BigDecimal(0);
                }
                suma[k] = suma[k].add(new BigDecimal(this.jep.getValue()));
                ++k;
            }
            ++i;
        }
        return suma;
    }

    public int getColumnIndexByName(String name) {
        int rez = -1;
        int i = 0;
        while (i < this.getColumnCount()) {
            if (this.getColumnName(i).equalsIgnoreCase(name)) {
                rez = i;
                break;
            }
            ++i;
        }
        return rez;
    }
}

