/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing;

import java.awt.Component;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.swing.PzManageableTable;
import rs.pezar.swing.data.models.PzTableModel;
import rs.pezar.swing.event.PzTablePropertyListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class PzTable
extends PzManageableTable {
    private static final long serialVersionUID = 1991139907228783253L;
    public static PzEntity selectedEntity;
    private String dbTableName;

    public PzTable(TableModel model) {
        super(model);
    }

    public PzTable(Vector<PzEntity> data) {
        PzTableModel tblModel = new PzTableModel(data);
        this.setModel(tblModel);
        this.setSelection();
    }

    public PzTable(List<? extends PzEntity> data, Class<?> type) {
        try {
            PzTableModel tblModel = new PzTableModel(data, type);
            this.setModel(tblModel);
            this.setSelection();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(SwingUtilities.getRoot((Component)((Object)this)), e);
        }
    }

    public PzTable(Class<?> c) {
        this.dbTableName = c.getName().replaceAll(String.valueOf(c.getPackage().getName()) + ".", "");
        try {
            Vector<PzEntity> data = PzEntityManager.selectAll(this.dbTableName);
            this.setModel(new PzTableModel(data, c));
            this.setSelection();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(SwingUtilities.getRoot((Component)((Object)this)), e);
        }
    }

    public void setData(List<? extends PzEntity> data, Class<?> type) {
        try {
            ((PzTableModel)this.getModel()).setData(data, type);
            this.restoreState();
            this.setSelection();
            this.setSorting();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(SwingUtilities.getRoot((Component)((Object)this)), e);
        }
    }

    public void setData(Vector<PzEntity> data, Class<?> type) {
        try {
            ((PzTableModel)this.getModel()).setData(data, type);
            this.restoreState();
            this.setSelection();
            this.setSorting();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(SwingUtilities.getRoot((Component)((Object)this)), e);
        }
    }

    public PzTable() {
        this.setModel(new PzTableModel());
        this.setSelection();
    }

    public List<PzEntity> getAllEntities() {
        return ((PzTableModel)this.getModel()).getData();
    }

    public void search(PzEntity entity) {
        try {
            Vector<PzEntity> data = PzEntityManager.search(entity);
            ((PzTableModel)this.getModel()).setData(data, entity.getClass());
            this.selectRow(0);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(SwingUtilities.getRoot((Component)((Object)this)), e);
        }
    }

    public void search(Class<PzEntity> type, String fieldName, Object fieldValue) {
        String tableName = type.getName().replaceAll(String.valueOf(type.getPackage().getName()) + ".", "");
        try {
            EntityManager em = PzEntityManager.getEm();
            Query q = em.createQuery("SELECT e FROM " + tableName + " WHERE " + fieldName + "=:fieldValue");
            q.setParameter("fieldValue", fieldValue);
            Vector data = (Vector)q.getResultList();
            ((PzTableModel)this.getModel()).setData(data, type);
            this.selectRow(0);
            em.close();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(SwingUtilities.getRoot((Component)((Object)this)), e);
        }
    }

    public void queryDB(String query) {
        try {
            Vector<PzEntity> data = PzEntityManager.select(query);
            ((PzTableModel)this.getModel()).setData(data);
            this.selectRow(0);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(SwingUtilities.getRoot((Component)((Object)this)), e);
        }
    }

    public void setPropertyListener(PzTablePropertyListener listener) {
        ((PzTableModel)this.getModel()).setPropertyListener(listener);
    }

    public void refreshData() {
        int row = this.getSelectedRow();
        this.getRowCount();
        ((PzTableModel)this.getModel()).fireTableDataChanged();
        try {
            if (row != -1) {
                this.setRowSelectionInterval(row, row);
            } else {
                this.setRowSelectionInterval(0, 0);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Override
    public void clear() {
        ((PzTableModel)this.getModel()).setData(new Vector<PzEntity>());
        this.refreshData();
    }

    public int getDataSize() {
        return ((PzTableModel)this.getModel()).size();
    }

    public void replaceEntity(PzEntity entity) {
        this.getAllEntities().remove(entity);
    }
}

