/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import rs.pezar.calculator.Calculator;
import rs.pezar.core.PzApplication;
import rs.pezar.core.PzGlobalKeyboardShortcutRegistry;
import rs.pezar.db.PzEntity;
import rs.pezar.db.commons.PzSettings;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.PzDialogSession;
import rs.pezar.swing.event.PzShortcutListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.util.PzUtil;

public abstract class PzDialog
extends JDialog
implements Action {
    private static final long serialVersionUID = 4321509254720823338L;
    private Object data1;
    private Object data2;
    private PzDialog parentDialog;
    private PzDialog childDialog;
    private PzDialogSession dialogSession;
    private boolean closeOnEnter;
    private Vector<PzAbstractTable> tables;
    private String id;
    private PzShortcutListener shortcutListener;
    private boolean exposed;
    private boolean restorable;

    public PzDialog(JFrame frame) {
        super(frame);
        this.init();
    }

    public PzDialog() {
        this.init();
    }

    public PzDialog(PzDialog parent) {
        super(parent);
        if (parent != null) {
            this.setParentDialog(parent);
            if (parent.getChildDialog() == null) {
                parent.setChildDialog(this);
            }
        }
        this.init();
    }

    public PzDialog(JFrame frame, String parameter) {
        super(frame);
        this.init();
    }

    private void init() {
        this.setName(this.getClass().getName());
        this.setDefaultCloseOperation(2);
        this.setRestorable(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent arg0) {
                if (PzDialog.this.dialogSession == null) {
                    PzDialog.this.setEnabled(true);
                    PzDialog.this.getFocusTraversalPolicy().getInitialComponent(PzDialog.this).requestFocusInWindow();
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
                PzDialog.this.thisWindowClosing(e);
            }
        });
    }

    public void setOptimalSize() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle bounds = ge.getMaximumWindowBounds();
        this.setBounds(bounds);
        this.setLocation(0, 0);
    }

    public void restoreTable(PzAbstractTable table) {
        try {
            if (table.getColumnCount() > 0) {
                table.restoreState();
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(e);
            table.saveState();
        }
    }

    protected void thisWindowClosing(WindowEvent evt) {
        try {
            if (!this.exposed) {
                return;
            }
            this.exposed = false;
            PzSettings.setDimension(this.getClass().getName(), this.getId(), this.getSize());
            PzSettings.setLocation(this.getClass().getName(), this.getId(), this.getLocation());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(this, e);
        }
    }

    private void recurseComponents(Container container) {
        int i = 0;
        while (i < container.getComponents().length) {
            if (container.getComponents()[i] instanceof PzAbstractTable) {
                this.tables.add((PzAbstractTable)((Object)container.getComponents()[i]));
            } else if (container.getComponents()[i] instanceof JScrollPane) {
                this.recurseComponents(((JScrollPane)container.getComponents()[i]).getViewport());
            } else if (container.getComponents()[i] instanceof Container) {
                this.recurseComponents((Container)container.getComponents()[i]);
            }
            ++i;
        }
    }

    private Vector<PzAbstractTable> findTables(Container container) {
        Vector<PzAbstractTable> result = new Vector<PzAbstractTable>();
        int i = 0;
        while (i < container.getComponents().length) {
            if (container.getComponents()[i] instanceof PzAbstractTable) {
                result.add((PzAbstractTable)((Object)container.getComponents()[i]));
            } else if (container.getComponents()[i] instanceof JScrollPane) {
                result.addAll(this.findTables((Container)container.getComponents()[i]));
            } else if (container.getComponents()[i] instanceof Container) {
                result.addAll(this.findTables((Container)container.getComponents()[i]));
            }
            ++i;
        }
        return result;
    }

    public void restoreSize() {
        try {
            Point p;
            Dimension d = PzSettings.getDimension(this.getClass().getName(), this.getId());
            if (d != null) {
                this.setPreferredSize(d);
                this.setSize(d);
            }
            if ((p = PzSettings.getLocation(this.getClass().getName(), this.getId())) != null) {
                this.setLocation(p);
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(this, e);
        }
    }

    @Override
    public abstract void actionPerformed(ActionEvent var1);

    @Override
    public Object getValue(String s) {
        return null;
    }

    @Override
    public void putValue(String s, Object obj) {
    }

    private void runDialog(PzDialog dialog, PzDialog parent) throws InterruptedException, InvocationTargetException {
        PzDialogStarterThread trd = new PzDialogStarterThread(dialog, parent);
        trd.run();
    }

    private void runDialog(PzDialog dialog, PzDialog parent, boolean modal, boolean restoreSize, boolean visible) throws InterruptedException, InvocationTargetException {
        PzDialogStarterThread trd = new PzDialogStarterThread(dialog, parent, modal, restoreSize, visible);
        trd.run();
    }

    public void showDialog(Class<? extends PzDialog> dialogClass) {
        try {
            Constructor<? extends PzDialog> c = dialogClass.getConstructor(Class.forName("rs.pezar.swing.PzDialog"));
            PzDialog dialog = c.newInstance(this);
            this.runDialog(dialog, this);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(this, e);
        }
    }

    public void showDialog(PzDialog child) {
        try {
            this.runDialog(child, this);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(this, e);
        }
    }

    public PzDialog showDialog(Class<? extends PzDialog> dialogClass, PzDialog parent, boolean modal, boolean restoreSize, boolean visible) {
        try {
            Constructor<? extends PzDialog> c = dialogClass.getConstructor(Class.forName("rs.pezar.swing.PzDialog"));
            PzDialog dialog = c.newInstance(parent);
            this.runDialog(dialog, parent, modal, restoreSize, visible);
            return dialog;
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(this, e);
            return null;
        }
    }

    protected void showDialog(String className) {
        try {
            String packageName = this.getClass().getPackage().getName();
            Class<?> dlg = Class.forName(String.valueOf(packageName) + "." + className);
            Constructor<?> c = dlg.getConstructor(Class.forName("rs.pezar.swing.PzDialog"));
            PzDialog dialog = (PzDialog)c.newInstance(this);
            this.runDialog(dialog, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void showDialog(String className, boolean arg, Object data1, Object data2) {
        try {
            String packageName = this.getClass().getPackage().getName();
            Class<?> dlg = Class.forName(String.valueOf(packageName) + "." + className);
            Constructor<?> c = dlg.getConstructor(Class.forName("rs.pezar.swing.PzDialog"), Boolean.TYPE, Object.class, Object.class);
            PzDialog dialog = (PzDialog)c.newInstance(this, arg, data1, data2);
            this.runDialog(dialog, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void showDialog(String className, ClassLoader loader, boolean arg, Object data1, Object data2) {
        try {
            String packageName = this.getClass().getPackage().getName();
            Class<?> dlg = Class.forName(String.valueOf(packageName) + "." + className, true, loader);
            Constructor<?> c = dlg.getConstructor(Class.forName("rs.pezar.swing.PzDialog"), Boolean.TYPE, Object.class, Object.class);
            PzDialog dialog = (PzDialog)c.newInstance(this, arg, data1, data2);
            this.runDialog(dialog, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void showDialog(Class<?> dialogClass, boolean arg, Object data1, Object data2) {
        try {
            Constructor<?> c = dialogClass.getConstructor(PzDialog.class, Boolean.TYPE, Object.class, Object.class);
            PzDialog dialog = (PzDialog)c.newInstance(this, arg, data1, data2);
            this.runDialog(dialog, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void showDialogFullPath(String path, boolean arg, Object data1, Object data2) {
        try {
            Class<?> dlg = Class.forName(path);
            Constructor<?> c = dlg.getConstructor(Class.forName("rs.pezar.swing.PzDialog"), Boolean.TYPE, Object.class, Object.class);
            PzDialog dialog = (PzDialog)c.newInstance(this, arg, data1, data2);
            this.runDialog(dialog, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object getData1() {
        return this.data1;
    }

    public void setData1(Object data1) {
        this.data1 = data1;
    }

    public Object getData2() {
        return this.data2;
    }

    public void setData2(Object data2) {
        this.data2 = data2;
    }

    public boolean shouldBeShown() {
        return true;
    }

    public void setEntity(PzEntity entity, Component component) {
    }

    public void setFirstComponentInFocus(Component c) {
        SwingUtilities.invokeLater(new FocusRequester(c));
    }

    public void addShortCuts() {
        JRootPane rootPane = this.getRootPane();
        KeyStroke strokeESC = KeyStroke.getKeyStroke("ESCAPE");
        AbstractAction actionListener = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PzDialog.this.setVisible(false);
                PzDialog.this.dispose();
            }
        };
        AbstractAction calcListener = new AbstractAction(){
            private static final long serialVersionUID = 6300355482467885061L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PzDialog.this.showDialog(Calculator.class);
            }
        };
        InputMap inputMap = rootPane.getInputMap(2);
        inputMap.put(strokeESC, "ESCAPE");
        rootPane.getActionMap().put("ESCAPE", actionListener);
        inputMap.put(KeyStroke.getKeyStroke("alt F9"), "CALC");
        rootPane.getActionMap().put("CALC", calcListener);
        for (PzGlobalKeyboardShortcutRegistry.Entry ent : PzApplication.getApplication().getShortcutRegistry().getShortcuts()) {
            inputMap.put(PzUtil.shortcutToKeyStroke(ent.getShortcut()), ent.getName());
            rootPane.getActionMap().put(ent.getName(), ent.getAction());
        }
    }

    public void registerShortcut(final String keys) {
        String[] key = keys.split("\\+");
        String keyStrokeStr = "";
        String separator = " ";
        int i = 0;
        while (i < key.length) {
            if (i == key.length - 1) {
                separator = "";
            }
            if (key[i].equalsIgnoreCase("alt") || key[i].equalsIgnoreCase("ctrl") || key[i].equalsIgnoreCase("shift")) {
                if (key[i].equalsIgnoreCase("ctrl")) {
                    key[i] = "control";
                }
                key[i] = key[i].toLowerCase();
            } else {
                key[i] = key[i].equalsIgnoreCase("backspace") ? "BACK_SPACE" : key[i].toUpperCase();
            }
            key[i] = String.valueOf(key[i]) + separator;
            keyStrokeStr = String.valueOf(keyStrokeStr) + key[i];
            ++i;
        }
        KeyStroke stroke = KeyStroke.getKeyStroke(keyStrokeStr);
        this.getRootPane().getInputMap(2).put(stroke, keyStrokeStr);
        AbstractAction shortcutAction = new AbstractAction(){
            private static final long serialVersionUID = 6300355482467885061L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (PzDialog.this.shortcutListener != null) {
                    PzDialog.this.shortcutListener.actionPerformed(new PzShortcutListener.PzShortcutEvent(keys, PzDialog.this));
                }
            }
        };
        shortcutAction.putValue("command", keys);
        this.getRootPane().getActionMap().put(keyStrokeStr, shortcutAction);
    }

    public void registerShortcuts(String[] shortcuts) {
        int i = 0;
        while (i < shortcuts.length) {
            this.registerShortcut(shortcuts[i]);
            ++i;
        }
    }

    protected PzShortcutListener getShortcutListener() {
        return this.shortcutListener;
    }

    public void setShortcutListener(PzShortcutListener shortcutListener) {
        this.shortcutListener = shortcutListener;
    }

    public PzDialog getParentDialog() {
        return this.parentDialog;
    }

    public void setParentDialog(PzDialog dialog) {
        this.parentDialog = dialog;
    }

    public void setChildDialog(PzDialog dialog) {
        this.childDialog = dialog;
    }

    public PzDialog getChildDialog() {
        return this.childDialog;
    }

    public void setDialogSessionOwner(boolean arg) {
        if (arg) {
            this.dialogSession = new PzDialogSession();
            this.dialogSession.setFirstDialog(this);
        } else {
            this.dialogSession = null;
        }
    }

    public PzDialogSession getSession() {
        return this.seekSession(this);
    }

    private PzDialogSession seekSession(PzDialog dlg) {
        if (dlg == null) {
            return null;
        }
        if (dlg.getDialogSession() != null) {
            return dlg.getDialogSession();
        }
        return this.seekSession(dlg.getParentDialog());
    }

    private PzDialogSession getDialogSession() {
        return this.dialogSession;
    }

    public boolean shouldCloseOnEnter() {
        return this.closeOnEnter;
    }

    public void setCloseOnEnter(boolean arg) {
        this.closeOnEnter = arg;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id != null ? this.id : "DIALOG";
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.exposed = true;
        }
        this.addShortCuts();
        super.setVisible(b);
    }

    @Override
    public void dispose() {
        if (this.getParentDialog() != null) {
            this.getParentDialog().setChildDialog(null);
        }
        super.dispose();
    }

    public boolean isRestorable() {
        return this.restorable;
    }

    public void setRestorable(boolean restorable) {
        this.restorable = restorable;
    }

    class FocusRequester
    implements Runnable {
        private Component c;

        public FocusRequester(Component c) {
            this.c = c;
        }

        @Override
        public void run() {
            this.c.requestFocusInWindow();
        }
    }

    private static class PzDialogStarterThread {
        private PzDialog dialog;
        private boolean restoreSize;
        private PzDialog parent;
        private boolean modal;
        private boolean visible;

        public PzDialogStarterThread(PzDialog dlg, PzDialog parent, boolean modal, boolean restoreSize, boolean visible) {
            this.dialog = dlg;
            this.restoreSize = restoreSize;
            this.parent = parent;
            this.modal = modal;
            this.visible = visible;
        }

        public PzDialogStarterThread(PzDialog dlg, PzDialog parent) {
            this(dlg, parent, true, true, true);
        }

        public void run() {
            if (this.parent.getChildDialog() != this.dialog) {
                this.dialog.dispose();
                return;
            }
            this.parent.setChildDialog(this.dialog);
            this.dialog.setParentDialog(this.parent);
            if (this.dialog.shouldBeShown()) {
                if (this.modal) {
                    this.dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
                }
                this.dialog.setLocationRelativeTo(this.parent);
                if (this.restoreSize && this.dialog.isRestorable()) {
                    this.dialog.restoreSize();
                }
                if (this.visible) {
                    this.dialog.setEnabled(false);
                    this.dialog.setVisible(true);
                }
            } else {
                this.dialog.dispose();
            }
            this.parent.setChildDialog(null);
        }
    }
}

