/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.management;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.jxpath.JXPathContext;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Standardnaporuka;
import rs.pezar.util.PzExpressionParser;

public class PzPorukeManager {
    private static final String FUNCTION_PATTERN = "\\$.+?\\(.+?\\)";
    private static final String FIELD_PATTERN = "DOK\\{.+?\\}";
    private static final String LIST_PATTERN = "LIST\\{.+?\\}";

    public static String getStandardnaPoruka(PzDokument dokument) {
        List<String> poruke = PzPorukeManager.getPoruke(dokument);
        String rez = "";
        if (poruke != null && poruke.size() > 0) {
            for (String s : poruke) {
                rez = String.valueOf(rez) + s + "\n";
            }
        }
        if (rez.trim().length() == 0) {
            rez = "";
        }
        return rez;
    }

    public static List<String> getPoruke(PzDokument dokument) {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        List<String> poruke = PzPorukeManager.getPoruke(dokument, em);
        em.close();
        return poruke;
    }

    public static List<String> getPoruke(PzDokument dokument, EntityManager em) {
        Firma f = PzFirma.getFirma(em);
        Vector<String> poruke = new Vector<String>();
        List sPoruke = em.createQuery("SELECT p from Standardnaporuka p WHERE p.tipDokumenta='" + dokument.getTip() + "'").getResultList();
        if (sPoruke == null || sPoruke.size() == 0) {
            return poruke;
        }
        for (Standardnaporuka poruka : sPoruke) {
            if (!PzPorukeManager.parseBooleanExpression(poruka.getUslov(), dokument).booleanValue()) continue;
            poruka.setSadrzaj(poruka.getSadrzaj().replaceAll("#MESTOREG#", f.getMestoReg()));
            poruke.add(PzPorukeManager.parseStringExpression(poruka.getSadrzaj(), dokument));
        }
        return poruke;
    }

    public static List<String> getPoruke(String naziv) {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        List<String> poruke = PzPorukeManager.getPoruke(naziv, em);
        em.close();
        return poruke;
    }

    public static List<String> getPoruke(String naziv, EntityManager em) {
        Vector<String> poruke = new Vector<String>();
        Firma f = PzFirma.getFirma(em);
        List sPoruke = em.createQuery("SELECT p from Standardnaporuka p WHERE p.naziv='" + naziv + "'").getResultList();
        if (sPoruke == null || sPoruke.size() == 0) {
            return poruke;
        }
        for (Standardnaporuka poruka : sPoruke) {
            poruke.add(poruka.getSadrzaj().replaceAll("#MESTOREG#", f.getMestoReg()));
        }
        return poruke;
    }

    public static String getPoruka(String tipDok) {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        String poruka = PzPorukeManager.getPoruka(tipDok, em);
        em.close();
        return poruka;
    }

    public static String getPoruka(String tip, EntityManager em) {
        Firma f = PzFirma.getFirma(em);
        String poruka = "";
        List sPoruke = em.createQuery("SELECT p from Standardnaporuka p WHERE p.tipDokumenta='" + tip + "'").getResultList();
        if (sPoruke == null || sPoruke.size() == 0) {
            return poruka;
        }
        poruka = ((Standardnaporuka)sPoruke.get(0)).getSadrzaj().replaceAll("#MESTOREG#", f.getMestoReg());
        return poruka;
    }

    public static String parseStringExpression(String opis, PzDokument dokument) throws IllegalArgumentException {
        if (opis == null) {
            return "";
        }
        Pattern pattern = Pattern.compile(FIELD_PATTERN);
        String expRes = new String(opis);
        Matcher m = pattern.matcher(opis);
        new Vector();
        while (m.find()) {
            String oName = m.group();
            String fName = oName.substring(4, oName.length() - 1);
            try {
                Object value = PropertyUtils.getProperty((Object)dokument, (String)fName);
                expRes = expRes.replace(oName, value != null ? value.toString() : "");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Greska prilikom pristupa polju '" + fName + "' dokumenta " + dokument.getClass().getSimpleName(), e);
            }
        }
        pattern = Pattern.compile(FUNCTION_PATTERN);
        m = pattern.matcher(expRes);
        String function = "";
        String rFunction = "";
        String result = new String(expRes);
        try {
            while (m.find()) {
                function = m.group();
                rFunction = function.substring(1).replace("(", "('").replace(")", "')");
                result = result.replace(function, PzExpressionParser.getString(rFunction).replace("'", ""));
            }
            return result;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Greska prilikom parsiranja izraza : " + rFunction, e);
        }
    }

    public static Boolean parseBooleanExpression(String expression, PzDokument dokument) throws IllegalArgumentException {
        String oName;
        if (expression == null || expression.equals("")) {
            return Boolean.TRUE;
        }
        String expRes = new String(expression);
        Pattern pattern = Pattern.compile(FIELD_PATTERN);
        Matcher m = pattern.matcher(expression);
        new Vector();
        while (m.find()) {
            oName = m.group();
            String fName = oName.substring(4, oName.length() - 1);
            try {
                Object value = JXPathContext.newContext((Object)dokument).getValue(fName);
                if (value instanceof String) {
                    expRes = expRes.replace(oName, "'" + value.toString() + "'");
                    continue;
                }
                expRes = expRes.replace(oName, value.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        expRes = expRes.replaceAll(FIELD_PATTERN, "0");
        pattern = Pattern.compile(LIST_PATTERN);
        m = pattern.matcher(expRes);
        String list = "";
        while (m.find()) {
            oName = m.group();
            String lName = oName.substring(5, oName.length() - 1);
            Iterator i = JXPathContext.newContext((Object)dokument).iterate(lName);
            while (i.hasNext()) {
                list = String.valueOf(list) + i.next() + ",";
            }
            if (!list.endsWith(",")) continue;
            list = list.substring(0, list.length() - 1);
            expRes = expRes.replace(oName, list);
        }
        expRes = expRes.replaceAll(LIST_PATTERN, "0");
        try {
            return PzExpressionParser.getBoolean(expRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

