/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.management;

import java.math.BigDecimal;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import rs.pezar.core.PzApplication;
import rs.pezar.core.RuleKep;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDefaultDokumentCustomizer;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentCustomizer;
import rs.pezar.db.PzDokumentException;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzDokumentManagerException;
import rs.pezar.db.PzDokumentValidator;
import rs.pezar.db.PzDokumentValidatorResult;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.commons.PzKurs;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.DokumentLog;
import rs.pezar.db.entity.Fakturaservisa;
import rs.pezar.db.entity.Fiskalniracun;
import rs.pezar.db.entity.Kurs;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.entity.Uslugafaktura;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.util.PzCacheUtility;
import rs.pezar.util.PzDateUtility;

public class PzDokumentManagerImpl
extends PzDokumentManager {
    private final Pzuser user = PzApplication.getApplication().getSession().getLoggedUser();

    @Override
    public synchronized void arhivirajDokument(PzDokument dokument, boolean azuriranjeStavki, PzDokumentCustomizer customizer) throws Exception {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            try {
                em.getTransaction().begin();
                this.arhivirajDokument(dokument, azuriranjeStavki, customizer, em);
                em.getTransaction().commit();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                throw e;
            }
        }
        finally {
            if (em.isOpen()) {
                em.close();
            }
        }
    }

    @Override
    public synchronized void arhivirajDokument(PzDokument dokumentK, boolean azuriranjeStavki, PzDokumentCustomizer customizer, EntityManager em) throws Exception {
        PzDokumentCustomizer dcust;
        Date grDatum = this.getGranicniDatum(em);
        if (grDatum != null && dokumentK.getDatum().compareTo(grDatum) < 0) {
            throw new PzDokumentManagerException("Gre\u0161ka! Dokument glasi na datum koji dolazi pre grani\u010dnog datuma za PDV!");
        }
        if (grDatum != null && dokumentK.getDatPrometa() != null && dokumentK.getDatPrometa().compareTo(grDatum) < 0) {
            throw new PzDokumentManagerException("Gre\u0161ka! Datum prometa sa dokumenta dolazi pre grani\u010dnog datuma za PDV!");
        }
        if (this.user.isKorisnik() && this.user.getDozvola("DOK_ARHIVIRANJE", dokumentK.getTip()) == null) {
            throw new PzDokumentManagerException("Ne mo\u017eete arhivirati ovaj dokument jer nemate odgovaraju\u0107u dozvolu u sistemu.");
        }
        if (dokumentK.getDatPrometa() != null && PzParameter.getBoolean("VALUTA_OBAVEZNA", false, em).booleanValue()) {
            String valuta = PzParameter.getParameterValue("DEF_VALUTA", "EUR", em);
            Kurs k = PzKurs.getKurs(dokumentK.getDatPrometa(), valuta, em);
            if (k == null) {
                throw new PzDokumentManagerException("Ne postoji definisan kurs za valutu " + valuta + " na datum prometa ( " + PzFormatFactory.getDateFormat().format(dokumentK.getDatPrometa()) + " ) dokumenta ( " + dokumentK.getOznDokumenta() + " ) .\nDa biste mogli da arhivirate dokument, morate prvo uneti kurs kroz sifarnik.");
            }
        }
        PzDokumentCustomizer pzDokumentCustomizer = dcust = customizer != null ? customizer : new PzDefaultDokumentCustomizer();
        if (dokumentK.getUserPoc() == null) {
            dokumentK.setUserPoc((Pzuser)em.find(Pzuser.class, (Object)PzApplication.getApplication().getSession().getLoggedUser().getPzusername()));
        }
        dokumentK.setUserKraj((Pzuser)em.find(Pzuser.class, (Object)PzApplication.getApplication().getSession().getLoggedUser().getPzusername()));
        if (dokumentK.getRadnajedinica() != null && dokumentK.getRadnajedinica().getgTip().equals("V")) {
            dokumentK.setCvProdajna(dokumentK.getRadnajedinica().getNacinVodjenja().equals("PRODAJNA") ? (short)1 : 0);
            if (azuriranjeStavki) {
                PzEntityUtil.osveziPRNC(dokumentK, em);
            }
        } else if (dokumentK.getRadnajedinica() != null && dokumentK.getRadnajedinica().getgTip().equals("S")) {
            dokumentK.setCvProdajna((short)0);
            if (azuriranjeStavki) {
                PzEntityUtil.osveziPRNC(dokumentK, em);
            }
        } else {
            dokumentK.setCvProdajna((short)1);
        }
        dokumentK.setArhiviran((short)1);
        dokumentK.izracunajVrednostRobe();
        dokumentK.setrBroj(dcust.getRBroj(dokumentK, em));
        dokumentK.setRbrDok(dcust.getRbrDok(dokumentK, em));
        if (dokumentK.getIdDok() == 0) {
            dokumentK.setIdDok(dcust.getIdDok(dokumentK, em));
            dokumentK.setNovi(true);
        } else {
            dokumentK.setNovi(false);
        }
        if (azuriranjeStavki) {
            dcust.addTaksas(dokumentK, em);
            dcust.adjust(dokumentK, em);
            dcust.sort(dokumentK.getArtikalDocuments());
            dcust.sort(dokumentK.getUslugaDocuments());
        }
        dokumentK.setDatArh(PzDateUtility.getServerDate());
        if (!(dokumentK instanceof Dokument)) {
            if (dokumentK.getDokument() == null) {
                dcust.createDokumentInstance(dokumentK, azuriranjeStavki, em);
            } else {
                dcust.updateDokumentInstance(dokumentK, azuriranjeStavki, em);
            }
            dokumentK.createLog(2, null, (Pzuser)em.find(Pzuser.class, (Object)this.user.getPzusername()), em);
        }
        if (dokumentK.getRadnajedinica() != null && RuleKep.isInKepu(dokumentK.getRadnajedinica(), dokumentK.getTip()) && dokumentK.getDokument() != null) {
            dokumentK.getDokument().setRbrKepu(dcust.getRbrKepu(dokumentK, em));
        }
        if (dokumentK.getDokument() != null && (dokumentK.getOznDokumenta() == null || dokumentK.getOznDokumenta().length() == 0)) {
            dokumentK.formirajOznaku();
            dokumentK.getDokument().setOznDokumenta(dokumentK.getOznDokumenta());
            dokumentK.getDokument().setOpis(dokumentK.getOpis());
        }
        dcust.finalize(dokumentK, em);
        if (dokumentK.getPodTip() == null) {
            dokumentK.setPodTip("");
            if (dokumentK.getDokument() != null && dokumentK.getDokument().getPodTip() == null) {
                dokumentK.getDokument().setPodTip("");
            }
        }
        this.validateFinal(dokumentK);
        if (dokumentK.getNovi()) {
            this.validatePreSave(dokumentK);
            em.persist((Object)dokumentK);
        } else {
            this.validatePreUpdate(dokumentK);
            em.merge((Object)dokumentK);
        }
        PzCacheUtility.removeReportFromCache(dokumentK);
    }

    @Override
    public synchronized void snimiDokument(PzDokument dokument, boolean azuriranjeStavki, PzDokumentCustomizer customizer) throws Exception {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            try {
                em.getTransaction().begin();
                this.snimiDokument(dokument, azuriranjeStavki, customizer, em);
                em.getTransaction().commit();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                throw e;
            }
        }
        finally {
            if (em.isOpen()) {
                em.close();
            }
        }
    }

    @Override
    public synchronized void snimiDokument(PzDokument dokument, boolean azuriranjeStavki, PzDokumentCustomizer customizer, EntityManager em) throws Exception {
        if (this.user.isKorisnik() && this.user.getDozvola("DOK_SNIMANJE", dokument.getTip()) == null) {
            throw new PzDokumentManagerException("Ne mo\u017eete otvoriti novi dokument jer nemate odgovaraju\u0107u dozvolu u sistemu.");
        }
        PzDokumentCustomizer dcust = customizer != null ? customizer : new PzDefaultDokumentCustomizer();
        dokument.setUserPoc(PzApplication.getApplication().getSession().getLoggedUser());
        dokument.setUserKraj(PzApplication.getApplication().getSession().getLoggedUser());
        if (dokument.getRadnajedinica() != null) {
            dokument.setCvProdajna(dokument.getRadnajedinica().getNacinVodjenja().equals("PRODAJNA") ? (short)1 : 0);
        }
        boolean novi = false;
        if (dokument.getIdDok() == 0) {
            novi = true;
            dokument.setIdDok(dcust.getIdDok(dokument, em));
        }
        dokument.adjust();
        dokument.setArhiviran((short)0);
        if (dokument.getDokument() == null) {
            dcust.createDokumentInstance(dokument, azuriranjeStavki, em);
        } else {
            dcust.updateDokumentInstance(dokument, azuriranjeStavki, em);
        }
        if (novi) {
            this.validatePreSave(dokument);
            em.persist((Object)dokument);
        } else {
            this.validatePreUpdate(dokument);
            em.merge((Object)dokument);
        }
        em.flush();
    }

    @Override
    public synchronized void arhivirajStorno(PzDokument stornoDokument, int azurirajKolicine, int kojeKolicine, boolean azurirajTakse, PzDokumentCustomizer customizer) throws Exception {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            try {
                em.getTransaction().begin();
                this.arhivirajStorno(stornoDokument, azurirajKolicine, kojeKolicine, azurirajTakse, customizer, em);
                em.getTransaction().commit();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                throw e;
            }
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
    }

    @Override
    public synchronized void arhivirajStorno(PzDokument stornoDokument, int azurirajKolicine, int kojeKolicine, boolean azurirajTakse, PzDokumentCustomizer customizer, EntityManager em) throws Exception {
        PzDokumentCustomizer dcust;
        Date grDatum = this.getGranicniDatum(em);
        if (grDatum != null && stornoDokument.getDatum().compareTo(grDatum) < 0) {
            throw new PzDokumentManagerException("Gre\u0161ka! Dokument glasi na datum koji dolazi pre grani\u010dnog datuma za PDV!");
        }
        if (this.user.isKorisnik() && this.user.getDozvola("DOK_ARHIVIRANJE", stornoDokument.getTip()) == null && !"ISECAK".equals(stornoDokument.getTip())) {
            throw new PzDokumentManagerException("Ne mo\u017eete arhivirati ovaj dokument jer nemate odgovaraju\u0107u dozvolu u sistemu.");
        }
        PzDokumentCustomizer pzDokumentCustomizer = dcust = customizer != null ? customizer : new PzDefaultDokumentCustomizer();
        if (stornoDokument.getRadnajedinica() != null) {
            stornoDokument.setCvProdajna(stornoDokument.getRadnajedinica().getNacinVodjenja().equals("PRODAJNA") ? (short)1 : 0);
        }
        Pzuser usr = (Pzuser)em.find(Pzuser.class, (Object)PzApplication.getApplication().getSession().getLoggedUser().getPzusername());
        stornoDokument.setUserKraj(usr);
        stornoDokument.setUserPoc(usr);
        PzDokument original = (PzDokument)em.find(stornoDokument.getClass(), (Object)stornoDokument.getIdDok());
        stornoDokument.setDatArh(PzDateUtility.getServerDate());
        stornoDokument.setStornoIznos(new BigDecimal(0));
        stornoDokument.setIdDok(dcust.getIdDok(stornoDokument, em));
        if (azurirajTakse && stornoDokument.getArtikalDocuments() != null && stornoDokument.getArtikalDocuments().size() >= 1) {
            stornoDokument.setTaksadokuments(new Vector());
            dcust.addTaksas(stornoDokument, em);
        }
        stornoDokument.izracunajVrednostRobe();
        dcust.adjust(stornoDokument, em);
        stornoDokument.setArhiviran((short)1);
        stornoDokument.setProknjizen((short)0);
        stornoDokument.setStorno(1);
        stornoDokument.setRbrDok(0);
        stornoDokument.setRbrDok(dcust.getRbrDok(stornoDokument, em));
        if (original != null) {
            original.setStornoIznos(original.getStornoIznos().add(stornoDokument.getIznos()));
            original.getDokument().setStornoIznos(original.getStornoIznos());
        }
        if (azurirajKolicine != PzEntityManager.KOLICINE_NEPROMENJENE && stornoDokument.getArtikalDocuments() != null) {
            Iterator<? extends PzArtikalDokument> i = stornoDokument.getArtikalDocuments().iterator();
            Stanje s = null;
            double novaKolicina = 0.0;
            while (i.hasNext()) {
                PzArtikalDokument artdok = i.next();
                s = (Stanje)PzEntityManager.find(Stanje.class, new StanjePK(artdok.getId().getSfrProizvod(), stornoDokument.getRadnajedinica()), em);
                if (s == null) continue;
                if (azurirajKolicine == PzEntityManager.KOLICINE_UMANJENJE) {
                    novaKolicina = s.getKolicina() - artdok.getKolicina();
                } else if (azurirajKolicine == PzEntityManager.KOLICINE_UVECANJE) {
                    novaKolicina = kojeKolicine == PzEntityManager.KOLICINA_UKUPNA ? s.getKolicina() + artdok.getKolicina() : s.getAlocKolicina() - artdok.getKolicina();
                }
                if (novaKolicina < 0.0 && azurirajKolicine == PzEntityManager.KOLICINE_UMANJENJE && stornoDokument.getRadnajedinica().getMinusKolicine().equals("ZABRANJEN")) {
                    throw new PzDokumentException(PzDokumentException.EXCEPTION_NEMA_KOLICINE, "Artikal '" + artdok.getId().getSfrProizvod() + " " + artdok.getNaziv() + "' nema dovoljno raspolo\u017eive koli\u010dine za storniranje. Storno ne\u0107e biti izra\u0111en.");
                }
                if (kojeKolicine == PzEntityManager.KOLICINA_UKUPNA) {
                    s.setKolicina(novaKolicina);
                } else {
                    s.setAlocKolicina(novaKolicina);
                }
                em.merge((Object)s);
            }
        }
        if (original != null) {
            stornoDokument.setOriginal(original);
            original.createLog(8, null, usr, em);
        }
        Dokument dok = new Dokument(stornoDokument, true);
        stornoDokument.setDokument(dok);
        if (stornoDokument.getRadnajedinica() != null && RuleKep.isInKepu(stornoDokument.getRadnajedinica(), stornoDokument.getTip())) {
            stornoDokument.getDokument().setRbrKepu(dcust.getRbrKepu(stornoDokument, em));
        }
        dcust.finalize(stornoDokument, em);
        this.validateFinal(stornoDokument);
        if (stornoDokument instanceof Fakturaservisa) {
            Fakturaservisa fs = (Fakturaservisa)stornoDokument;
            List<Uslugafaktura> list = fs.getUslugafakturas();
            fs.setUslugafakturas(new Vector<Uslugafaktura>());
            em.persist((Object)fs);
            em.flush();
            fs.setUslugafakturas(list);
        } else {
            em.persist((Object)stornoDokument);
        }
    }

    @Override
    public synchronized void deleteDokument(PzDokument dokument, PzDokumentCustomizer customizer) throws Exception {
        if (dokument == null) {
            return;
        }
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            try {
                em.getTransaction().begin();
                this.deleteDokument(dokument, customizer, em);
                em.getTransaction().commit();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                throw e;
            }
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
    }

    @Override
    public synchronized void deleteDokument(PzDokument dokument, PzDokumentCustomizer customizer, EntityManager em) throws Exception {
        if (dokument == null) {
            return;
        }
        dokument.createLog(4, null, (Pzuser)em.find(Pzuser.class, (Object)this.user.getPzusername()), em);
        dokument.setArhiviran((short)-1);
        if (dokument.getDokument() != null) {
            dokument.getDokument().setArhiviran((short)-1);
        }
        if (!em.contains((Object)dokument)) {
            em.merge((Object)dokument);
        }
    }

    private Date getGranicniDatum(EntityManager em) throws ParseException {
        String datum = PzParameter.getParameterValue("PDV_OBRACUNSKI_PERIOD", em);
        if (datum == null) {
            return null;
        }
        return new Date(new SimpleDateFormat("yyyy-MM-dd").parse(datum).getTime());
    }

    private void validatePreSave(PzDokument d) throws PzInfoException {
        PzDokumentValidatorResult r = new PzDokumentValidatorResult(0, "");
        Iterator<PzDokumentValidator> iterator = PzApplication.getApplication().getDokumentValidatorRegistry().iterator();
        while (iterator.hasNext() && r.getState() == 0) {
            PzDokumentValidator v = iterator.next();
            r = v.validatePreSave(d);
        }
        if (r.getState() == 1) {
            throw new PzInfoException("Dogodila se ozbiljna gre\u0161ka prilikom snimanja dokumenta: " + r.getMessage());
        }
    }

    private void validatePreUpdate(PzDokument d) throws PzInfoException {
        PzDokumentValidatorResult r = new PzDokumentValidatorResult(0, "");
        Iterator<PzDokumentValidator> iterator = PzApplication.getApplication().getDokumentValidatorRegistry().iterator();
        while (iterator.hasNext() && r.getState() == 0) {
            PzDokumentValidator v = iterator.next();
            r = v.validatePreUpdate(d);
        }
        if (r.getState() == 1) {
            throw new PzInfoException("Dogodila se ozbiljna gre\u0161ka prilikom snimanja dokumenta: " + r.getMessage());
        }
    }

    private void validateFinal(PzDokument d) throws PzInfoException {
        PzDokumentValidatorResult r = new PzDokumentValidatorResult(0, "");
        Iterator<PzDokumentValidator> iterator = PzApplication.getApplication().getDokumentValidatorRegistry().iterator();
        while (iterator.hasNext() && r.getState() == 0) {
            PzDokumentValidator v = iterator.next();
            r = v.validateFinal(d);
        }
        if (r.getState() == 1) {
            throw new PzInfoException("Dogodila se ozbiljna gre\u0161ka prilikom snimanja dokumenta: " + r.getMessage());
        }
    }

    @Override
    public PzDokument getPzDokument(Dokument d) {
        if (d.getKalkulacija() != null) {
            return d.getKalkulacija();
        }
        if (d.getFaktura() != null) {
            return d.getFaktura();
        }
        if (d.getFakturausluga() != null) {
            return d.getFakturausluga();
        }
        if (d.getInterniracun() != null) {
            return d.getInterniracun();
        }
        if (d.getInterniracun1() != null) {
            return d.getInterniracun1();
        }
        if (d.getKonsignacija() != null) {
            return d.getKonsignacija();
        }
        if (d.getNivelacija() != null) {
            return d.getNivelacija();
        }
        if (d.getOpstidokument() != null) {
            return d.getOpstidokument();
        }
        Fiskalniracun fr = (Fiskalniracun)PzEntityManager.findEntity(Fiskalniracun.class, d.getIdDok());
        if (fr != null) {
            return fr;
        }
        return null;
    }

    @Override
    public void log(PzDokument dok, int vrsta, String opis) throws Exception {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            try {
                em.getTransaction().begin();
                this.log(dok, vrsta, opis, em);
                em.getTransaction().commit();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                throw e;
            }
        }
        finally {
            if (em.isOpen()) {
                em.close();
            }
        }
    }

    @Override
    public void log(PzDokument dok, int vrsta, String opis, EntityManager em) {
        if (PzParameter.getBoolean("LOG", Boolean.TRUE).booleanValue()) {
            Pzuser u = (Pzuser)em.find(Pzuser.class, (Object)PzApplication.getApplication().getSession().getLoggedUser().getPzusername());
            DokumentLog dl = dok.createLog(vrsta, opis, u, em);
            em.persist((Object)dl);
        }
    }
}

