/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.eclipse.persistence.annotations.PrivateOwned;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzUslugaDokument;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.db.entity.Udtaksa;
import rs.pezar.db.entity.Usluga;
import rs.pezar.db.entity.UslugadokumentPK;

@Entity
@Table(name="UslugaDokument")
public class Uslugadokument
extends PzUslugaDokument
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private UslugadokumentPK id;
    @Column(nullable=false)
    private double brNormaSati;
    @Column(nullable=false)
    private double cena;
    private double kolicina;
    @Column(nullable=false, length=255)
    private String naziv;
    private int sort;
    @OneToMany(mappedBy="uslugadokument", cascade={CascadeType.ALL})
    @PrivateOwned
    private List<Udtaksa> udtaksas;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE})
    @JoinColumn(name="idDok", nullable=false, insertable=false, updatable=false)
    private Dokument dokument;

    public Uslugadokument() {
    }

    public Uslugadokument(PzUslugaDokument ud, Dokument dok) {
        this.id = new UslugadokumentPK(dok.getIdDok(), ud.getId().getrBroj());
        this.cena = ud.getCena();
        this.naziv = ud.getNaziv();
        this.kolicina = ud.getKolicina();
        this.brNormaSati = ud.getBrNormaSati();
        if (ud.getTaksas() != null && ud.getTaksas().size() > 0) {
            this.copyTaksas(ud.getTaksas());
        }
    }

    public void copyTaksas(List<? extends PzADTaksa> taksas) {
        this.setUdtaksas(new Vector<Udtaksa>());
        for (PzADTaksa pzADTaksa : taksas) {
            this.udtaksas.add(new Udtaksa(this, pzADTaksa));
        }
    }

    public void update(PzUslugaDokument ud) {
        this.cena = ud.getCena();
        this.naziv = ud.getNaziv();
        this.kolicina = ud.getKolicina();
        this.brNormaSati = ud.getBrNormaSati();
        if (this.getUdtaksas() == null || this.getUdtaksas().size() == 0) {
            this.copyTaksas(ud.getTaksas());
        } else {
            this.updateTaksas(ud.getTaksas());
        }
    }

    private void updateTaksas(List<? extends PzADTaksa> taksas) {
        if (this.getTaksas() != null && this.getTaksas().size() > 0) {
            boolean found = false;
            for (PzADTaksa pzADTaksa : taksas) {
                found = false;
                for (Udtaksa udtaksa : this.getUdtaksas()) {
                    if (!pzADTaksa.getOznTarGr().equals(udtaksa.getId().getOznTarGr())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.getUdtaksas().add(new Udtaksa(this, pzADTaksa));
            }
            found = false;
            Iterator<Udtaksa> iterator = this.getUdtaksas().iterator();
            while (iterator.hasNext()) {
                Udtaksa adtaksa = iterator.next();
                for (PzADTaksa pzADTaksa : taksas) {
                    if (!pzADTaksa.getOznTarGr().equals(adtaksa.getId().getOznTarGr())) continue;
                    found = true;
                }
                if (found) continue;
                iterator.remove();
            }
        }
    }

    @Override
    public UslugadokumentPK getId() {
        return this.id;
    }

    public void setId(UslugadokumentPK id) {
        this.id = id;
    }

    @Override
    public double getBrNormaSati() {
        return this.brNormaSati;
    }

    @Override
    public void setBrNormaSati(double brnormasati) {
        this.brNormaSati = brnormasati;
    }

    @Override
    public double getCena() {
        return this.cena;
    }

    @Override
    public void setCena(double cena) {
        this.cena = cena;
    }

    @Override
    public double getKolicina() {
        return this.kolicina;
    }

    @Override
    public void setKolicina(double kolicina) {
        this.kolicina = kolicina;
    }

    @Override
    public String getNaziv() {
        return this.naziv;
    }

    @Override
    public void setNaziv(String naziv) {
        this.naziv = naziv;
    }

    public List<Udtaksa> getUdtaksas() {
        return this.udtaksas;
    }

    public void setUdtaksas(List<Udtaksa> udtaksas) {
        this.udtaksas = udtaksas;
    }

    @Override
    public Dokument getDokument() {
        return this.dokument;
    }

    public void setDokument(Dokument dokument) {
        this.dokument = dokument;
    }

    @Override
    public Object[] getValues() {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return null;
    }

    @Override
    public void setId(int idDok, int rBroj) {
        this.id = new UslugadokumentPK(idDok, rBroj);
    }

    @Override
    public Usluga getUsluga() {
        return null;
    }

    @Override
    public void setUsluga(Usluga usluga) {
    }

    @Override
    public void setDokument(PzDokument dokument) {
        this.dokument = (Dokument)dokument;
    }

    @Override
    public void addTaksa(Tarifnagrupa tgr) {
        if (this.udtaksas == null) {
            this.udtaksas = new Vector<Udtaksa>();
        }
        this.udtaksas.add(new Udtaksa(this, tgr));
    }

    @Override
    public List<? extends PzADTaksa> getTaksas() {
        return this.udtaksas;
    }

    @Override
    public int getSort() {
        return this.sort;
    }

    @Override
    public void setSort(int sort) {
        this.sort = sort;
    }
}

