/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.TaksaopstidokumentPK;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.db.entity.Uplata;

@Entity
@Table(name="TaksaOpstiDokument")
public class Taksaopstidokument
extends PzTaksaDokument
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private TaksaopstidokumentPK id;
    @Column(nullable=false)
    private BigDecimal iznos = new BigDecimal(0);
    @Column(nullable=false)
    private BigDecimal osnovica = new BigDecimal(0);
    @Column(nullable=false, length=15)
    private String vrsta;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="oznTarGr", nullable=false, insertable=false, updatable=false)
    private Tarifnagrupa tarifnagrupa;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE})
    @JoinColumn(name="idDok", nullable=false, insertable=false, updatable=false)
    private Opstidokument opstidokument;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.MERGE})
    @JoinColumn(name="idDok", nullable=false, insertable=false, updatable=false)
    private Uplata uplata;

    public Taksaopstidokument() {
    }

    public Taksaopstidokument(int idDok, String oznTarGr, String tip) {
        this.setId(new TaksaopstidokumentPK(idDok, oznTarGr, tip));
    }

    public TaksaopstidokumentPK getId() {
        return this.id;
    }

    public void setId(TaksaopstidokumentPK id) {
        this.id = id;
    }

    public void setId(int idDok, String oznTarGr) {
        this.setId(new TaksaopstidokumentPK(idDok, oznTarGr));
    }

    @Override
    public BigDecimal getIznos() {
        return this.iznos;
    }

    @Override
    public void setIznos(BigDecimal iznos) {
        this.iznos = iznos;
    }

    @Override
    public BigDecimal getOsnovica() {
        return this.osnovica;
    }

    @Override
    public void setOsnovica(BigDecimal osnovica) {
        this.osnovica = osnovica;
    }

    @Override
    public String getVrsta() {
        return this.vrsta;
    }

    @Override
    public void setVrsta(String vrsta) {
        this.vrsta = vrsta;
    }

    @Override
    public Tarifnagrupa getTarifnagrupa() {
        return this.tarifnagrupa;
    }

    @Override
    public void setTarifnagrupa(Tarifnagrupa tarifnagrupa) {
        this.tarifnagrupa = tarifnagrupa;
    }

    public Opstidokument getOpstidokument() {
        return this.opstidokument;
    }

    public void setOpstidokument(Opstidokument opstidokument) {
        this.opstidokument = opstidokument;
    }

    public Uplata getUplata() {
        return this.uplata;
    }

    public void setUplata(Uplata uplata) {
        this.uplata = uplata;
    }

    @Override
    public String[] getColumnNames() {
        if (this.opstidokument != null && this.opstidokument.getTip().equals("POPIS")) {
            return new String[]{"Tarifna grupa", "Stopa", "Manjak", "Vi\u0161ak"};
        }
        return new String[]{"Tarifna grupa", "Stopa PDV-a", "Osnovica", "Iznos poreza"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.tarifnagrupa.getOznTarGr(), this.tarifnagrupa.getStopa(), this.osnovica, this.iznos};
    }

    @Override
    public PzDokument getDokument() {
        return this.opstidokument;
    }

    @Override
    public void setDokument(PzDokument dokument) {
        this.opstidokument = (Opstidokument)dokument;
    }

    @Override
    public String getTip() {
        return this.id.getTip();
    }

    @Override
    public void setTip(String tip) {
        this.id.setTip(tip);
    }

    @Override
    public void setId(String oznTarGr, int idDok, String tip) {
        this.setId(new TaksaopstidokumentPK(idDok, oznTarGr, tip));
    }
}

