/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.TaksafakturaPK;
import rs.pezar.db.entity.Tarifnagrupa;

@Entity
@Table(name="TaksaFaktura")
public class Taksafaktura
extends PzTaksaDokument
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private TaksafakturaPK id;
    @Column(nullable=false)
    private BigDecimal iznos = new BigDecimal(0);
    @Column(nullable=false)
    private BigDecimal osnovica = new BigDecimal(0);
    @Column(nullable=false, length=15)
    private String vrsta;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idDok", nullable=false, insertable=false, updatable=false)
    private Faktura faktura;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="oznTarGr", nullable=false, insertable=false, updatable=false)
    private Tarifnagrupa tarifnagrupa;

    public Taksafaktura() {
    }

    public Taksafaktura(int idDok, String tip, String oznTarGr) {
        this.setId(new TaksafakturaPK(oznTarGr, idDok, tip));
    }

    public TaksafakturaPK getId() {
        return this.id;
    }

    public void setId(TaksafakturaPK id) {
        this.id = id;
    }

    @Override
    public BigDecimal getIznos() {
        return this.iznos;
    }

    @Override
    public void setIznos(BigDecimal iznos) {
        this.iznos = iznos;
    }

    @Override
    public BigDecimal getOsnovica() {
        return this.osnovica;
    }

    @Override
    public void setOsnovica(BigDecimal osnovica) {
        this.osnovica = osnovica;
    }

    @Override
    public String getVrsta() {
        return this.vrsta;
    }

    @Override
    public void setVrsta(String vrsta) {
        this.vrsta = vrsta;
    }

    public Faktura getFaktura() {
        return this.faktura;
    }

    public void setFaktura(Faktura faktura) {
        this.faktura = faktura;
    }

    @Override
    public Tarifnagrupa getTarifnagrupa() {
        return this.tarifnagrupa;
    }

    @Override
    public void setTarifnagrupa(Tarifnagrupa tarifnagrupa) {
        this.tarifnagrupa = tarifnagrupa;
    }

    public BigDecimal getObracunatiIznos() {
        return this.iznos.add(this.osnovica);
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Tarifna grupa", "Stopa PDV-a", "Osnovica", "Iznos poreza"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.tarifnagrupa.getOznTarGr(), this.tarifnagrupa.getStopa(), this.osnovica, this.iznos};
    }

    @Override
    public PzDokument getDokument() {
        return this.getFaktura();
    }

    @Override
    public String getTip() {
        return this.id.getTip();
    }

    @Override
    public void setDokument(PzDokument dokument) {
        this.setFaktura((Faktura)dokument);
    }

    @Override
    public void setTip(String tip) {
        this.id.setTip(tip);
    }

    @Override
    public void setId(String oznTarGr, int idDok, String tip) {
        this.setId(new TaksafakturaPK(oznTarGr, idDok, tip));
    }
}

