/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.eclipse.persistence.annotations.PrivateOwned;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Dozvola;
import rs.pezar.db.entity.Email;
import rs.pezar.db.entity.Pzuserinfo;
import rs.pezar.db.entity.Radnomesto;
import rs.pezar.db.entity.Telefon;

@Entity
@Table(name="PzUser")
public class Pzuser
implements Serializable,
PzEntity {
    private static final long serialVersionUID = 1L;
    public static int STATUS_NEAKTIVAN = 0;
    public static int STATUS_AKTIVAN = 1;
    public static int GRUPA_KORISNIKA = 2;
    @Id
    @Column(unique=true, nullable=false, length=20)
    private String pzusername;
    @Column(length=30)
    private String oznMagacin;
    @Column(nullable=false, length=20)
    private String password;
    @Column(length=0x7FFFFFFF)
    private String privilegije;
    private Integer status;
    @OneToMany(mappedBy="pzuser", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @PrivateOwned
    private List<Dozvola> dozvolas;
    @OneToMany(mappedBy="pzuser", cascade={CascadeType.ALL})
    private List<Email> emails;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nadredjeni", nullable=false)
    private Pzuser pzuser;
    @OneToMany(mappedBy="pzuser")
    private List<Pzuser> pzusers;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idRadnoMesto", nullable=false)
    private Radnomesto radnoMesto;
    @OneToOne(mappedBy="pzuser", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Pzuserinfo pzuserInfo;
    @OneToMany(mappedBy="pzuser", cascade={CascadeType.ALL})
    private List<Telefon> telefons;

    public String getPzusername() {
        return this.pzusername;
    }

    public void setPzusername(String pzusername) {
        this.pzusername = pzusername;
    }

    public String getOznMagacin() {
        return this.oznMagacin;
    }

    public void setOznMagacin(String oznmagacin) {
        this.oznMagacin = oznmagacin;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPrivilegije() {
        return this.privilegije;
    }

    public void setPrivilegije(String privilegije) {
        this.privilegije = privilegije;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public List<Dozvola> getDozvolas() {
        return this.dozvolas;
    }

    public void setDozvolas(List<Dozvola> dozvolas) {
        this.dozvolas = dozvolas;
    }

    public List<Email> getEmails() {
        return this.emails;
    }

    public void setEmails(List<Email> emails) {
        this.emails = emails;
    }

    public Pzuser getPzuser() {
        return this.pzuser;
    }

    public void setPzuser(Pzuser pzuser) {
        this.pzuser = pzuser;
    }

    public List<Pzuser> getPzusers() {
        return this.pzusers;
    }

    public void setPzusers(List<Pzuser> pzusers) {
        this.pzusers = pzusers;
    }

    public Radnomesto getRadnoMesto() {
        return this.radnoMesto;
    }

    public void setRadnoMesto(Radnomesto radnomesto) {
        this.radnoMesto = radnomesto;
    }

    public Pzuserinfo getPzuserInfo() {
        return this.pzuserInfo;
    }

    public void setPzuserInfo(Pzuserinfo pzuserinfo) {
        this.pzuserInfo = pzuserinfo;
    }

    public List<Telefon> getTelefons() {
        return this.telefons;
    }

    public void setTelefons(List<Telefon> telefons) {
        this.telefons = telefons;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Username", "Ime", "Prezime"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.pzusername, this.getIme(), this.getPrezime()};
    }

    public String getFullName() {
        return String.valueOf(this.pzusername) + " [ " + this.getIme() + " " + this.getPrezime() + " ]";
    }

    public String getIme() {
        return this.pzuserInfo != null ? this.pzuserInfo.getIme() : "";
    }

    public String getPrezime() {
        return this.pzuserInfo != null ? this.pzuserInfo.getPrezime() : "";
    }

    public Email getEmail(Integer tip) {
        Email email = null;
        Iterator<Email> iterator = this.getEmails().iterator();
        while (iterator.hasNext() && email == null) {
            Email e = iterator.next();
            if (!e.getTipEmaila().getIdTipEmaila().equals(tip)) continue;
            email = e;
        }
        return email;
    }

    public Telefon getTelefon(Integer tip) {
        Telefon telefon = null;
        Iterator<Telefon> iterator = this.getTelefons().iterator();
        while (iterator.hasNext() && telefon == null) {
            Telefon t = iterator.next();
            if (!t.getTipTelefona().getIdTipTelefona().equals(tip)) continue;
            telefon = t;
        }
        return telefon;
    }

    public Dozvola getDozvola(String tip, String opcija) {
        Dozvola dozvola = null;
        if (this.getDozvolas() != null) {
            Iterator<Dozvola> iterator = this.getDozvolas().iterator();
            while (iterator.hasNext() && dozvola == null) {
                Dozvola d = iterator.next();
                if (!d.getId().getTip().equals(tip) || !d.getId().getOpcija().equals(opcija)) continue;
                dozvola = d;
            }
        }
        if (dozvola == null && this.getPzuser() != null) {
            return this.getPzuser().getDozvola(tip, opcija);
        }
        return dozvola;
    }

    public List<Dozvola> getDozvole(String tip) {
        ArrayList<Dozvola> dozvole = new ArrayList<Dozvola>();
        for (Dozvola d : this.getDozvolas()) {
            if (!d.getId().getTip().equals(tip)) continue;
            dozvole.add(d);
        }
        if (this.getPzuser() != null) {
            dozvole.addAll(this.getPzuser().getDozvole(tip));
        }
        return dozvole;
    }

    public boolean isKorisnik() {
        return this.getPrivilegije() == null || this.getPrivilegije().equals("k");
    }

    public boolean isModerator() {
        return this.getPrivilegije() != null && this.getPrivilegije().contains("m");
    }

    public boolean isManager() {
        return this.getPrivilegije() != null && this.getPrivilegije().contains("s");
    }

    public boolean isAdministrator() {
        return this.getPrivilegije() != null && this.getPrivilegije().contains("a");
    }
}

