/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.eclipse.persistence.indirection.IndirectList;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Fiskalniracun;
import rs.pezar.db.entity.Pfrtaksa;
import rs.pezar.db.entity.Proizvod;
import rs.pezar.db.entity.ProizvodfiskalniracunPK;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.db.entity.Usluga;
import rs.pezar.util.PzMathUtility;

@Entity
public class Proizvodfiskalniracun
extends PzArtikalDokument
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private ProizvodfiskalniracunPK id;
    private String bliziOpis;
    private double cena;
    private String jm;
    private double kolicina;
    private String naziv;
    private double procRabata;
    private double rabat;
    private int sort;
    private short indk;
    private String dobSifra;
    @OneToMany(mappedBy="proizvodfiskalniracun", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private List<Pfrtaksa> pfrtaksas;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="sfrProizvod", nullable=false, insertable=false, updatable=false)
    private Proizvod proizvod;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE})
    @JoinColumn(name="idDok", nullable=false, insertable=false, updatable=false)
    private Fiskalniracun fiskalniracun;

    public Proizvodfiskalniracun() {
    }

    public Proizvodfiskalniracun(int idRacun, String sfrProizvod, int rbroj, String bliziOpis, Double cena, String jm, double kolicina, String naziv, double procRabata, String dobSifra) {
        this.setId(idRacun, sfrProizvod, rbroj);
        this.bliziOpis = bliziOpis;
        this.cena = cena;
        this.jm = jm;
        this.kolicina = kolicina;
        this.naziv = naziv;
        this.procRabata = procRabata;
        this.dobSifra = dobSifra;
    }

    public Proizvodfiskalniracun(Artikalfaktura af) {
        this(af.getId().getIdDok(), af.getId().getSfrProizvod(), af.getId().getrBroj(), af.getBliziOpis(), af.getCena(), af.getJm(), af.getKolicina(), af.getNaziv(), 0.0, af.getDobSifra());
        this.proizvod = af.getArtikal().getProizvod();
        this.sort = af.getSort();
        this.indk = 0;
    }

    public Proizvodfiskalniracun(Proizvodfiskalniracun af) {
        this(af.getId().getIdDok(), af.getId().getSfrProizvod(), af.getId().getrBroj(), af.getBliziOpis(), af.getCena(), af.getJm(), af.getKolicina(), af.getNaziv(), 0.0, af.getDobSifra());
        this.proizvod = af.getArtikal().getProizvod();
        this.sort = af.getSort();
        this.indk = 0;
    }

    @Override
    public ProizvodfiskalniracunPK getId() {
        return this.id;
    }

    public void setId(ProizvodfiskalniracunPK id) {
        this.id = id;
    }

    @Override
    public void setId(int idRacun, String sfrProizvod, int rBroj) {
        this.id = new ProizvodfiskalniracunPK(idRacun, sfrProizvod, rBroj);
    }

    @Override
    public String getBliziOpis() {
        return this.bliziOpis;
    }

    @Override
    public void setBliziOpis(String bliziopis) {
        this.bliziOpis = bliziopis;
    }

    @Override
    public double getCena() {
        return this.cena;
    }

    @Override
    public void setCena(double cena) {
        this.cena = cena;
    }

    @Override
    public String getJm() {
        return this.jm;
    }

    @Override
    public void setJm(String jm) {
        this.jm = jm;
    }

    @Override
    public double getKolicina() {
        return this.kolicina;
    }

    @Override
    public void setKolicina(double kolicina) {
        this.kolicina = kolicina;
    }

    @Override
    public String getNaziv() {
        return this.naziv;
    }

    @Override
    public void setNaziv(String naziv) {
        this.naziv = naziv;
    }

    @Override
    public double getProcRabata() {
        return this.procRabata;
    }

    @Override
    public void setProcRabata(double procrabata) {
        this.procRabata = procrabata;
    }

    public double getRabat() {
        return this.rabat;
    }

    public void setRabat(double rabat) {
        this.rabat = rabat;
    }

    @Override
    public int getSort() {
        return this.sort;
    }

    @Override
    public void setSort(int sort) {
        this.sort = sort;
    }

    public List<Pfrtaksa> getPfrtaksas() {
        return this.pfrtaksas;
    }

    public void setPfrtaksas(List<Pfrtaksa> pfrtaksas) {
        this.pfrtaksas = pfrtaksas;
    }

    @Override
    public void addTaksa(Tarifnagrupa tgr) {
        if (this.pfrtaksas == null) {
            this.pfrtaksas = new IndirectList();
        }
        this.pfrtaksas.add(new Pfrtaksa(this, tgr));
    }

    public Proizvod getProizvod() {
        return this.proizvod;
    }

    public void setProizvod(Proizvod proizvod) {
        this.proizvod = proizvod;
    }

    public Fiskalniracun getFiskalniracun() {
        return this.fiskalniracun;
    }

    public void setFiskalniracun(Fiskalniracun fiskalniracun) {
        this.fiskalniracun = fiskalniracun;
    }

    public void init(Fiskalniracun f, Proizvod p) {
        this.setId(f.getIdDok(), p.getSfrProizvod(), f.getNextRBrojArtikli());
        this.setProizvod(p);
        this.setFiskalniracun(f);
        if (p.getSfrProizvod().startsWith("U") && p.getUsluga() != null) {
            for (Tarifnagrupa tgr : p.getUsluga().getTarifnagrupas()) {
                this.addTaksa(tgr);
            }
        } else {
            for (Tarifnagrupa tgr : p.getArtikal().getTarifnagrupas()) {
                this.addTaksa(tgr);
            }
        }
    }

    @Override
    public Pfrtaksa getTaksa(String vrsta) {
        Pfrtaksa result = null;
        for (Pfrtaksa t : this.getPfrtaksas()) {
            if (!t.getOznVrstaTG().equals(vrsta)) continue;
            result = t;
            break;
        }
        return result;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"\u0160ifra", "Naziv", "JM", "Koli\u010dina", "Cena", "Popust", "Vrednost"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.id.getSfrProizvod(), this.naziv, this.jm, this.kolicina, this.cena, BDConverter.getIznos(this.rabat), BDConverter.getIznos(this.cena * this.kolicina)};
    }

    public BigDecimal getPopust() {
        return BDConverter.getIznos(BDConverter.getProdCena(this.getCena() * this.getProcRabata() / 100.0).doubleValue() * this.getKolicina());
    }

    @Override
    public BigDecimal getVrednost() {
        return BDConverter.getIznos(this.cena * this.kolicina);
    }

    @Override
    public BigDecimal calculateTaksa(String vrsta) {
        BigDecimal stopa = PzMathUtility.roundToBigDecimal(this.getTaksa(vrsta).getStopa() / 100.0, 2);
        BigDecimal kolicina = new BigDecimal(Double.toString(this.getKolicina()));
        BigDecimal cena = PzMathUtility.roundToBigDecimal(this.getCena());
        return PzMathUtility.round(kolicina.multiply(cena).multiply(stopa.multiply(new BigDecimal("100"))).divide(new BigDecimal("100").add(stopa.multiply(new BigDecimal("100"))), PzMathUtility.getBrojDecimala(), 4));
    }

    @Override
    public BigDecimal calculateOsnovica(String vrsta) {
        BigDecimal kolicina = new BigDecimal(Double.toString(this.getKolicina()));
        BigDecimal cena = PzMathUtility.roundToBigDecimal(this.getCena());
        return PzMathUtility.round(kolicina.multiply(cena).subtract(this.calculateTaksa(vrsta)));
    }

    public void setIndk(short indk) {
        this.indk = indk;
    }

    public short getIndk() {
        return this.indk;
    }

    public void setDobSifra(String dobSifra) {
        this.dobSifra = dobSifra;
    }

    public String getDobSifra() {
        return this.dobSifra;
    }

    @Override
    public Artikal getArtikal() {
        return this.getProizvod().getArtikal();
    }

    @Override
    public Object[] getKValues() {
        return null;
    }

    @Override
    public BigDecimal getProdCena() {
        return new BigDecimal(this.cena);
    }

    @Override
    public BigDecimal getProsNabCena() {
        return null;
    }

    @Override
    public String getSifra() {
        return this.id.getSfrProizvod();
    }

    @Override
    public Usluga getUsluga() {
        return null;
    }

    @Override
    public void setArtikal(Artikal artikal) {
    }

    @Override
    public void setProdCena(BigDecimal prodCena) {
    }

    @Override
    public void setProsNabCena(BigDecimal prosNabCena) {
    }

    @Override
    public void setUsluga(Usluga usluga) {
    }

    @Override
    public PzDokument getDokument() {
        return this.fiskalniracun;
    }

    @Override
    public List<? extends PzADTaksa> getTaksas() {
        return this.pfrtaksas;
    }

    @Override
    public void setDokument(PzDokument dokument) {
        this.fiskalniracun = (Fiskalniracun)dokument;
    }

    @Override
    public String getVrsta() {
        if (this.getTaksa("PDV").getOznTarGr().equals("U1")) {
            return "N";
        }
        return super.getVrsta();
    }
}

