/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.sql.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Artikalnalogprijem;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.globals.TipDokumentConfig;

@Entity
@Table(name="NalogPrijem")
public class Nalogprijem
implements Serializable,
PzEntity {
    private static final long serialVersionUID = 1L;
    public static final int STATUS_NA_CEKANJU = 0;
    public static final int STATUS_PAKUJE_SE = 1;
    public static final int STATUS_SPAKOVAN = 2;
    @Id
    @Column(unique=true, nullable=false)
    @TableGenerator(name="NalogPrijemTab", table="ID_GEN", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="NALOG_PRIJEM_ID", initialValue=1, allocationSize=1)
    @GeneratedValue(generator="NalogPrijemTab", strategy=GenerationType.TABLE)
    private int oznNalogPrijem;
    @Column(nullable=false)
    private Date datNaloga;
    private Date datPakovanja;
    @Column(nullable=false, length=30)
    private String magacini;
    private String napomena;
    private String potpis;
    @Column(nullable=false)
    private int status;
    private int spakovano;
    @OneToMany(mappedBy="nalogprijem", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<Artikalnalogprijem> artikalnalogprijems;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idDok", nullable=false)
    private Dokument dokument;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="pzusername", nullable=false)
    private Pzuser pzuser;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="oznOgranak", referencedColumnName="OZNOGRANAK", nullable=false), @JoinColumn(name="oznRj", referencedColumnName="OZNRJ", nullable=false)})
    private Radnajedinica radnajedinica;

    public int getOznNalogPrijem() {
        return this.oznNalogPrijem;
    }

    public void setOznNalogPrijem(int oznnalogprijem) {
        this.oznNalogPrijem = oznnalogprijem;
    }

    public Date getDatNaloga() {
        return this.datNaloga;
    }

    public void setDatNaloga(Date datnaloga) {
        this.datNaloga = datnaloga;
    }

    public Date getDatPakovanja() {
        return this.datPakovanja;
    }

    public void setDatPakovanja(Date datpakovanja) {
        this.datPakovanja = datpakovanja;
    }

    public String getMagacini() {
        return this.magacini;
    }

    public void setMagacini(String magacini) {
        this.magacini = magacini;
    }

    public String getPotpis() {
        return this.potpis;
    }

    public void setPotpis(String potpis) {
        this.potpis = potpis;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getSpakovano() {
        return this.spakovano;
    }

    public void setSpakovano(int spakovano) {
        this.spakovano = spakovano;
    }

    public List<Artikalnalogprijem> getArtikalnalogprijems() {
        return this.artikalnalogprijems;
    }

    public void setArtikalnalogprijems(List<Artikalnalogprijem> artikalnalogprijems) {
        this.artikalnalogprijems = artikalnalogprijems;
    }

    public Dokument getDokument() {
        return this.dokument;
    }

    public void setDokument(Dokument kalkulacija) {
        this.dokument = kalkulacija;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Status", "Nalog", "Datum naloga", "Datum pakovanja", "Dokument", "Rj", "\u0160ifta dob.", "Naziv dob.", "Br.fakture", "Magacini"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.status, this.getOznNalogPrijem(), this.datNaloga, this.datPakovanja, String.valueOf(TipDokumentConfig.getNameByValue(this.dokument.getTip(), null)) + " " + this.dokument.getOznDokumenta(), this.dokument.getRadnajedinica().getId().getOznRj(), this.dokument.getKomitent() == null ? "" : this.dokument.getKomitent().getSfrKomitent(), this.dokument.getKomitent() == null ? "" : this.dokument.getKomitent().getNaziv(), this.dokument.getOznDokumenta(), this.magacini};
    }

    public Pzuser getPzuser() {
        return this.pzuser;
    }

    public void setPzuser(Pzuser pzuser) {
        this.pzuser = pzuser;
    }

    public String getNapomena() {
        return this.napomena;
    }

    public void setNapomena(String napomena) {
        this.napomena = napomena;
    }

    public Radnajedinica getRadnajedinica() {
        return this.radnajedinica;
    }

    public void setRadnajedinica(Radnajedinica radnajedinica) {
        this.radnajedinica = radnajedinica;
    }
}

