/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Radnajedinica;

@Embeddable
public class LokacijaPK
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(unique=true, nullable=false, length=255)
    private String sfrProizvod;
    @Column(unique=true, nullable=false, length=255)
    private String oznOgranak;
    @Column(unique=true, nullable=false, length=255)
    private String oznRj;

    public LokacijaPK() {
    }

    public LokacijaPK(Artikal artikal, Radnajedinica radnajedinica) {
        this.sfrProizvod = artikal.getSfrProizvod();
        this.oznOgranak = radnajedinica.getId().getOznOgranak();
        this.oznRj = radnajedinica.getId().getOznRj();
    }

    public LokacijaPK(String sfrProizvod, Radnajedinica rj) {
        this.sfrProizvod = sfrProizvod;
        this.oznOgranak = rj.getId().getOznOgranak();
        this.oznRj = rj.getId().getOznRj();
    }

    public String getSfrProizvod() {
        return this.sfrProizvod;
    }

    public void setSfrProizvod(String sfrProizvod) {
        this.sfrProizvod = sfrProizvod;
    }

    public String getOznOgranak() {
        return this.oznOgranak;
    }

    public void setOznOgranak(String oznOgranak) {
        this.oznOgranak = oznOgranak;
    }

    public String getOznRj() {
        return this.oznRj;
    }

    public void setOznRj(String oznRj) {
        this.oznRj = oznRj;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LokacijaPK)) {
            return false;
        }
        LokacijaPK castOther = (LokacijaPK)other;
        return this.sfrProizvod.equals(castOther.sfrProizvod) && this.oznOgranak.equals(castOther.oznOgranak) && this.oznRj.equals(castOther.oznRj);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.sfrProizvod.hashCode();
        hash = hash * 31 + this.oznOgranak.hashCode();
        hash = hash * 31 + this.oznRj.hashCode();
        return hash;
    }
}

