/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.KursPK;
import rs.pezar.db.entity.Valuta;

@Entity
@Table(name="Kurs")
public class Kurs
implements Serializable,
PzEntity {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private KursPK id;
    private int auto;
    private int jedinica;
    @Column(precision=20, scale=4)
    private BigDecimal kupovni;
    @Column(nullable=false, precision=20, scale=4)
    private BigDecimal srednji;
    @Column(precision=20, scale=4)
    private BigDecimal prodajni;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="oznValuta", nullable=false, insertable=false, updatable=false)
    private Valuta valuta;

    public KursPK getId() {
        return this.id;
    }

    public void setId(KursPK id) {
        this.id = id;
    }

    public BigDecimal getSrednji() {
        return this.srednji;
    }

    public void setSrednji(BigDecimal iznos) {
        this.srednji = iznos;
    }

    public Valuta getValuta() {
        return this.valuta;
    }

    public void setValuta(Valuta valuta) {
        this.valuta = valuta;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Valuta", "Jedinica", "Datum", "Iznos"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{String.valueOf(this.valuta.getOznValuta()) + " [ " + this.valuta.getNaziv() + " ] ", this.jedinica, this.id.getDatum(), this.srednji};
    }

    public int getAuto() {
        return this.auto;
    }

    public void setAuto(int auto) {
        this.auto = auto;
    }

    public int getJedinica() {
        return this.jedinica;
    }

    public void setJedinica(int jedinica) {
        this.jedinica = jedinica;
    }

    public BigDecimal getKupovni() {
        return this.kupovni;
    }

    public void setKupovni(BigDecimal kupovni) {
        this.kupovni = kupovni;
    }

    public BigDecimal getProdajni() {
        return this.prodajni;
    }

    public void setProdajni(BigDecimal prodajni) {
        this.prodajni = prodajni;
    }
}

