/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.entity.Akonstaksa;
import rs.pezar.db.entity.Artikalkonsignacija;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.globals.TipDokumentConfig;

@Entity
@Table(name="Konsignacija")
public class Konsignacija
extends PzDokument
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(unique=true, nullable=false)
    private int idDok;
    @Column(nullable=false)
    private short arhiviran;
    private short cvProdajna;
    private Date datArh;
    private Date datum;
    @Column(nullable=false)
    private BigDecimal iznosBezPoreza = new BigDecimal(0);
    @Column(nullable=false)
    private BigDecimal iznosSaPorezom = new BigDecimal(0);
    @Column(length=255)
    private String oznDokumenta;
    @Column(length=30)
    private String podTip;
    @Column(nullable=false)
    private BigDecimal pdvIznos = new BigDecimal(0);
    @Column(nullable=false)
    private double procRabata;
    @Column(nullable=false)
    private short proknjizen;
    @Column(length=255)
    private String poruka;
    @Column(nullable=false)
    private int rbrDok;
    @Column(nullable=false)
    private int rBroj;
    @Column(nullable=false, length=255)
    private String rjUlaz;
    @Column(nullable=false)
    private int storno;
    private BigDecimal stornoIznos = new BigDecimal(0);
    @Column(nullable=false, length=255)
    private String tip;
    @OneToMany(mappedBy="konsignacija", cascade={CascadeType.ALL})
    @OrderBy(value="sort ASC")
    private List<Artikalkonsignacija> artikalkonsignacijas;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="oznOgranak", referencedColumnName="OZNOGRANAK", nullable=false), @JoinColumn(name="oznRj", referencedColumnName="OZNRJ", nullable=false)})
    private Radnajedinica radnajedinica;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="idDok", nullable=false, insertable=false, updatable=false)
    private Dokument dokument;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="usernamepoc", nullable=false)
    private Pzuser userPoc;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="usernamekraj", nullable=false)
    private Pzuser userKraj;

    @Override
    public int getIdDok() {
        return this.idDok;
    }

    @Override
    public void setIdDok(int idDok) {
        this.idDok = idDok;
    }

    @Override
    public short getArhiviran() {
        return this.arhiviran;
    }

    @Override
    public void setArhiviran(short arhiviran) {
        this.arhiviran = arhiviran;
    }

    @Override
    public short getCvProdajna() {
        return this.cvProdajna;
    }

    @Override
    public void setCvProdajna(short cvProdajna) {
        this.cvProdajna = cvProdajna;
    }

    @Override
    public Date getDatArh() {
        return this.datArh;
    }

    @Override
    public void setDatArh(Date datArh) {
        this.datArh = datArh;
    }

    @Override
    public Date getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Date datum) {
        this.datum = datum;
    }

    public BigDecimal getIznosBezPoreza() {
        return this.iznosBezPoreza;
    }

    public void setIznosBezPoreza(BigDecimal iznosBezPoreza) {
        this.iznosBezPoreza = iznosBezPoreza;
    }

    public BigDecimal getIznosSaPorezom() {
        return this.iznosSaPorezom;
    }

    public void setIznosSaPorezom(BigDecimal iznosSaPorezom) {
        this.iznosSaPorezom = iznosSaPorezom;
    }

    @Override
    public String getOznDokumenta() {
        return this.oznDokumenta;
    }

    @Override
    public void setOznDokumenta(String oznDokumenta) {
        this.oznDokumenta = oznDokumenta;
    }

    @Override
    public String getPodTip() {
        return this.podTip;
    }

    @Override
    public void setPodTip(String podTip) {
        this.podTip = podTip;
    }

    public BigDecimal getPdvIznos() {
        return this.pdvIznos;
    }

    public void setPdvIznos(BigDecimal pdvIznos) {
        this.pdvIznos = pdvIznos;
    }

    public double getProcRabata() {
        return this.procRabata;
    }

    public void setProcRabata(double procRabata) {
        this.procRabata = procRabata;
    }

    @Override
    public short getProknjizen() {
        return this.proknjizen;
    }

    @Override
    public void setProknjizen(short proknjizen) {
        this.proknjizen = proknjizen;
    }

    public String getPoruka() {
        return this.poruka;
    }

    public void setPoruka(String razlogIzrade) {
        this.poruka = razlogIzrade;
    }

    @Override
    public int getRbrDok() {
        return this.rbrDok;
    }

    @Override
    public void setRbrDok(int rbrDok) {
        this.rbrDok = rbrDok;
    }

    @Override
    public int getrBroj() {
        return this.rBroj;
    }

    @Override
    public void setrBroj(int rBroj) {
        this.rBroj = rBroj;
    }

    public String getRjUlaz() {
        return this.rjUlaz;
    }

    public void setRjUlaz(String rjUlaz) {
        this.rjUlaz = rjUlaz;
    }

    @Override
    public int getStorno() {
        return this.storno;
    }

    @Override
    public void setStorno(int storno) {
        this.storno = storno;
    }

    @Override
    public BigDecimal getStornoIznos() {
        return this.stornoIznos;
    }

    @Override
    public void setStornoIznos(BigDecimal stornoIznos) {
        this.stornoIznos = stornoIznos;
    }

    @Override
    public String getTip() {
        return this.tip;
    }

    @Override
    public void setTip(String tip) {
        this.tip = tip;
    }

    @Override
    public String getVrsta() {
        String vrsta = null;
        if (this.tip.equals("KONSIGNACIJA_PRIJEM_V") || this.tip.equals("KONSIGNACIJA_PRIJEM_M")) {
            vrsta = "U";
        } else if (this.tip.equals("KONSIGNACIJA_POVRATNICA_V") || this.tip.equals("KONSIGNACIJA_POVRATNICA_M")) {
            vrsta = "I";
        }
        return vrsta;
    }

    @Override
    public void setVrsta(String vrsta) {
    }

    public List<Artikalkonsignacija> getArtikalkonsignacijas() {
        return this.artikalkonsignacijas;
    }

    public void setArtikalkonsignacijas(List<Artikalkonsignacija> artikalkonsignacijas) {
        this.artikalkonsignacijas = artikalkonsignacijas;
    }

    @Override
    public Radnajedinica getRadnajedinica() {
        return this.radnajedinica;
    }

    @Override
    public void setRadnajedinica(Radnajedinica radnajedinica) {
        this.radnajedinica = radnajedinica;
    }

    @Override
    public Dokument getDokument() {
        return this.dokument;
    }

    @Override
    public void setDokument(Dokument dokument) {
        this.dokument = dokument;
    }

    @Override
    public Pzuser getUserPoc() {
        return this.userPoc;
    }

    @Override
    public void setUserPoc(Pzuser pzuser) {
        this.userPoc = pzuser;
    }

    @Override
    public Pzuser getUserKraj() {
        return this.userKraj;
    }

    @Override
    public void setUserKraj(Pzuser pzuser) {
        this.userKraj = pzuser;
    }

    @Override
    public void formirajOznaku() {
        String tipI = this.getTip();
        if (tipI.equals("KONSIGNACIJA_POVRATNICA_V") || tipI.equals("KONSIGNACIJA_POVRATNICA_M")) {
            this.oznDokumenta = String.format("%s/%s-%s", this.getRadnajedinica().getId().getOznRj(), String.valueOf(this.getRadnajedinica().getId().getOznRj()) + this.getRadnajedinica().getgTip(), PzEntityUtil.strZero("" + this.getrBroj(), 5));
        }
    }

    @Override
    public List<? extends PzArtikalDokument> getArtikalDocuments() {
        return this.artikalkonsignacijas;
    }

    @Override
    public String[] getDokColumnNames() {
        if (this.tip != null) {
            if (this.tip.equals("KONSIGNACIJA_PRIJEM_V")) {
                return new String[]{"Prijemnica", "Dokumenat", "Datum", "Iznos", "iddok", "rjulaz", "Arhivirao"};
            }
            if (this.tip.equals("KONSIGNACIJA_POVRATNICA_V")) {
                return new String[]{"Povratnica", "Dokumenat", "Datum", "Iznos", "iddok", "rjulaz", "Arhivirao"};
            }
            if (this.tip.equals("KONSIGNACIJA_PRIJEM_M")) {
                return new String[]{"Prijemnica", "Dokumenat", "Datum", "Bez PDV-a", "PDV", "Sa PDV-om", "iddok", "rjulaz", "Arhivirao"};
            }
            if (this.tip.equals("KONSIGNACIJA_POVRATNICA_M")) {
                return new String[]{"Prijemnica", "Dokumenat", "Datum", "Bez PDV-a", "PDV", "Sa PDV-om", "iddok", "rjulaz", "Arhivirao"};
            }
            return null;
        }
        return null;
    }

    @Override
    public Object[] getDokValues() {
        if (this.tip.equals("KONSIGNACIJA_PRIJEM_V") || this.tip.equals("KONSIGNACIJA_POVRATNICA_V")) {
            return new Object[]{this.rBroj, this.oznDokumenta, this.datum, 0, this.iznosBezPoreza};
        }
        if (this.tip.equals("KONSIGNACIJA_PRIJEM_M") || this.tip.equals("KONSIGNACIJA_POVRATNICA_M")) {
            return new Object[]{this.rBroj, this.oznDokumenta, this.datum, 0, this.iznosBezPoreza, this.iznosSaPorezom.subtract(this.iznosBezPoreza), this.iznosSaPorezom};
        }
        return null;
    }

    @Override
    public Object[] getKValues(byte type) {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Br. dokumenta", "Datum dok.", "Iznos bez poreza", "Iznos sa porezom", "Radna jedinica"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.getrBroj(), this.datum, this.iznosBezPoreza, this.iznosSaPorezom, String.valueOf(this.radnajedinica.getId().getOznRj()) + " - " + this.radnajedinica.getNaziv()};
    }

    @Override
    public BigDecimal getIznos() {
        return null;
    }

    @Override
    public Komitent getKomitent() {
        return null;
    }

    @Override
    public void setIznos(BigDecimal iznos) {
    }

    @Override
    public void setKomitent(Komitent komitent) {
    }

    @Override
    public String getOpis() {
        return TipDokumentConfig.getNameByValue(this.getTip(), null);
    }

    @Override
    public void setOpis(String opis) {
    }

    @Override
    public void adjust() {
        if (this.getArtikalkonsignacijas() != null) {
            for (Artikalkonsignacija ak : this.getArtikalkonsignacijas()) {
                ak.getId().setIdDok(this.getIdDok());
                if (ak.getAkonstaksas() == null) continue;
                for (Akonstaksa taksa : ak.getAkonstaksas()) {
                    taksa.getId().setIdDok(this.getIdDok());
                    taksa.getId().setrBroj(ak.getId().getrBroj());
                }
            }
        }
    }

    @Override
    public Date getDatValute() {
        return null;
    }

    @Override
    public void setDatValute(Date datum) {
    }

    @Override
    public PzTaksaDokument createEmptyTaksaDokument(String oznTarGr, String tip) {
        return null;
    }

    @Override
    public void setTaksadokuments(List<? extends PzTaksaDokument> taksaDokuments) {
    }

    @Override
    public List<? extends PzTaksaDokument> getTaksadokuments() {
        return null;
    }

    @Override
    public void izracunajVrednostRobe() {
    }

    @Override
    public Date getDatPrometa() {
        return this.datum;
    }

    @Override
    public void setArtikalDokuments(List<? extends PzArtikalDokument> list) {
        this.artikalkonsignacijas = list;
    }

    public int getCountArtikal(String sfrA) {
        int i = 0;
        for (Artikalkonsignacija af : this.artikalkonsignacijas) {
            if (!af.getId().getSfrProizvod().equals(sfrA)) continue;
            ++i;
        }
        return i;
    }
}

