/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.eclipse.persistence.annotations.PrivateOwned;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityExtended;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzRacun;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.entity.Aktaksa;
import rs.pezar.db.entity.Artikalkalkulacija;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Kalkulacijazapisnik;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Taksakalkulacija;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.db.entity.Trosak;
import rs.pezar.globals.TipDokumentConfig;

@Entity
@Table(name="Kalkulacija")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="discriminator", discriminatorType=DiscriminatorType.STRING, length=255)
@DiscriminatorValue(value="KALKULACIJA")
public class Kalkulacija
extends PzDokument
implements Serializable,
PzRacun {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(unique=true, nullable=false)
    private int idDok;
    @Column(nullable=false)
    private short arhiviran;
    @Column(nullable=false)
    private short cvProdajna;
    private Date datArh;
    @Column(nullable=false)
    private Date datDPO;
    @Column(nullable=false)
    private Date datum;
    @Column(nullable=false)
    private Date datFakture;
    @Column(nullable=false)
    private Date datValute;
    @Column(nullable=false)
    private BigDecimal iznos = new BigDecimal(0);
    @Column(nullable=false)
    private double kurs;
    private BigDecimal nabavnaVrednost;
    private BigDecimal razlUCeni = new BigDecimal(0);
    @Column(nullable=false, length=255)
    private String oznDokumenta;
    @Column(length=30)
    private String podTip;
    @Column(nullable=false, length=255)
    private String pdv;
    @Column(nullable=false)
    private double procRabata;
    private BigDecimal prodVrednost = new BigDecimal(0);
    @Column(nullable=false)
    private short proknjizen;
    @Column(nullable=false)
    private int rbrDok;
    @Column(nullable=false)
    private int rBroj;
    @Column(nullable=false)
    private int storno;
    private BigDecimal stornoIznos = new BigDecimal(0);
    @Column(nullable=false, length=2000)
    private String poruka;
    @Column(nullable=false, length=45)
    private String tip;
    @Column(nullable=false, length=255)
    private String tipKalkulacije;
    @Column(nullable=false)
    private BigDecimal trosakBezPdv = new BigDecimal(0);
    private BigDecimal troskoviCarina = new BigDecimal(0);
    private BigDecimal troskoviInterni = new BigDecimal(0);
    private BigDecimal troskoviEksterni = new BigDecimal(0);
    private BigDecimal uplata = new BigDecimal(0);
    @Column(nullable=false)
    private BigDecimal ukupnoFakturisano = new BigDecimal(0);
    private BigDecimal vrednostRobe = new BigDecimal(0);
    private BigDecimal zaokruzenje = new BigDecimal(0);
    private String kategorija;
    @Transient
    private BigDecimal zatvaranje = new BigDecimal(0);
    @OneToMany(mappedBy="kalkulacija", cascade={CascadeType.ALL})
    @PrivateOwned
    @OrderBy(value="id.rBroj ASC")
    private List<Artikalkalkulacija> artikalkalkulacijas;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="oznOgranak", referencedColumnName="OZNOGRANAK"), @JoinColumn(name="oznRj", referencedColumnName="OZNRJ")})
    private Radnajedinica radnajedinica;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="idDok", nullable=false, insertable=false, updatable=false)
    private Dokument dokument;
    @OneToMany(mappedBy="kalkulacija", fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    private List<Kalkulacijazapisnik> kalkulacijazapisniks1;
    @OneToMany(mappedBy="zapisnik", fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    private List<Kalkulacijazapisnik> kalkulacijazapisniks2;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="sfrKomitent", nullable=false)
    private Komitent komitent;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="usernamepoc", nullable=false)
    private Pzuser userPoc;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="usernamekraj", nullable=false)
    private Pzuser userKraj;
    @OneToMany(mappedBy="kalkulacija", cascade={CascadeType.ALL})
    @PrivateOwned
    private List<Taksakalkulacija> taksakalkulacijas;
    @OneToMany(mappedBy="kalkulacija", cascade={CascadeType.ALL})
    @PrivateOwned
    private List<Trosak> trosaks;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="original")
    private Kalkulacija original;
    @OneToMany(mappedBy="original")
    private List<Kalkulacija> originals;

    @Override
    public int getIdDok() {
        return this.idDok;
    }

    @Override
    public void setIdDok(int idDok) {
        this.idDok = idDok;
    }

    @Override
    public short getArhiviran() {
        return this.arhiviran;
    }

    @Override
    public void setArhiviran(short arhiviran) {
        this.arhiviran = arhiviran;
    }

    @Override
    public void setCvProdajna(short cvProdajna) {
        this.cvProdajna = cvProdajna;
    }

    @Override
    public short getCvProdajna() {
        return this.cvProdajna;
    }

    @Override
    public Date getDatArh() {
        return this.datArh;
    }

    @Override
    public void setDatArh(Date datArh) {
        this.datArh = datArh;
    }

    public Date getDatDPO() {
        return this.datDPO;
    }

    public void setDatDPO(Date datDPO) {
        this.datDPO = datDPO;
    }

    public Date getDatFakture() {
        return this.datFakture;
    }

    public void setDatFakture(Date datFakture) {
        this.datFakture = datFakture;
    }

    @Override
    public Date getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Date datum) {
        this.datum = datum;
    }

    @Override
    public Date getDatValute() {
        return this.datValute;
    }

    @Override
    public void setDatValute(Date datValute) {
        this.datValute = datValute;
    }

    @Override
    public BigDecimal getIznos() {
        return this.iznos;
    }

    @Override
    public void setIznos(BigDecimal iznos) {
        this.iznos = iznos;
    }

    public double getKurs() {
        return this.kurs;
    }

    public void setKurs(double kursEvra) {
        this.kurs = kursEvra;
    }

    public BigDecimal getNabavnaVrednost() {
        return this.nabavnaVrednost;
    }

    public void setNabavnaVrednost(BigDecimal nabavnaVrednost) {
        this.nabavnaVrednost = nabavnaVrednost;
    }

    public BigDecimal getRazlUCeni() {
        return this.razlUCeni;
    }

    public void setRazlUCeni(BigDecimal nabavnaVrednost) {
        this.razlUCeni = nabavnaVrednost;
    }

    @Override
    public String getOznDokumenta() {
        return this.oznDokumenta;
    }

    @Override
    public void setOznDokumenta(String oznDokumenta) {
        this.oznDokumenta = oznDokumenta;
    }

    @Override
    public String getPodTip() {
        return this.podTip;
    }

    @Override
    public void setPodTip(String podTip) {
        this.podTip = podTip;
    }

    public String getPdv() {
        return this.pdv;
    }

    public void setPdv(String pdv) {
        this.pdv = pdv;
    }

    public double getProcRabata() {
        return this.procRabata;
    }

    public void setProcRabata(double procRabata) {
        this.procRabata = procRabata;
    }

    public void setProdVrednost(BigDecimal prodVrednost) {
        this.prodVrednost = prodVrednost;
    }

    public BigDecimal getProdVrednost() {
        return this.prodVrednost;
    }

    @Override
    public short getProknjizen() {
        return this.proknjizen;
    }

    @Override
    public void setProknjizen(short proknjizen) {
        this.proknjizen = proknjizen;
    }

    @Override
    public int getRbrDok() {
        return this.rbrDok;
    }

    @Override
    public void setRbrDok(int rbrDok) {
        this.rbrDok = rbrDok;
    }

    @Override
    public int getrBroj() {
        return this.rBroj;
    }

    @Override
    public void setrBroj(int rBroj) {
        this.rBroj = rBroj;
    }

    @Override
    public int getStorno() {
        return this.storno;
    }

    @Override
    public void setStorno(int storno) {
        this.storno = storno;
    }

    @Override
    public void setStornoIznos(BigDecimal stornoIznos) {
        this.stornoIznos = stornoIznos;
        if (this.getDokument() != null) {
            this.getDokument().setStornoIznos(stornoIznos);
        }
    }

    @Override
    public BigDecimal getStornoIznos() {
        return this.stornoIznos;
    }

    public String getPoruka() {
        return this.poruka;
    }

    public void setPoruka(String stornoRazlog) {
        this.poruka = stornoRazlog;
    }

    @Override
    public String getTip() {
        return this.tip;
    }

    @Override
    public void setTip(String tip) {
        this.tip = tip;
    }

    public String getTipKalkulacije() {
        return this.tipKalkulacije;
    }

    public void setTipKalkulacije(String tipKalkulacije) {
        this.tipKalkulacije = tipKalkulacije;
    }

    public BigDecimal getTrosakBezPdv() {
        return this.trosakBezPdv;
    }

    public BigDecimal getTroskoviCarina() {
        return this.troskoviCarina;
    }

    public void setTroskoviCarina(BigDecimal troskoviCarina) {
        this.troskoviCarina = troskoviCarina;
    }

    public BigDecimal getTroskoviInterni() {
        return this.troskoviInterni;
    }

    public void setTroskoviInterni(BigDecimal troskoviInterni) {
        this.troskoviInterni = troskoviInterni;
    }

    public BigDecimal getTroskoviEksterni() {
        return this.troskoviEksterni;
    }

    public void setTroskoviEksterni(BigDecimal troskoviEksterni) {
        this.troskoviEksterni = troskoviEksterni;
    }

    public void setTrosakBezPdv(BigDecimal trosakBezPdv) {
        this.trosakBezPdv = trosakBezPdv;
    }

    @Override
    public BigDecimal getUplata() {
        return this.uplata;
    }

    @Override
    public void setUplata(BigDecimal uplata) {
        this.uplata = uplata;
        if (this.getDokument() != null) {
            this.getDokument().setUplata(uplata);
        }
    }

    public BigDecimal getUkupnoFakturisano() {
        return this.ukupnoFakturisano;
    }

    public void setUkupnoFakturisano(BigDecimal ukupnoFakturisano) {
        this.ukupnoFakturisano = ukupnoFakturisano;
    }

    @Override
    public BigDecimal getVrednostRobe() {
        return this.vrednostRobe;
    }

    @Override
    public void setVrednostRobe(BigDecimal vrednostRobe) {
        this.vrednostRobe = vrednostRobe;
    }

    @Override
    public String getVrsta() {
        return "U";
    }

    @Override
    public void setVrsta(String vrsta) {
    }

    public BigDecimal getZaokruzenje() {
        return this.zaokruzenje;
    }

    public void setZaokruzenje(BigDecimal zaokruzenje) {
        this.zaokruzenje = zaokruzenje;
    }

    public String getKategorija() {
        return this.kategorija;
    }

    public void setKategorija(String kategorija) {
        this.kategorija = kategorija;
    }

    public List<Artikalkalkulacija> getArtikalkalkulacijas() {
        return this.artikalkalkulacijas;
    }

    public void setArtikalkalkulacijas(List<Artikalkalkulacija> artikalkalkulacijas) {
        this.artikalkalkulacijas = artikalkalkulacijas;
    }

    @Override
    public Radnajedinica getRadnajedinica() {
        return this.radnajedinica;
    }

    @Override
    public void setRadnajedinica(Radnajedinica radnajedinica) {
        this.radnajedinica = radnajedinica;
    }

    @Override
    public Dokument getDokument() {
        return this.dokument;
    }

    @Override
    public void setDokument(Dokument dokument) {
        this.dokument = dokument;
    }

    public void setKalkulacijazapisniks1(List<Kalkulacijazapisnik> kalkulacijazapisniks) {
        this.kalkulacijazapisniks1 = kalkulacijazapisniks;
    }

    public List<Kalkulacijazapisnik> getKalkulacijazapisniks1() {
        return this.kalkulacijazapisniks1;
    }

    public List<Kalkulacijazapisnik> getKalkulacijazapisniks2() {
        return this.kalkulacijazapisniks2;
    }

    public void setKalkulacijazapisniks2(List<Kalkulacijazapisnik> kalkulacijazapisniks2) {
        this.kalkulacijazapisniks2 = kalkulacijazapisniks2;
    }

    @Override
    public Komitent getKomitent() {
        return this.komitent;
    }

    @Override
    public void setKomitent(Komitent komitent) {
        this.komitent = komitent;
    }

    @Override
    public Pzuser getUserPoc() {
        return this.userPoc;
    }

    @Override
    public void setUserPoc(Pzuser pzuser) {
        this.userPoc = pzuser;
    }

    @Override
    public Pzuser getUserKraj() {
        return this.userKraj;
    }

    @Override
    public void setUserKraj(Pzuser pzuser) {
        this.userKraj = pzuser;
    }

    public List<Taksakalkulacija> getTaksakalkulacijas() {
        return this.taksakalkulacijas;
    }

    public void setTaksakalkulacijas(List<Taksakalkulacija> pdvkalkulacijas) {
        this.taksakalkulacijas = pdvkalkulacijas;
    }

    public List<Trosak> getTrosaks() {
        return this.trosaks;
    }

    public void setTrosaks(List<Trosak> trosaks) {
        this.trosaks = trosaks;
    }

    @Override
    public Kalkulacija getOriginal() {
        return this.original;
    }

    public void setOriginal(Kalkulacija original) {
        this.original = original;
    }

    public List<Kalkulacija> getOriginals() {
        return this.originals;
    }

    public void setOriginals(List<Kalkulacija> originals) {
        this.originals = originals;
    }

    public void setZatvaranje(BigDecimal zatvaranje) {
        this.zatvaranje = zatvaranje;
    }

    public BigDecimal getZatvaranje() {
        return this.zatvaranje;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"\u0160ifra dobavlja\u010da", "Naziv dobavlja\u010da", "Broj dokumenta", "Datum dokumenta", "Iznos", "RJ"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.komitent.getSfrKomitent(), this.komitent.getNaziv(), this.getOznDokumenta(), this.datum, this.iznos, this.radnajedinica != null ? this.radnajedinica.getId().getOznRj() : null};
    }

    @Override
    public String[] getDokColumnNames() {
        return new String[]{"Kalkulacija", "Datum izrade", "Datum dokumenta", "NZK", "Dobavlja\u010d", "Dokument", "Iznos fakture", "Iznos otpremnice", "Razlika u ceni", "Ukalkulisani PDV", "Prodajna vrednost", "PDV", "Eksterni tro\u0161kovi.", "Interni tro\u0161kovi"};
    }

    public String[] getKalkColumnNames() {
        if (TipDokumentConfig.get().PRIJEMNICA_REPRO.equals(this.tip)) {
            return new String[]{"iddok", "Kalkulacija", "Datum izrade", "Datum dokumenta", "Dobavlja\u010d", "Dokument", "Iznos dokumenta", "Tip dokumenta", "Razlika u ceni", "Ukalkulisani PDV", "Planska vrednost", "PDV", "Eksterni tro\u0161kovi", "Interni tro\u0161kovi", "Dokument arhivirao"};
        }
        return new String[]{"iddok", "Kalkulacija", "Datum izrade", "Datum dokumenta", "Dobavlja\u010d", "Dokument", "Iznos dokumenta", "Tip dokumenta", "Razlika u ceni", "Ukalkulisani PDV", "Prodajna vrednost", "PDV", "Eksterni tro\u0161kovi", "Interni tro\u0161kovi", "Dokument arhivirao"};
    }

    @Override
    public Object[] getDokValues() {
        double nabv = 0.0;
        double prodv = 0.0;
        for (Artikalkalkulacija ak : this.artikalkalkulacijas) {
            nabv += ak.getFakturnaCena() * ak.getKolicina() * (1.0 - ak.getProcRabata() / 100.0);
            prodv += ak.getProdCena().doubleValue() * ak.getKolicina();
        }
        return new Object[]{this.rBroj, this.datum, this.datum, "NZK", this.komitent.getSfrKomitent(), this.getOznDokumenta(), this.iznos, "IZNOS OTPREMNICE", prodv - nabv, "UKALK PDV", "PRODAJNA VRED", this.pdv, "E TROSKOVI", "I TROSKOVI"};
    }

    @Override
    public Object[] getKValues(byte type) {
        return new Object[]{this.getDatFakture(), this.getOpis(), this.getOznDokumenta(), 0.0, this.storno == 0 ? this.iznos : this.iznos.negate(), 0.0, this.getDatValute(), 0};
    }

    @Override
    public void formirajOznaku() {
    }

    public void setId(int id) {
        this.setIdDok(id);
    }

    public BigDecimal getPdvIznos() {
        BigDecimal pdv = new BigDecimal(0);
        for (Taksakalkulacija taksa : this.taksakalkulacijas) {
            if (!taksa.getVrsta().equals("PDV")) continue;
            pdv = pdv.add(taksa.getIznos());
        }
        return pdv;
    }

    public int getId() {
        return this.getIdDok();
    }

    @Override
    public List<? extends PzArtikalDokument> getArtikalDocuments() {
        return this.getArtikalkalkulacijas();
    }

    @Override
    public List<? extends PzTaksaDokument> getTaksadokuments() {
        return this.getTaksakalkulacijas();
    }

    @Override
    public String getOpis() {
        String dokumentNaziv2 = "Greska u prepoznavanju";
        String tipFakture = this.getTip();
        int storno = this.getStorno();
        if (tipFakture.equalsIgnoreCase(TipDokumentConfig.get().KALKULACIJA)) {
            dokumentNaziv2 = storno == 0 ? "Kalkulacija" : "Storno kalkulacije";
        } else if (tipFakture.equalsIgnoreCase(TipDokumentConfig.get().ZAPISNIK_OTPREMNICE)) {
            dokumentNaziv2 = storno == 0 ? "Naknadna faktura" : "Storno naknadne fakture";
        } else if (tipFakture.equalsIgnoreCase(TipDokumentConfig.get().RACUN_DOBAVLJACA)) {
            dokumentNaziv2 = storno == 0 ? "Racun dobavljaca" : "Storno rac. dobav.";
        } else if (tipFakture.equalsIgnoreCase(TipDokumentConfig.get().PRIJEMNICA_REPRO)) {
            dokumentNaziv2 = storno == 0 ? "Prijemnica" : "Storno prijemnica";
        } else {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
        String datum = formatter.format((Object)this.getDatFakture());
        this.getIznos();
        String brFakture = this.getOznDokumenta();
        String opis = String.format("%s %d, po ra\u010dunu %s: od %s", dokumentNaziv2, this.getrBroj(), brFakture, datum);
        return opis;
    }

    @Override
    public void setOpis(String opis) {
    }

    @Override
    public void adjust() {
        if (this.getArtikalkalkulacijas() != null) {
            for (Artikalkalkulacija ak : this.getArtikalkalkulacijas()) {
                ak.getId().setIdDok(this.getIdDok());
                if (ak.getAktaksas() == null) continue;
                Iterator<Aktaksa> j = ak.getAktaksas().iterator();
                while (j.hasNext()) {
                    j.next().getId().setIdDok(this.getIdDok());
                }
            }
        }
        if (this.getTaksakalkulacijas() != null) {
            Iterator<PzEntityExtended> i = this.getTaksakalkulacijas().iterator();
            while (i.hasNext()) {
                ((Taksakalkulacija)i.next()).getId().setIdDok(this.getIdDok());
            }
        }
        if (this.getTrosaks() != null) {
            for (Trosak t : this.getTrosaks()) {
                t.setKalkulacija(this);
            }
        }
    }

    @Override
    public void setOriginal(PzDokument original) {
        this.original = (Kalkulacija)original;
    }

    @Override
    public PzTaksaDokument createEmptyTaksaDokument(String oznTarGr, String tip) {
        return new Taksakalkulacija(this.idDok, oznTarGr, tip);
    }

    @Override
    public void setTaksadokuments(List<? extends PzTaksaDokument> taksaDokuments) {
        this.taksakalkulacijas = taksaDokuments;
    }

    @Override
    public boolean obracunavaSePorez(Tarifnagrupa tg, String tip) {
        return tg.getVrstatg().getOznVrstaTG().equals("PDV") && tip.equals(PzTaksaDokument.TIP_UKALKULISANI) || this.komitent.getDomaciKomitent() == 0 && tg.getVrstatg().getOznVrstaTG().equals("PDV") && tip.equals(PzTaksaDokument.TIP_IZRACUNATI);
    }

    public void removeKalkulacija(Kalkulacijazapisnik kz) {
        EntityManager em = PzEntityManager.getEm();
        try {
            em.getTransaction().begin();
            Kalkulacijazapisnik removeKZ = (Kalkulacijazapisnik)em.find(Kalkulacijazapisnik.class, (Object)kz.getId());
            em.remove((Object)removeKZ);
            Kalkulacija kalk = (Kalkulacija)em.find(Kalkulacija.class, (Object)kz.getKalkulacija().getIdDok());
            kalk.setUkupnoFakturisano(kalk.getUkupnoFakturisano().subtract(kz.getFakturisano()));
            em.getTransaction().commit();
            em.clear();
            em.close();
        }
        catch (Exception e) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            e.printStackTrace();
        }
    }

    public void addKalkulacija(Kalkulacija k, BigDecimal fakturisano, Kalkulacijazapisnik kz) {
        EntityManager em = PzEntityManager.getEm();
        em.getTransaction().begin();
        try {
            Kalkulacija updateKalk = (Kalkulacija)em.find(Kalkulacija.class, (Object)k.getIdDok());
            updateKalk.setUkupnoFakturisano(updateKalk.getUkupnoFakturisano().add(fakturisano));
            em.getTransaction().commit();
            em.clear();
            em.close();
        }
        catch (Exception e) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            e.printStackTrace();
        }
    }

    public Kalkulacijazapisnik updateKalkulacija(Kalkulacijazapisnik kz, BigDecimal fakturisano) {
        EntityManager em = PzEntityManager.getEm();
        Kalkulacijazapisnik updateKZ = null;
        try {
            em.getTransaction().begin();
            updateKZ = (Kalkulacijazapisnik)em.find(Kalkulacijazapisnik.class, (Object)kz.getId());
            Kalkulacija updateKalk = (Kalkulacija)em.find(Kalkulacija.class, (Object)kz.getKalkulacija().getIdDok());
            updateKZ.setFakturisano(fakturisano);
            updateKalk.setUkupnoFakturisano(updateKalk.getUkupnoFakturisano().subtract(kz.getFakturisano()).add(fakturisano));
            em.getTransaction().commit();
            em.clear();
            em.close();
        }
        catch (Exception e) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            e.printStackTrace();
        }
        return updateKZ;
    }

    @Override
    public void izracunajVrednostRobe() {
        if (this.getArtikalkalkulacijas() == null || this.getArtikalkalkulacijas().size() == 0) {
            return;
        }
        BigDecimal vrednost = new BigDecimal(0);
        if (this.getCvProdajna() == 1) {
            for (Artikalkalkulacija ad : this.getArtikalkalkulacijas()) {
                vrednost = vrednost.add(BDConverter.getIznos(ad.getProdCena().multiply(BDConverter.getKolicina(ad.getKolicina()))));
            }
        } else {
            for (Artikalkalkulacija ad : this.getArtikalkalkulacijas()) {
                vrednost = vrednost.add(ad.calculateNabVrednost());
            }
            vrednost = BDConverter.getIznos(vrednost.add(this.calculateRazlikaTroskova()));
        }
        this.setVrednostRobe(vrednost);
    }

    @Override
    public BigDecimal getDug() {
        return this.getIznos().subtract(this.getUplata()).subtract(this.getStornoIznos());
    }

    @Override
    public Date getDatPrometa() {
        return this.datDPO;
    }

    @Override
    public Date getDatumKnjizenja() {
        return this.getDatPrometa();
    }

    @Override
    public void setArtikalDokuments(List<? extends PzArtikalDokument> list) {
        this.artikalkalkulacijas = list;
    }

    public BigDecimal calculateTroskoviSum() {
        return this.getTroskoviEksterni().add(this.getTroskoviInterni()).add(this.getTroskoviCarina());
    }

    public BigDecimal calculateRazlikaTroskova() {
        BigDecimal sum = new BigDecimal(0);
        if (this.getArtikalkalkulacijas() != null && this.getArtikalkalkulacijas().size() > 0) {
            for (Artikalkalkulacija ak : this.getArtikalkalkulacijas()) {
                sum = sum.add(ak.calculateZavTrosak());
            }
        }
        BigDecimal tros = this.calculateTroskoviSum();
        tros = tros.add(this.getTrosakBezPdv());
        return tros.subtract(sum);
    }

    public Artikalkalkulacija getArtikal(String sfrA) {
        for (Artikalkalkulacija af : this.getArtikalkalkulacijas()) {
            if (!af.getId().getSfrProizvod().equals(sfrA)) continue;
            return af;
        }
        return null;
    }
}

