/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.eclipse.persistence.annotations.PrivateOwned;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzUslugaDokument;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fakturaparameter;
import rs.pezar.db.entity.PutniTrosak;
import rs.pezar.db.entity.Sfutaksa;
import rs.pezar.db.entity.Stavkafaktureusl;
import rs.pezar.db.entity.Taksafaktura;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.globals.TipDokumentConfig;

@Entity
@Table(name="Faktura")
@DiscriminatorValue(value="FAKTURA_USLUGA")
public class Fakturausluga
extends Faktura
implements Serializable {
    private static final long serialVersionUID = 1L;
    @OneToMany(mappedBy="fakturausluga", cascade={CascadeType.ALL})
    @PrivateOwned
    private List<PutniTrosak> putnitrosaks;
    public static final String[] kColNames = new String[]{"Ra\u010dun", "Kupac", "Naziv kupca", "Datum izdavanja", "Proknji\u017een", "Oporezivo", "PDV", "Bez PDV-a sa pravom", "Bez PDV-a bez prava", "Iznos ra\u010duna", "Dokument arhivirao", "iddok"};

    @Override
    public String getVrsta() {
        return "N";
    }

    @Override
    public void setVrsta(String vrsta) {
    }

    public List<PutniTrosak> getPutnitrosaks() {
        return this.putnitrosaks;
    }

    public void setPutnitrosaks(List<PutniTrosak> putnitrosaks) {
        this.putnitrosaks = putnitrosaks;
    }

    public Stavkafaktureusl getStavka(String sfrProizvod) {
        for (Stavkafaktureusl stavka : this.getStavkafaktureusls()) {
            if (!stavka.getUsluga().getSfrProizvod().equals(sfrProizvod)) continue;
            return stavka;
        }
        return null;
    }

    public BigDecimal getOporezivoSpedicije() {
        BigDecimal iznosUkupan = new BigDecimal("0.00");
        for (Stavkafaktureusl st : this.getStavkafaktureusls()) {
            BigDecimal kolicina = BDConverter.getKolicina(st.getKolicina());
            BigDecimal cena = BDConverter.getIznos(st.getCena());
            iznosUkupan = iznosUkupan.add(BDConverter.getIznos(cena.multiply(kolicina)));
        }
        return iznosUkupan;
    }

    public BigDecimal getIznosFaktureSpedicije() {
        BigDecimal iznosUkupan = new BigDecimal(0);
        for (Stavkafaktureusl st : this.getStavkafaktureusls()) {
            BigDecimal cena = BDConverter.getIznos(st.getCena());
            BigDecimal stopaPDV100 = null;
            stopaPDV100 = st.getUsluga() != null ? BDConverter.getStopaPDVProc(st.getUsluga().getStopa("PDV")) : BDConverter.getStopaPDVProc(st.getTaksa("PDV").getStopa());
            BigDecimal iznosPDVa = BDConverter.getIznos(cena.multiply(stopaPDV100));
            iznosUkupan = iznosUkupan.add(BDConverter.getIznos(cena.add(iznosPDVa)));
        }
        return iznosUkupan;
    }

    public BigDecimal getUkupanPdvSpedicije() {
        BigDecimal iznosUkupan = new BigDecimal(0);
        for (Stavkafaktureusl st : this.getStavkafaktureusls()) {
            BigDecimal cena = BDConverter.getIznos(st.getCena());
            BigDecimal stopaPDV100 = null;
            stopaPDV100 = st.getUsluga() != null ? BDConverter.getStopaPDVProc(st.getUsluga().getStopa("PDV")) : BDConverter.getStopaPDVProc(st.getTaksa("PDV").getStopa());
            iznosUkupan = iznosUkupan.add(cena.multiply(stopaPDV100));
        }
        return iznosUkupan;
    }

    public BigDecimal getIznosFaktureusluga() {
        BigDecimal iznos = new BigDecimal(0);
        if (this.getSaPorezom() == 1) {
            for (Stavkafaktureusl stavka : this.getStavkafaktureusls()) {
                BigDecimal cena = BDConverter.getIznos(stavka.getCena());
                if (stavka.getSfutaksas() != null) {
                    if (stavka.getFakturausluga().getRadnajedinica().getgTip().equals("E")) {
                        iznos = iznos.add(cena);
                        continue;
                    }
                    BigDecimal stopaPDV100 = null;
                    stopaPDV100 = stavka.getUsluga() != null ? BDConverter.getStopaPDVProc(stavka.getUsluga().getStopa("PDV")) : BDConverter.getStopaPDVProc(stavka.getTaksa("PDV").getStopa());
                    BigDecimal iznosPDVa = BDConverter.getIznos(cena.multiply(stopaPDV100));
                    iznos = iznos.add(BDConverter.getIznos(cena.add(iznosPDVa)));
                    continue;
                }
                iznos = iznos.add(cena);
            }
        } else {
            iznos = this.getVrednostUsluga();
        }
        return iznos;
    }

    public BigDecimal getIznosBezPDVSaPravomNaOdbitak() {
        return this.getSaPorezom() == 0 && this.getSaPravomNaOdbitak() == 1 ? this.getVrednostUsluga() : new BigDecimal(0);
    }

    public BigDecimal getIznosBezPDVBezPravaNaOdbitak() {
        return this.getSaPorezom() == 0 && this.getSaPravomNaOdbitak() == 0 ? this.getVrednostUsluga() : new BigDecimal(0);
    }

    @Override
    public String[] getColumnNames() {
        return kColNames;
    }

    @Override
    public Object[] getValues() {
        BigDecimal iznosPoreza = new BigDecimal(0);
        BigDecimal iznosBezPDVSaPravomNaOdbitak = new BigDecimal(0);
        BigDecimal iznosBezPDVBezPravaNaOdbitak = new BigDecimal(0);
        BigDecimal iznosUkupan = new BigDecimal(0);
        if (this.getStavkafaktureusls().size() == 0) {
            if (this.getSaPorezom() == 1) {
                iznosPoreza = this.getTaksafakturas().get(0).getIznos();
                iznosUkupan = iznosPoreza.add(this.getVrednostUsluga());
            } else {
                iznosUkupan = this.getSaPravomNaOdbitak() == 1 ? (iznosBezPDVSaPravomNaOdbitak = this.getVrednostUsluga()) : (iznosBezPDVBezPravaNaOdbitak = this.getVrednostUsluga());
            }
        } else {
            iznosUkupan = this.getIznosFaktureSpedicije();
            iznosPoreza = this.getUkupanPdvSpedicije();
            iznosBezPDVSaPravomNaOdbitak = iznosBezPDVBezPravaNaOdbitak = new BigDecimal(0);
            this.setVrednostUsluga(iznosUkupan.subtract(iznosPoreza));
        }
        return new Object[]{this.getOznDokumenta(), this.getKomitent().getSfrKomitent(), this.getKomitent().getNaziv(), this.getDatum().toString(), this.getProknjizen(), this.getSaPorezom() == 1 ? this.getVrednostUsluga() : Integer.valueOf(0), iznosPoreza, iznosBezPDVSaPravomNaOdbitak, iznosBezPDVBezPravaNaOdbitak, iznosUkupan, this.getIdDok()};
    }

    @Override
    public Object[] getKValues(byte type) {
        String dokument = "Greska u prepoznavanju";
        int storno = 0;
        String tipFakture = this.getTip();
        storno = this.getStorno();
        if (!tipFakture.equalsIgnoreCase("FAKTURA_USLUGA")) {
            return null;
        }
        dokument = storno == 0 ? "Faktura usluga" : "Storno Fakture Usluga";
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
        String datum = formatter.format((Object)this.getDatum());
        BigDecimal iznos = this.getVrednostUsluga().add(this.getTaksafakturas().get(0).getIznos());
        String brFakture = this.getOznDokumenta();
        String opis = String.format("%s: %s od %s", dokument, brFakture, datum);
        if (type == 1) {
            return new Object[]{this.getOznDokumenta(), this.getIznosFaktureSpedicije(), this.getIznosFaktureSpedicije().subtract(this.getUplata()), this.getDatum(), this.getDatValute()};
        }
        if (type == 2) {
            Object[] objectArray = new Object[7];
            objectArray[0] = dokument;
            objectArray[1] = this.getOznDokumenta();
            objectArray[2] = this.getIznosFaktureSpedicije();
            objectArray[3] = this.getDatValute();
            objectArray[6] = this.getUplata();
            return objectArray;
        }
        return new Object[]{this.getDatum(), opis, brFakture, storno == 0 ? iznos : iznos.negate(), 0.0, 0.0, this.getDatValute(), 0};
    }

    @Override
    public String[] getDokColumnNames() {
        return this.getColumnNames();
    }

    @Override
    public Object[] getDokValues() {
        return this.getValues();
    }

    @Override
    public void adjust() {
        if (this.getStavkafaktureusls() != null) {
            for (Stavkafaktureusl stavka : this.getStavkafaktureusls()) {
                stavka.setFakturausluga(this);
                stavka.getId().setIdDok(this.getIdDok());
                if (stavka.getSfutaksas() == null) continue;
                Iterator<Sfutaksa> j = stavka.getSfutaksas().iterator();
                while (j.hasNext()) {
                    j.next().getId().setIdDok(this.getIdDok());
                }
            }
        }
        if (this.getTaksafakturas() != null) {
            for (Taksafaktura taksa : this.getTaksafakturas()) {
                taksa.getId().setIdDok(this.getIdDok());
                taksa.setFaktura(this);
            }
        }
        if (this.getFakturaparameters() != null && this.getFakturaparameters().size() > 0) {
            for (Fakturaparameter p : this.getFakturaparameters()) {
                p.getId().setIdDok(this.getIdDok());
            }
        }
        if (this.getPutnitrosaks() != null) {
            for (PutniTrosak ptrosak : this.getPutnitrosaks()) {
                ptrosak.getId().setIddok(this.getIdDok());
                ptrosak.setFakturausluga(this);
            }
        }
        if (this.getStavkafaktureusls() != null) {
            if (this.getPodTip().equalsIgnoreCase(TipDokumentConfig.get().PODTIP_FAKTURA_SPEDICIJE)) {
                this.setIznos(this.getIznosFaktureSpedicije());
                this.setVrednostUsluga(this.getOporezivoSpedicije());
            } else if (this.getPodTip().equalsIgnoreCase(TipDokumentConfig.get().PODTIP_FAKTURA_USLUGA)) {
                this.setVrednostUsluga(this.getOporezivoSpedicije());
                this.setIznos(this.getIznosFaktureusluga());
            }
        }
        if (this.putnitrosaks != null) {
            this.setVrednostPutTroskova(this.getIznosTroskova());
        }
    }

    private BigDecimal getIznosTroskova() {
        BigDecimal rez = new BigDecimal("0.00");
        if (this.putnitrosaks.size() == 0) {
            return rez;
        }
        for (PutniTrosak trosak : this.putnitrosaks) {
            rez = rez.add(trosak.getVrednost());
        }
        return rez;
    }

    public BigDecimal getPreostaliIznosZaStorniranje() {
        return this.getIznos().subtract(this.getStornoIznos());
    }

    @Override
    public BigDecimal getDug() {
        return this.getIznos().subtract(this.getUplata()).subtract(this.getStornoIznos());
    }

    public boolean jeFakturaSpedicije() {
        return this.getPodTip().equals("FAKTURA_SPEDICIJE");
    }

    @Override
    public String getOpis() {
        String dokument = "Greska u prepoznavanju ili neimplementirani dokument";
        String tipFakture = this.getTip();
        int storno = this.getStorno();
        if (tipFakture.equalsIgnoreCase("FAKTURA_USLUGA")) {
            dokument = storno == 0 ? "Faktura usluga" : "Storno fakture usluga";
        } else if (tipFakture.equalsIgnoreCase("FAKTURA_SPEDICIJE")) {
            dokument = storno == 0 ? "Faktura spedicije" : "Storno fakture spedicije";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
        String datum = formatter.format((Object)this.getDatum());
        String brFakture = this.getOznDokumenta();
        String opis = String.format("%s: %s od %s", dokument, brFakture, datum);
        return opis;
    }

    @Override
    public boolean obracunavaSePorez(Tarifnagrupa tg, String tip) {
        return tg.getVrstatg().getOznVrstaTG().equals("PDV");
    }

    @Override
    public List<? extends PzUslugaDokument> getUslugaDocuments() {
        return this.getStavkafaktureusls();
    }
}

