/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.eclipse.persistence.annotations.PrivateOwned;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzRacun;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.PzUslugaDokument;
import rs.pezar.db.entity.Artikaldokument;
import rs.pezar.db.entity.DokumentLog;
import rs.pezar.db.entity.Dtaksa;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fakturausluga;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Konsignacija;
import rs.pezar.db.entity.Nalogmagacinu;
import rs.pezar.db.entity.Nalogprijem;
import rs.pezar.db.entity.Nivelacija;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Shema;
import rs.pezar.db.entity.Stavkanzk;
import rs.pezar.db.entity.Trosak;
import rs.pezar.db.entity.Uslugadokument;

@Entity
@Table(name="Dokument")
public class Dokument
extends PzDokument
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(unique=true, nullable=false)
    private int idDok;
    @Column(nullable=false)
    private short arhiviran;
    @Column(nullable=false)
    private short cvProdajna;
    private Date datArh;
    @Column(nullable=false)
    private Date datum;
    private Date datValute;
    private Date datPrometa;
    private BigDecimal iznos;
    private Short kepu;
    @Column(length=200)
    private String opis;
    @Column(nullable=false, length=30)
    private String oznDokumenta;
    @Column(length=30)
    private String podTip;
    @Column(nullable=false)
    private short proknjizen;
    @Column(nullable=false)
    private double razduzenje;
    @Column(nullable=false)
    private int rbrDok;
    private int rbrKepu;
    @Column(nullable=false)
    private int rBroj;
    @Column(nullable=false)
    private int storno;
    private BigDecimal stornoIznos;
    @Column(nullable=false, length=30)
    private String tip;
    private BigDecimal uplata;
    @Column(nullable=false, length=1)
    private String vrsta;
    private String vrstaDuga;
    private BigDecimal vrednostRobe;
    private BigDecimal vrednostUsluga;
    @Column(nullable=false)
    private double zaduzenje;
    @OneToMany(mappedBy="dokument", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @PrivateOwned
    private List<Artikaldokument> artikaldokuments;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="sfrKomitent")
    private Komitent komitent;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="usernamepoc", nullable=false)
    private Pzuser userPoc;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="usernamekraj", nullable=false)
    private Pzuser userKraj;
    @Transient
    private Shema shemaKnjizenja;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="oznOgranak", referencedColumnName="OZNOGRANAK", nullable=false), @JoinColumn(name="oznRj", referencedColumnName="OZNRJ", nullable=false)})
    private Radnajedinica radnajedinica;
    @OneToOne(mappedBy="dokument", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private Faktura faktura;
    @OneToOne(mappedBy="dokument", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private Fakturausluga fakturausluga;
    @OneToOne(mappedBy="dokument1", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Interniracun interniracun;
    @OneToOne(mappedBy="dokument2", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Interniracun interniracun1;
    @OneToOne(mappedBy="dokument", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private Kalkulacija kalkulacija;
    @OneToOne(mappedBy="dokument", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Konsignacija konsignacija;
    @OneToOne(mappedBy="dokument", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private Nivelacija nivelacija;
    @OneToOne(mappedBy="dokument", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Opstidokument opstidokument;
    @OneToOne(mappedBy="dokument", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Trosak trosak;
    @OneToMany(mappedBy="dokument", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<Stavkanzk> stavkanzks;
    @OneToMany(mappedBy="dokument", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @PrivateOwned
    private List<Dtaksa> dtaksas;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="original")
    private Dokument original;
    @OneToMany(mappedBy="original")
    private List<Dokument> originals;
    @OneToMany(mappedBy="dokument", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<Uslugadokument> uslugadokuments;
    @OneToMany(mappedBy="dokument", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<Nalogmagacinu> nalogmagacinus;
    @OneToMany(mappedBy="dokument", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<Nalogprijem> nalogprijems;
    @OneToMany(mappedBy="dokument", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @PrivateOwned
    private List<DokumentLog> logs;

    public Dokument() {
        this.iznos = new BigDecimal(0);
        this.stornoIznos = new BigDecimal(0);
    }

    public Dokument(PzDokument dok, boolean azuriranjeStavki) {
        this.idDok = dok.getIdDok();
        this.vrsta = dok.getVrsta();
        this.tip = dok.getTip();
        this.oznDokumenta = dok.getOznDokumenta();
        this.rBroj = dok.getrBroj();
        this.rbrDok = dok.getRbrDok();
        this.datum = dok.getDatum();
        this.datArh = dok.getDatArh();
        this.datPrometa = dok.getDatPrometa();
        this.arhiviran = dok.getArhiviran();
        this.proknjizen = dok.getProknjizen();
        this.opis = dok.getOpis();
        this.storno = dok.getStorno();
        this.iznos = dok.getIznos();
        this.radnajedinica = dok.getRadnajedinica();
        this.komitent = dok.getKomitent();
        this.userPoc = dok.getUserPoc();
        this.userKraj = dok.getUserKraj();
        this.datValute = dok.getDatValute();
        this.podTip = dok.getPodTip();
        this.cvProdajna = dok.getCvProdajna();
        this.stornoIznos = dok.getStornoIznos();
        this.vrednostRobe = dok.getVrednostRobe();
        this.vrednostUsluga = dok.getVrednostUsluga();
        if (dok instanceof PzRacun) {
            PzRacun rac = (PzRacun)((Object)dok);
            this.uplata = rac.getUplata();
        }
        if (dok.getOriginal() != null) {
            Dokument dokument = this.original = this.storno != 0 ? dok.getOriginal().getDokument() : null;
        }
        if (azuriranjeStavki) {
            if (dok.getTaksadokuments() != null && dok.getTaksadokuments().size() > 0) {
                this.copyTaksaDokuments(dok.getTaksadokuments());
            }
            if (dok.getArtikalDocuments() != null && dok.getArtikalDocuments().size() > 0) {
                this.copyArtikalDocuments(dok.getArtikalDocuments());
            }
            if (dok.getUslugaDocuments() != null && dok.getUslugaDocuments().size() > 0) {
                this.copyUslugaDocuments(dok.getUslugaDocuments());
            }
        }
    }

    public void copyTaksaDokuments(List<? extends PzTaksaDokument> taksadokuments) {
        Iterator<? extends PzTaksaDokument> i = taksadokuments.iterator();
        this.setDtaksas(new Vector<Dtaksa>());
        while (i.hasNext()) {
            Dtaksa dt = new Dtaksa(i.next(), this);
            this.getDtaksas().add(dt);
        }
    }

    public void copyArtikalDocuments(List<? extends PzArtikalDokument> artikalDocuments) {
        if (this.getArtikaldokuments() == null) {
            this.setArtikaldokuments(new Vector<Artikaldokument>());
        }
        if (artikalDocuments != null) {
            for (PzArtikalDokument pzArtikalDokument : artikalDocuments) {
                Artikaldokument artDok = new Artikaldokument(pzArtikalDokument, this);
                artDok.setDokument(this);
                this.artikaldokuments.add(artDok);
            }
        }
    }

    public void copyUslugaDocuments(List<? extends PzUslugaDokument> uslugaDocuments) {
        if (this.getUslugadokuments() == null) {
            this.setUslugadokuments(new Vector<Uslugadokument>());
        }
        if (uslugaDocuments == null) {
            return;
        }
        for (PzUslugaDokument pzUslugaDokument : uslugaDocuments) {
            Uslugadokument uslDok = new Uslugadokument(pzUslugaDokument, this);
            uslDok.setDokument(this);
            this.uslugadokuments.add(uslDok);
        }
    }

    public void update(PzDokument dok, boolean azuriranjeStavki) {
        this.tip = dok.getTip();
        this.oznDokumenta = dok.getOznDokumenta();
        this.rBroj = dok.getrBroj();
        this.rbrDok = dok.getRbrDok();
        this.datum = dok.getDatum();
        this.datArh = dok.getDatArh();
        this.datValute = dok.getDatValute();
        this.datPrometa = dok.getDatPrometa();
        this.arhiviran = dok.getArhiviran();
        this.proknjizen = dok.getProknjizen();
        this.opis = dok.getOpis();
        this.storno = dok.getStorno();
        this.iznos = dok.getIznos();
        this.radnajedinica = dok.getRadnajedinica();
        this.komitent = dok.getKomitent();
        this.userPoc = dok.getUserPoc();
        this.userKraj = dok.getUserKraj();
        this.podTip = dok.getPodTip();
        this.cvProdajna = dok.getCvProdajna();
        this.stornoIznos = dok.getStornoIznos();
        this.vrednostRobe = dok.getVrednostRobe();
        this.vrednostUsluga = dok.getVrednostUsluga();
        this.vrsta = dok.getVrsta();
        if (dok.getTaksadokuments() != null && dok.getTaksadokuments().size() > 0) {
            if (this.getDtaksas() == null || this.getDtaksas().size() == 0) {
                this.copyTaksaDokuments(dok.getTaksadokuments());
            } else {
                this.updateTaksaDokuments(dok.getTaksadokuments());
            }
        }
        if (azuriranjeStavki) {
            if (this.getArtikaldokuments() == null || this.getArtikaldokuments().size() == 0) {
                this.copyArtikalDocuments(dok.getArtikalDocuments());
            } else {
                this.updateArtikalDocuments(dok.getArtikalDocuments());
            }
            if (this.getUslugadokuments() == null || this.getUslugadokuments().size() == 0) {
                this.copyUslugaDocuments(dok.getUslugaDocuments());
            } else {
                this.updateUslugaDocuments(dok.getUslugaDocuments());
            }
        }
    }

    public void updateTaksaDokuments(List<? extends PzTaksaDokument> taksadokuments) {
        boolean found = false;
        if (taksadokuments == null) {
            return;
        }
        for (PzTaksaDokument pzTaksaDokument : taksadokuments) {
            found = false;
            if (this.getDtaksas() == null) continue;
            for (Dtaksa dtaksa : this.getDtaksas()) {
                if (!pzTaksaDokument.getTarifnagrupa().getOznTarGr().equals(dtaksa.getId().getOznTarGr()) || !pzTaksaDokument.getTip().equals(dtaksa.getId().getTip())) continue;
                dtaksa.update(pzTaksaDokument);
                found = true;
            }
            if (found) continue;
            this.getDtaksas().add(new Dtaksa(pzTaksaDokument, this));
        }
        if (this.getDtaksas() != null && this.getDtaksas().size() > 0) {
            Iterator<Dtaksa> iterator = this.getDtaksas().iterator();
            while (iterator.hasNext()) {
                Dtaksa dt = iterator.next();
                found = false;
                for (PzTaksaDokument pzTaksaDokument : taksadokuments) {
                    if (!dt.getId().getOznTarGr().equals(pzTaksaDokument.getTarifnagrupa().getOznTarGr()) || !dt.getId().getTip().equals(pzTaksaDokument.getTip())) continue;
                    found = true;
                }
                if (found) continue;
                iterator.remove();
                dt.setDokument(null);
            }
        }
    }

    public void updateArtikalDocuments(List<? extends PzArtikalDokument> artikalDocuments) {
        if (this.getArtikalDocuments() != null && this.getArtikalDocuments().size() > 0) {
            boolean found = false;
            for (PzArtikalDokument pzArtikalDokument : artikalDocuments) {
                found = false;
                for (Artikaldokument artikaldokument : this.getArtikaldokuments()) {
                    if (!pzArtikalDokument.getArtikal().getSfrProizvod().equals(artikaldokument.getId().getSfrProizvod()) || pzArtikalDokument.getId().getrBroj() != artikaldokument.getId().getrBroj()) continue;
                    artikaldokument.update(pzArtikalDokument);
                    found = true;
                }
                if (found) continue;
                this.getArtikaldokuments().add(new Artikaldokument(pzArtikalDokument, this));
            }
            Iterator<Artikaldokument> iterator = this.getArtikaldokuments().iterator();
            while (iterator.hasNext()) {
                Artikaldokument ad = iterator.next();
                found = false;
                for (PzArtikalDokument pzArtikalDokument : artikalDocuments) {
                    if (!pzArtikalDokument.getArtikal().getSfrProizvod().equals(ad.getId().getSfrProizvod()) || pzArtikalDokument.getId().getrBroj() != ad.getId().getrBroj()) continue;
                    found = true;
                }
                if (found) continue;
                iterator.remove();
                ad.setDokument(null);
            }
        }
    }

    public void updateUslugaDocuments(List<? extends PzUslugaDokument> uslugaDocuments) {
        if (this.getUslugaDocuments() != null && this.getUslugaDocuments().size() > 0) {
            Iterator<Uslugadokument> i1 = this.getUslugadokuments().iterator();
            while (i1.hasNext()) {
                Uslugadokument tmp = i1.next();
                if (tmp.getUsluga() != null) continue;
                i1.remove();
            }
            ArrayList<PzUslugaDokument> add = new ArrayList<PzUslugaDokument>();
            Iterator<? extends PzUslugaDokument> i2 = uslugaDocuments.iterator();
            while (i2.hasNext()) {
                PzUslugaDokument tmp = i2.next();
                if (tmp.getUsluga() != null) continue;
                i2.remove();
                add.add(tmp);
            }
            boolean found = false;
            for (PzUslugaDokument pzUslugaDokument : uslugaDocuments) {
                found = false;
                for (Uslugadokument uslugadokument : this.getUslugadokuments()) {
                    if (!pzUslugaDokument.getUsluga().getSfrProizvod().equals(uslugadokument.getUsluga().getSfrProizvod()) || pzUslugaDokument.getId().getrBroj() != uslugadokument.getId().getrBroj()) continue;
                    uslugadokument.update(pzUslugaDokument);
                    found = true;
                }
                if (found) continue;
                this.getUslugadokuments().add(new Uslugadokument(pzUslugaDokument, this));
            }
            Iterator<Uslugadokument> iterator = this.getUslugadokuments().iterator();
            while (iterator.hasNext()) {
                Uslugadokument ud = iterator.next();
                found = false;
                for (PzUslugaDokument pzUslugaDokument : uslugaDocuments) {
                    if (!pzUslugaDokument.getUsluga().getSfrProizvod().equals(ud.getUsluga().getSfrProizvod()) || pzUslugaDokument.getId().getrBroj() != ud.getId().getrBroj()) continue;
                    found = true;
                }
                if (found) continue;
                iterator.remove();
                ud.setDokument(null);
            }
            this.copyUslugaDocuments(add);
        }
    }

    @Override
    public int getIdDok() {
        return this.idDok;
    }

    @Override
    public void setIdDok(int idDok) {
        this.idDok = idDok;
    }

    @Override
    public short getArhiviran() {
        return this.arhiviran;
    }

    @Override
    public void setArhiviran(short arhiviran) {
        this.arhiviran = arhiviran;
    }

    @Override
    public short getCvProdajna() {
        return this.cvProdajna;
    }

    @Override
    public void setCvProdajna(short cvProdajna) {
        this.cvProdajna = cvProdajna;
    }

    @Override
    public Date getDatArh() {
        return this.datArh;
    }

    @Override
    public void setDatArh(Date datArh) {
        this.datArh = datArh;
    }

    @Override
    public Date getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Date datum) {
        this.datum = datum;
    }

    @Override
    public Date getDatValute() {
        return this.datValute;
    }

    @Override
    public void setDatValute(Date datValute) {
        this.datValute = datValute;
    }

    @Override
    public Date getDatPrometa() {
        return this.datPrometa;
    }

    public void setDatPrometa(Date datPrometa) {
        this.datPrometa = datPrometa;
    }

    @Override
    public BigDecimal getIznos() {
        return this.iznos;
    }

    @Override
    public void setIznos(BigDecimal iznos) {
        this.iznos = iznos;
    }

    public Short getKepu() {
        return this.kepu;
    }

    public void setKepu(Short kepu) {
        this.kepu = kepu;
    }

    @Override
    public String getOpis() {
        return this.opis;
    }

    @Override
    public void setOpis(String opis) {
        this.opis = opis;
    }

    @Override
    public String getOznDokumenta() {
        return this.oznDokumenta;
    }

    @Override
    public void setOznDokumenta(String oznDokumenta) {
        this.oznDokumenta = oznDokumenta;
    }

    @Override
    public void setPodTip(String podTip) {
        this.podTip = podTip;
    }

    @Override
    public String getPodTip() {
        return this.podTip;
    }

    @Override
    public short getProknjizen() {
        return this.proknjizen;
    }

    @Override
    public void setProknjizen(short proknjizen) {
        this.proknjizen = proknjizen;
    }

    public double getRazduzenje() {
        return this.razduzenje;
    }

    public void setRazduzenje(double razduzenje) {
        this.razduzenje = razduzenje;
    }

    @Override
    public int getRbrDok() {
        return this.rbrDok;
    }

    @Override
    public void setRbrDok(int rbrDok) {
        this.rbrDok = rbrDok;
    }

    public int getRbrKepu() {
        return this.rbrKepu;
    }

    public void setRbrKepu(int rbrKepu) {
        this.rbrKepu = rbrKepu;
    }

    @Override
    public int getrBroj() {
        return this.rBroj;
    }

    @Override
    public void setrBroj(int rBroj) {
        this.rBroj = rBroj;
    }

    @Override
    public int getStorno() {
        return this.storno;
    }

    @Override
    public void setStorno(int storno) {
        this.storno = storno;
    }

    @Override
    public void setStornoIznos(BigDecimal stornoIznos) {
        this.stornoIznos = stornoIznos;
    }

    @Override
    public BigDecimal getStornoIznos() {
        return this.stornoIznos;
    }

    @Override
    public String getTip() {
        return this.tip;
    }

    @Override
    public void setTip(String tip) {
        this.tip = tip;
    }

    public BigDecimal getUplata() {
        return this.uplata;
    }

    public void setUplata(BigDecimal uplata) {
        this.uplata = uplata;
    }

    public double getZaduzenje() {
        return this.zaduzenje;
    }

    public void setZaduzenje(double zaduzenje) {
        this.zaduzenje = zaduzenje;
    }

    @Override
    public String getVrsta() {
        return this.vrsta;
    }

    @Override
    public void setVrsta(String vrsta) {
        this.vrsta = vrsta;
    }

    public String getVrstaDuga() {
        return this.vrstaDuga;
    }

    public void setVrstaDuga(String vrstaDuga) {
        this.vrstaDuga = vrstaDuga;
    }

    @Override
    public BigDecimal getVrednostRobe() {
        return this.vrednostRobe;
    }

    @Override
    public void setVrednostRobe(BigDecimal vrednostRobe) {
        this.vrednostRobe = vrednostRobe;
    }

    @Override
    public BigDecimal getVrednostUsluga() {
        return this.vrednostUsluga;
    }

    @Override
    public void setVrednostUsluga(BigDecimal vrednostUsluga) {
        this.vrednostUsluga = vrednostUsluga;
    }

    public List<Artikaldokument> getArtikaldokuments() {
        return this.artikaldokuments;
    }

    public void setArtikaldokuments(List<Artikaldokument> artikaldokuments) {
        this.artikaldokuments = artikaldokuments;
    }

    @Override
    public Komitent getKomitent() {
        return this.komitent;
    }

    @Override
    public void setKomitent(Komitent komitent) {
        this.komitent = komitent;
    }

    @Override
    public Pzuser getUserPoc() {
        return this.userPoc;
    }

    @Override
    public void setUserPoc(Pzuser pzuser) {
        this.userPoc = pzuser;
    }

    @Override
    public Pzuser getUserKraj() {
        return this.userKraj;
    }

    @Override
    public void setUserKraj(Pzuser pzuser) {
        this.userKraj = pzuser;
    }

    @Override
    public Radnajedinica getRadnajedinica() {
        return this.radnajedinica;
    }

    @Override
    public void setRadnajedinica(Radnajedinica radnajedinica) {
        this.radnajedinica = radnajedinica;
    }

    public Faktura getFaktura() {
        return this.faktura;
    }

    public void setFaktura(Faktura faktura) {
        this.faktura = faktura;
    }

    public Fakturausluga getFakturausluga() {
        return this.fakturausluga;
    }

    public void setFakturausluga(Fakturausluga fakturausluga) {
        this.fakturausluga = fakturausluga;
    }

    public Interniracun getInterniracun() {
        return this.interniracun;
    }

    public void setInterniracun(Interniracun interniracun) {
        this.interniracun = interniracun;
    }

    public Interniracun getInterniracun1() {
        return this.interniracun1;
    }

    public void setInterniracun1(Interniracun interniracun1) {
        this.interniracun1 = interniracun1;
    }

    public Kalkulacija getKalkulacija() {
        return this.kalkulacija;
    }

    public void setKalkulacija(Kalkulacija kalkulacija) {
        this.kalkulacija = kalkulacija;
    }

    public Konsignacija getKonsignacija() {
        return this.konsignacija;
    }

    public void setKonsignacija(Konsignacija konsignacija) {
        this.konsignacija = konsignacija;
    }

    public Nivelacija getNivelacija() {
        return this.nivelacija;
    }

    public void setNivelacija(Nivelacija nivelacija) {
        this.nivelacija = nivelacija;
    }

    public Opstidokument getOpstidokument() {
        return this.opstidokument;
    }

    public void setOpstidokument(Opstidokument opstidokument) {
        this.opstidokument = opstidokument;
    }

    public Trosak getTrosak() {
        return this.trosak;
    }

    public void setTrosak(Trosak trosak) {
        this.trosak = trosak;
    }

    public List<Stavkanzk> getStavkanzks() {
        return this.stavkanzks;
    }

    public void setStavkanzks(List<Stavkanzk> stavkanzks) {
        this.stavkanzks = stavkanzks;
    }

    public List<Dtaksa> getDtaksas() {
        return this.dtaksas;
    }

    public void setDtaksas(List<Dtaksa> dtaksas) {
        this.dtaksas = dtaksas;
    }

    @Override
    public Dokument getOriginal() {
        return this.original;
    }

    public void setOriginal(Dokument original) {
        this.original = original;
    }

    public List<Dokument> getOriginals() {
        return this.originals;
    }

    public void setOriginals(List<Dokument> originals) {
        this.originals = originals;
    }

    public List<Uslugadokument> getUslugadokuments() {
        return this.uslugadokuments;
    }

    public void setUslugadokuments(List<Uslugadokument> uslugadokuments) {
        this.uslugadokuments = uslugadokuments;
    }

    @Override
    public void formirajOznaku() {
    }

    @Override
    public List<? extends PzArtikalDokument> getArtikalDocuments() {
        return this.artikaldokuments;
    }

    @Override
    public String[] getDokColumnNames() {
        return null;
    }

    @Override
    public Object[] getDokValues() {
        return null;
    }

    @Override
    public Object[] getKValues(byte type) {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return null;
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.getKomitent().getNaziv(), this.getDatum(), this.getOznDokumenta(), this.getIznos()};
    }

    @Override
    public Dokument getDokument() {
        return null;
    }

    @Override
    public void setDokument(Dokument dokument) {
    }

    public PzDokument getKonkretanDokument() {
        if (this.getKalkulacija() != null) {
            return this.getKalkulacija();
        }
        if (this.getFaktura() != null) {
            return this.getFaktura();
        }
        if (this.getFakturausluga() != null) {
            return this.getFakturausluga();
        }
        if (this.getInterniracun() != null) {
            return this.getInterniracun();
        }
        if (this.getInterniracun1() != null) {
            return this.getInterniracun1();
        }
        if (this.getKonsignacija() != null) {
            return this.getKonsignacija();
        }
        if (this.getNivelacija() != null) {
            return this.getNivelacija();
        }
        if (this.getOpstidokument() != null) {
            return this.getOpstidokument();
        }
        return null;
    }

    @Override
    public void adjust() {
        if (this.getArtikaldokuments() != null) {
            Iterator<Artikaldokument> i = this.getArtikaldokuments().iterator();
            while (i.hasNext()) {
                i.next().getId().setIdDok(this.getIdDok());
            }
        }
    }

    @Override
    public void setOriginal(PzDokument original) {
        this.original = (Dokument)original;
    }

    @Override
    public PzTaksaDokument createEmptyTaksaDokument(String oznTarGr, String tip) {
        return null;
    }

    @Override
    public void setTaksadokuments(List<? extends PzTaksaDokument> taksaDokuments) {
    }

    @Override
    public List<? extends PzTaksaDokument> getTaksadokuments() {
        return null;
    }

    @Override
    public void setArtikalDokuments(List<? extends PzArtikalDokument> list) {
        this.artikaldokuments = list;
    }

    public Shema getShemaKnjizenja() {
        return this.shemaKnjizenja;
    }

    public void setShemaKnjizenja(Shema shemaKnjizenja) {
        this.shemaKnjizenja = shemaKnjizenja;
    }

    public List<Nalogmagacinu> getNalogmagacinus() {
        return this.nalogmagacinus;
    }

    public void setNalogmagacinus(List<Nalogmagacinu> nalogmagacinus) {
        this.nalogmagacinus = nalogmagacinus;
    }

    public List<Nalogprijem> getNalogprijems() {
        return this.nalogprijems;
    }

    public void setNalogprijems(List<Nalogprijem> nalogprijems) {
        this.nalogprijems = nalogprijems;
    }

    public List<DokumentLog> getLogs() {
        return this.logs;
    }

    public void setLogs(List<DokumentLog> logs) {
        this.logs = logs;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.arhiviran;
        result = 31 * result + (this.artikaldokuments == null ? 0 : this.artikaldokuments.hashCode());
        result = 31 * result + (this.datArh == null ? 0 : this.datArh.hashCode());
        result = 31 * result + (this.datPrometa == null ? 0 : this.datPrometa.hashCode());
        result = 31 * result + (this.datValute == null ? 0 : this.datValute.hashCode());
        result = 31 * result + (this.datum == null ? 0 : this.datum.hashCode());
        result = 31 * result + (this.dtaksas == null ? 0 : this.dtaksas.hashCode());
        result = 31 * result + (this.iznos == null ? 0 : this.iznos.hashCode());
        result = 31 * result + (this.kepu == null ? 0 : this.kepu.hashCode());
        result = 31 * result + (this.komitent == null ? 0 : this.komitent.hashCode());
        result = 31 * result + (this.opis == null ? 0 : this.opis.hashCode());
        result = 31 * result + (this.oznDokumenta == null ? 0 : this.oznDokumenta.hashCode());
        result = 31 * result + (this.podTip == null ? 0 : this.podTip.hashCode());
        result = 31 * result + this.rBroj;
        result = 31 * result + (this.radnajedinica == null ? 0 : this.radnajedinica.hashCode());
        long temp = Double.doubleToLongBits(this.razduzenje);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.rbrDok;
        result = 31 * result + this.rbrKepu;
        result = 31 * result + this.storno;
        result = 31 * result + (this.stornoIznos == null ? 0 : this.stornoIznos.hashCode());
        result = 31 * result + (this.tip == null ? 0 : this.tip.hashCode());
        result = 31 * result + (this.uplata == null ? 0 : this.uplata.hashCode());
        result = 31 * result + (this.vrednostRobe == null ? 0 : this.vrednostRobe.hashCode());
        result = 31 * result + (this.vrednostUsluga == null ? 0 : this.vrednostUsluga.hashCode());
        result = 31 * result + (this.vrsta == null ? 0 : this.vrsta.hashCode());
        result = 31 * result + (this.vrstaDuga == null ? 0 : this.vrstaDuga.hashCode());
        temp = Double.doubleToLongBits(this.zaduzenje);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

