/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.commons;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import rs.pezar.db.PzDokument;
import rs.pezar.db.entity.Brojac;
import rs.pezar.db.entity.Brojacrj;
import rs.pezar.db.entity.BrojacrjPK;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.util.PzDateUtility;

public class PzBrojacRj {
    public static synchronized Brojacrj getRBroj(PzDokument dokument, EntityManager em) throws Exception {
        if (dokument.getRadnajedinica() == null) {
            throw new PzInfoException("Dokument koji nema radnu jedinicu ne mo\u017ee imati redni broj u radnoj jedinici!");
        }
        Brojacrj rBroj = (Brojacrj)em.find(Brojacrj.class, (Object)new BrojacrjPK(dokument.getRadnajedinica().getId(), dokument.getTip(), 1));
        if (rBroj == null) {
            rBroj = new Brojacrj();
            BrojacrjPK pk = new BrojacrjPK();
            pk.setArhiviran((short)1);
            pk.setOznOgranak(dokument.getRadnajedinica().getId().getOznOgranak());
            pk.setOznRj(dokument.getRadnajedinica().getId().getOznRj());
            pk.setTip(dokument.getTip());
            rBroj.setId(pk);
            rBroj.setRadnajedinica(dokument.getRadnajedinica());
            Query q = em.createQuery("SELECT max(d.rBroj) FROM Dokument d WHERE d.radnajedinica=:rj AND d.tip=:tip and d.storno=0 AND d.arhiviran=:arhiviran AND d.datArh>:datum and d.rbrDok!=(-1)");
            q.setParameter("rj", (Object)dokument.getRadnajedinica());
            q.setParameter("tip", (Object)dokument.getTip());
            q.setParameter("datum", (Object)PzDateUtility.getFirstDayOfCurrentYear());
            q.setParameter("arhiviran", (Object)1);
            int br = q.getResultList().size() > 0 && q.getResultList().get(0) != null ? ((Number)q.getResultList().get(0)).intValue() : 0;
            rBroj.setRBroj(br < 0 ? 0 : br);
            em.persist((Object)rBroj);
        }
        return rBroj;
    }

    public static synchronized Brojacrj getRBroj(String tip, Radnajedinica rj, EntityManager em) throws Exception {
        Brojacrj rBroj = (Brojacrj)em.find(Brojacrj.class, (Object)new BrojacrjPK(rj.getId(), tip, 1));
        if (rBroj == null) {
            rBroj = new Brojacrj();
            BrojacrjPK pk = new BrojacrjPK();
            pk.setArhiviran((short)1);
            pk.setOznOgranak(rj.getId().getOznOgranak());
            pk.setOznRj(rj.getId().getOznRj());
            pk.setTip(tip);
            rBroj.setId(pk);
            rBroj.setRadnajedinica(rj);
            int br = 0;
            rBroj.setRBroj(br < 0 ? 0 : br);
            em.persist((Object)rBroj);
        }
        return rBroj;
    }

    public static synchronized Brojacrj getRbrKepu(PzDokument dokument, EntityManager em) throws Exception {
        Brojacrj brDok = (Brojacrj)em.find(Brojacrj.class, (Object)new BrojacrjPK(dokument.getRadnajedinica().getId(), "KEPU", dokument.getArhiviran()));
        if (brDok == null) {
            brDok = new Brojacrj();
            BrojacrjPK pk = new BrojacrjPK();
            pk.setArhiviran(dokument.getArhiviran());
            pk.setOznOgranak(dokument.getRadnajedinica().getId().getOznOgranak());
            pk.setOznRj(dokument.getRadnajedinica().getId().getOznRj());
            pk.setTip("KEPU");
            brDok.setId(pk);
            brDok.setRadnajedinica(dokument.getRadnajedinica());
            Query q = em.createQuery("SELECT max(d.rbrKepu) FROM Dokument d WHERE d.radnajedinica=:rj and d.rbrDok!=(-1) and d.arhiviran=1");
            q.setParameter("rj", (Object)dokument.getRadnajedinica());
            int br = q.getSingleResult() != null ? (Integer)q.getSingleResult() : 0;
            brDok.setRBroj(br);
            em.persist((Object)brDok);
        }
        return brDok;
    }

    public static synchronized Brojacrj getRbrDok(PzDokument dokument, EntityManager em) throws Exception {
        Brojacrj brDok = (Brojacrj)em.find(Brojacrj.class, (Object)new BrojacrjPK(dokument.getRadnajedinica().getId(), "DOKUMENT", 1));
        if (brDok == null) {
            brDok = new Brojacrj();
            BrojacrjPK pk = new BrojacrjPK();
            pk.setArhiviran((short)1);
            pk.setOznOgranak(dokument.getRadnajedinica().getId().getOznOgranak());
            pk.setOznRj(dokument.getRadnajedinica().getId().getOznRj());
            pk.setTip("DOKUMENT");
            brDok.setId(pk);
            brDok.setRadnajedinica(dokument.getRadnajedinica());
            Query q = em.createQuery("SELECT max(d.rbrDok) FROM Dokument d WHERE d.radnajedinica=:rj");
            q.setParameter("rj", (Object)dokument.getRadnajedinica());
            int br = q.getSingleResult() != null ? (Integer)q.getSingleResult() : 0;
            brDok.setRBroj(br);
            em.persist((Object)brDok);
        }
        return brDok;
    }

    public static synchronized Brojac getBrojac(PzDokument dokument, EntityManager em) {
        Brojac brojac = (Brojac)em.find(Brojac.class, (Object)dokument.getTip());
        if (brojac == null) {
            brojac = new Brojac();
            brojac.setTip(dokument.getTip());
            Query q = em.createQuery("SELECT count(d) FROM Dokument d WHERE d.tip=:tip and d.storno=0 AND d.arhiviran=1 AND d.datArh>:datum and d.rbrDok!= (-1)");
            q.setParameter("tip", (Object)dokument.getTip());
            q.setParameter("datum", (Object)PzDateUtility.getFirstDayOfCurrentYear());
            if (q.getSingleResult() != null) {
                ((Long)q.getSingleResult()).intValue();
            }
            em.persist((Object)brojac);
        }
        return brojac;
    }
}

